# ymaps

### Клиент для [API Яндекс Карт](https://yandex.ru/dev/maps/mapsapi/) (Неофициальный)
<hr>

Включает в себя 4 класса:
* BaseClient - Родитель
* SearchClient - Поиск по организациям
* GeocoderClient - Геокодер
* StaticClient - Static API

> Геокоординаты задаются в порядке долгота и широта

> \* - обязательный аргумент

<br>
<hr>
<br>

### BaseClient
#### Аргументы:
 - api_key*, [получить ключ](https://yandex.ru/dev/maps/geosearch/?from=mapsapi).
 - scheme, протокол передачи данных, по умолчанию https
 - timeout, таймаут запроса, по умолчанию 1
 - proxies, прокси-сервера, по умолчанию ищет прокси в системе, если не находит не используется


> SearchClient, GeocoderClient, StaticClient принимают такие же аргументы, передавайте api_key в StaticClient только если используете коммерческую версию.


#### Примеры:

> scheme='http'

> timeout=10

> proxies={
	“http”: “http://0.0.0.0:8000*”,
	“https”: “http://0.0.0.0:8000”
}

<br>
<hr>
<br>

### [SearchClient](https://yandex.ru/dev/maps/geosearch/doc/concepts/request.html)
#### search()

Выполняет поиск по организациям или топонимам.

- __text*__, текст поискового запроса
- __lang__, язык ответа, по умолчанию ru_RU
- __type_objects__, типы возвращаемых результатов. geo — топонимы, biz — организации, по умолчанию автоматическое определение типа по тексту запроса
- __ll__, центр области поиска
- __spn__, размеры области поиска
- __bbox__, альтернативный способ задания области поиска, при одновременном задании bbox и ll+spn параметр bbox является более приоритетным
- __rspn__, признак «жесткого» ограничения области поиска, по умолчанию False (не ограничивать)
- __results__, количество возвращаемых объектов, по умолчанию 10
- __skip__, количество объектов в ответе (начиная с первого), которое необходимо пропустить, skip должно нацело делиться на results

#### Примеры:

 * __text__
 
> text='лебединое озеро'

> text='55.750788,37.618534'

> text='Санкт-Петербург, ул. Блохина, 15'

> text='+7 495 739-70-70'

> text='ООО Яндекс'

* __lang__

> lang='ru_RU'

>lang='be_BY'

* __type__

> type_objects='biz'

> type_objects='geo'

* __ll__, __spn__ (используются совместно)

> ll=[37.618920, 55.756994], spn=[0.552069, 0.400552]

* __bbox__

> bbox=[36.83, 55.67, 38.24, 55.91]

* __rspn__

> rspn=True # не искать за пределами заданной области

* __results__

> results=25

* __skip__

> skip=25

<br>
<hr>
<br>

### [GeocoderClient](https://yandex.ru/dev/maps/geocoder/doc/desc/concepts/input_params.html)

Прямое и обратное геокодирование

#### geocode()

Преобразует адрес в координаты объекта

- __address*__, текст поискового запроса
- __rspn__, признак «жесткого» ограничения области поиска, по умолчанию False (не ограничивать)
- __ll__, центр области поиска
- __spn__, размеры области поиска
- __bbox__, альтернативный способ задания области поиска, при одновременном задании bbox и ll+spn параметр bbox является более приоритетным
- __form__, формат ответа геокодера xml, json по умолчанию 
- __results__, количество возвращаемых объектов, по умолчанию 10
- __skip__, количество объектов в ответе (начиная с первого), которое необходимо пропустить, skip должно нацело делиться на results
- __lang__, язык ответа, по умолчанию ru_RU

#### reverse()

Преобразует координаты в адрес объекта. Принимает те же аргументы что и geocode() кроме address, и еще:

* __geocode__*, географические координаты объекта
* __sco__, порядок записи координат, longlat — долгота, широта, latlong — широта, долгота
* __kind__, вид необходимого топонима (house, street, metro, district, locality)

#### Примеры:

> text='Санкт-Петербург, ул. Блохина, 15'

> geocode=[37.611347, 55.760241]

> form='xml'

> sco='longlat'

> kind='street'

<br>
<hr>
<br>

### [StaticClient](https://yandex.ru/dev/maps/staticapi/doc/1.x/dg/concepts/input_params.html)

Формирует изображение карты в соответствии со значениями параметров

#### getimage()

- __l*__, перечень слоев, определяющих тип карты: map (схема), sat (спутник) и sat,skl (гибрид)
- __ll*__, долгота и широта центра карты в градусах
- __spn__, протяженность области показа карты по долготе и широте (в градусах)
- __z__, уровень масштабирования карты (0-17), см
- __size__, ширина и высота запрашиваемого изображения карты (в пикселах)
- __scale__, коэффициент увеличения объектов на карте (от 1.0 до 4.0)
- __pt__, содержит описание одной или нескольких меток, которые требуется отобразить на карте
- __pl__, Содержит набор описаний геометрических фигур (ломаных и многоугольников), которые требуется отобразить на карте
- __lang__, язык ответа, по умолчанию ru_RU

#### Примеры:

> l=['sat', 'skl']

> ll=[37.620070, 55.753630]

> spn=[0.01, 0.01]

> z=10

> size=[450, 450]

> scale=2.0

> pt=['37.620070,55.753630,pmwtm1']

> pl=['c:ec473fFF,f:00FF00A0,w:5,37.51,55.83,37.67,55.82,37.66,55.74,37.49,55.70,37.51,55.83']

<br>

Сохраните изображение:  

	with open('file.png', "wb") as f:
		f.write(response)