# Generated by Django 3.1.7 on 2021-02-21 17:10

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="CalendarDate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "calendar_date",
                    models.DateField(help_text="The actual date object", unique=True, verbose_name="Date"),
                ),
                (
                    "calendar_day",
                    models.PositiveSmallIntegerField(help_text="Number from 1 through 31", verbose_name="Calendar Day"),
                ),
                (
                    "calendar_month",
                    models.PositiveSmallIntegerField(help_text="Month number from 1-12", verbose_name="Calendar Month"),
                ),
                (
                    "calendar_year",
                    models.PositiveSmallIntegerField(
                        help_text="Current year, eg: 2017, 2025, 1984", verbose_name="Calendar Year"
                    ),
                ),
                (
                    "calendar_quarter",
                    models.PositiveSmallIntegerField(
                        help_text="1-4, indicates quarter within the current year", verbose_name="Calendar Quarter"
                    ),
                ),
                (
                    "fiscal_year",
                    models.PositiveSmallIntegerField(
                        help_text="Current fiscal year, eg: 2017, 2025, 1984", verbose_name="Fiscal Year"
                    ),
                ),
                (
                    "fiscal_quarter",
                    models.PositiveSmallIntegerField(
                        help_text="1-4, indicates fiscal quarter within the current fiscal year",
                        verbose_name="Fiscal Quarter",
                    ),
                ),
                (
                    "day_of_week",
                    models.PositiveSmallIntegerField(
                        help_text="Monday is 0 and Sunday is 6", verbose_name="Day of Week"
                    ),
                ),
                (
                    "day_of_isoweek",
                    models.PositiveSmallIntegerField(
                        help_text="Monday is 1 and Sunday is 7", verbose_name="Day of ISO Week"
                    ),
                ),
                (
                    "day_of_quarter",
                    models.PositiveSmallIntegerField(
                        help_text="Number from 1-92, indicates the day # in the current quarter",
                        verbose_name="Day in Quarter",
                    ),
                ),
                (
                    "day_of_year",
                    models.PositiveSmallIntegerField(help_text="Number from 1-366", verbose_name="Day in Year"),
                ),
                (
                    "week_of_month",
                    models.PositiveSmallIntegerField(
                        help_text="Number from 1-6, indicates the number of week within the current month",
                        verbose_name="Week of Month",
                    ),
                ),
                (
                    "week_of_year",
                    models.PositiveSmallIntegerField(
                        help_text="Number from 1-53, indicates the number of week within the current year",
                        verbose_name="Week of Year",
                    ),
                ),
                (
                    "isoweek_of_year",
                    models.PositiveSmallIntegerField(
                        help_text="Number from 1-53, indicates the number of isoweek within the current year",
                        verbose_name="ISO Week of Year",
                    ),
                ),
                (
                    "is_weekday",
                    models.BooleanField(
                        default=False,
                        help_text="True if Monday-->Friday, False for Saturday/Sunday",
                        verbose_name="Is Weekday",
                    ),
                ),
                (
                    "is_leap_year",
                    models.BooleanField(
                        default=False, help_text="True if current year is a leap year", verbose_name="Is Leap Year"
                    ),
                ),
                (
                    "days_in_month",
                    models.PositiveSmallIntegerField(
                        help_text="Number of days in the current month", verbose_name="Days in current month"
                    ),
                ),
            ],
            options={
                "verbose_name": "Calendar Date",
                "verbose_name_plural": "Calendar Dates",
                "ordering": ["-calendar_date"],
                "get_latest_by": ["-calendar_date"],
            },
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["calendar_date"], name="django_cale_calenda_95378f_idx"),
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["calendar_year", "calendar_month"], name="django_cale_calenda_fcdc17_idx"),
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["calendar_year", "calendar_quarter"], name="django_cale_calenda_b87451_idx"),
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["calendar_year", "week_of_year"], name="django_cale_calenda_a55a54_idx"),
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["fiscal_year", "fiscal_quarter"], name="django_cale_fiscal__592cc1_idx"),
        ),
        migrations.AddIndex(
            model_name="calendardate",
            index=models.Index(fields=["is_weekday"], name="django_cale_is_week_c191dd_idx"),
        ),
    ]
