# -*- coding: UTF-8 -*-
from .. import Provider as DateTimeProvider


class Provider(DateTimeProvider):

    DAY_NAMES = {
        "0": "Воскресенье",
        "1": "Понедельник",
        "2": "Вторник",
        "3": "Среда",
        "4": "Четверг",
        "5": "Пятница",
        "6": "Суббота",
    }

    MONTH_NAMES = {
        "01": "Январь",
        "02": "Февраль",
        "03": "Март",
        "04": "Апрель",
        "05": "Май",
        "06": "Июнь",
        "07": "Июль",
        "08": "Август",
        "09": "Сентябрь",
        "10": "Октябрь",
        "11": "Ноябрь",
        "12": "Декабрь",
    }

    # Timezone names are based on Wiki list, source: https://ru.wikipedia.org/wiki/Список_часовых_поясов_по_странам
    countries = [{'timezones': ['Андорра (UTC+01)'],
                  'alpha-2-code': 'AD',
                  'alpha-3-code': 'AND',
                  'continent': 'Европа',
                  'name': 'Андорра',
                  'capital': 'Андорра-ла-Велья'},
                 {'timezones': ['Афганистан (UTC+04:30)'],
                  'alpha-2-code': 'AF',
                  'alpha-3-code': 'AFG',
                  'continent': 'Азия',
                  'name': 'Афганистан',
                  'capital': 'Кабул'},
                 {'timezones': ['Антигуа и Барбуда (UTC-04)'],
                  'alpha-2-code': 'AG',
                  'alpha-3-code': 'ATG',
                  'continent': 'Северная Америка',
                  'name': 'Антигуа и Барбуда',
                  'capital': "Сент-Джонс"},
                 {'timezones': ['Албания (UTC+01)'],
                  'alpha-2-code': 'AL',
                  'alpha-3-code': 'ALB',
                  'continent': 'Европа',
                  'name': 'Албания',
                  'capital': 'Тирана'},
                 {'timezones': ['Армения (UTC+04)'],
                  'alpha-2-code': 'AM',
                  'alpha-3-code': 'ARM',
                  'continent': 'Азия',
                  'name': 'Армения',
                  'capital': 'Ереван'},
                 {'timezones': ['Ангола (UTC+01)'],
                  'alpha-2-code': 'AO',
                  'alpha-3-code': 'AGO',
                  'continent': 'Африка',
                  'name': 'Ангола',
                  'capital': 'Луанда'},
                 {'timezones': ['Аргентина (UTC-03)'],
                  'alpha-2-code': 'AR',
                  'alpha-3-code': 'ARG',
                  'continent': 'Южная Америка',
                  'name': 'Аргентина',
                  'capital': 'Буэнос Айрес'},
                 {'timezones': ['Австрия (UTC+01)'],
                  'alpha-2-code': 'AT',
                  'alpha-3-code': 'AUT',
                  'continent': 'Европа',
                  'name': 'Австрия',
                  'capital': 'Вена'},
                 {'timezones': ['Австралия (UTC+05)',
                                'Австралия (UTC+06:30)',
                                'Австралия (UTC+07)',
                                'Австралия (UTC+08)',
                                'Австралия (UTC+9:30)',
                                'Австралия (UTC+10)',
                                'Австралия (UTC+10:30)',
                                'Австралия (UTC+11:30)'],
                  'alpha-2-code': 'AU',
                  'alpha-3-code': 'AUS',
                  'continent': 'Океания',
                  'name': 'Австралия',
                  'capital': 'Канберра'},
                 {'timezones': ['Азербайджан (UTC+04)'],
                  'alpha-2-code': 'AZ',
                  'alpha-3-code': 'AZE',
                  'continent': 'Азия',
                  'name': 'Азербайджан',
                  'capital': 'Баку'},
                 {'timezones': ['Барбадос (UTC-04)'],
                  'alpha-2-code': 'BB',
                  'alpha-3-code': 'BRB',
                  'continent': 'Северная Америка',
                  'name': 'Барбадос',
                  'capital': 'Бриджтаун'},
                 {'timezones': ['Бангладеш (UTC+06)'],
                  'alpha-2-code': 'BD',
                  'alpha-3-code': 'BGD',
                  'continent': 'Азия',
                  'name': 'Бангладеш',
                  'capital': 'Дака'},
                 {'timezones': ['Бельгия (UTC+01)'],
                  'alpha-2-code': 'BE',
                  'alpha-3-code': 'BEL',
                  'continent': 'Европа',
                  'name': 'Бельгия',
                  'capital': 'Брюссель'},
                 {'timezones': ['Буркина-Фасо (UTC)'],
                  'alpha-2-code': 'BF',
                  'alpha-3-code': 'BFA',
                  'continent': 'Африка',
                  'name': 'Буркина-Фасо',
                  'capital': 'Уагадугу'},
                 {'timezones': ['Болгария (UTC+02)'],
                  'alpha-2-code': 'BG',
                  'alpha-3-code': 'BGR',
                  'continent': 'Европа',
                  'name': 'Болгария',
                  'capital': 'София'},
                 {'timezones': ['Бахрейн (UTC+03)'],
                  'alpha-2-code': 'BH',
                  'alpha-3-code': 'BHR',
                  'continent': 'Азия',
                  'name': 'Бахрейн',
                  'capital': 'Манама'},
                 {'timezones': ['Бурунди (UTC+02)'],
                  'alpha-2-code': 'BI',
                  'alpha-3-code': 'BDI',
                  'continent': 'Африка',
                  'name': 'Бурунди',
                  'capital': 'Гитега'},
                 {'timezones': ['Бенин (UTC+01)'],
                  'alpha-2-code': 'BJ',
                  'alpha-3-code': 'BEN',
                  'continent': 'Африка',
                  'name': 'Бенин',
                  'capital': 'Порто-Ново'},
                 {'timezones': ['Бруней (UTC+08)'],
                  'alpha-2-code': 'BN',
                  'alpha-3-code': 'BRN',
                  'continent': 'Азия',
                  'name': 'Бруней',
                  'capital': 'Бандар-Сери-Бегаван'},
                 {'timezones': ['Боливия (UTC-04)'],
                  'alpha-2-code': 'BO',
                  'alpha-3-code': 'BOL',
                  'continent': 'Южная Америка',
                  'name': 'Боливия',
                  'capital': 'Сукре'},
                 {'timezones': ['Бразилия (UTC-05)',
                                'Бразилия (UTC-04)',
                                'Бразилия (UTC-03)',
                                'Бразилия (UTC-02)'],
                  'alpha-2-code': 'BR',
                  'alpha-3-code': 'BRA',
                  'continent': 'Южная Америка',
                  'name': 'Бразилия',
                  'capital': 'Бразилиа'},
                 {'timezones': ['Багамские Острова (UTC-05)'],
                  'alpha-2-code': 'BS',
                  'alpha-3-code': 'BHS',
                  'continent': 'Северная Америка',
                  'name': 'Багамские Острова',
                  'capital': 'Нассау'},
                 {'timezones': ['Бутан (UTC+06)'],
                  'alpha-2-code': 'BT',
                  'alpha-3-code': 'BTN',
                  'continent': 'Азия',
                  'name': 'Бутан',
                  'capital': 'Тхимпху'},
                 {'timezones': ['Ботсвана (UTC+02)'],
                  'alpha-2-code': 'BW',
                  'alpha-3-code': 'BWA',
                  'continent': 'Африка',
                  'name': 'Ботсвана',
                  'capital': 'Габороне'},
                 {'timezones': ['Белоруссия (UTC+03)'],
                  'alpha-2-code': 'BY',
                  'alpha-3-code': 'BLR',
                  'continent': 'Европа',
                  'name': 'Белоруссия',
                  'capital': 'Минск'},
                 {'timezones': ['Белиз (UTC-06)'],
                  'alpha-2-code': 'BZ',
                  'alpha-3-code': 'BLZ',
                  'continent': 'Северная Америка',
                  'name': 'Белиз',
                  'capital': 'Бельмопан'},
                 {'timezones': ['Канада (UTC-08)',
                                'Канада (UTC-07)',
                                'Канада (UTC-06)',
                                'Канада (UTC-05)',
                                'Канада (UTC-04)',
                                'Канада (UTC-03:30)'],
                  'alpha-2-code': 'CA',
                  'alpha-3-code': 'CAN',
                  'continent': 'Северная Америка',
                  'name': 'Канада',
                  'capital': 'Оттава'},
                 {'timezones': ['Демократическая Республика Конго (UTC+01)',
                                'Демократическая Республика Конго (UTC+02)'],
                  'alpha-2-code': 'CD',
                  'alpha-3-code': 'COD',
                  'continent': 'Африка',
                  'name': 'Демократическая Республика Конго',
                  'capital': 'Киншаса'},
                 {'timezones': ['Республика Конго (UTC+01)'],
                  'alpha-2-code': 'CG',
                  'alpha-3-code': 'COG',
                  'continent': 'Африка',
                  'name': 'Руспублика Конго',
                  'capital': 'Браззавиль'},
                 {'timezones': ["Кот-д'Ивуар (UTC)"],
                  'alpha-2-code': 'CI',
                  'alpha-3-code': 'CIV',
                  'continent': 'Африка',
                  'name': "Кот-д'Ивуар",
                  'capital': 'Ямусукро'},
                 {'timezones': ['Чили (UTC-06)',
                                'Чили (UTC-04)'],
                  'alpha-2-code': 'CL',
                  'alpha-3-code': 'CHL',
                  'continent': 'Южная Америка',
                  'name': 'Чили',
                  'capital': 'Сантьяго'},
                 {'timezones': ['Камерун (UTC+01)'],
                  'alpha-2-code': 'CM',
                  'alpha-3-code': 'CMR',
                  'continent': 'Африка',
                  'name': 'Камерун',
                  'capital': 'Яунде'},
                 {'timezones': ['Китай (UTC+08)'],
                  'alpha-2-code': 'CN',
                  'alpha-3-code': 'CHN',
                  'continent': 'Азия',
                  'name': "Китайская Народная Республика",
                  'capital': 'Пекин'},
                 {'timezones': ['Колумбия (UTC-05)'],
                  'alpha-2-code': 'CO',
                  'alpha-3-code': 'COL',
                  'continent': 'Южная Америка',
                  'name': 'Колумбия',
                  'capital': 'Богота'},
                 {'timezones': ['Коста-Рика (UTC-06)'],
                  'alpha-2-code': 'CR',
                  'alpha-3-code': 'CRI',
                  'continent': 'Северная Америка',
                  'name': 'Коста-Рика',
                  'capital': 'Сан-Хосе'},
                 {'timezones': ['Куба (UTC-05)'],
                  'alpha-2-code': 'CU',
                  'alpha-3-code': 'CUB',
                  'continent': 'Северная Америка',
                  'name': 'Куба',
                  'capital': 'Гавана'},
                 {'timezones': ['Кабо-Верде (UTC-01)'],
                  'alpha-2-code': 'CV',
                  'alpha-3-code': 'CPV',
                  'continent': 'Африка',
                  'name': 'Кабо-Верде',
                  'capital': 'Прая'},
                 {'timezones': ['Кипр (UTC+02)'],
                  'alpha-2-code': 'CY',
                  'alpha-3-code': 'CYP',
                  'continent': 'Азия',
                  'name': 'Кипр',
                  'capital': 'Никосия'},
                 {'timezones': ['Чехия (UTC+01)'],
                  'alpha-2-code': 'CZ',
                  'alpha-3-code': 'CZE',
                  'continent': 'Европа',
                  'name': 'Чехия',
                  'capital': 'Прага'},
                 {'timezones': ['Германия (UTC+01)'],
                  'alpha-2-code': 'DE',
                  'alpha-3-code': 'DEU',
                  'continent': 'Европа',
                  'name': 'Германия',
                  'capital': 'Берлин'},
                 {'timezones': ['Джибути (UTC+03)'],
                  'alpha-2-code': 'DJ',
                  'alpha-3-code': 'DJI',
                  'continent': 'Африка',
                  'name': 'Джибути',
                  'capital': 'Джибути'},
                 {'timezones': ['Дания (UTC+01)'],
                  'alpha-2-code': 'DK',
                  'alpha-3-code': 'DNK',
                  'continent': 'Европа',
                  'name': 'Дания',
                  'capital': 'Копенгаген'},
                 {'timezones': ['Доминика (UTC-04)'],
                  'alpha-2-code': 'DM',
                  'alpha-3-code': 'DMA',
                  'continent': 'Северная Америка',
                  'name': 'Доминика',
                  'capital': 'Розо'},
                 {'timezones': ['Доминиканская Республика (UTC-04)'],
                  'alpha-2-code': 'DO',
                  'alpha-3-code': 'DOM',
                  'continent': 'Северная Америка',
                  'name': 'Доминиканская Республика',
                  'capital': 'Санто-Доминго'},
                 {'timezones': ['Эквадор (UTC-06)',
                                'Эквадор (UTC-05)'],
                  'alpha-2-code': 'EC',
                  'alpha-3-code': 'ECU',
                  'continent': 'Южная Америка',
                  'name': 'Эквадор',
                  'capital': 'Кито'},
                 {'timezones': ['Эстония (UTC+02)'],
                  'alpha-2-code': 'EE',
                  'alpha-3-code': 'EST',
                  'continent': 'Европа',
                  'name': 'Эстония',
                  'capital': 'Таллинн'},
                 {'timezones': ['Египет (UTC+02)'],
                  'alpha-2-code': 'EG',
                  'alpha-3-code': 'EGY',
                  'continent': 'Африка',
                  'name': 'Египет',
                  'capital': 'Каир'},
                 {'timezones': ['Эритрея (UTC+03)'],
                  'alpha-2-code': 'ER',
                  'alpha-3-code': 'ERI',
                  'continent': 'Африка',
                  'name': 'Эритрея',
                  'capital': 'Асмэра'},
                 {'timezones': ['Эфиопия (UTC+03)'],
                  'alpha-2-code': 'ET',
                  'alpha-3-code': 'ETH',
                  'continent': 'Африка',
                  'name': 'Эфиопия',
                  'capital': 'Аддис-Абеба'},
                 {'timezones': ['Финляндия (UTC+02)'],
                  'alpha-2-code': 'FI',
                  'alpha-3-code': 'FIN',
                  'continent': 'Европа',
                  'name': 'Финляндия',
                  'capital': 'Хельсинки'},
                 {'timezones': ['Фиджи (UTC+12)'],
                  'alpha-2-code': 'FJ',
                  'alpha-3-code': 'FJI',
                  'continent': 'Океания',
                  'name': 'Фиджи',
                  'capital': 'Сува'},
                 {'timezones': ['Франция (UTC+01)'],
                  'alpha-2-code': 'FR',
                  'alpha-3-code': 'FRA',
                  'continent': 'Европа',
                  'name': 'Франция',
                  'capital': 'Париж'},
                 {'timezones': ['Габон (UTC+01)'],
                  'alpha-2-code': 'GA',
                  'alpha-3-code': 'GAB',
                  'continent': 'Африка',
                  'name': 'Габон',
                  'capital': 'Либревиль'},
                 {'timezones': ['Грузия (UTC+04)'],
                  'alpha-2-code': 'GE',
                  'alpha-3-code': 'GEO',
                  'continent': 'Азия',
                  'name': 'Грузия',
                  'capital': 'Тбилиси'},
                 {'timezones': ['Гана (UTC)'],
                  'alpha-2-code': 'GH',
                  'alpha-3-code': 'GHA',
                  'continent': 'Африка',
                  'name': 'Гана',
                  'capital': 'Аккра'},
                 {'timezones': ['Гамбия (UTC)'],
                  'alpha-2-code': 'GM',
                  'alpha-3-code': 'GMB',
                  'continent': 'Африка',
                  'name': 'Гамбия',
                  'capital': 'Банджул'},
                 {'timezones': ['Гвинея (UTC)'],
                  'alpha-2-code': 'GN',
                  'alpha-3-code': 'GIN',
                  'continent': 'Африка',
                  'name': 'Гвинея',
                  'capital': 'Конакри'},
                 {'timezones': ['Греция (UTC+02)'],
                  'alpha-2-code': 'GR',
                  'alpha-3-code': 'GRC',
                  'continent': 'Европа',
                  'name': 'Греция',
                  'capital': 'Афины'},
                 {'timezones': ['Гватемала (UTC-06)'],
                  'alpha-2-code': 'GT',
                  'alpha-3-code': 'GTM',
                  'continent': 'Северная Америка',
                  'name': 'Гватемала',
                  'capital': 'Гватемала'},
                 {'timezones': ['Гаити (UTC-05)'],
                  'alpha-2-code': 'HT',
                  'alpha-3-code': 'HTI',
                  'continent': 'Северная Америка',
                  'name': 'Гаити',
                  'capital': 'Порт-о-Пренс'},
                 {'timezones': ['Гвинея-Бисау (UTC)'],
                  'alpha-2-code': 'GW',
                  'alpha-3-code': 'GNB',
                  'continent': 'Африка',
                  'name': 'Гвинея-Бисау',
                  'capital': 'Бисау'},
                 {'timezones': ['Гайана (UTC-04)'],
                  'alpha-2-code': 'GY',
                  'alpha-3-code': 'GUY',
                  'continent': 'Южная Америка',
                  'name': 'Гайана',
                  'capital': 'Джорджтаун'},
                 {'timezones': ['Гондурас (UTC-06)'],
                  'alpha-2-code': 'HN',
                  'alpha-3-code': 'HND',
                  'continent': 'Северная Америка',
                  'name': 'Гондурас',
                  'capital': 'Тегусигальпа'},
                 {'timezones': ['Венгрия (UTC+01)'],
                  'alpha-2-code': 'HU',
                  'alpha-3-code': 'HUN',
                  'continent': 'Европа',
                  'name': 'Венгрия',
                  'capital': 'Будапешт'},
                 {'timezones': ['Индонезия (UTC+07)',
                                'Индонезия (UTC+08)',
                                'Индонезия (UTC+09)'],
                  'alpha-2-code': 'ID',
                  'alpha-3-code': 'IDN',
                  'continent': 'Азия',
                  'name': 'Индонезия',
                  'capital': 'Джакарта'},
                 {'timezones': ['Ирландия (UTC)'],
                  'alpha-2-code': 'IE',
                  'alpha-3-code': 'IRL',
                  'continent': 'Европа',
                  'name': 'Ирландия',
                  'capital': 'Дублин'},
                 {'timezones': ['Израиль (UTC+02)'],
                  'alpha-2-code': 'IL',
                  'alpha-3-code': 'ISR',
                  'continent': 'Азия',
                  'name': 'Израиль',
                  'capital': 'Иерусалим'},
                 {'timezones': ['Индия (UTC+05:30'],
                  'alpha-2-code': 'IN',
                  'alpha-3-code': 'IND',
                  'continent': 'Азия',
                  'name': 'Индия',
                  'capital': 'Дели'},
                 {'timezones': ['Ирак (UTC+03)'],
                  'alpha-2-code': 'IQ',
                  'alpha-3-code': 'IRQ',
                  'continent': 'Азия',
                  'name': 'Ирак',
                  'capital': 'Багдад'},
                 {'timezones': ['Иран (UTC+03:30)'],
                  'alpha-2-code': 'IR',
                  'alpha-3-code': 'IRN',
                  'continent': 'Азия',
                  'name': 'Иран',
                  'capital': 'Тегеран'},
                 {'timezones': ['Исландия (UTC)'],
                  'alpha-2-code': 'IS',
                  'alpha-3-code': 'ISL',
                  'continent': 'Европа',
                  'name': 'Исландия',
                  'capital': 'Рейкьявик'},
                 {'timezones': ['Италия (UTC+01)'],
                  'alpha-2-code': 'IT',
                  'alpha-3-code': 'ITA',
                  'continent': 'Европа',
                  'name': 'Италия',
                  'capital': 'Рим'},
                 {'timezones': ['Ямайка (UTC-05)'],
                  'alpha-2-code': 'JM',
                  'alpha-3-code': 'JAM',
                  'continent': 'Северная Америка',
                  'name': 'Ямайка',
                  'capital': 'Кингстон'},
                 {'timezones': ['Иордания (UTC+02)'],
                  'alpha-2-code': 'JO',
                  'alpha-3-code': 'JOR',
                  'continent': 'Азия',
                  'name': 'Иордания',
                  'capital': 'Амман'},
                 {'timezones': ['Япония (UTC+09)'],
                  'alpha-2-code': 'JP',
                  'alpha-3-code': 'JPN',
                  'continent': 'Азия',
                  'name': 'Япония',
                  'capital': 'Токио'},
                 {'timezones': ['Кения (UTC+03)'],
                  'alpha-2-code': 'KE',
                  'alpha-3-code': 'KEN',
                  'continent': 'Африка',
                  'name': 'Кения',
                  'capital': 'Найроби'},
                 {'timezones': ['Киргизия (UTC+06)'],
                  'alpha-2-code': 'KG',
                  'alpha-3-code': 'KGZ',
                  'continent': 'Азия',
                  'name': 'Киргизия',
                  'capital': 'Бишкек'},
                 {'timezones': ['Кирибати (UTC+12)',
                                'Кирибати (UTC+13)',
                                'Кирибати (UTC+14)'],
                  'alpha-2-code': 'KI',
                  'alpha-3-code': 'KIR',
                  'continent': 'Океания',
                  'name': 'Кирибати',
                  'capital': 'Южная Тарава'},
                 {'timezones': ['КНДР (UTC+09)'],
                  'alpha-2-code': 'KP',
                  'alpha-3-code': 'PRK',
                  'continent': 'Азия',
                  'name': 'КНДР',
                  'capital': 'Пхеньян'},
                 {'timezones': ['Республика Корея (UTC+09)'],
                  'alpha-2-code': 'KR',
                  'alpha-3-code': 'KOR',
                  'continent': 'Азия',
                  'name': 'Республика Корея',
                  'capital': 'Сеул'},
                 {'timezones': ['Кувейт (UTC+03)'],
                  'alpha-2-code': 'KW',
                  'alpha-3-code': 'KWT',
                  'continent': 'Азия',
                  'name': 'Кувейт',
                  'capital': 'Эль-Кувейт'},
                 {'timezones': ['Ливан (UTC+02)'],
                  'alpha-2-code': 'LB',
                  'alpha-3-code': 'LBN',
                  'continent': 'Азия',
                  'name': 'Ливан',
                  'capital': 'Бейрут'},
                 {'timezones': ['Лихтенштейн (UTC+01)'],
                  'alpha-2-code': 'LI',
                  'alpha-3-code': 'LIE',
                  'continent': 'Европа',
                  'name': 'Лихтенштейн',
                  'capital': 'Вадуц'},
                 {'timezones': ['Либерия (UTC)'],
                  'alpha-2-code': 'LR',
                  'alpha-3-code': 'LBR',
                  'continent': 'Африка',
                  'name': 'Либерия',
                  'capital': 'Монровия'},
                 {'timezones': ['Лесото (UTC+02)'],
                  'alpha-2-code': 'LS',
                  'alpha-3-code': 'LSO',
                  'continent': 'Африка',
                  'name': 'Лесото',
                  'capital': 'Масеру'},
                 {'timezones': ['Литва (UTC+02)'],
                  'alpha-2-code': 'LT',
                  'alpha-3-code': 'LTU',
                  'continent': 'Европа',
                  'name': 'Литва',
                  'capital': 'Вильнюс'},
                 {'timezones': ['Люксембург (UTC+01)'],
                  'alpha-2-code': 'LU',
                  'alpha-3-code': 'LUX',
                  'continent': 'Европа',
                  'name': 'Люксембург',
                  'capital': 'Люксембург'},
                 {'timezones': ['Латвия (UTC+02)'],
                  'alpha-2-code': 'LV',
                  'alpha-3-code': 'LVA',
                  'continent': 'Европа',
                  'name': 'Латвия',
                  'capital': 'Рига'},
                 {'timezones': ['Ливия (UTC+02)'],
                  'alpha-2-code': 'LY',
                  'alpha-3-code': 'LBY',
                  'continent': 'Африка',
                  'name': 'Ливия',
                  'capital': 'Триполи'},
                 {'timezones': ['Мадагаскар (UTC+03)'],
                  'alpha-2-code': 'MG',
                  'alpha-3-code': 'MDG',
                  'continent': 'Африка',
                  'name': 'Мадагаскар',
                  'capital': 'Антананариву'},
                 {'timezones': ['Маршалловы Острова (UTC+12)'],
                  'alpha-2-code': 'MH',
                  'alpha-3-code': 'MHL',
                  'continent': 'Океания',
                  'name': 'Маршалловы Острова',
                  'capital': 'Маджуро'},
                 {'timezones': ['Северная Македония (UTC+01)'],
                  'alpha-2-code': 'MK',
                  'alpha-3-code': 'MKD',
                  'continent': 'Европа',
                  'name': 'Северная Македония',
                  'capital': 'Скопье'},
                 {'timezones': ['Мали (UTC)'],
                  'alpha-2-code': 'ML',
                  'alpha-3-code': 'MLI',
                  'continent': 'Африка',
                  'name': 'Мали',
                  'capital': 'Бамако'},
                 {'timezones': ['Мьянма (UTC+06:30)'],
                  'alpha-2-code': 'MM',
                  'alpha-3-code': 'MMR',
                  'continent': 'Азия',
                  'name': 'Мьянма',
                  'capital': 'Нейпьидо'},
                 {'timezones': ['Монголия (UTC+07)',
                                'Монголия (UTC+08)'],
                  'alpha-2-code': 'MN',
                  'alpha-3-code': 'MNG',
                  'continent': 'Азия',
                  'name': 'Монголия',
                  'capital': 'Улан-Батор'},
                 {'timezones': ['Мавритания (UTC)'],
                  'alpha-2-code': 'MR',
                  'alpha-3-code': 'MRT',
                  'continent': 'Африка',
                  'name': 'Мавритания',
                  'capital': 'Нуакшот'},
                 {'timezones': ['Мальта (UTC+01)'],
                  'alpha-2-code': 'MT',
                  'alpha-3-code': 'MLT',
                  'continent': 'Европа',
                  'name': 'Мальта',
                  'capital': 'Валлетта'},
                 {'timezones': ['Маврикий (UTC+04)'],
                  'alpha-2-code': 'MU',
                  'alpha-3-code': 'MUS',
                  'continent': 'Африка',
                  'name': 'Маврикий',
                  'capital': 'Порт-Луи'},
                 {'timezones': ['Мальдивы (UTC+05)'],
                  'alpha-2-code': 'MV',
                  'alpha-3-code': 'MDV',
                  'continent': 'Азия',
                  'name': 'Мальдивы',
                  'capital': 'Мале'},
                 {'timezones': ['Малави (UTC+02)'],
                  'alpha-2-code': 'MW',
                  'alpha-3-code': 'MWI',
                  'continent': 'Африка',
                  'name': 'Малави',
                  'capital': 'Лилонгве'},
                 {'timezones': ['Мексика (UTC-08)',
                                'Мексика (UTC-07)',
                                'Мексика (UTC-06)'],
                  'alpha-2-code': 'MX',
                  'alpha-3-code': 'MEX',
                  'continent': 'Северная Америка',
                  'name': 'Мексика',
                  'capital': 'Мехико'},
                 {'timezones': ['Малайзия (UTC+08)'],
                  'alpha-2-code': 'MY',
                  'alpha-3-code': 'MYS',
                  'continent': 'Азия',
                  'name': 'Малайзия',
                  'capital': 'Куала-Лумпур'},
                 {'timezones': ['Мозамбик (UTC+02)'],
                  'alpha-2-code': 'MZ',
                  'alpha-3-code': 'MOZ',
                  'continent': 'Африка',
                  'name': 'Мозамбик',
                  'capital': 'Мапуту'},
                 {'timezones': ['Намибия (UTC+01)'],
                  'alpha-2-code': 'NA',
                  'alpha-3-code': 'NAM',
                  'continent': 'Африка',
                  'name': 'Намибия',
                  'capital': 'Виндхук'},
                 {'timezones': ['Нигер (UTC+01)'],
                  'alpha-2-code': 'NE',
                  'alpha-3-code': 'NER',
                  'continent': 'Африка',
                  'name': 'Нигер',
                  'capital': 'Ниамей'},
                 {'timezones': ['Нигерия (UTC+01)'],
                  'alpha-2-code': 'NG',
                  'alpha-3-code': 'NGA',
                  'continent': 'Африка',
                  'name': 'Нигерия',
                  'capital': 'Абуджа'},
                 {'timezones': ['Никарагуа (UTC-06)'],
                  'alpha-2-code': 'NI',
                  'alpha-3-code': 'NIC',
                  'continent': 'Северная Америка',
                  'name': 'Никарагуа',
                  'capital': 'Манагуа'},
                 {'timezones': ['Нидерланды (UTC+01)'],
                  'alpha-2-code': 'NL',
                  'alpha-3-code': 'NLD',
                  'continent': 'Европа',
                  'name': 'Нидерланды',
                  'capital': 'Амстердам'},
                 {'timezones': ['Норвегия (UTC+01)'],
                  'alpha-2-code': 'NO',
                  'alpha-3-code': 'NOR',
                  'continent': 'Европа',
                  'name': 'Норвегия',
                  'capital': 'Осло'},
                 {'timezones': ['Непал (UTC+05:45'],
                  'alpha-2-code': 'NP',
                  'alpha-3-code': 'NPL',
                  'continent': 'Азия',
                  'name': 'Непал',
                  'capital': 'Катманду'},
                 {'timezones': ['Науру (UTC+12)'],
                  'alpha-2-code': 'NR',
                  'alpha-3-code': 'NRU',
                  'continent': 'Океания',
                  'name': 'Науру',
                  'capital': 'Ярен'},
                 {'timezones': ['Новая Зеландия (UTC+12)'],
                  'alpha-2-code': 'NZ',
                  'alpha-3-code': 'NZL',
                  'continent': 'Океания',
                  'name': 'Новая Зеландия',
                  'capital': 'Веллингтон'},
                 {'timezones': ['Оман (UTC+04'],
                  'alpha-2-code': 'OM',
                  'alpha-3-code': 'OMN',
                  'continent': 'Азия',
                  'name': 'Оман',
                  'capital': 'Маскат'},
                 {'timezones': ['Панама (UTC-05)'],
                  'alpha-2-code': 'PA',
                  'alpha-3-code': 'PAN',
                  'continent': 'Северная Америка',
                  'name': 'Панама',
                  'capital': 'Панама'},
                 {'timezones': ['Перу (UTC-05)'],
                  'alpha-2-code': 'PE',
                  'alpha-3-code': 'PER',
                  'continent': 'Южная Америка',
                  'name': 'Перу',
                  'capital': 'Лима'},
                 {'timezones': ['Папуа - Новая Гвинея (UTC+10)'],
                  'alpha-2-code': 'PG',
                  'alpha-3-code': 'PNG',
                  'continent': 'Океания',
                  'name': 'Папуа - Новая Гвинея',
                  'capital': 'Порт-Морсби'},
                 {'timezones': ['Филиппины (UTC+08)'],
                  'alpha-2-code': 'PH',
                  'alpha-3-code': 'PHL',
                  'continent': 'Азия',
                  'name': 'Филиппины',
                  'capital': 'Манила'},
                 {'timezones': ['Пакистан (UTC+05)'],
                  'alpha-2-code': 'PK',
                  'alpha-3-code': 'PAK',
                  'continent': 'Азия',
                  'name': 'Пакистан',
                  'capital': 'Исламабад'},
                 {'timezones': ['Польша (UTC+01)'],
                  'alpha-2-code': 'PL',
                  'alpha-3-code': 'POL',
                  'continent': 'Европа',
                  'name': 'Польша',
                  'capital': 'Варшава'},
                 {'timezones': ['Португалия (UTC)'],
                  'alpha-2-code': 'PT',
                  'alpha-3-code': 'PRT',
                  'continent': 'Европа',
                  'name': 'Португалия',
                  'capital': 'Лиссабон'},
                 {'timezones': ['Палау (UTC+09)'],
                  'alpha-2-code': 'PW',
                  'alpha-3-code': 'PLW',
                  'continent': 'Океания',
                  'name': 'Палау',
                  'capital': 'Кампала'},
                 {'timezones': ['Парагвай (UTC-04)'],
                  'alpha-2-code': 'PY',
                  'alpha-3-code': 'PRY',
                  'continent': 'Южная Америка',
                  'name': 'Парагвай',
                  'capital': 'Асунсьон'},
                 {'timezones': ['Катар (UTC+03)'],
                  'alpha-2-code': 'QA',
                  'alpha-3-code': 'QAT',
                  'continent': 'Азия',
                  'name': 'Катар',
                  'capital': 'Доха'},
                 {'timezones': ['Румыния (UTC+02)'],
                  'alpha-2-code': 'RO',
                  'alpha-3-code': 'ROU',
                  'continent': 'Европа',
                  'name': 'Румыния',
                  'capital': 'Бухарест'},
                 {'timezones': ['Россия (UTC+02)',
                                'Россия (UTC+03)',
                                'Россия (UTC+04)',
                                'Россия (UTC+05)',
                                'Россия (UTC+06)',
                                'Россия (UTC+07)',
                                'Россия (UTC+08)',
                                'Россия (UTC+09)',
                                'Россия (UTC+10)',
                                'Россия (UTC+11)',
                                'Россия (UTC+12)'],
                  'alpha-2-code': 'RU',
                  'alpha-3-code': 'RUS',
                  'continent': 'Европа',
                  'name': 'Россия',
                  'capital': 'Москва'},
                 {'timezones': ['Руанда (UTC+02)'],
                  'alpha-2-code': 'RW',
                  'alpha-3-code': 'RWA',
                  'continent': 'Африка',
                  'name': 'Руанда',
                  'capital': 'Кигали'},
                 {'timezones': ['Саудовская Аравия (UTC+03)'],
                  'alpha-2-code': 'SA',
                  'alpha-3-code': 'SAU',
                  'continent': 'Азия',
                  'name': 'Саудовская Аравия',
                  'capital': 'Эр-Рияд'},
                 {'timezones': ['Соломоновы Острова (UTC+11)'],
                  'alpha-2-code': 'SB',
                  'alpha-3-code': 'SLB',
                  'continent': 'Океания',
                  'name': 'Соломоновы Острова',
                  'capital': 'Хониара'},
                 {'timezones': ['Сейшельские острова (UTC+04)'],
                  'alpha-2-code': 'SC',
                  'alpha-3-code': 'SYC',
                  'continent': 'Африка',
                  'name': 'Сейшельские острова',
                  'capital': 'Виктория'},
                 {'timezones': ['Судан (UTC+03)'],
                  'alpha-2-code': 'SD',
                  'alpha-3-code': 'SDN',
                  'continent': 'Африка',
                  'name': 'Судан',
                  'capital': 'Хартум'},
                 {'timezones': ['Швеция (UTC+01)'],
                  'alpha-2-code': 'SE',
                  'alpha-3-code': 'SWE',
                  'continent': 'Европа',
                  'name': 'Швеци',
                  'capital': 'Стокгольм'},
                 {'timezones': ['Сингапур (UTC+08)'],
                  'alpha-2-code': 'SG',
                  'alpha-3-code': 'SGP',
                  'continent': 'Азия',
                  'name': 'Сингапур',
                  'capital': 'Сингапур'},
                 {'timezones': ['Словения (UTC+01)'],
                  'alpha-2-code': 'SI',
                  'alpha-3-code': 'SVN',
                  'continent': 'Европа',
                  'name': 'Словения',
                  'capital': 'Любляна'},
                 {'timezones': ['Словакия (UTC+01)'],
                  'alpha-2-code': 'SK',
                  'alpha-3-code': 'SVK',
                  'continent': 'Европа',
                  'name': 'Словакия',
                  'capital': 'Братислава'},
                 {'timezones': ['Сьерра-Леоне (UTC)'],
                  'alpha-2-code': 'SL',
                  'alpha-3-code': 'SLE',
                  'continent': 'Африка',
                  'name': 'Сьерра Леоне',
                  'capital': 'Фритаун'},
                 {'timezones': ['Сан-Марино (UTC+01)'],
                  'alpha-2-code': 'SM',
                  'alpha-3-code': 'SMR',
                  'continent': 'Европа',
                  'name': 'Сан-Марино',
                  'capital': 'Сан-Марино'},
                 {'timezones': ['Сенегал (UTC)'],
                  'alpha-2-code': 'SN',
                  'alpha-3-code': 'SEN',
                  'continent': 'Африка',
                  'name': 'Сенегал',
                  'capital': 'Дакар'},
                 {'timezones': ['Сомали (UTC+03)'],
                  'alpha-2-code': 'SO',
                  'alpha-3-code': 'SOM',
                  'continent': 'Африка',
                  'name': 'Сомали',
                  'capital': 'Могадишо'},
                 {'timezones': ['Суринам (UTC-03)'],
                  'alpha-2-code': 'SR',
                  'alpha-3-code': 'SUR',
                  'continent': 'Южная Америка',
                  'name': 'Суринам',
                  'capital': 'Парамарибо'},
                 {'timezones': ['Сан-Томе и Принсипи (UTC)'],
                  'alpha-2-code': 'ST',
                  'alpha-3-code': 'STP',
                  'continent': 'Африка',
                  'name': 'Сан-Томе и Принсипи',
                  'capital': 'Сан-Томе'},
                 {'timezones': ['Сирия (UTC+02)'],
                  'alpha-2-code': 'SY',
                  'alpha-3-code': 'SYR',
                  'continent': 'Азия',
                  'name': 'Сирия',
                  'capital': 'Дамаск'},
                 {'timezones': ['Того (UTC)'],
                  'alpha-2-code': 'TG',
                  'alpha-3-code': 'TGO',
                  'continent': 'Африка',
                  'name': 'Того',
                  'capital': 'Ломе'},
                 {'timezones': ['Таиланд (UTC+07)'],
                  'alpha-2-code': 'TH',
                  'alpha-3-code': 'THA',
                  'continent': 'Азия',
                  'name': 'Таиланд',
                  'capital': 'Бангкок'},
                 {'timezones': ['Таджикистан (UTC+05)'],
                  'alpha-2-code': 'TJ',
                  'alpha-3-code': 'TJK',
                  'continent': 'Азия',
                  'name': 'Таджикистан',
                  'capital': 'Душанбе'},
                 {'timezones': ['Туркмения (UTC+05)'],
                  'alpha-2-code': 'TM',
                  'alpha-3-code': 'TKM',
                  'continent': 'Азия',
                  'name': 'Туркмения',
                  'capital': 'Ашхабад'},
                 {'timezones': ['Тунис (UTC+01)'],
                  'alpha-2-code': 'TN',
                  'alpha-3-code': 'TUN',
                  'continent': 'Африка',
                  'name': 'Тунис',
                  'capital': 'Тунис'},
                 {'timezones': ['Тонга (UTC+13)'],
                  'alpha-2-code': 'TO',
                  'alpha-3-code': 'TON',
                  'continent': 'Океания',
                  'name': 'Тонга',
                  'capital': 'Нукуалофа'},
                 {'timezones': ['Турция (UTC+02)'],
                  'alpha-2-code': 'TR',
                  'alpha-3-code': 'TUR',
                  'continent': 'Азия',
                  'name': 'Турция',
                  'capital': 'Анкара'},
                 {'timezones': ['Тринидад и Тобаго (UTC-04)'],
                  'alpha-2-code': 'TT',
                  'alpha-3-code': 'TTO',
                  'continent': 'Северная Америка',
                  'name': 'Тринидад и Тобаго',
                  'capital': 'Порт-оф-Спейн'},
                 {'timezones': ['Тувалу (UTC+12)'],
                  'alpha-2-code': 'TV',
                  'alpha-3-code': 'TUV',
                  'continent': 'Океания',
                  'name': 'Тувалу',
                  'capital': 'Фунафути'},
                 {'timezones': ['Танзания (UTC+03)'],
                  'alpha-2-code': 'TZ',
                  'alpha-3-code': 'TZA',
                  'continent': 'Африка',
                  'name': 'Танзания',
                  'capital': 'Додома'},
                 {'timezones': ['Украина (UTC+02)',
                                'Украина (UTC+03)'],
                  'alpha-2-code': 'UA',
                  'alpha-3-code': 'UKR',
                  'continent': 'Европа',
                  'name': 'Украина',
                  'capital': 'Киев'},
                 {'timezones': ['Уганда (UTC+03)'],
                  'alpha-2-code': 'UG',
                  'alpha-3-code': 'UGA',
                  'continent': 'Африка',
                  'name': 'Уганда',
                  'capital': 'Кампала'},
                 {'timezones': ['США (UTC-11)',
                                'США (UTC-10)',
                                'США (UTC-09)',
                                'США (UTC-08)',
                                'США (UTC-07)',
                                'США (UTC-06)',
                                'США (UTC-05)',
                                'США (UTC-04)',
                                'США (UTC+10)'],
                  'alpha-2-code': 'US',
                  'alpha-3-code': 'USA',
                  'continent': 'Северная Америка',
                  'name': 'США',
                  'capital': 'Вашингтон'},
                 {'timezones': ['Уругвай (UTC-03)'],
                  'alpha-2-code': 'UY',
                  'alpha-3-code': 'URY',
                  'continent': 'Южная Америка',
                  'name': 'Уругвай',
                  'capital': 'Монтевидео'},
                 {'timezones': ['Узбекистан (UTC+05)'],
                  'alpha-2-code': 'UZ',
                  'alpha-3-code': 'UZB',
                  'continent': 'Азия',
                  'name': 'Узбекистан',
                  'capital': 'Ташкент'},
                 {'timezones': ['Ватикан (UTC+01)'],
                  'alpha-2-code': 'VA',
                  'alpha-3-code': 'VAT',
                  'continent': 'Европа',
                  'name': 'Ватикан',
                  'capital': 'Ватикан'},
                 {'timezones': ['Венесуэла (UTC-04:30)'],
                  'alpha-2-code': 'VE',
                  'alpha-3-code': 'VEN',
                  'continent': 'Южная Америка',
                  'name': 'Венесуэла',
                  'capital': 'Каракас'},
                 {'timezones': ['Вьетнам (UTC+07)'],
                  'alpha-2-code': 'VN',
                  'alpha-3-code': 'VNM',
                  'continent': 'Азия',
                  'name': 'Вьетнам',
                  'capital': 'Ханой'},
                 {'timezones': ['Вануату (UTC+11)'],
                  'alpha-2-code': 'VU',
                  'alpha-3-code': 'VUT',
                  'continent': 'Океания',
                  'name': 'Вануату',
                  'capital': 'Порт-Вила'},
                 {'timezones': ['Йемен (UTC+03)'],
                  'alpha-2-code': 'YE',
                  'alpha-3-code': 'YEM',
                  'continent': 'Азия',
                  'name': 'Йемен',
                  'capital': "Сана"},
                 {'timezones': ['Замбия (UTC+02)'],
                  'alpha-2-code': 'ZM',
                  'alpha-3-code': 'ZMB',
                  'continent': 'Африка',
                  'name': 'Замбия',
                  'capital': 'Лусака'},
                 {'timezones': ['Зимбабве (UTC+02)'],
                  'alpha-2-code': 'ZW',
                  'alpha-3-code': 'ZWE',
                  'continent': 'Африка',
                  'name': 'Зимбабве',
                  'capital': 'Хараре'},
                 {'timezones': ['Алжир (UTC+01)'],
                  'alpha-2-code': 'DZ',
                  'alpha-3-code': 'DZA',
                  'continent': 'Африка',
                  'name': 'Алжир',
                  'capital': 'Алжир'},
                 {'timezones': ['Босния и Герцеговина (UTC+01)'],
                  'alpha-2-code': 'BA',
                  'alpha-3-code': 'BIH',
                  'continent': 'Европа',
                  'name': 'Босния и Герцеговина',
                  'capital': 'Сараево'},
                 {'timezones': ['Камбоджа (UTC+07)'],
                  'alpha-2-code': 'KH',
                  'alpha-3-code': 'KHM',
                  'continent': 'Азия',
                  'name': 'Камбоджа',
                  'capital': 'Пномпень'},
                 {'timezones': ['ЦАР (UTC+01)'],
                  'alpha-2-code': 'CF',
                  'alpha-3-code': 'CAF',
                  'continent': 'Африка',
                  'name': 'ЦАР',
                  'capital': 'Банги'},
                 {'timezones': ['Чад (UTC+01)'],
                  'alpha-2-code': 'TD',
                  'alpha-3-code': 'TCD',
                  'continent': 'Африка',
                  'name': 'Чад',
                  'capital': "Нджамена"},
                 {'timezones': ['Коморы (UTC+03)'],
                  'alpha-2-code': 'KM',
                  'alpha-3-code': 'COM',
                  'continent': 'Африка',
                  'name': 'Коморы',
                  'capital': 'Морони'},
                 {'timezones': ['Хорватия (UTC+01)'],
                  'alpha-2-code': 'HR',
                  'alpha-3-code': 'HRV',
                  'continent': 'Европа',
                  'name': 'Хорватия',
                  'capital': 'Загреб'},
                 {'timezones': ['Восточный Тимор (UTC+09)'],
                  'alpha-2-code': 'TL',
                  'alpha-3-code': 'TLS',
                  'continent': 'Азия',
                  'name': 'Восточный Тимор',
                  'capital': 'Дили'},
                 {'timezones': ['Сальвадор (UTC-06)'],
                  'alpha-2-code': 'SV',
                  'alpha-3-code': 'SLV',
                  'continent': 'Северная Америка',
                  'name': 'Сальвадор',
                  'capital': 'Сан-Сальвадор'},
                 {'timezones': ['Экваториальная Гвинея (UTC+01)'],
                  'alpha-2-code': 'GQ',
                  'alpha-3-code': 'GNQ',
                  'continent': 'Африка',
                  'name': 'Экваториальная Гвинея',
                  'capital': 'Малабо'},
                 {'timezones': ['Гренада (UTC-04)'],
                  'alpha-2-code': 'GD',
                  'alpha-3-code': 'GRD',
                  'continent': 'Северная Америка',
                  'name': 'Гренада',
                  'capital': "Сент-Джорджес"},
                 {'timezones': ['Казахстан (UTC+05)',
                                'Казахстан (UTC+06)'],
                  'alpha-2-code': 'KZ',
                  'alpha-3-code': 'KAZ',
                  'continent': 'Азия',
                  'name': 'Казахстан',
                  'capital': 'Нур-Султан (Астана)'},
                 {'timezones': ['Лаос (UTC+07)'],
                  'alpha-2-code': 'LA',
                  'alpha-3-code': 'LAO',
                  'continent': 'Азия',
                  'name': 'Лаос',
                  'capital': 'Вьентьян'},
                 {'timezones': ['Микронезия (UTC+10)',
                                'Микронезия (UTC+11)'],
                  'alpha-2-code': 'FM',
                  'alpha-3-code': 'FSM',
                  'continent': 'Океания',
                  'name': 'Микронезия',
                  'capital': 'Паликир'},
                 {'timezones': ['Молдавия (UTC+02)'],
                  'alpha-2-code': 'MD',
                  'alpha-3-code': 'MDA',
                  'continent': 'Европа',
                  'name': 'Молдавия',
                  'capital': 'Кишинев'},
                 {'timezones': ['Монако (UTC+01)'],
                  'alpha-2-code': 'MC',
                  'alpha-3-code': 'MCO',
                  'continent': 'Европа',
                  'name': 'Монако',
                  'capital': 'Монако'},
                 {'timezones': ['Черногория (UTC+01)'],
                  'alpha-2-code': 'ME',
                  'alpha-3-code': 'MNE',
                  'continent': 'Европа',
                  'name': 'Черногория',
                  'capital': 'Подгорица'},
                 {'timezones': ['Марокко (UTC)'],
                  'alpha-2-code': 'MA',
                  'alpha-3-code': 'MAR',
                  'continent': 'Африка',
                  'name': 'Марокко',
                  'capital': 'Рабат'},
                 {'timezones': ['Сент-Китс и Невис (UTC-04)'],
                  'alpha-2-code': 'KN',
                  'alpha-3-code': 'KNA',
                  'continent': 'Северная Америка',
                  'name': 'Сент-Китс и Невис',
                  'capital': 'Бастер'},
                 {'timezones': ['Сент-Люсия (UTC-04)'],
                  'alpha-2-code': 'LC',
                  'alpha-3-code': 'LCA',
                  'continent': 'Северная Америка',
                  'name': 'Сент-Люсия',
                  'capital': 'Кастри'},
                 {'timezones': ['Сент-Винсент и Гренадины (UTC-04)'],
                  'alpha-2-code': 'VC',
                  'alpha-3-code': 'VCT',
                  'continent': 'Северная Америка',
                  'name': 'Сент-Винсент и Гренадины',
                  'capital': 'Кингстаун'},
                 {'timezones': ['Самоа (UTC+13)'],
                  'alpha-2-code': 'WS',
                  'alpha-3-code': 'WSM',
                  'continent': 'Океания',
                  'name': 'Самоа',
                  'capital': 'Апиа'},
                 {'timezones': ['Сербия (UTC+01)'],
                  'alpha-2-code': 'RS',
                  'alpha-3-code': 'SRB',
                  'continent': 'Европа',
                  'name': 'Сербия',
                  'capital': 'Белград'},
                 {'timezones': ['ЮАР (UTC+02)'],
                  'alpha-2-code': 'ZA',
                  'alpha-3-code': 'ZAF',
                  'continent': 'Африка',
                  'name': 'ЮАР',
                  'capital': 'Претория'},
                 {'timezones': ['Испания (UTC)',
                                'Испания (UTC+01)'],
                  'alpha-2-code': 'ES',
                  'alpha-3-code': 'ESP',
                  'continent': 'Европа',
                  'name': 'Испания',
                  'capital': 'Мадрид'},
                 {'timezones': ['Шри-Ланка (UTC+05:30)'],
                  'alpha-2-code': 'LK',
                  'alpha-3-code': 'LKA',
                  'continent': 'Азия',
                  'name': 'Шри-Ланка',
                  'capital': 'Шри-Джаяварденепура-Котте'},
                 {'timezones': ['Эсватини (Свазиленд) (UTC+02)'],
                  'alpha-2-code': 'SZ',
                  'alpha-3-code': 'SWZ',
                  'continent': 'Африка',
                  'name': 'Эсватини (Свазиленд)',
                  'capital': 'Мбабане'},
                 {'timezones': ['Швейцария (UTC+01)'],
                  'alpha-2-code': 'CH',
                  'alpha-3-code': 'CHE',
                  'continent': 'Европа',
                  'name': 'Швейцария',
                  'capital': 'Берн'},
                 {'timezones': ['ОАЭ (UTC+04)'],
                  'alpha-2-code': 'AE',
                  'alpha-3-code': 'ARE',
                  'continent': 'Азия',
                  'name': 'ОАЭ',
                  'capital': 'Абу-Даби'},
                 {'timezones': ['Великобритания (UTC)'],
                  'alpha-2-code': 'GB',
                  'alpha-3-code': 'GBR',
                  'continent': 'Европа',
                  'name': 'Великобритания',
                  'capital': 'Лондон'},
                 ]

    def day_of_week(self):
        day = self.date('%w')
        return self.DAY_NAMES[day]

    def month_name(self):
        month = self.month()
        return self.MONTH_NAMES[month]
