import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface AlpsSpecRestApiProps {
    /**
     * Optional mapping from openApi spec operationId to Lambda name.
     *
     * Per default it uses a Lambda integration with using the openApi spec operationId property as Lambda name
     *
     * @stability stable
     */
    readonly operationIdLambdaMapping?: Record<string, string>;
    /**
     * ALPS Spec File.
     *
     * Must be YAML.
     *
     * @stability stable
     */
    readonly alpsSpecFile: string;
}
/**
 * @stability stable
 */
export declare class AlpsSpecRestApi extends cdk.Construct {
    /**
     * @stability stable
     */
    operationIdLambdaMapping?: Record<string, string>;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AlpsSpecRestApiProps);
}
