# coding: utf-8

"""
    Kubeflow Trainer OpenAPI Spec

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: unversioned
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kubeflow.trainer.models.io_k8s_apimachinery_pkg_apis_meta_v1_list_meta import IoK8sApimachineryPkgApisMetaV1ListMeta
from kubeflow.trainer.models.io_k8s_apimachinery_pkg_apis_meta_v1_table_column_definition import IoK8sApimachineryPkgApisMetaV1TableColumnDefinition
from kubeflow.trainer.models.io_k8s_apimachinery_pkg_apis_meta_v1_table_row import IoK8sApimachineryPkgApisMetaV1TableRow
from typing import Optional, Set
from typing_extensions import Self

class IoK8sApimachineryPkgApisMetaV1Table(BaseModel):
    """
    Table is a tabular representation of a set of API resources. The server transforms the object into a set of preferred columns for quickly reviewing the objects.
    """ # noqa: E501
    api_version: Optional[StrictStr] = Field(default=None, description="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources", alias="apiVersion")
    column_definitions: List[IoK8sApimachineryPkgApisMetaV1TableColumnDefinition] = Field(description="columnDefinitions describes each column in the returned items array. The number of cells per row will always match the number of column definitions.", alias="columnDefinitions")
    kind: Optional[StrictStr] = Field(default=None, description="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    metadata: Optional[IoK8sApimachineryPkgApisMetaV1ListMeta] = Field(default=None, description="Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    rows: List[IoK8sApimachineryPkgApisMetaV1TableRow] = Field(description="rows is the list of items in the table.")
    __properties: ClassVar[List[str]] = ["apiVersion", "columnDefinitions", "kind", "metadata", "rows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IoK8sApimachineryPkgApisMetaV1Table from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in column_definitions (list)
        _items = []
        if self.column_definitions:
            for _item_column_definitions in self.column_definitions:
                if _item_column_definitions:
                    _items.append(_item_column_definitions.to_dict())
            _dict['columnDefinitions'] = _items
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rows (list)
        _items = []
        if self.rows:
            for _item_rows in self.rows:
                if _item_rows:
                    _items.append(_item_rows.to_dict())
            _dict['rows'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IoK8sApimachineryPkgApisMetaV1Table from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiVersion": obj.get("apiVersion"),
            "columnDefinitions": [IoK8sApimachineryPkgApisMetaV1TableColumnDefinition.from_dict(_item) for _item in obj["columnDefinitions"]] if obj.get("columnDefinitions") is not None else None,
            "kind": obj.get("kind"),
            "metadata": IoK8sApimachineryPkgApisMetaV1ListMeta.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "rows": [IoK8sApimachineryPkgApisMetaV1TableRow.from_dict(_item) for _item in obj["rows"]] if obj.get("rows") is not None else None
        })
        return _obj


