# coding: utf-8

"""
    Kubeflow Trainer OpenAPI Spec

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: unversioned
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kubeflow.trainer.models.io_k8s_api_core_v1_topology_selector_label_requirement import IoK8sApiCoreV1TopologySelectorLabelRequirement
from typing import Optional, Set
from typing_extensions import Self

class IoK8sApiCoreV1TopologySelectorTerm(BaseModel):
    """
    A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future.
    """ # noqa: E501
    match_label_expressions: Optional[List[IoK8sApiCoreV1TopologySelectorLabelRequirement]] = Field(default=None, description="A list of topology selector requirements by labels.", alias="matchLabelExpressions")
    __properties: ClassVar[List[str]] = ["matchLabelExpressions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1TopologySelectorTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in match_label_expressions (list)
        _items = []
        if self.match_label_expressions:
            for _item_match_label_expressions in self.match_label_expressions:
                if _item_match_label_expressions:
                    _items.append(_item_match_label_expressions.to_dict())
            _dict['matchLabelExpressions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1TopologySelectorTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "matchLabelExpressions": [IoK8sApiCoreV1TopologySelectorLabelRequirement.from_dict(_item) for _item in obj["matchLabelExpressions"]] if obj.get("matchLabelExpressions") is not None else None
        })
        return _obj


