# coding: utf-8

"""
    Kubeflow Trainer OpenAPI Spec

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: unversioned
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kubeflow.trainer.models.io_k8s_api_core_v1_node_config_source import IoK8sApiCoreV1NodeConfigSource
from kubeflow.trainer.models.io_k8s_api_core_v1_taint import IoK8sApiCoreV1Taint
from typing import Optional, Set
from typing_extensions import Self

class IoK8sApiCoreV1NodeSpec(BaseModel):
    """
    NodeSpec describes the attributes that a node is created with.
    """ # noqa: E501
    config_source: Optional[IoK8sApiCoreV1NodeConfigSource] = Field(default=None, description="Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.", alias="configSource")
    external_id: Optional[StrictStr] = Field(default=None, description="Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966", alias="externalID")
    pod_cidr: Optional[StrictStr] = Field(default=None, description="PodCIDR represents the pod IP range assigned to the node.", alias="podCIDR")
    pod_cidrs: Optional[List[StrictStr]] = Field(default=None, description="podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.", alias="podCIDRs")
    provider_id: Optional[StrictStr] = Field(default=None, description="ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>", alias="providerID")
    taints: Optional[List[IoK8sApiCoreV1Taint]] = Field(default=None, description="If specified, the node's taints.")
    unschedulable: Optional[StrictBool] = Field(default=None, description="Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration")
    __properties: ClassVar[List[str]] = ["configSource", "externalID", "podCIDR", "podCIDRs", "providerID", "taints", "unschedulable"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1NodeSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config_source
        if self.config_source:
            _dict['configSource'] = self.config_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in taints (list)
        _items = []
        if self.taints:
            for _item_taints in self.taints:
                if _item_taints:
                    _items.append(_item_taints.to_dict())
            _dict['taints'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1NodeSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configSource": IoK8sApiCoreV1NodeConfigSource.from_dict(obj["configSource"]) if obj.get("configSource") is not None else None,
            "externalID": obj.get("externalID"),
            "podCIDR": obj.get("podCIDR"),
            "podCIDRs": obj.get("podCIDRs"),
            "providerID": obj.get("providerID"),
            "taints": [IoK8sApiCoreV1Taint.from_dict(_item) for _item in obj["taints"]] if obj.get("taints") is not None else None,
            "unschedulable": obj.get("unschedulable")
        })
        return _obj


