# coding: utf-8

"""
    Kubeflow Trainer OpenAPI Spec

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: unversioned
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kubeflow.trainer.models.io_k8s_api_core_v1_event_series import IoK8sApiCoreV1EventSeries
from kubeflow.trainer.models.io_k8s_api_core_v1_event_source import IoK8sApiCoreV1EventSource
from kubeflow.trainer.models.io_k8s_api_core_v1_object_reference import IoK8sApiCoreV1ObjectReference
from kubeflow.trainer.models.io_k8s_apimachinery_pkg_apis_meta_v1_object_meta import IoK8sApimachineryPkgApisMetaV1ObjectMeta
from typing import Optional, Set
from typing_extensions import Self

class IoK8sApiCoreV1Event(BaseModel):
    """
    Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
    """ # noqa: E501
    action: Optional[StrictStr] = Field(default=None, description="What action was taken/failed regarding to the Regarding object.")
    api_version: Optional[StrictStr] = Field(default=None, description="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources", alias="apiVersion")
    count: Optional[StrictInt] = Field(default=None, description="The number of times this event has occurred.")
    event_time: Optional[datetime] = Field(default=None, description="Time when this Event was first observed.", alias="eventTime")
    first_timestamp: Optional[datetime] = Field(default=None, description="The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)", alias="firstTimestamp")
    involved_object: IoK8sApiCoreV1ObjectReference = Field(description="The object that this event is about.", alias="involvedObject")
    kind: Optional[StrictStr] = Field(default=None, description="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    last_timestamp: Optional[datetime] = Field(default=None, description="The time at which the most recent occurrence of this event was recorded.", alias="lastTimestamp")
    message: Optional[StrictStr] = Field(default=None, description="A human-readable description of the status of this operation.")
    metadata: IoK8sApimachineryPkgApisMetaV1ObjectMeta = Field(description="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata")
    reason: Optional[StrictStr] = Field(default=None, description="This should be a short, machine understandable string that gives the reason for the transition into the object's current status.")
    related: Optional[IoK8sApiCoreV1ObjectReference] = Field(default=None, description="Optional secondary object for more complex actions.")
    reporting_component: Optional[StrictStr] = Field(default='', description="Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.", alias="reportingComponent")
    reporting_instance: Optional[StrictStr] = Field(default='', description="ID of the controller instance, e.g. `kubelet-xyzf`.", alias="reportingInstance")
    series: Optional[IoK8sApiCoreV1EventSeries] = Field(default=None, description="Data about the Event series this event represents or nil if it's a singleton Event.")
    source: Optional[IoK8sApiCoreV1EventSource] = Field(default=None, description="The component reporting this event. Should be a short machine understandable string.")
    type: Optional[StrictStr] = Field(default=None, description="Type of this event (Normal, Warning), new types could be added in the future")
    __properties: ClassVar[List[str]] = ["action", "apiVersion", "count", "eventTime", "firstTimestamp", "involvedObject", "kind", "lastTimestamp", "message", "metadata", "reason", "related", "reportingComponent", "reportingInstance", "series", "source", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1Event from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of involved_object
        if self.involved_object:
            _dict['involvedObject'] = self.involved_object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of related
        if self.related:
            _dict['related'] = self.related.to_dict()
        # override the default output from pydantic by calling `to_dict()` of series
        if self.series:
            _dict['series'] = self.series.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IoK8sApiCoreV1Event from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "apiVersion": obj.get("apiVersion"),
            "count": obj.get("count"),
            "eventTime": obj.get("eventTime"),
            "firstTimestamp": obj.get("firstTimestamp"),
            "involvedObject": IoK8sApiCoreV1ObjectReference.from_dict(obj["involvedObject"]) if obj.get("involvedObject") is not None else None,
            "kind": obj.get("kind"),
            "lastTimestamp": obj.get("lastTimestamp"),
            "message": obj.get("message"),
            "metadata": IoK8sApimachineryPkgApisMetaV1ObjectMeta.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "reason": obj.get("reason"),
            "related": IoK8sApiCoreV1ObjectReference.from_dict(obj["related"]) if obj.get("related") is not None else None,
            "reportingComponent": obj.get("reportingComponent") if obj.get("reportingComponent") is not None else '',
            "reportingInstance": obj.get("reportingInstance") if obj.get("reportingInstance") is not None else '',
            "series": IoK8sApiCoreV1EventSeries.from_dict(obj["series"]) if obj.get("series") is not None else None,
            "source": IoK8sApiCoreV1EventSource.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "type": obj.get("type")
        })
        return _obj


