#pragma once
/**********************************************************
 *					Dfinition de la page de garde DOxygen
 **********************************************************/
/**
 * \mainpage Implementation de l'algorithme de compression de RICE du projet DESIR
 * \image html logo.jpg
 * \section Info Informations
 * \author Loc Gueguen
 * \version 1.0
 * \date
 * \section Description Description de la bibliothque
 * Bibliothque de compression et de dcompression base sur l'agorithme de RICE du CCSDS (SZIP)
 * L'algorithme est adapt aux spcficits du projet DESIR,  savoir:
 *	- Les pixels sont cods sur 16 bits
 *	- Le nombre de pixels est un multiple de 16
 */

/**********************************************************
 *					Dfinition des sections DOxygen
 **********************************************************/
/**
 * \defgroup Exposed  Fonctions et types exposs dans la DLL
 * \defgroup NotExposed  Fonctions et types non exposs dans la DLL
 * \defgroup NotExposedCompressor  Fonctions et variables lies  la compression
			* \ingroup NotExposed
 * \defgroup NotExposedUncompressor Fonctions et variables lies  la decompression
			* \ingroup NotExposed
 * \defgroup Constantes  Constantes et macros prdfinies
 */


/**
 * \ingroup Exposed
* @{
*/
#include "GsrPreprocessMode.h"

/**
 * \brief fonction effectuant le pre-processing des donnes
 * \param data Tableau de donnes  transformer. Doit tre de type UI16
 * \param nbInput Taille du tableau
 * \param preprocessed Tableau contenant les donnes preprocesses (doit tre allou)
 * \param mode Mode de transformation
 * \return Nombre de donnes utiles dans le tableau transform
 */
int preprocess(unsigned short* data,int nbInput,unsigned int* preprocessed,PreprocessMode mode);
/**
 * \brief Fonction effectuant la compression d'un bloc de donnes
 * \param data Tableau de donnes  compresser
 * \param nbInput Taille du tableau
 * \param compressed Tableau de retour pour les donnes compresses
 * \param compressedLen Taille du tableau de retour
 * \return la taille en octet du tableau compress ou -1 en cas d'erreur
 */
int compress(unsigned int* data,int nbInput,unsigned char* compressed,int compressedLen);
/**@}*/ // End of group Exposed
