# KubeMQ Python SDK 

KubeMQ is an enterprise-grade message queue and broker for containers, designed for any workload and architecture running in Kubernetes.
This library is Python implementation of KubeMQ client connection.

## Install KubeMQ Community Edition
Please visit [KubeMQ Community](https://github.com/kubemq-io/kubemq-community) for intallation steps.

## Examples - Cookbook Recipes
Please visit our cookbook [repository](https://github.com/kubemq-io/python-sdk-cookbook)

## Install Python SDK
### Prerequisites

KubeMQ-SDK-Python works with **Python 3.2** or newer.

### Installing
 
The recommended way to use the SDK for Python in your project is to consume it from pip.

```
pip install kubemq
```

This package uses setuptools for the installation if needed please run:
```
python3 -m pip install --upgrade pip setuptools wheel
```

### Building from source

Once you check out the code from GitHub, you can install the package locally with:

```
$ pip install .
```

You can also install the package with a symlink, 
so that changes to the source files will be immediately available:

```
$ pip install -e .
```

Installation:
$ pip install kubemq

## Learn KubeMQ
Visit our [Extensive KubeMQ Documentation](https://docs.kubemq.io/).

## Support
if you encounter any issues, please open an issue here,
In addition, you can reach us for support by:
- [**Email**](mailto://support@kubemq.io)
- [**Slack**](https://kubmq.slack.com)
