# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebApplicationArgs', 'WebApplication']

@pulumi.input_type
class WebApplicationArgs:
    def __init__(__self__, *,
                 cost_control_user_session_percentage: pulumi.Input[int],
                 custom_action_apdex_settings: pulumi.Input['WebApplicationCustomActionApdexSettingsArgs'],
                 load_action_apdex_settings: pulumi.Input['WebApplicationLoadActionApdexSettingsArgs'],
                 load_action_key_performance_metric: pulumi.Input[str],
                 monitoring_settings: pulumi.Input['WebApplicationMonitoringSettingsArgs'],
                 type: pulumi.Input[str],
                 waterfall_settings: pulumi.Input['WebApplicationWaterfallSettingsArgs'],
                 xhr_action_apdex_settings: pulumi.Input['WebApplicationXhrActionApdexSettingsArgs'],
                 xhr_action_key_performance_metric: pulumi.Input[str],
                 conversion_goals: Optional[pulumi.Input['WebApplicationConversionGoalsArgs']] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]] = None,
                 meta_data_capture_settings: Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_user_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 session_replay_config: Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']] = None,
                 url_injection_pattern: Optional[pulumi.Input[str]] = None,
                 user_action_and_session_properties: Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']] = None,
                 user_action_naming_settings: Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']] = None,
                 user_tags: Optional[pulumi.Input['WebApplicationUserTagsArgs']] = None):
        """
        The set of arguments for constructing a WebApplication resource.
        :param pulumi.Input[int] cost_control_user_session_percentage: (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        :param pulumi.Input['WebApplicationCustomActionApdexSettingsArgs'] custom_action_apdex_settings: Defines the Custom Action Apdex settings of an application
        :param pulumi.Input['WebApplicationLoadActionApdexSettingsArgs'] load_action_apdex_settings: Defines the Load Action Apdex settings of an application
        :param pulumi.Input[str] load_action_key_performance_metric: The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        :param pulumi.Input['WebApplicationMonitoringSettingsArgs'] monitoring_settings: Real user monitoring settings
        :param pulumi.Input[str] type: The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        :param pulumi.Input['WebApplicationWaterfallSettingsArgs'] waterfall_settings: These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        :param pulumi.Input['WebApplicationXhrActionApdexSettingsArgs'] xhr_action_apdex_settings: Defines the XHR Action Apdex settings of an application
        :param pulumi.Input[str] xhr_action_key_performance_metric: The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        :param pulumi.Input['WebApplicationConversionGoalsArgs'] conversion_goals: A list of conversion goals of the application
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs'] meta_data_capture_settings: Java script agent meta data capture settings
        :param pulumi.Input[str] name: The name of the web application, displayed in the UI
        :param pulumi.Input[bool] real_user_monitoring_enabled: (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        :param pulumi.Input['WebApplicationSessionReplayConfigArgs'] session_replay_config: Settings regarding Session Replay
        :param pulumi.Input[str] url_injection_pattern: URL injection pattern for manual web application
        :param pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs'] user_action_and_session_properties: User action and session properties settings
        :param pulumi.Input['WebApplicationUserActionNamingSettingsArgs'] user_action_naming_settings: The settings of user action naming
        :param pulumi.Input['WebApplicationUserTagsArgs'] user_tags: User tags settings
        """
        pulumi.set(__self__, "cost_control_user_session_percentage", cost_control_user_session_percentage)
        pulumi.set(__self__, "custom_action_apdex_settings", custom_action_apdex_settings)
        pulumi.set(__self__, "load_action_apdex_settings", load_action_apdex_settings)
        pulumi.set(__self__, "load_action_key_performance_metric", load_action_key_performance_metric)
        pulumi.set(__self__, "monitoring_settings", monitoring_settings)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "waterfall_settings", waterfall_settings)
        pulumi.set(__self__, "xhr_action_apdex_settings", xhr_action_apdex_settings)
        pulumi.set(__self__, "xhr_action_key_performance_metric", xhr_action_key_performance_metric)
        if conversion_goals is not None:
            pulumi.set(__self__, "conversion_goals", conversion_goals)
        if key_user_actions is not None:
            warnings.warn("""Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""", DeprecationWarning)
            pulumi.log.warn("""key_user_actions is deprecated: Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""")
        if key_user_actions is not None:
            pulumi.set(__self__, "key_user_actions", key_user_actions)
        if meta_data_capture_settings is not None:
            pulumi.set(__self__, "meta_data_capture_settings", meta_data_capture_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if real_user_monitoring_enabled is not None:
            pulumi.set(__self__, "real_user_monitoring_enabled", real_user_monitoring_enabled)
        if session_replay_config is not None:
            pulumi.set(__self__, "session_replay_config", session_replay_config)
        if url_injection_pattern is not None:
            pulumi.set(__self__, "url_injection_pattern", url_injection_pattern)
        if user_action_and_session_properties is not None:
            pulumi.set(__self__, "user_action_and_session_properties", user_action_and_session_properties)
        if user_action_naming_settings is not None:
            pulumi.set(__self__, "user_action_naming_settings", user_action_naming_settings)
        if user_tags is not None:
            pulumi.set(__self__, "user_tags", user_tags)

    @property
    @pulumi.getter(name="costControlUserSessionPercentage")
    def cost_control_user_session_percentage(self) -> pulumi.Input[int]:
        """
        (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        """
        return pulumi.get(self, "cost_control_user_session_percentage")

    @cost_control_user_session_percentage.setter
    def cost_control_user_session_percentage(self, value: pulumi.Input[int]):
        pulumi.set(self, "cost_control_user_session_percentage", value)

    @property
    @pulumi.getter(name="customActionApdexSettings")
    def custom_action_apdex_settings(self) -> pulumi.Input['WebApplicationCustomActionApdexSettingsArgs']:
        """
        Defines the Custom Action Apdex settings of an application
        """
        return pulumi.get(self, "custom_action_apdex_settings")

    @custom_action_apdex_settings.setter
    def custom_action_apdex_settings(self, value: pulumi.Input['WebApplicationCustomActionApdexSettingsArgs']):
        pulumi.set(self, "custom_action_apdex_settings", value)

    @property
    @pulumi.getter(name="loadActionApdexSettings")
    def load_action_apdex_settings(self) -> pulumi.Input['WebApplicationLoadActionApdexSettingsArgs']:
        """
        Defines the Load Action Apdex settings of an application
        """
        return pulumi.get(self, "load_action_apdex_settings")

    @load_action_apdex_settings.setter
    def load_action_apdex_settings(self, value: pulumi.Input['WebApplicationLoadActionApdexSettingsArgs']):
        pulumi.set(self, "load_action_apdex_settings", value)

    @property
    @pulumi.getter(name="loadActionKeyPerformanceMetric")
    def load_action_key_performance_metric(self) -> pulumi.Input[str]:
        """
        The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        """
        return pulumi.get(self, "load_action_key_performance_metric")

    @load_action_key_performance_metric.setter
    def load_action_key_performance_metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_action_key_performance_metric", value)

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> pulumi.Input['WebApplicationMonitoringSettingsArgs']:
        """
        Real user monitoring settings
        """
        return pulumi.get(self, "monitoring_settings")

    @monitoring_settings.setter
    def monitoring_settings(self, value: pulumi.Input['WebApplicationMonitoringSettingsArgs']):
        pulumi.set(self, "monitoring_settings", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="waterfallSettings")
    def waterfall_settings(self) -> pulumi.Input['WebApplicationWaterfallSettingsArgs']:
        """
        These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        """
        return pulumi.get(self, "waterfall_settings")

    @waterfall_settings.setter
    def waterfall_settings(self, value: pulumi.Input['WebApplicationWaterfallSettingsArgs']):
        pulumi.set(self, "waterfall_settings", value)

    @property
    @pulumi.getter(name="xhrActionApdexSettings")
    def xhr_action_apdex_settings(self) -> pulumi.Input['WebApplicationXhrActionApdexSettingsArgs']:
        """
        Defines the XHR Action Apdex settings of an application
        """
        return pulumi.get(self, "xhr_action_apdex_settings")

    @xhr_action_apdex_settings.setter
    def xhr_action_apdex_settings(self, value: pulumi.Input['WebApplicationXhrActionApdexSettingsArgs']):
        pulumi.set(self, "xhr_action_apdex_settings", value)

    @property
    @pulumi.getter(name="xhrActionKeyPerformanceMetric")
    def xhr_action_key_performance_metric(self) -> pulumi.Input[str]:
        """
        The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        return pulumi.get(self, "xhr_action_key_performance_metric")

    @xhr_action_key_performance_metric.setter
    def xhr_action_key_performance_metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "xhr_action_key_performance_metric", value)

    @property
    @pulumi.getter(name="conversionGoals")
    def conversion_goals(self) -> Optional[pulumi.Input['WebApplicationConversionGoalsArgs']]:
        """
        A list of conversion goals of the application
        """
        return pulumi.get(self, "conversion_goals")

    @conversion_goals.setter
    def conversion_goals(self, value: Optional[pulumi.Input['WebApplicationConversionGoalsArgs']]):
        pulumi.set(self, "conversion_goals", value)

    @property
    @pulumi.getter(name="keyUserActions")
    @_utilities.deprecated("""Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""")
    def key_user_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @key_user_actions.setter
    def key_user_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]]):
        pulumi.set(self, "key_user_actions", value)

    @property
    @pulumi.getter(name="metaDataCaptureSettings")
    def meta_data_capture_settings(self) -> Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']]:
        """
        Java script agent meta data capture settings
        """
        return pulumi.get(self, "meta_data_capture_settings")

    @meta_data_capture_settings.setter
    def meta_data_capture_settings(self, value: Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']]):
        pulumi.set(self, "meta_data_capture_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the web application, displayed in the UI
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realUserMonitoringEnabled")
    def real_user_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        """
        return pulumi.get(self, "real_user_monitoring_enabled")

    @real_user_monitoring_enabled.setter
    def real_user_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "real_user_monitoring_enabled", value)

    @property
    @pulumi.getter(name="sessionReplayConfig")
    def session_replay_config(self) -> Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']]:
        """
        Settings regarding Session Replay
        """
        return pulumi.get(self, "session_replay_config")

    @session_replay_config.setter
    def session_replay_config(self, value: Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']]):
        pulumi.set(self, "session_replay_config", value)

    @property
    @pulumi.getter(name="urlInjectionPattern")
    def url_injection_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        URL injection pattern for manual web application
        """
        return pulumi.get(self, "url_injection_pattern")

    @url_injection_pattern.setter
    def url_injection_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_injection_pattern", value)

    @property
    @pulumi.getter(name="userActionAndSessionProperties")
    def user_action_and_session_properties(self) -> Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']]:
        """
        User action and session properties settings
        """
        return pulumi.get(self, "user_action_and_session_properties")

    @user_action_and_session_properties.setter
    def user_action_and_session_properties(self, value: Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']]):
        pulumi.set(self, "user_action_and_session_properties", value)

    @property
    @pulumi.getter(name="userActionNamingSettings")
    def user_action_naming_settings(self) -> Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']]:
        """
        The settings of user action naming
        """
        return pulumi.get(self, "user_action_naming_settings")

    @user_action_naming_settings.setter
    def user_action_naming_settings(self, value: Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']]):
        pulumi.set(self, "user_action_naming_settings", value)

    @property
    @pulumi.getter(name="userTags")
    def user_tags(self) -> Optional[pulumi.Input['WebApplicationUserTagsArgs']]:
        """
        User tags settings
        """
        return pulumi.get(self, "user_tags")

    @user_tags.setter
    def user_tags(self, value: Optional[pulumi.Input['WebApplicationUserTagsArgs']]):
        pulumi.set(self, "user_tags", value)


@pulumi.input_type
class _WebApplicationState:
    def __init__(__self__, *,
                 conversion_goals: Optional[pulumi.Input['WebApplicationConversionGoalsArgs']] = None,
                 cost_control_user_session_percentage: Optional[pulumi.Input[int]] = None,
                 custom_action_apdex_settings: Optional[pulumi.Input['WebApplicationCustomActionApdexSettingsArgs']] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]] = None,
                 load_action_apdex_settings: Optional[pulumi.Input['WebApplicationLoadActionApdexSettingsArgs']] = None,
                 load_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
                 meta_data_capture_settings: Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']] = None,
                 monitoring_settings: Optional[pulumi.Input['WebApplicationMonitoringSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_user_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 session_replay_config: Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url_injection_pattern: Optional[pulumi.Input[str]] = None,
                 user_action_and_session_properties: Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']] = None,
                 user_action_naming_settings: Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']] = None,
                 user_tags: Optional[pulumi.Input['WebApplicationUserTagsArgs']] = None,
                 waterfall_settings: Optional[pulumi.Input['WebApplicationWaterfallSettingsArgs']] = None,
                 xhr_action_apdex_settings: Optional[pulumi.Input['WebApplicationXhrActionApdexSettingsArgs']] = None,
                 xhr_action_key_performance_metric: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WebApplication resources.
        :param pulumi.Input['WebApplicationConversionGoalsArgs'] conversion_goals: A list of conversion goals of the application
        :param pulumi.Input[int] cost_control_user_session_percentage: (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        :param pulumi.Input['WebApplicationCustomActionApdexSettingsArgs'] custom_action_apdex_settings: Defines the Custom Action Apdex settings of an application
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input['WebApplicationLoadActionApdexSettingsArgs'] load_action_apdex_settings: Defines the Load Action Apdex settings of an application
        :param pulumi.Input[str] load_action_key_performance_metric: The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        :param pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs'] meta_data_capture_settings: Java script agent meta data capture settings
        :param pulumi.Input['WebApplicationMonitoringSettingsArgs'] monitoring_settings: Real user monitoring settings
        :param pulumi.Input[str] name: The name of the web application, displayed in the UI
        :param pulumi.Input[bool] real_user_monitoring_enabled: (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        :param pulumi.Input['WebApplicationSessionReplayConfigArgs'] session_replay_config: Settings regarding Session Replay
        :param pulumi.Input[str] type: The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        :param pulumi.Input[str] url_injection_pattern: URL injection pattern for manual web application
        :param pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs'] user_action_and_session_properties: User action and session properties settings
        :param pulumi.Input['WebApplicationUserActionNamingSettingsArgs'] user_action_naming_settings: The settings of user action naming
        :param pulumi.Input['WebApplicationUserTagsArgs'] user_tags: User tags settings
        :param pulumi.Input['WebApplicationWaterfallSettingsArgs'] waterfall_settings: These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        :param pulumi.Input['WebApplicationXhrActionApdexSettingsArgs'] xhr_action_apdex_settings: Defines the XHR Action Apdex settings of an application
        :param pulumi.Input[str] xhr_action_key_performance_metric: The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        if conversion_goals is not None:
            pulumi.set(__self__, "conversion_goals", conversion_goals)
        if cost_control_user_session_percentage is not None:
            pulumi.set(__self__, "cost_control_user_session_percentage", cost_control_user_session_percentage)
        if custom_action_apdex_settings is not None:
            pulumi.set(__self__, "custom_action_apdex_settings", custom_action_apdex_settings)
        if key_user_actions is not None:
            warnings.warn("""Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""", DeprecationWarning)
            pulumi.log.warn("""key_user_actions is deprecated: Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""")
        if key_user_actions is not None:
            pulumi.set(__self__, "key_user_actions", key_user_actions)
        if load_action_apdex_settings is not None:
            pulumi.set(__self__, "load_action_apdex_settings", load_action_apdex_settings)
        if load_action_key_performance_metric is not None:
            pulumi.set(__self__, "load_action_key_performance_metric", load_action_key_performance_metric)
        if meta_data_capture_settings is not None:
            pulumi.set(__self__, "meta_data_capture_settings", meta_data_capture_settings)
        if monitoring_settings is not None:
            pulumi.set(__self__, "monitoring_settings", monitoring_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if real_user_monitoring_enabled is not None:
            pulumi.set(__self__, "real_user_monitoring_enabled", real_user_monitoring_enabled)
        if session_replay_config is not None:
            pulumi.set(__self__, "session_replay_config", session_replay_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url_injection_pattern is not None:
            pulumi.set(__self__, "url_injection_pattern", url_injection_pattern)
        if user_action_and_session_properties is not None:
            pulumi.set(__self__, "user_action_and_session_properties", user_action_and_session_properties)
        if user_action_naming_settings is not None:
            pulumi.set(__self__, "user_action_naming_settings", user_action_naming_settings)
        if user_tags is not None:
            pulumi.set(__self__, "user_tags", user_tags)
        if waterfall_settings is not None:
            pulumi.set(__self__, "waterfall_settings", waterfall_settings)
        if xhr_action_apdex_settings is not None:
            pulumi.set(__self__, "xhr_action_apdex_settings", xhr_action_apdex_settings)
        if xhr_action_key_performance_metric is not None:
            pulumi.set(__self__, "xhr_action_key_performance_metric", xhr_action_key_performance_metric)

    @property
    @pulumi.getter(name="conversionGoals")
    def conversion_goals(self) -> Optional[pulumi.Input['WebApplicationConversionGoalsArgs']]:
        """
        A list of conversion goals of the application
        """
        return pulumi.get(self, "conversion_goals")

    @conversion_goals.setter
    def conversion_goals(self, value: Optional[pulumi.Input['WebApplicationConversionGoalsArgs']]):
        pulumi.set(self, "conversion_goals", value)

    @property
    @pulumi.getter(name="costControlUserSessionPercentage")
    def cost_control_user_session_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        """
        return pulumi.get(self, "cost_control_user_session_percentage")

    @cost_control_user_session_percentage.setter
    def cost_control_user_session_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cost_control_user_session_percentage", value)

    @property
    @pulumi.getter(name="customActionApdexSettings")
    def custom_action_apdex_settings(self) -> Optional[pulumi.Input['WebApplicationCustomActionApdexSettingsArgs']]:
        """
        Defines the Custom Action Apdex settings of an application
        """
        return pulumi.get(self, "custom_action_apdex_settings")

    @custom_action_apdex_settings.setter
    def custom_action_apdex_settings(self, value: Optional[pulumi.Input['WebApplicationCustomActionApdexSettingsArgs']]):
        pulumi.set(self, "custom_action_apdex_settings", value)

    @property
    @pulumi.getter(name="keyUserActions")
    @_utilities.deprecated("""Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""")
    def key_user_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @key_user_actions.setter
    def key_user_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationKeyUserActionArgs']]]]):
        pulumi.set(self, "key_user_actions", value)

    @property
    @pulumi.getter(name="loadActionApdexSettings")
    def load_action_apdex_settings(self) -> Optional[pulumi.Input['WebApplicationLoadActionApdexSettingsArgs']]:
        """
        Defines the Load Action Apdex settings of an application
        """
        return pulumi.get(self, "load_action_apdex_settings")

    @load_action_apdex_settings.setter
    def load_action_apdex_settings(self, value: Optional[pulumi.Input['WebApplicationLoadActionApdexSettingsArgs']]):
        pulumi.set(self, "load_action_apdex_settings", value)

    @property
    @pulumi.getter(name="loadActionKeyPerformanceMetric")
    def load_action_key_performance_metric(self) -> Optional[pulumi.Input[str]]:
        """
        The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        """
        return pulumi.get(self, "load_action_key_performance_metric")

    @load_action_key_performance_metric.setter
    def load_action_key_performance_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_action_key_performance_metric", value)

    @property
    @pulumi.getter(name="metaDataCaptureSettings")
    def meta_data_capture_settings(self) -> Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']]:
        """
        Java script agent meta data capture settings
        """
        return pulumi.get(self, "meta_data_capture_settings")

    @meta_data_capture_settings.setter
    def meta_data_capture_settings(self, value: Optional[pulumi.Input['WebApplicationMetaDataCaptureSettingsArgs']]):
        pulumi.set(self, "meta_data_capture_settings", value)

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> Optional[pulumi.Input['WebApplicationMonitoringSettingsArgs']]:
        """
        Real user monitoring settings
        """
        return pulumi.get(self, "monitoring_settings")

    @monitoring_settings.setter
    def monitoring_settings(self, value: Optional[pulumi.Input['WebApplicationMonitoringSettingsArgs']]):
        pulumi.set(self, "monitoring_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the web application, displayed in the UI
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="realUserMonitoringEnabled")
    def real_user_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        """
        return pulumi.get(self, "real_user_monitoring_enabled")

    @real_user_monitoring_enabled.setter
    def real_user_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "real_user_monitoring_enabled", value)

    @property
    @pulumi.getter(name="sessionReplayConfig")
    def session_replay_config(self) -> Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']]:
        """
        Settings regarding Session Replay
        """
        return pulumi.get(self, "session_replay_config")

    @session_replay_config.setter
    def session_replay_config(self, value: Optional[pulumi.Input['WebApplicationSessionReplayConfigArgs']]):
        pulumi.set(self, "session_replay_config", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="urlInjectionPattern")
    def url_injection_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        URL injection pattern for manual web application
        """
        return pulumi.get(self, "url_injection_pattern")

    @url_injection_pattern.setter
    def url_injection_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_injection_pattern", value)

    @property
    @pulumi.getter(name="userActionAndSessionProperties")
    def user_action_and_session_properties(self) -> Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']]:
        """
        User action and session properties settings
        """
        return pulumi.get(self, "user_action_and_session_properties")

    @user_action_and_session_properties.setter
    def user_action_and_session_properties(self, value: Optional[pulumi.Input['WebApplicationUserActionAndSessionPropertiesArgs']]):
        pulumi.set(self, "user_action_and_session_properties", value)

    @property
    @pulumi.getter(name="userActionNamingSettings")
    def user_action_naming_settings(self) -> Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']]:
        """
        The settings of user action naming
        """
        return pulumi.get(self, "user_action_naming_settings")

    @user_action_naming_settings.setter
    def user_action_naming_settings(self, value: Optional[pulumi.Input['WebApplicationUserActionNamingSettingsArgs']]):
        pulumi.set(self, "user_action_naming_settings", value)

    @property
    @pulumi.getter(name="userTags")
    def user_tags(self) -> Optional[pulumi.Input['WebApplicationUserTagsArgs']]:
        """
        User tags settings
        """
        return pulumi.get(self, "user_tags")

    @user_tags.setter
    def user_tags(self, value: Optional[pulumi.Input['WebApplicationUserTagsArgs']]):
        pulumi.set(self, "user_tags", value)

    @property
    @pulumi.getter(name="waterfallSettings")
    def waterfall_settings(self) -> Optional[pulumi.Input['WebApplicationWaterfallSettingsArgs']]:
        """
        These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        """
        return pulumi.get(self, "waterfall_settings")

    @waterfall_settings.setter
    def waterfall_settings(self, value: Optional[pulumi.Input['WebApplicationWaterfallSettingsArgs']]):
        pulumi.set(self, "waterfall_settings", value)

    @property
    @pulumi.getter(name="xhrActionApdexSettings")
    def xhr_action_apdex_settings(self) -> Optional[pulumi.Input['WebApplicationXhrActionApdexSettingsArgs']]:
        """
        Defines the XHR Action Apdex settings of an application
        """
        return pulumi.get(self, "xhr_action_apdex_settings")

    @xhr_action_apdex_settings.setter
    def xhr_action_apdex_settings(self, value: Optional[pulumi.Input['WebApplicationXhrActionApdexSettingsArgs']]):
        pulumi.set(self, "xhr_action_apdex_settings", value)

    @property
    @pulumi.getter(name="xhrActionKeyPerformanceMetric")
    def xhr_action_key_performance_metric(self) -> Optional[pulumi.Input[str]]:
        """
        The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        return pulumi.get(self, "xhr_action_key_performance_metric")

    @xhr_action_key_performance_metric.setter
    def xhr_action_key_performance_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xhr_action_key_performance_metric", value)


class WebApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_goals: Optional[pulumi.Input[Union['WebApplicationConversionGoalsArgs', 'WebApplicationConversionGoalsArgsDict']]] = None,
                 cost_control_user_session_percentage: Optional[pulumi.Input[int]] = None,
                 custom_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationCustomActionApdexSettingsArgs', 'WebApplicationCustomActionApdexSettingsArgsDict']]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebApplicationKeyUserActionArgs', 'WebApplicationKeyUserActionArgsDict']]]]] = None,
                 load_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationLoadActionApdexSettingsArgs', 'WebApplicationLoadActionApdexSettingsArgsDict']]] = None,
                 load_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
                 meta_data_capture_settings: Optional[pulumi.Input[Union['WebApplicationMetaDataCaptureSettingsArgs', 'WebApplicationMetaDataCaptureSettingsArgsDict']]] = None,
                 monitoring_settings: Optional[pulumi.Input[Union['WebApplicationMonitoringSettingsArgs', 'WebApplicationMonitoringSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_user_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 session_replay_config: Optional[pulumi.Input[Union['WebApplicationSessionReplayConfigArgs', 'WebApplicationSessionReplayConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url_injection_pattern: Optional[pulumi.Input[str]] = None,
                 user_action_and_session_properties: Optional[pulumi.Input[Union['WebApplicationUserActionAndSessionPropertiesArgs', 'WebApplicationUserActionAndSessionPropertiesArgsDict']]] = None,
                 user_action_naming_settings: Optional[pulumi.Input[Union['WebApplicationUserActionNamingSettingsArgs', 'WebApplicationUserActionNamingSettingsArgsDict']]] = None,
                 user_tags: Optional[pulumi.Input[Union['WebApplicationUserTagsArgs', 'WebApplicationUserTagsArgsDict']]] = None,
                 waterfall_settings: Optional[pulumi.Input[Union['WebApplicationWaterfallSettingsArgs', 'WebApplicationWaterfallSettingsArgsDict']]] = None,
                 xhr_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationXhrActionApdexSettingsArgs', 'WebApplicationXhrActionApdexSettingsArgsDict']]] = None,
                 xhr_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a WebApplication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WebApplicationConversionGoalsArgs', 'WebApplicationConversionGoalsArgsDict']] conversion_goals: A list of conversion goals of the application
        :param pulumi.Input[int] cost_control_user_session_percentage: (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        :param pulumi.Input[Union['WebApplicationCustomActionApdexSettingsArgs', 'WebApplicationCustomActionApdexSettingsArgsDict']] custom_action_apdex_settings: Defines the Custom Action Apdex settings of an application
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebApplicationKeyUserActionArgs', 'WebApplicationKeyUserActionArgsDict']]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[Union['WebApplicationLoadActionApdexSettingsArgs', 'WebApplicationLoadActionApdexSettingsArgsDict']] load_action_apdex_settings: Defines the Load Action Apdex settings of an application
        :param pulumi.Input[str] load_action_key_performance_metric: The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        :param pulumi.Input[Union['WebApplicationMetaDataCaptureSettingsArgs', 'WebApplicationMetaDataCaptureSettingsArgsDict']] meta_data_capture_settings: Java script agent meta data capture settings
        :param pulumi.Input[Union['WebApplicationMonitoringSettingsArgs', 'WebApplicationMonitoringSettingsArgsDict']] monitoring_settings: Real user monitoring settings
        :param pulumi.Input[str] name: The name of the web application, displayed in the UI
        :param pulumi.Input[bool] real_user_monitoring_enabled: (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        :param pulumi.Input[Union['WebApplicationSessionReplayConfigArgs', 'WebApplicationSessionReplayConfigArgsDict']] session_replay_config: Settings regarding Session Replay
        :param pulumi.Input[str] type: The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        :param pulumi.Input[str] url_injection_pattern: URL injection pattern for manual web application
        :param pulumi.Input[Union['WebApplicationUserActionAndSessionPropertiesArgs', 'WebApplicationUserActionAndSessionPropertiesArgsDict']] user_action_and_session_properties: User action and session properties settings
        :param pulumi.Input[Union['WebApplicationUserActionNamingSettingsArgs', 'WebApplicationUserActionNamingSettingsArgsDict']] user_action_naming_settings: The settings of user action naming
        :param pulumi.Input[Union['WebApplicationUserTagsArgs', 'WebApplicationUserTagsArgsDict']] user_tags: User tags settings
        :param pulumi.Input[Union['WebApplicationWaterfallSettingsArgs', 'WebApplicationWaterfallSettingsArgsDict']] waterfall_settings: These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        :param pulumi.Input[Union['WebApplicationXhrActionApdexSettingsArgs', 'WebApplicationXhrActionApdexSettingsArgsDict']] xhr_action_apdex_settings: Defines the XHR Action Apdex settings of an application
        :param pulumi.Input[str] xhr_action_key_performance_metric: The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a WebApplication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param WebApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversion_goals: Optional[pulumi.Input[Union['WebApplicationConversionGoalsArgs', 'WebApplicationConversionGoalsArgsDict']]] = None,
                 cost_control_user_session_percentage: Optional[pulumi.Input[int]] = None,
                 custom_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationCustomActionApdexSettingsArgs', 'WebApplicationCustomActionApdexSettingsArgsDict']]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebApplicationKeyUserActionArgs', 'WebApplicationKeyUserActionArgsDict']]]]] = None,
                 load_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationLoadActionApdexSettingsArgs', 'WebApplicationLoadActionApdexSettingsArgsDict']]] = None,
                 load_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
                 meta_data_capture_settings: Optional[pulumi.Input[Union['WebApplicationMetaDataCaptureSettingsArgs', 'WebApplicationMetaDataCaptureSettingsArgsDict']]] = None,
                 monitoring_settings: Optional[pulumi.Input[Union['WebApplicationMonitoringSettingsArgs', 'WebApplicationMonitoringSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 real_user_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 session_replay_config: Optional[pulumi.Input[Union['WebApplicationSessionReplayConfigArgs', 'WebApplicationSessionReplayConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url_injection_pattern: Optional[pulumi.Input[str]] = None,
                 user_action_and_session_properties: Optional[pulumi.Input[Union['WebApplicationUserActionAndSessionPropertiesArgs', 'WebApplicationUserActionAndSessionPropertiesArgsDict']]] = None,
                 user_action_naming_settings: Optional[pulumi.Input[Union['WebApplicationUserActionNamingSettingsArgs', 'WebApplicationUserActionNamingSettingsArgsDict']]] = None,
                 user_tags: Optional[pulumi.Input[Union['WebApplicationUserTagsArgs', 'WebApplicationUserTagsArgsDict']]] = None,
                 waterfall_settings: Optional[pulumi.Input[Union['WebApplicationWaterfallSettingsArgs', 'WebApplicationWaterfallSettingsArgsDict']]] = None,
                 xhr_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationXhrActionApdexSettingsArgs', 'WebApplicationXhrActionApdexSettingsArgsDict']]] = None,
                 xhr_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebApplicationArgs.__new__(WebApplicationArgs)

            __props__.__dict__["conversion_goals"] = conversion_goals
            if cost_control_user_session_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'cost_control_user_session_percentage'")
            __props__.__dict__["cost_control_user_session_percentage"] = cost_control_user_session_percentage
            if custom_action_apdex_settings is None and not opts.urn:
                raise TypeError("Missing required property 'custom_action_apdex_settings'")
            __props__.__dict__["custom_action_apdex_settings"] = custom_action_apdex_settings
            __props__.__dict__["key_user_actions"] = key_user_actions
            if load_action_apdex_settings is None and not opts.urn:
                raise TypeError("Missing required property 'load_action_apdex_settings'")
            __props__.__dict__["load_action_apdex_settings"] = load_action_apdex_settings
            if load_action_key_performance_metric is None and not opts.urn:
                raise TypeError("Missing required property 'load_action_key_performance_metric'")
            __props__.__dict__["load_action_key_performance_metric"] = load_action_key_performance_metric
            __props__.__dict__["meta_data_capture_settings"] = meta_data_capture_settings
            if monitoring_settings is None and not opts.urn:
                raise TypeError("Missing required property 'monitoring_settings'")
            __props__.__dict__["monitoring_settings"] = monitoring_settings
            __props__.__dict__["name"] = name
            __props__.__dict__["real_user_monitoring_enabled"] = real_user_monitoring_enabled
            __props__.__dict__["session_replay_config"] = session_replay_config
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url_injection_pattern"] = url_injection_pattern
            __props__.__dict__["user_action_and_session_properties"] = user_action_and_session_properties
            __props__.__dict__["user_action_naming_settings"] = user_action_naming_settings
            __props__.__dict__["user_tags"] = user_tags
            if waterfall_settings is None and not opts.urn:
                raise TypeError("Missing required property 'waterfall_settings'")
            __props__.__dict__["waterfall_settings"] = waterfall_settings
            if xhr_action_apdex_settings is None and not opts.urn:
                raise TypeError("Missing required property 'xhr_action_apdex_settings'")
            __props__.__dict__["xhr_action_apdex_settings"] = xhr_action_apdex_settings
            if xhr_action_key_performance_metric is None and not opts.urn:
                raise TypeError("Missing required property 'xhr_action_key_performance_metric'")
            __props__.__dict__["xhr_action_key_performance_metric"] = xhr_action_key_performance_metric
        super(WebApplication, __self__).__init__(
            'dynatrace:index/webApplication:WebApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conversion_goals: Optional[pulumi.Input[Union['WebApplicationConversionGoalsArgs', 'WebApplicationConversionGoalsArgsDict']]] = None,
            cost_control_user_session_percentage: Optional[pulumi.Input[int]] = None,
            custom_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationCustomActionApdexSettingsArgs', 'WebApplicationCustomActionApdexSettingsArgsDict']]] = None,
            key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebApplicationKeyUserActionArgs', 'WebApplicationKeyUserActionArgsDict']]]]] = None,
            load_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationLoadActionApdexSettingsArgs', 'WebApplicationLoadActionApdexSettingsArgsDict']]] = None,
            load_action_key_performance_metric: Optional[pulumi.Input[str]] = None,
            meta_data_capture_settings: Optional[pulumi.Input[Union['WebApplicationMetaDataCaptureSettingsArgs', 'WebApplicationMetaDataCaptureSettingsArgsDict']]] = None,
            monitoring_settings: Optional[pulumi.Input[Union['WebApplicationMonitoringSettingsArgs', 'WebApplicationMonitoringSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            real_user_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
            session_replay_config: Optional[pulumi.Input[Union['WebApplicationSessionReplayConfigArgs', 'WebApplicationSessionReplayConfigArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None,
            url_injection_pattern: Optional[pulumi.Input[str]] = None,
            user_action_and_session_properties: Optional[pulumi.Input[Union['WebApplicationUserActionAndSessionPropertiesArgs', 'WebApplicationUserActionAndSessionPropertiesArgsDict']]] = None,
            user_action_naming_settings: Optional[pulumi.Input[Union['WebApplicationUserActionNamingSettingsArgs', 'WebApplicationUserActionNamingSettingsArgsDict']]] = None,
            user_tags: Optional[pulumi.Input[Union['WebApplicationUserTagsArgs', 'WebApplicationUserTagsArgsDict']]] = None,
            waterfall_settings: Optional[pulumi.Input[Union['WebApplicationWaterfallSettingsArgs', 'WebApplicationWaterfallSettingsArgsDict']]] = None,
            xhr_action_apdex_settings: Optional[pulumi.Input[Union['WebApplicationXhrActionApdexSettingsArgs', 'WebApplicationXhrActionApdexSettingsArgsDict']]] = None,
            xhr_action_key_performance_metric: Optional[pulumi.Input[str]] = None) -> 'WebApplication':
        """
        Get an existing WebApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WebApplicationConversionGoalsArgs', 'WebApplicationConversionGoalsArgsDict']] conversion_goals: A list of conversion goals of the application
        :param pulumi.Input[int] cost_control_user_session_percentage: (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        :param pulumi.Input[Union['WebApplicationCustomActionApdexSettingsArgs', 'WebApplicationCustomActionApdexSettingsArgsDict']] custom_action_apdex_settings: Defines the Custom Action Apdex settings of an application
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebApplicationKeyUserActionArgs', 'WebApplicationKeyUserActionArgsDict']]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[Union['WebApplicationLoadActionApdexSettingsArgs', 'WebApplicationLoadActionApdexSettingsArgsDict']] load_action_apdex_settings: Defines the Load Action Apdex settings of an application
        :param pulumi.Input[str] load_action_key_performance_metric: The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        :param pulumi.Input[Union['WebApplicationMetaDataCaptureSettingsArgs', 'WebApplicationMetaDataCaptureSettingsArgsDict']] meta_data_capture_settings: Java script agent meta data capture settings
        :param pulumi.Input[Union['WebApplicationMonitoringSettingsArgs', 'WebApplicationMonitoringSettingsArgsDict']] monitoring_settings: Real user monitoring settings
        :param pulumi.Input[str] name: The name of the web application, displayed in the UI
        :param pulumi.Input[bool] real_user_monitoring_enabled: (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        :param pulumi.Input[Union['WebApplicationSessionReplayConfigArgs', 'WebApplicationSessionReplayConfigArgsDict']] session_replay_config: Settings regarding Session Replay
        :param pulumi.Input[str] type: The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        :param pulumi.Input[str] url_injection_pattern: URL injection pattern for manual web application
        :param pulumi.Input[Union['WebApplicationUserActionAndSessionPropertiesArgs', 'WebApplicationUserActionAndSessionPropertiesArgsDict']] user_action_and_session_properties: User action and session properties settings
        :param pulumi.Input[Union['WebApplicationUserActionNamingSettingsArgs', 'WebApplicationUserActionNamingSettingsArgsDict']] user_action_naming_settings: The settings of user action naming
        :param pulumi.Input[Union['WebApplicationUserTagsArgs', 'WebApplicationUserTagsArgsDict']] user_tags: User tags settings
        :param pulumi.Input[Union['WebApplicationWaterfallSettingsArgs', 'WebApplicationWaterfallSettingsArgsDict']] waterfall_settings: These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        :param pulumi.Input[Union['WebApplicationXhrActionApdexSettingsArgs', 'WebApplicationXhrActionApdexSettingsArgsDict']] xhr_action_apdex_settings: Defines the XHR Action Apdex settings of an application
        :param pulumi.Input[str] xhr_action_key_performance_metric: The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebApplicationState.__new__(_WebApplicationState)

        __props__.__dict__["conversion_goals"] = conversion_goals
        __props__.__dict__["cost_control_user_session_percentage"] = cost_control_user_session_percentage
        __props__.__dict__["custom_action_apdex_settings"] = custom_action_apdex_settings
        __props__.__dict__["key_user_actions"] = key_user_actions
        __props__.__dict__["load_action_apdex_settings"] = load_action_apdex_settings
        __props__.__dict__["load_action_key_performance_metric"] = load_action_key_performance_metric
        __props__.__dict__["meta_data_capture_settings"] = meta_data_capture_settings
        __props__.__dict__["monitoring_settings"] = monitoring_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["real_user_monitoring_enabled"] = real_user_monitoring_enabled
        __props__.__dict__["session_replay_config"] = session_replay_config
        __props__.__dict__["type"] = type
        __props__.__dict__["url_injection_pattern"] = url_injection_pattern
        __props__.__dict__["user_action_and_session_properties"] = user_action_and_session_properties
        __props__.__dict__["user_action_naming_settings"] = user_action_naming_settings
        __props__.__dict__["user_tags"] = user_tags
        __props__.__dict__["waterfall_settings"] = waterfall_settings
        __props__.__dict__["xhr_action_apdex_settings"] = xhr_action_apdex_settings
        __props__.__dict__["xhr_action_key_performance_metric"] = xhr_action_key_performance_metric
        return WebApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conversionGoals")
    def conversion_goals(self) -> pulumi.Output[Optional['outputs.WebApplicationConversionGoals']]:
        """
        A list of conversion goals of the application
        """
        return pulumi.get(self, "conversion_goals")

    @property
    @pulumi.getter(name="costControlUserSessionPercentage")
    def cost_control_user_session_percentage(self) -> pulumi.Output[int]:
        """
        (Field has overlap with `WebAppEnablement`) Analize *X*% of user sessions
        """
        return pulumi.get(self, "cost_control_user_session_percentage")

    @property
    @pulumi.getter(name="customActionApdexSettings")
    def custom_action_apdex_settings(self) -> pulumi.Output['outputs.WebApplicationCustomActionApdexSettings']:
        """
        Defines the Custom Action Apdex settings of an application
        """
        return pulumi.get(self, "custom_action_apdex_settings")

    @property
    @pulumi.getter(name="keyUserActions")
    @_utilities.deprecated("""Configuring Key User Actions within `WebApplication` is discouraged. Use the dedicated resource `KeyUserAction` instead.""")
    def key_user_actions(self) -> pulumi.Output[Optional[Sequence['outputs.WebApplicationKeyUserAction']]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @property
    @pulumi.getter(name="loadActionApdexSettings")
    def load_action_apdex_settings(self) -> pulumi.Output['outputs.WebApplicationLoadActionApdexSettings']:
        """
        Defines the Load Action Apdex settings of an application
        """
        return pulumi.get(self, "load_action_apdex_settings")

    @property
    @pulumi.getter(name="loadActionKeyPerformanceMetric")
    def load_action_key_performance_metric(self) -> pulumi.Output[str]:
        """
        The key performance metric of load actions. Possible values are `ACTION_DURATION`, `CUMULATIVE_LAYOUT_SHIFT`, `DOM_INTERACTIVE`, `FIRST_INPUT_DELAY`, `LARGEST_CONTENTFUL_PAINT`, `LOAD_EVENT_END`, `LOAD_EVENT_START`, `RESPONSE_END`, `RESPONSE_START`, `SPEED_INDEX` and `VISUALLY_COMPLETE`
        """
        return pulumi.get(self, "load_action_key_performance_metric")

    @property
    @pulumi.getter(name="metaDataCaptureSettings")
    def meta_data_capture_settings(self) -> pulumi.Output[Optional['outputs.WebApplicationMetaDataCaptureSettings']]:
        """
        Java script agent meta data capture settings
        """
        return pulumi.get(self, "meta_data_capture_settings")

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> pulumi.Output['outputs.WebApplicationMonitoringSettings']:
        """
        Real user monitoring settings
        """
        return pulumi.get(self, "monitoring_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the web application, displayed in the UI
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="realUserMonitoringEnabled")
    def real_user_monitoring_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        (Field has overlap with `WebAppEnablement`) Real user monitoring enabled/disabled
        """
        return pulumi.get(self, "real_user_monitoring_enabled")

    @property
    @pulumi.getter(name="sessionReplayConfig")
    def session_replay_config(self) -> pulumi.Output['outputs.WebApplicationSessionReplayConfig']:
        """
        Settings regarding Session Replay
        """
        return pulumi.get(self, "session_replay_config")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the web application. Possible values are `AUTO_INJECTED`, `BROWSER_EXTENSION_INJECTED` and `MANUALLY_INJECTED`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="urlInjectionPattern")
    def url_injection_pattern(self) -> pulumi.Output[Optional[str]]:
        """
        URL injection pattern for manual web application
        """
        return pulumi.get(self, "url_injection_pattern")

    @property
    @pulumi.getter(name="userActionAndSessionProperties")
    def user_action_and_session_properties(self) -> pulumi.Output[Optional['outputs.WebApplicationUserActionAndSessionProperties']]:
        """
        User action and session properties settings
        """
        return pulumi.get(self, "user_action_and_session_properties")

    @property
    @pulumi.getter(name="userActionNamingSettings")
    def user_action_naming_settings(self) -> pulumi.Output[Optional['outputs.WebApplicationUserActionNamingSettings']]:
        """
        The settings of user action naming
        """
        return pulumi.get(self, "user_action_naming_settings")

    @property
    @pulumi.getter(name="userTags")
    def user_tags(self) -> pulumi.Output[Optional['outputs.WebApplicationUserTags']]:
        """
        User tags settings
        """
        return pulumi.get(self, "user_tags")

    @property
    @pulumi.getter(name="waterfallSettings")
    def waterfall_settings(self) -> pulumi.Output['outputs.WebApplicationWaterfallSettings']:
        """
        These settings influence the monitoring data you receive for 3rd party, CDN, and 1st party resources
        """
        return pulumi.get(self, "waterfall_settings")

    @property
    @pulumi.getter(name="xhrActionApdexSettings")
    def xhr_action_apdex_settings(self) -> pulumi.Output['outputs.WebApplicationXhrActionApdexSettings']:
        """
        Defines the XHR Action Apdex settings of an application
        """
        return pulumi.get(self, "xhr_action_apdex_settings")

    @property
    @pulumi.getter(name="xhrActionKeyPerformanceMetric")
    def xhr_action_key_performance_metric(self) -> pulumi.Output[str]:
        """
        The key performance metric of XHR actions. Possible values are `ACTION_DURATION`, `RESPONSE_END`, `RESPONSE_START` and `VISUALLY_COMPLETE`.
        """
        return pulumi.get(self, "xhr_action_key_performance_metric")

