# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VulnerabilitySettingsArgs', 'VulnerabilitySettings']

@pulumi.input_type
class VulnerabilitySettingsArgs:
    def __init__(__self__, *,
                 enable_code_level_vulnerability_detection: pulumi.Input[bool],
                 enable_runtime_vulnerability_detection: pulumi.Input[bool],
                 global_monitoring_mode_java: pulumi.Input[str],
                 technologies: pulumi.Input['VulnerabilitySettingsTechnologiesArgs'],
                 global_monitoring_mode_dot_net: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_tpv: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VulnerabilitySettings resource.
        :param pulumi.Input[bool] enable_code_level_vulnerability_detection: Enable Code-level Vulnerability Analytics
        :param pulumi.Input[bool] enable_runtime_vulnerability_detection: Enable Third-party Vulnerability Analytics
        :param pulumi.Input[str] global_monitoring_mode_java: Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input['VulnerabilitySettingsTechnologiesArgs'] technologies: Vulnerability Analytics can be enabled/disabled per supported technology.
        :param pulumi.Input[str] global_monitoring_mode_dot_net: (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_tpv: Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        pulumi.set(__self__, "enable_code_level_vulnerability_detection", enable_code_level_vulnerability_detection)
        pulumi.set(__self__, "enable_runtime_vulnerability_detection", enable_runtime_vulnerability_detection)
        pulumi.set(__self__, "global_monitoring_mode_java", global_monitoring_mode_java)
        pulumi.set(__self__, "technologies", technologies)
        if global_monitoring_mode_dot_net is not None:
            pulumi.set(__self__, "global_monitoring_mode_dot_net", global_monitoring_mode_dot_net)
        if global_monitoring_mode_tpv is not None:
            pulumi.set(__self__, "global_monitoring_mode_tpv", global_monitoring_mode_tpv)

    @property
    @pulumi.getter(name="enableCodeLevelVulnerabilityDetection")
    def enable_code_level_vulnerability_detection(self) -> pulumi.Input[bool]:
        """
        Enable Code-level Vulnerability Analytics
        """
        return pulumi.get(self, "enable_code_level_vulnerability_detection")

    @enable_code_level_vulnerability_detection.setter
    def enable_code_level_vulnerability_detection(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_code_level_vulnerability_detection", value)

    @property
    @pulumi.getter(name="enableRuntimeVulnerabilityDetection")
    def enable_runtime_vulnerability_detection(self) -> pulumi.Input[bool]:
        """
        Enable Third-party Vulnerability Analytics
        """
        return pulumi.get(self, "enable_runtime_vulnerability_detection")

    @enable_runtime_vulnerability_detection.setter
    def enable_runtime_vulnerability_detection(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_runtime_vulnerability_detection", value)

    @property
    @pulumi.getter(name="globalMonitoringModeJava")
    def global_monitoring_mode_java(self) -> pulumi.Input[str]:
        """
        Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_java")

    @global_monitoring_mode_java.setter
    def global_monitoring_mode_java(self, value: pulumi.Input[str]):
        pulumi.set(self, "global_monitoring_mode_java", value)

    @property
    @pulumi.getter
    def technologies(self) -> pulumi.Input['VulnerabilitySettingsTechnologiesArgs']:
        """
        Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        return pulumi.get(self, "technologies")

    @technologies.setter
    def technologies(self, value: pulumi.Input['VulnerabilitySettingsTechnologiesArgs']):
        pulumi.set(self, "technologies", value)

    @property
    @pulumi.getter(name="globalMonitoringModeDotNet")
    def global_monitoring_mode_dot_net(self) -> Optional[pulumi.Input[str]]:
        """
        (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_dot_net")

    @global_monitoring_mode_dot_net.setter
    def global_monitoring_mode_dot_net(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_monitoring_mode_dot_net", value)

    @property
    @pulumi.getter(name="globalMonitoringModeTpv")
    def global_monitoring_mode_tpv(self) -> Optional[pulumi.Input[str]]:
        """
        Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_tpv")

    @global_monitoring_mode_tpv.setter
    def global_monitoring_mode_tpv(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_monitoring_mode_tpv", value)


@pulumi.input_type
class _VulnerabilitySettingsState:
    def __init__(__self__, *,
                 enable_code_level_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 enable_runtime_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 global_monitoring_mode_dot_net: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_java: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_tpv: Optional[pulumi.Input[str]] = None,
                 technologies: Optional[pulumi.Input['VulnerabilitySettingsTechnologiesArgs']] = None):
        """
        Input properties used for looking up and filtering VulnerabilitySettings resources.
        :param pulumi.Input[bool] enable_code_level_vulnerability_detection: Enable Code-level Vulnerability Analytics
        :param pulumi.Input[bool] enable_runtime_vulnerability_detection: Enable Third-party Vulnerability Analytics
        :param pulumi.Input[str] global_monitoring_mode_dot_net: (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_java: Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_tpv: Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input['VulnerabilitySettingsTechnologiesArgs'] technologies: Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        if enable_code_level_vulnerability_detection is not None:
            pulumi.set(__self__, "enable_code_level_vulnerability_detection", enable_code_level_vulnerability_detection)
        if enable_runtime_vulnerability_detection is not None:
            pulumi.set(__self__, "enable_runtime_vulnerability_detection", enable_runtime_vulnerability_detection)
        if global_monitoring_mode_dot_net is not None:
            pulumi.set(__self__, "global_monitoring_mode_dot_net", global_monitoring_mode_dot_net)
        if global_monitoring_mode_java is not None:
            pulumi.set(__self__, "global_monitoring_mode_java", global_monitoring_mode_java)
        if global_monitoring_mode_tpv is not None:
            pulumi.set(__self__, "global_monitoring_mode_tpv", global_monitoring_mode_tpv)
        if technologies is not None:
            pulumi.set(__self__, "technologies", technologies)

    @property
    @pulumi.getter(name="enableCodeLevelVulnerabilityDetection")
    def enable_code_level_vulnerability_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Code-level Vulnerability Analytics
        """
        return pulumi.get(self, "enable_code_level_vulnerability_detection")

    @enable_code_level_vulnerability_detection.setter
    def enable_code_level_vulnerability_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_code_level_vulnerability_detection", value)

    @property
    @pulumi.getter(name="enableRuntimeVulnerabilityDetection")
    def enable_runtime_vulnerability_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Third-party Vulnerability Analytics
        """
        return pulumi.get(self, "enable_runtime_vulnerability_detection")

    @enable_runtime_vulnerability_detection.setter
    def enable_runtime_vulnerability_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_runtime_vulnerability_detection", value)

    @property
    @pulumi.getter(name="globalMonitoringModeDotNet")
    def global_monitoring_mode_dot_net(self) -> Optional[pulumi.Input[str]]:
        """
        (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_dot_net")

    @global_monitoring_mode_dot_net.setter
    def global_monitoring_mode_dot_net(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_monitoring_mode_dot_net", value)

    @property
    @pulumi.getter(name="globalMonitoringModeJava")
    def global_monitoring_mode_java(self) -> Optional[pulumi.Input[str]]:
        """
        Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_java")

    @global_monitoring_mode_java.setter
    def global_monitoring_mode_java(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_monitoring_mode_java", value)

    @property
    @pulumi.getter(name="globalMonitoringModeTpv")
    def global_monitoring_mode_tpv(self) -> Optional[pulumi.Input[str]]:
        """
        Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_tpv")

    @global_monitoring_mode_tpv.setter
    def global_monitoring_mode_tpv(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_monitoring_mode_tpv", value)

    @property
    @pulumi.getter
    def technologies(self) -> Optional[pulumi.Input['VulnerabilitySettingsTechnologiesArgs']]:
        """
        Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        return pulumi.get(self, "technologies")

    @technologies.setter
    def technologies(self, value: Optional[pulumi.Input['VulnerabilitySettingsTechnologiesArgs']]):
        pulumi.set(self, "technologies", value)


class VulnerabilitySettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_code_level_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 enable_runtime_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 global_monitoring_mode_dot_net: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_java: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_tpv: Optional[pulumi.Input[str]] = None,
                 technologies: Optional[pulumi.Input[Union['VulnerabilitySettingsTechnologiesArgs', 'VulnerabilitySettingsTechnologiesArgsDict']]] = None,
                 __props__=None):
        """
        Create a VulnerabilitySettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_code_level_vulnerability_detection: Enable Code-level Vulnerability Analytics
        :param pulumi.Input[bool] enable_runtime_vulnerability_detection: Enable Third-party Vulnerability Analytics
        :param pulumi.Input[str] global_monitoring_mode_dot_net: (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_java: Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_tpv: Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[Union['VulnerabilitySettingsTechnologiesArgs', 'VulnerabilitySettingsTechnologiesArgsDict']] technologies: Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilitySettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VulnerabilitySettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VulnerabilitySettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilitySettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_code_level_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 enable_runtime_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
                 global_monitoring_mode_dot_net: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_java: Optional[pulumi.Input[str]] = None,
                 global_monitoring_mode_tpv: Optional[pulumi.Input[str]] = None,
                 technologies: Optional[pulumi.Input[Union['VulnerabilitySettingsTechnologiesArgs', 'VulnerabilitySettingsTechnologiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilitySettingsArgs.__new__(VulnerabilitySettingsArgs)

            if enable_code_level_vulnerability_detection is None and not opts.urn:
                raise TypeError("Missing required property 'enable_code_level_vulnerability_detection'")
            __props__.__dict__["enable_code_level_vulnerability_detection"] = enable_code_level_vulnerability_detection
            if enable_runtime_vulnerability_detection is None and not opts.urn:
                raise TypeError("Missing required property 'enable_runtime_vulnerability_detection'")
            __props__.__dict__["enable_runtime_vulnerability_detection"] = enable_runtime_vulnerability_detection
            __props__.__dict__["global_monitoring_mode_dot_net"] = global_monitoring_mode_dot_net
            if global_monitoring_mode_java is None and not opts.urn:
                raise TypeError("Missing required property 'global_monitoring_mode_java'")
            __props__.__dict__["global_monitoring_mode_java"] = global_monitoring_mode_java
            __props__.__dict__["global_monitoring_mode_tpv"] = global_monitoring_mode_tpv
            if technologies is None and not opts.urn:
                raise TypeError("Missing required property 'technologies'")
            __props__.__dict__["technologies"] = technologies
        super(VulnerabilitySettings, __self__).__init__(
            'dynatrace:index/vulnerabilitySettings:VulnerabilitySettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_code_level_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
            enable_runtime_vulnerability_detection: Optional[pulumi.Input[bool]] = None,
            global_monitoring_mode_dot_net: Optional[pulumi.Input[str]] = None,
            global_monitoring_mode_java: Optional[pulumi.Input[str]] = None,
            global_monitoring_mode_tpv: Optional[pulumi.Input[str]] = None,
            technologies: Optional[pulumi.Input[Union['VulnerabilitySettingsTechnologiesArgs', 'VulnerabilitySettingsTechnologiesArgsDict']]] = None) -> 'VulnerabilitySettings':
        """
        Get an existing VulnerabilitySettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_code_level_vulnerability_detection: Enable Code-level Vulnerability Analytics
        :param pulumi.Input[bool] enable_runtime_vulnerability_detection: Enable Third-party Vulnerability Analytics
        :param pulumi.Input[str] global_monitoring_mode_dot_net: (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_java: Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[str] global_monitoring_mode_tpv: Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        :param pulumi.Input[Union['VulnerabilitySettingsTechnologiesArgs', 'VulnerabilitySettingsTechnologiesArgsDict']] technologies: Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilitySettingsState.__new__(_VulnerabilitySettingsState)

        __props__.__dict__["enable_code_level_vulnerability_detection"] = enable_code_level_vulnerability_detection
        __props__.__dict__["enable_runtime_vulnerability_detection"] = enable_runtime_vulnerability_detection
        __props__.__dict__["global_monitoring_mode_dot_net"] = global_monitoring_mode_dot_net
        __props__.__dict__["global_monitoring_mode_java"] = global_monitoring_mode_java
        __props__.__dict__["global_monitoring_mode_tpv"] = global_monitoring_mode_tpv
        __props__.__dict__["technologies"] = technologies
        return VulnerabilitySettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableCodeLevelVulnerabilityDetection")
    def enable_code_level_vulnerability_detection(self) -> pulumi.Output[bool]:
        """
        Enable Code-level Vulnerability Analytics
        """
        return pulumi.get(self, "enable_code_level_vulnerability_detection")

    @property
    @pulumi.getter(name="enableRuntimeVulnerabilityDetection")
    def enable_runtime_vulnerability_detection(self) -> pulumi.Output[bool]:
        """
        Enable Third-party Vulnerability Analytics
        """
        return pulumi.get(self, "enable_runtime_vulnerability_detection")

    @property
    @pulumi.getter(name="globalMonitoringModeDotNet")
    def global_monitoring_mode_dot_net(self) -> pulumi.Output[Optional[str]]:
        """
        (v1.290) Global .NET code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_dot_net")

    @property
    @pulumi.getter(name="globalMonitoringModeJava")
    def global_monitoring_mode_java(self) -> pulumi.Output[str]:
        """
        Global Java code-level vulnerability detection control defines the default for all process groups. You can use monitoring rules to override the default for certain processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_java")

    @property
    @pulumi.getter(name="globalMonitoringModeTpv")
    def global_monitoring_mode_tpv(self) -> pulumi.Output[Optional[str]]:
        """
        Global third-party vulnerability detection control defines the default for all processes. Possible Values: `MONITORING_OFF`, `MONITORING_ON`
        """
        return pulumi.get(self, "global_monitoring_mode_tpv")

    @property
    @pulumi.getter
    def technologies(self) -> pulumi.Output['outputs.VulnerabilitySettingsTechnologies']:
        """
        Vulnerability Analytics can be enabled/disabled per supported technology.
        """
        return pulumi.get(self, "technologies")

