# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VulnerabilityAlertingArgs', 'VulnerabilityAlerting']

@pulumi.input_type
class VulnerabilityAlertingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 enabled_risk_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled_trigger_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VulnerabilityAlerting resource.
        :param pulumi.Input[bool] enabled: Alerting profile is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_risk_levels: List of risk levels to alert
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_trigger_events: List of events to alert
        :param pulumi.Input[str] management_zone: Alert only if the following management zone is affected (optional)
        :param pulumi.Input[str] name: Alerting profile name
        """
        pulumi.set(__self__, "enabled", enabled)
        if enabled_risk_levels is not None:
            pulumi.set(__self__, "enabled_risk_levels", enabled_risk_levels)
        if enabled_trigger_events is not None:
            pulumi.set(__self__, "enabled_trigger_events", enabled_trigger_events)
        if management_zone is not None:
            pulumi.set(__self__, "management_zone", management_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Alerting profile is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="enabledRiskLevels")
    def enabled_risk_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of risk levels to alert
        """
        return pulumi.get(self, "enabled_risk_levels")

    @enabled_risk_levels.setter
    def enabled_risk_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_risk_levels", value)

    @property
    @pulumi.getter(name="enabledTriggerEvents")
    def enabled_trigger_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of events to alert
        """
        return pulumi.get(self, "enabled_trigger_events")

    @enabled_trigger_events.setter
    def enabled_trigger_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_trigger_events", value)

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Alert only if the following management zone is affected (optional)
        """
        return pulumi.get(self, "management_zone")

    @management_zone.setter
    def management_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Alerting profile name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VulnerabilityAlertingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enabled_risk_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled_trigger_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityAlerting resources.
        :param pulumi.Input[bool] enabled: Alerting profile is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_risk_levels: List of risk levels to alert
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_trigger_events: List of events to alert
        :param pulumi.Input[str] management_zone: Alert only if the following management zone is affected (optional)
        :param pulumi.Input[str] name: Alerting profile name
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enabled_risk_levels is not None:
            pulumi.set(__self__, "enabled_risk_levels", enabled_risk_levels)
        if enabled_trigger_events is not None:
            pulumi.set(__self__, "enabled_trigger_events", enabled_trigger_events)
        if management_zone is not None:
            pulumi.set(__self__, "management_zone", management_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Alerting profile is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="enabledRiskLevels")
    def enabled_risk_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of risk levels to alert
        """
        return pulumi.get(self, "enabled_risk_levels")

    @enabled_risk_levels.setter
    def enabled_risk_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_risk_levels", value)

    @property
    @pulumi.getter(name="enabledTriggerEvents")
    def enabled_trigger_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of events to alert
        """
        return pulumi.get(self, "enabled_trigger_events")

    @enabled_trigger_events.setter
    def enabled_trigger_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_trigger_events", value)

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Alert only if the following management zone is affected (optional)
        """
        return pulumi.get(self, "management_zone")

    @management_zone.setter
    def management_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Alerting profile name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class VulnerabilityAlerting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enabled_risk_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled_trigger_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a VulnerabilityAlerting resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Alerting profile is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_risk_levels: List of risk levels to alert
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_trigger_events: List of events to alert
        :param pulumi.Input[str] management_zone: Alert only if the following management zone is affected (optional)
        :param pulumi.Input[str] name: Alerting profile name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityAlertingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VulnerabilityAlerting resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VulnerabilityAlertingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityAlertingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enabled_risk_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled_trigger_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityAlertingArgs.__new__(VulnerabilityAlertingArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["enabled_risk_levels"] = enabled_risk_levels
            __props__.__dict__["enabled_trigger_events"] = enabled_trigger_events
            __props__.__dict__["management_zone"] = management_zone
            __props__.__dict__["name"] = name
        super(VulnerabilityAlerting, __self__).__init__(
            'dynatrace:index/vulnerabilityAlerting:VulnerabilityAlerting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            enabled_risk_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled_trigger_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            management_zone: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'VulnerabilityAlerting':
        """
        Get an existing VulnerabilityAlerting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Alerting profile is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_risk_levels: List of risk levels to alert
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_trigger_events: List of events to alert
        :param pulumi.Input[str] management_zone: Alert only if the following management zone is affected (optional)
        :param pulumi.Input[str] name: Alerting profile name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityAlertingState.__new__(_VulnerabilityAlertingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["enabled_risk_levels"] = enabled_risk_levels
        __props__.__dict__["enabled_trigger_events"] = enabled_trigger_events
        __props__.__dict__["management_zone"] = management_zone
        __props__.__dict__["name"] = name
        return VulnerabilityAlerting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Alerting profile is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="enabledRiskLevels")
    def enabled_risk_levels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of risk levels to alert
        """
        return pulumi.get(self, "enabled_risk_levels")

    @property
    @pulumi.getter(name="enabledTriggerEvents")
    def enabled_trigger_events(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of events to alert
        """
        return pulumi.get(self, "enabled_trigger_events")

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Alert only if the following management zone is affected (optional)
        """
        return pulumi.get(self, "management_zone")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Alerting profile name
        """
        return pulumi.get(self, "name")

