# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VmwareArgs', 'Vmware']

@pulumi.input_type
class VmwareArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 ipaddress: pulumi.Input[str],
                 label: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 filter: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Vmware resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] ipaddress: Specify the IP address or name of the vCenter or standalone ESXi host:
        :param pulumi.Input[str] label: Name this connection
        :param pulumi.Input[str] password: no documentation available
        :param pulumi.Input[str] username: Provide user credentials for the vCenter or standalone ESXi host:
        :param pulumi.Input[str] filter: This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
               $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
               - $contains(parameter) - property value contains 'parameter'
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "ipaddress", ipaddress)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def ipaddress(self) -> pulumi.Input[str]:
        """
        Specify the IP address or name of the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "ipaddress")

    @ipaddress.setter
    def ipaddress(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipaddress", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name this connection
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        no documentation available
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Provide user credentials for the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
        $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
        - $contains(parameter) - property value contains 'parameter'
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class _VmwareState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 ipaddress: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Vmware resources.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] filter: This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
               $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
               - $contains(parameter) - property value contains 'parameter'
        :param pulumi.Input[str] ipaddress: Specify the IP address or name of the vCenter or standalone ESXi host:
        :param pulumi.Input[str] label: Name this connection
        :param pulumi.Input[str] password: no documentation available
        :param pulumi.Input[str] username: Provide user credentials for the vCenter or standalone ESXi host:
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if ipaddress is not None:
            pulumi.set(__self__, "ipaddress", ipaddress)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
        $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
        - $contains(parameter) - property value contains 'parameter'
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def ipaddress(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the IP address or name of the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "ipaddress")

    @ipaddress.setter
    def ipaddress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipaddress", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Name this connection
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        no documentation available
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Provide user credentials for the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Vmware(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 ipaddress: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Vmware resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] filter: This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
               $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
               - $contains(parameter) - property value contains 'parameter'
        :param pulumi.Input[str] ipaddress: Specify the IP address or name of the vCenter or standalone ESXi host:
        :param pulumi.Input[str] label: Name this connection
        :param pulumi.Input[str] password: no documentation available
        :param pulumi.Input[str] username: Provide user credentials for the vCenter or standalone ESXi host:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmwareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Vmware resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VmwareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmwareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 ipaddress: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmwareArgs.__new__(VmwareArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            if ipaddress is None and not opts.urn:
                raise TypeError("Missing required property 'ipaddress'")
            __props__.__dict__["ipaddress"] = ipaddress
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Vmware, __self__).__init__(
            'dynatrace:index/vmware:Vmware',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            filter: Optional[pulumi.Input[str]] = None,
            ipaddress: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Vmware':
        """
        Get an existing Vmware resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] filter: This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
               $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
               - $contains(parameter) - property value contains 'parameter'
        :param pulumi.Input[str] ipaddress: Specify the IP address or name of the vCenter or standalone ESXi host:
        :param pulumi.Input[str] label: Name this connection
        :param pulumi.Input[str] password: no documentation available
        :param pulumi.Input[str] username: Provide user credentials for the vCenter or standalone ESXi host:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmwareState.__new__(_VmwareState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["ipaddress"] = ipaddress
        __props__.__dict__["label"] = label
        __props__.__dict__["password"] = password
        __props__.__dict__["username"] = username
        return Vmware(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[str]]:
        """
        This string should have one of the following formats: - $prefix(parameter) - property value starting with 'parameter' -
        $eq(parameter) - property value exactly matching 'parameter' - $suffix(parameter) - property value ends with 'parameter'
        - $contains(parameter) - property value contains 'parameter'
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def ipaddress(self) -> pulumi.Output[str]:
        """
        Specify the IP address or name of the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "ipaddress")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Name this connection
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        no documentation available
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Provide user credentials for the vCenter or standalone ESXi host:
        """
        return pulumi.get(self, "username")

