# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserExperienceScoreArgs', 'UserExperienceScore']

@pulumi.input_type
class UserExperienceScoreArgs:
    def __init__(__self__, *,
                 consider_last_action: pulumi.Input[bool],
                 consider_rage_click: pulumi.Input[bool],
                 max_frustrated_user_actions_threshold: pulumi.Input[int],
                 min_satisfied_user_actions_threshold: pulumi.Input[int]):
        """
        The set of arguments for constructing a UserExperienceScore resource.
        :param pulumi.Input[bool] consider_last_action: If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        :param pulumi.Input[bool] consider_rage_click: Consider rage clicks / rage taps in score calculation
        :param pulumi.Input[int] max_frustrated_user_actions_threshold: User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        :param pulumi.Input[int] min_satisfied_user_actions_threshold: User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        pulumi.set(__self__, "consider_last_action", consider_last_action)
        pulumi.set(__self__, "consider_rage_click", consider_rage_click)
        pulumi.set(__self__, "max_frustrated_user_actions_threshold", max_frustrated_user_actions_threshold)
        pulumi.set(__self__, "min_satisfied_user_actions_threshold", min_satisfied_user_actions_threshold)

    @property
    @pulumi.getter(name="considerLastAction")
    def consider_last_action(self) -> pulumi.Input[bool]:
        """
        If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        """
        return pulumi.get(self, "consider_last_action")

    @consider_last_action.setter
    def consider_last_action(self, value: pulumi.Input[bool]):
        pulumi.set(self, "consider_last_action", value)

    @property
    @pulumi.getter(name="considerRageClick")
    def consider_rage_click(self) -> pulumi.Input[bool]:
        """
        Consider rage clicks / rage taps in score calculation
        """
        return pulumi.get(self, "consider_rage_click")

    @consider_rage_click.setter
    def consider_rage_click(self, value: pulumi.Input[bool]):
        pulumi.set(self, "consider_rage_click", value)

    @property
    @pulumi.getter(name="maxFrustratedUserActionsThreshold")
    def max_frustrated_user_actions_threshold(self) -> pulumi.Input[int]:
        """
        User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        """
        return pulumi.get(self, "max_frustrated_user_actions_threshold")

    @max_frustrated_user_actions_threshold.setter
    def max_frustrated_user_actions_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_frustrated_user_actions_threshold", value)

    @property
    @pulumi.getter(name="minSatisfiedUserActionsThreshold")
    def min_satisfied_user_actions_threshold(self) -> pulumi.Input[int]:
        """
        User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        return pulumi.get(self, "min_satisfied_user_actions_threshold")

    @min_satisfied_user_actions_threshold.setter
    def min_satisfied_user_actions_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_satisfied_user_actions_threshold", value)


@pulumi.input_type
class _UserExperienceScoreState:
    def __init__(__self__, *,
                 consider_last_action: Optional[pulumi.Input[bool]] = None,
                 consider_rage_click: Optional[pulumi.Input[bool]] = None,
                 max_frustrated_user_actions_threshold: Optional[pulumi.Input[int]] = None,
                 min_satisfied_user_actions_threshold: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering UserExperienceScore resources.
        :param pulumi.Input[bool] consider_last_action: If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        :param pulumi.Input[bool] consider_rage_click: Consider rage clicks / rage taps in score calculation
        :param pulumi.Input[int] max_frustrated_user_actions_threshold: User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        :param pulumi.Input[int] min_satisfied_user_actions_threshold: User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        if consider_last_action is not None:
            pulumi.set(__self__, "consider_last_action", consider_last_action)
        if consider_rage_click is not None:
            pulumi.set(__self__, "consider_rage_click", consider_rage_click)
        if max_frustrated_user_actions_threshold is not None:
            pulumi.set(__self__, "max_frustrated_user_actions_threshold", max_frustrated_user_actions_threshold)
        if min_satisfied_user_actions_threshold is not None:
            pulumi.set(__self__, "min_satisfied_user_actions_threshold", min_satisfied_user_actions_threshold)

    @property
    @pulumi.getter(name="considerLastAction")
    def consider_last_action(self) -> Optional[pulumi.Input[bool]]:
        """
        If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        """
        return pulumi.get(self, "consider_last_action")

    @consider_last_action.setter
    def consider_last_action(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consider_last_action", value)

    @property
    @pulumi.getter(name="considerRageClick")
    def consider_rage_click(self) -> Optional[pulumi.Input[bool]]:
        """
        Consider rage clicks / rage taps in score calculation
        """
        return pulumi.get(self, "consider_rage_click")

    @consider_rage_click.setter
    def consider_rage_click(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consider_rage_click", value)

    @property
    @pulumi.getter(name="maxFrustratedUserActionsThreshold")
    def max_frustrated_user_actions_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        """
        return pulumi.get(self, "max_frustrated_user_actions_threshold")

    @max_frustrated_user_actions_threshold.setter
    def max_frustrated_user_actions_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_frustrated_user_actions_threshold", value)

    @property
    @pulumi.getter(name="minSatisfiedUserActionsThreshold")
    def min_satisfied_user_actions_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        return pulumi.get(self, "min_satisfied_user_actions_threshold")

    @min_satisfied_user_actions_threshold.setter
    def min_satisfied_user_actions_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_satisfied_user_actions_threshold", value)


class UserExperienceScore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consider_last_action: Optional[pulumi.Input[bool]] = None,
                 consider_rage_click: Optional[pulumi.Input[bool]] = None,
                 max_frustrated_user_actions_threshold: Optional[pulumi.Input[int]] = None,
                 min_satisfied_user_actions_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a UserExperienceScore resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] consider_last_action: If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        :param pulumi.Input[bool] consider_rage_click: Consider rage clicks / rage taps in score calculation
        :param pulumi.Input[int] max_frustrated_user_actions_threshold: User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        :param pulumi.Input[int] min_satisfied_user_actions_threshold: User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserExperienceScoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a UserExperienceScore resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserExperienceScoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserExperienceScoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consider_last_action: Optional[pulumi.Input[bool]] = None,
                 consider_rage_click: Optional[pulumi.Input[bool]] = None,
                 max_frustrated_user_actions_threshold: Optional[pulumi.Input[int]] = None,
                 min_satisfied_user_actions_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserExperienceScoreArgs.__new__(UserExperienceScoreArgs)

            if consider_last_action is None and not opts.urn:
                raise TypeError("Missing required property 'consider_last_action'")
            __props__.__dict__["consider_last_action"] = consider_last_action
            if consider_rage_click is None and not opts.urn:
                raise TypeError("Missing required property 'consider_rage_click'")
            __props__.__dict__["consider_rage_click"] = consider_rage_click
            if max_frustrated_user_actions_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'max_frustrated_user_actions_threshold'")
            __props__.__dict__["max_frustrated_user_actions_threshold"] = max_frustrated_user_actions_threshold
            if min_satisfied_user_actions_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'min_satisfied_user_actions_threshold'")
            __props__.__dict__["min_satisfied_user_actions_threshold"] = min_satisfied_user_actions_threshold
        super(UserExperienceScore, __self__).__init__(
            'dynatrace:index/userExperienceScore:UserExperienceScore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consider_last_action: Optional[pulumi.Input[bool]] = None,
            consider_rage_click: Optional[pulumi.Input[bool]] = None,
            max_frustrated_user_actions_threshold: Optional[pulumi.Input[int]] = None,
            min_satisfied_user_actions_threshold: Optional[pulumi.Input[int]] = None) -> 'UserExperienceScore':
        """
        Get an existing UserExperienceScore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] consider_last_action: If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        :param pulumi.Input[bool] consider_rage_click: Consider rage clicks / rage taps in score calculation
        :param pulumi.Input[int] max_frustrated_user_actions_threshold: User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        :param pulumi.Input[int] min_satisfied_user_actions_threshold: User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserExperienceScoreState.__new__(_UserExperienceScoreState)

        __props__.__dict__["consider_last_action"] = consider_last_action
        __props__.__dict__["consider_rage_click"] = consider_rage_click
        __props__.__dict__["max_frustrated_user_actions_threshold"] = max_frustrated_user_actions_threshold
        __props__.__dict__["min_satisfied_user_actions_threshold"] = min_satisfied_user_actions_threshold
        return UserExperienceScore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="considerLastAction")
    def consider_last_action(self) -> pulumi.Output[bool]:
        """
        If last user action in a session is classified as Frustrating, classify the entire session as Frustrating
        """
        return pulumi.get(self, "consider_last_action")

    @property
    @pulumi.getter(name="considerRageClick")
    def consider_rage_click(self) -> pulumi.Output[bool]:
        """
        Consider rage clicks / rage taps in score calculation
        """
        return pulumi.get(self, "consider_rage_click")

    @property
    @pulumi.getter(name="maxFrustratedUserActionsThreshold")
    def max_frustrated_user_actions_threshold(self) -> pulumi.Output[int]:
        """
        User experience is considered Frustrating when the selected percentage or more of the user actions in a session are rated as Frustrating.
        """
        return pulumi.get(self, "max_frustrated_user_actions_threshold")

    @property
    @pulumi.getter(name="minSatisfiedUserActionsThreshold")
    def min_satisfied_user_actions_threshold(self) -> pulumi.Output[int]:
        """
        User experience is considered Satisfying when at least the selected percentage of the user actions in a session are rated as Satisfying.
        """
        return pulumi.get(self, "min_satisfied_user_actions_threshold")

