# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserActionMetricsArgs', 'UserActionMetrics']

@pulumi.input_type
class UserActionMetricsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 metric_key: pulumi.Input[str],
                 value: pulumi.Input['UserActionMetricsValueArgs'],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input['UserActionMetricsFiltersArgs']] = None):
        """
        The set of arguments for constructing a UserActionMetrics resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric_key: Metric key
        :param pulumi.Input['UserActionMetricsValueArgs'] value: Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        :param pulumi.Input['UserActionMetricsFiltersArgs'] filters: Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metric_key", metric_key)
        pulumi.set(__self__, "value", value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Input[str]:
        """
        Metric key
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['UserActionMetricsValueArgs']:
        """
        Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['UserActionMetricsValueArgs']):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['UserActionMetricsFiltersArgs']]:
        """
        Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['UserActionMetricsFiltersArgs']]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class _UserActionMetricsState:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input['UserActionMetricsFiltersArgs']] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input['UserActionMetricsValueArgs']] = None):
        """
        Input properties used for looking up and filtering UserActionMetrics resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['UserActionMetricsFiltersArgs'] filters: Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        :param pulumi.Input[str] metric_key: Metric key
        :param pulumi.Input['UserActionMetricsValueArgs'] value: Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if metric_key is not None:
            pulumi.set(__self__, "metric_key", metric_key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['UserActionMetricsFiltersArgs']]:
        """
        Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['UserActionMetricsFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> Optional[pulumi.Input[str]]:
        """
        Metric key
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['UserActionMetricsValueArgs']]:
        """
        Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['UserActionMetricsValueArgs']]):
        pulumi.set(self, "value", value)


class UserActionMetrics(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Union['UserActionMetricsFiltersArgs', 'UserActionMetricsFiltersArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Union['UserActionMetricsValueArgs', 'UserActionMetricsValueArgsDict']]] = None,
                 __props__=None):
        """
        Create a UserActionMetrics resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['UserActionMetricsFiltersArgs', 'UserActionMetricsFiltersArgsDict']] filters: Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        :param pulumi.Input[str] metric_key: Metric key
        :param pulumi.Input[Union['UserActionMetricsValueArgs', 'UserActionMetricsValueArgsDict']] value: Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserActionMetricsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a UserActionMetrics resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserActionMetricsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserActionMetricsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Union['UserActionMetricsFiltersArgs', 'UserActionMetricsFiltersArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Union['UserActionMetricsValueArgs', 'UserActionMetricsValueArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserActionMetricsArgs.__new__(UserActionMetricsArgs)

            __props__.__dict__["dimensions"] = dimensions
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            if metric_key is None and not opts.urn:
                raise TypeError("Missing required property 'metric_key'")
            __props__.__dict__["metric_key"] = metric_key
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(UserActionMetrics, __self__).__init__(
            'dynatrace:index/userActionMetrics:UserActionMetrics',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            filters: Optional[pulumi.Input[Union['UserActionMetricsFiltersArgs', 'UserActionMetricsFiltersArgsDict']]] = None,
            metric_key: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[Union['UserActionMetricsValueArgs', 'UserActionMetricsValueArgsDict']]] = None) -> 'UserActionMetrics':
        """
        Get an existing UserActionMetrics resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['UserActionMetricsFiltersArgs', 'UserActionMetricsFiltersArgsDict']] filters: Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        :param pulumi.Input[str] metric_key: Metric key
        :param pulumi.Input[Union['UserActionMetricsValueArgs', 'UserActionMetricsValueArgsDict']] value: Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserActionMetricsState.__new__(_UserActionMetricsState)

        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["metric_key"] = metric_key
        __props__.__dict__["value"] = value
        return UserActionMetrics(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Defines the fields that are used as dimensions. A dimension is a collection of reference information about a metric data point that is of interest to your business. Dimensions are parameters like "application", "type", "apdexCategory". For example, using "type" as a dimension allows you to split chart data based on the user action type.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.UserActionMetricsFilters']]:
        """
        Defines the filters for the user action. Filters apply at the moment of extracting the data and only sessions that satisfy the filtering criteria will be used to extract the custom metrics. You will not be able to modify these filters in the metric data explorer. For example, using "type equals Xhr" will give you only data from xhr actions, while forcing the rest of user actions of different types to be ignored.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Output[str]:
        """
        Metric key
        """
        return pulumi.get(self, "metric_key")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output['outputs.UserActionMetricsValue']:
        """
        Defines the type of value to be extracted from the user action. When using **user action counter**, the number of user actions is counted (similar to count(*) when using USQL). When using **user action field value**, the value of a user action field is extracted.
        """
        return pulumi.get(self, "value")

