# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SloArgs', 'Slo']

@pulumi.input_type
class SloArgs:
    def __init__(__self__, *,
                 evaluation: pulumi.Input[str],
                 target: pulumi.Input[float],
                 timeframe: pulumi.Input[str],
                 warning: pulumi.Input[float],
                 denominator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 error_budget_burn_rate: Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 metric_expression: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 numerator: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Slo resource.
        :param pulumi.Input[str] evaluation: The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        :param pulumi.Input[float] target: The target value of the SLO
        :param pulumi.Input[str] timeframe: The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        :param pulumi.Input[float] warning: The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        :param pulumi.Input[str] denominator: The total count metric (the denominator in rate calculation)
        :param pulumi.Input[str] description: The custom description of the SLO (optional)
        :param pulumi.Input[bool] disabled: The SLO is enabled (`false`) or disabled (`true`)
        :param pulumi.Input['SloErrorBudgetBurnRateArgs'] error_budget_burn_rate: Error budget burn rate configuration of a service-level objective (SLO).
        :param pulumi.Input[str] filter: The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        :param pulumi.Input[str] metric_expression: The percentage-based metric expression for the calculation of the SLO
        :param pulumi.Input[str] metric_name: The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] numerator: The metric for the count of successes (the numerator in rate calculation)
        :param pulumi.Input[str] rate: The percentage-based metric for the calculation of the SLO
        """
        pulumi.set(__self__, "evaluation", evaluation)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "warning", warning)
        if denominator is not None:
            pulumi.set(__self__, "denominator", denominator)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if error_budget_burn_rate is not None:
            pulumi.set(__self__, "error_budget_burn_rate", error_budget_burn_rate)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if metric_expression is not None:
            pulumi.set(__self__, "metric_expression", metric_expression)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if numerator is not None:
            warnings.warn("""`numerator` and `denominator` have been replaced by `metric_expression`""", DeprecationWarning)
            pulumi.log.warn("""numerator is deprecated: `numerator` and `denominator` have been replaced by `metric_expression`""")
        if numerator is not None:
            pulumi.set(__self__, "numerator", numerator)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)

    @property
    @pulumi.getter
    def evaluation(self) -> pulumi.Input[str]:
        """
        The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        """
        return pulumi.get(self, "evaluation")

    @evaluation.setter
    def evaluation(self, value: pulumi.Input[str]):
        pulumi.set(self, "evaluation", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[float]:
        """
        The target value of the SLO
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[float]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def timeframe(self) -> pulumi.Input[str]:
        """
        The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: pulumi.Input[str]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def warning(self) -> pulumi.Input[float]:
        """
        The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: pulumi.Input[float]):
        pulumi.set(self, "warning", value)

    @property
    @pulumi.getter
    def denominator(self) -> Optional[pulumi.Input[str]]:
        """
        The total count metric (the denominator in rate calculation)
        """
        return pulumi.get(self, "denominator")

    @denominator.setter
    def denominator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "denominator", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The custom description of the SLO (optional)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The SLO is enabled (`false`) or disabled (`true`)
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="errorBudgetBurnRate")
    def error_budget_burn_rate(self) -> Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']]:
        """
        Error budget burn rate configuration of a service-level objective (SLO).
        """
        return pulumi.get(self, "error_budget_burn_rate")

    @error_budget_burn_rate.setter
    def error_budget_burn_rate(self, value: Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']]):
        pulumi.set(self, "error_budget_burn_rate", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="metricExpression")
    def metric_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The percentage-based metric expression for the calculation of the SLO
        """
        return pulumi.get(self, "metric_expression")

    @metric_expression.setter
    def metric_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_expression", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`numerator` and `denominator` have been replaced by `metric_expression`""")
    def numerator(self) -> Optional[pulumi.Input[str]]:
        """
        The metric for the count of successes (the numerator in rate calculation)
        """
        return pulumi.get(self, "numerator")

    @numerator.setter
    def numerator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "numerator", value)

    @property
    @pulumi.getter
    def rate(self) -> Optional[pulumi.Input[str]]:
        """
        The percentage-based metric for the calculation of the SLO
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate", value)


@pulumi.input_type
class _SloState:
    def __init__(__self__, *,
                 denominator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 error_budget_burn_rate: Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']] = None,
                 evaluation: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 metric_expression: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 numerator: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[float]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 warning: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering Slo resources.
        :param pulumi.Input[str] denominator: The total count metric (the denominator in rate calculation)
        :param pulumi.Input[str] description: The custom description of the SLO (optional)
        :param pulumi.Input[bool] disabled: The SLO is enabled (`false`) or disabled (`true`)
        :param pulumi.Input['SloErrorBudgetBurnRateArgs'] error_budget_burn_rate: Error budget burn rate configuration of a service-level objective (SLO).
        :param pulumi.Input[str] evaluation: The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        :param pulumi.Input[str] filter: The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        :param pulumi.Input[str] metric_expression: The percentage-based metric expression for the calculation of the SLO
        :param pulumi.Input[str] metric_name: The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] numerator: The metric for the count of successes (the numerator in rate calculation)
        :param pulumi.Input[str] rate: The percentage-based metric for the calculation of the SLO
        :param pulumi.Input[float] target: The target value of the SLO
        :param pulumi.Input[str] timeframe: The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        :param pulumi.Input[float] warning: The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        if denominator is not None:
            pulumi.set(__self__, "denominator", denominator)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if error_budget_burn_rate is not None:
            pulumi.set(__self__, "error_budget_burn_rate", error_budget_burn_rate)
        if evaluation is not None:
            pulumi.set(__self__, "evaluation", evaluation)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if metric_expression is not None:
            pulumi.set(__self__, "metric_expression", metric_expression)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if numerator is not None:
            warnings.warn("""`numerator` and `denominator` have been replaced by `metric_expression`""", DeprecationWarning)
            pulumi.log.warn("""numerator is deprecated: `numerator` and `denominator` have been replaced by `metric_expression`""")
        if numerator is not None:
            pulumi.set(__self__, "numerator", numerator)
        if rate is not None:
            pulumi.set(__self__, "rate", rate)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeframe is not None:
            pulumi.set(__self__, "timeframe", timeframe)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter
    def denominator(self) -> Optional[pulumi.Input[str]]:
        """
        The total count metric (the denominator in rate calculation)
        """
        return pulumi.get(self, "denominator")

    @denominator.setter
    def denominator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "denominator", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The custom description of the SLO (optional)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The SLO is enabled (`false`) or disabled (`true`)
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="errorBudgetBurnRate")
    def error_budget_burn_rate(self) -> Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']]:
        """
        Error budget burn rate configuration of a service-level objective (SLO).
        """
        return pulumi.get(self, "error_budget_burn_rate")

    @error_budget_burn_rate.setter
    def error_budget_burn_rate(self, value: Optional[pulumi.Input['SloErrorBudgetBurnRateArgs']]):
        pulumi.set(self, "error_budget_burn_rate", value)

    @property
    @pulumi.getter
    def evaluation(self) -> Optional[pulumi.Input[str]]:
        """
        The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        """
        return pulumi.get(self, "evaluation")

    @evaluation.setter
    def evaluation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="metricExpression")
    def metric_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The percentage-based metric expression for the calculation of the SLO
        """
        return pulumi.get(self, "metric_expression")

    @metric_expression.setter
    def metric_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_expression", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`numerator` and `denominator` have been replaced by `metric_expression`""")
    def numerator(self) -> Optional[pulumi.Input[str]]:
        """
        The metric for the count of successes (the numerator in rate calculation)
        """
        return pulumi.get(self, "numerator")

    @numerator.setter
    def numerator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "numerator", value)

    @property
    @pulumi.getter
    def rate(self) -> Optional[pulumi.Input[str]]:
        """
        The percentage-based metric for the calculation of the SLO
        """
        return pulumi.get(self, "rate")

    @rate.setter
    def rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[float]]:
        """
        The target value of the SLO
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def timeframe(self) -> Optional[pulumi.Input[str]]:
        """
        The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input[float]]:
        """
        The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warning", value)


class Slo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 denominator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 error_budget_burn_rate: Optional[pulumi.Input[Union['SloErrorBudgetBurnRateArgs', 'SloErrorBudgetBurnRateArgsDict']]] = None,
                 evaluation: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 metric_expression: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 numerator: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[float]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 warning: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        Create a Slo resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] denominator: The total count metric (the denominator in rate calculation)
        :param pulumi.Input[str] description: The custom description of the SLO (optional)
        :param pulumi.Input[bool] disabled: The SLO is enabled (`false`) or disabled (`true`)
        :param pulumi.Input[Union['SloErrorBudgetBurnRateArgs', 'SloErrorBudgetBurnRateArgsDict']] error_budget_burn_rate: Error budget burn rate configuration of a service-level objective (SLO).
        :param pulumi.Input[str] evaluation: The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        :param pulumi.Input[str] filter: The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        :param pulumi.Input[str] metric_expression: The percentage-based metric expression for the calculation of the SLO
        :param pulumi.Input[str] metric_name: The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] numerator: The metric for the count of successes (the numerator in rate calculation)
        :param pulumi.Input[str] rate: The percentage-based metric for the calculation of the SLO
        :param pulumi.Input[float] target: The target value of the SLO
        :param pulumi.Input[str] timeframe: The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        :param pulumi.Input[float] warning: The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SloArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Slo resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SloArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SloArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 denominator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 error_budget_burn_rate: Optional[pulumi.Input[Union['SloErrorBudgetBurnRateArgs', 'SloErrorBudgetBurnRateArgsDict']]] = None,
                 evaluation: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 metric_expression: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 numerator: Optional[pulumi.Input[str]] = None,
                 rate: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[float]] = None,
                 timeframe: Optional[pulumi.Input[str]] = None,
                 warning: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SloArgs.__new__(SloArgs)

            __props__.__dict__["denominator"] = denominator
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["error_budget_burn_rate"] = error_budget_burn_rate
            if evaluation is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation'")
            __props__.__dict__["evaluation"] = evaluation
            __props__.__dict__["filter"] = filter
            __props__.__dict__["metric_expression"] = metric_expression
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["name"] = name
            __props__.__dict__["numerator"] = numerator
            __props__.__dict__["rate"] = rate
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            if timeframe is None and not opts.urn:
                raise TypeError("Missing required property 'timeframe'")
            __props__.__dict__["timeframe"] = timeframe
            if warning is None and not opts.urn:
                raise TypeError("Missing required property 'warning'")
            __props__.__dict__["warning"] = warning
        super(Slo, __self__).__init__(
            'dynatrace:index/slo:Slo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            denominator: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            error_budget_burn_rate: Optional[pulumi.Input[Union['SloErrorBudgetBurnRateArgs', 'SloErrorBudgetBurnRateArgsDict']]] = None,
            evaluation: Optional[pulumi.Input[str]] = None,
            filter: Optional[pulumi.Input[str]] = None,
            metric_expression: Optional[pulumi.Input[str]] = None,
            metric_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            numerator: Optional[pulumi.Input[str]] = None,
            rate: Optional[pulumi.Input[str]] = None,
            target: Optional[pulumi.Input[float]] = None,
            timeframe: Optional[pulumi.Input[str]] = None,
            warning: Optional[pulumi.Input[float]] = None) -> 'Slo':
        """
        Get an existing Slo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] denominator: The total count metric (the denominator in rate calculation)
        :param pulumi.Input[str] description: The custom description of the SLO (optional)
        :param pulumi.Input[bool] disabled: The SLO is enabled (`false`) or disabled (`true`)
        :param pulumi.Input[Union['SloErrorBudgetBurnRateArgs', 'SloErrorBudgetBurnRateArgsDict']] error_budget_burn_rate: Error budget burn rate configuration of a service-level objective (SLO).
        :param pulumi.Input[str] evaluation: The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        :param pulumi.Input[str] filter: The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        :param pulumi.Input[str] metric_expression: The percentage-based metric expression for the calculation of the SLO
        :param pulumi.Input[str] metric_name: The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        :param pulumi.Input[str] name: The name of the rule
        :param pulumi.Input[str] numerator: The metric for the count of successes (the numerator in rate calculation)
        :param pulumi.Input[str] rate: The percentage-based metric for the calculation of the SLO
        :param pulumi.Input[float] target: The target value of the SLO
        :param pulumi.Input[str] timeframe: The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        :param pulumi.Input[float] warning: The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SloState.__new__(_SloState)

        __props__.__dict__["denominator"] = denominator
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["error_budget_burn_rate"] = error_budget_burn_rate
        __props__.__dict__["evaluation"] = evaluation
        __props__.__dict__["filter"] = filter
        __props__.__dict__["metric_expression"] = metric_expression
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["name"] = name
        __props__.__dict__["numerator"] = numerator
        __props__.__dict__["rate"] = rate
        __props__.__dict__["target"] = target
        __props__.__dict__["timeframe"] = timeframe
        __props__.__dict__["warning"] = warning
        return Slo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def denominator(self) -> pulumi.Output[Optional[str]]:
        """
        The total count metric (the denominator in rate calculation)
        """
        return pulumi.get(self, "denominator")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The custom description of the SLO (optional)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The SLO is enabled (`false`) or disabled (`true`)
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="errorBudgetBurnRate")
    def error_budget_burn_rate(self) -> pulumi.Output[Optional['outputs.SloErrorBudgetBurnRate']]:
        """
        Error budget burn rate configuration of a service-level objective (SLO).
        """
        return pulumi.get(self, "error_budget_burn_rate")

    @property
    @pulumi.getter
    def evaluation(self) -> pulumi.Output[str]:
        """
        The evaluation type of the SLO. Currently only `AGGREGATE` is supported
        """
        return pulumi.get(self, "evaluation")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[str]]:
        """
        The entity filter for the SLO evaluation. Use the [syntax of entity selector](https://dt-url.net/entityselector)
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="metricExpression")
    def metric_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The percentage-based metric expression for the calculation of the SLO
        """
        return pulumi.get(self, "metric_expression")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name that is used to create SLO func metrics keys. Once created, metric name cannot be changed.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`numerator` and `denominator` have been replaced by `metric_expression`""")
    def numerator(self) -> pulumi.Output[Optional[str]]:
        """
        The metric for the count of successes (the numerator in rate calculation)
        """
        return pulumi.get(self, "numerator")

    @property
    @pulumi.getter
    def rate(self) -> pulumi.Output[Optional[str]]:
        """
        The percentage-based metric for the calculation of the SLO
        """
        return pulumi.get(self, "rate")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[float]:
        """
        The target value of the SLO
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def timeframe(self) -> pulumi.Output[str]:
        """
        The timeframe for the SLO evaluation. Use the syntax of the global timeframe selector
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def warning(self) -> pulumi.Output[float]:
        """
        The warning value of the SLO. At warning state the SLO is still fulfilled but is getting close to failure
        """
        return pulumi.get(self, "warning")

