# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SessionReplayWebPrivacyArgs', 'SessionReplayWebPrivacy']

@pulumi.input_type
class SessionReplayWebPrivacyArgs:
    def __init__(__self__, *,
                 enable_opt_in_mode: pulumi.Input[bool],
                 masking_presets: pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs'],
                 application_id: Optional[pulumi.Input[str]] = None,
                 url_exclusion_pattern_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SessionReplayWebPrivacy resource.
        :param pulumi.Input[bool] enable_opt_in_mode: (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        :param pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs'] masking_presets: (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        :param pulumi.Input[str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] url_exclusion_pattern_lists: (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        pulumi.set(__self__, "enable_opt_in_mode", enable_opt_in_mode)
        pulumi.set(__self__, "masking_presets", masking_presets)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if url_exclusion_pattern_lists is not None:
            pulumi.set(__self__, "url_exclusion_pattern_lists", url_exclusion_pattern_lists)

    @property
    @pulumi.getter(name="enableOptInMode")
    def enable_opt_in_mode(self) -> pulumi.Input[bool]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        """
        return pulumi.get(self, "enable_opt_in_mode")

    @enable_opt_in_mode.setter
    def enable_opt_in_mode(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_opt_in_mode", value)

    @property
    @pulumi.getter(name="maskingPresets")
    def masking_presets(self) -> pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs']:
        """
        (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        """
        return pulumi.get(self, "masking_presets")

    @masking_presets.setter
    def masking_presets(self, value: pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs']):
        pulumi.set(self, "masking_presets", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="urlExclusionPatternLists")
    def url_exclusion_pattern_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        return pulumi.get(self, "url_exclusion_pattern_lists")

    @url_exclusion_pattern_lists.setter
    def url_exclusion_pattern_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "url_exclusion_pattern_lists", value)


@pulumi.input_type
class _SessionReplayWebPrivacyState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 enable_opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 masking_presets: Optional[pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs']] = None,
                 url_exclusion_pattern_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SessionReplayWebPrivacy resources.
        :param pulumi.Input[str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[bool] enable_opt_in_mode: (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        :param pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs'] masking_presets: (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] url_exclusion_pattern_lists: (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if enable_opt_in_mode is not None:
            pulumi.set(__self__, "enable_opt_in_mode", enable_opt_in_mode)
        if masking_presets is not None:
            pulumi.set(__self__, "masking_presets", masking_presets)
        if url_exclusion_pattern_lists is not None:
            pulumi.set(__self__, "url_exclusion_pattern_lists", url_exclusion_pattern_lists)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="enableOptInMode")
    def enable_opt_in_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        """
        return pulumi.get(self, "enable_opt_in_mode")

    @enable_opt_in_mode.setter
    def enable_opt_in_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_opt_in_mode", value)

    @property
    @pulumi.getter(name="maskingPresets")
    def masking_presets(self) -> Optional[pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs']]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        """
        return pulumi.get(self, "masking_presets")

    @masking_presets.setter
    def masking_presets(self, value: Optional[pulumi.Input['SessionReplayWebPrivacyMaskingPresetsArgs']]):
        pulumi.set(self, "masking_presets", value)

    @property
    @pulumi.getter(name="urlExclusionPatternLists")
    def url_exclusion_pattern_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        return pulumi.get(self, "url_exclusion_pattern_lists")

    @url_exclusion_pattern_lists.setter
    def url_exclusion_pattern_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "url_exclusion_pattern_lists", value)


class SessionReplayWebPrivacy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 enable_opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 masking_presets: Optional[pulumi.Input[Union['SessionReplayWebPrivacyMaskingPresetsArgs', 'SessionReplayWebPrivacyMaskingPresetsArgsDict']]] = None,
                 url_exclusion_pattern_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a SessionReplayWebPrivacy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[bool] enable_opt_in_mode: (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        :param pulumi.Input[Union['SessionReplayWebPrivacyMaskingPresetsArgs', 'SessionReplayWebPrivacyMaskingPresetsArgsDict']] masking_presets: (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] url_exclusion_pattern_lists: (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SessionReplayWebPrivacyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SessionReplayWebPrivacy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SessionReplayWebPrivacyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SessionReplayWebPrivacyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 enable_opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 masking_presets: Optional[pulumi.Input[Union['SessionReplayWebPrivacyMaskingPresetsArgs', 'SessionReplayWebPrivacyMaskingPresetsArgsDict']]] = None,
                 url_exclusion_pattern_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SessionReplayWebPrivacyArgs.__new__(SessionReplayWebPrivacyArgs)

            __props__.__dict__["application_id"] = application_id
            if enable_opt_in_mode is None and not opts.urn:
                raise TypeError("Missing required property 'enable_opt_in_mode'")
            __props__.__dict__["enable_opt_in_mode"] = enable_opt_in_mode
            if masking_presets is None and not opts.urn:
                raise TypeError("Missing required property 'masking_presets'")
            __props__.__dict__["masking_presets"] = masking_presets
            __props__.__dict__["url_exclusion_pattern_lists"] = url_exclusion_pattern_lists
        super(SessionReplayWebPrivacy, __self__).__init__(
            'dynatrace:index/sessionReplayWebPrivacy:SessionReplayWebPrivacy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            enable_opt_in_mode: Optional[pulumi.Input[bool]] = None,
            masking_presets: Optional[pulumi.Input[Union['SessionReplayWebPrivacyMaskingPresetsArgs', 'SessionReplayWebPrivacyMaskingPresetsArgsDict']]] = None,
            url_exclusion_pattern_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SessionReplayWebPrivacy':
        """
        Get an existing SessionReplayWebPrivacy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[bool] enable_opt_in_mode: (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        :param pulumi.Input[Union['SessionReplayWebPrivacyMaskingPresetsArgs', 'SessionReplayWebPrivacyMaskingPresetsArgsDict']] masking_presets: (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] url_exclusion_pattern_lists: (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SessionReplayWebPrivacyState.__new__(_SessionReplayWebPrivacyState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["enable_opt_in_mode"] = enable_opt_in_mode
        __props__.__dict__["masking_presets"] = masking_presets
        __props__.__dict__["url_exclusion_pattern_lists"] = url_exclusion_pattern_lists
        return SessionReplayWebPrivacy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="enableOptInMode")
    def enable_opt_in_mode(self) -> pulumi.Output[bool]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) When [Session Replay opt-in mode](https://dt-url.net/sr-opt-in-mode) is turned on, Session Replay is deactivated until explicitly activated via an API call.
        """
        return pulumi.get(self, "enable_opt_in_mode")

    @property
    @pulumi.getter(name="maskingPresets")
    def masking_presets(self) -> pulumi.Output['outputs.SessionReplayWebPrivacyMaskingPresets']:
        """
        (Field has overlap with `ApplicationDataPrivacy`) To protect your end users' privacy, select or customize [predefined masking options](https://dt-url.net/sr-masking-preset-options) that suit your content recording and playback requirements.
        """
        return pulumi.get(self, "masking_presets")

    @property
    @pulumi.getter(name="urlExclusionPatternLists")
    def url_exclusion_pattern_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Field has overlap with `ApplicationDataPrivacy`) Exclude webpages or views from Session Replay recording by adding [URL exclusion rules](https://dt-url.net/sr-url-exclusion)
        """
        return pulumi.get(self, "url_exclusion_pattern_lists")

