# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RemoteEnvironmentsArgs', 'RemoteEnvironments']

@pulumi.input_type
class RemoteEnvironmentsArgs:
    def __init__(__self__, *,
                 network_scope: pulumi.Input[str],
                 token: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RemoteEnvironments resource.
        :param pulumi.Input[str] network_scope: Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        :param pulumi.Input[str] token: Provide a valid token created on the remote environment.
        :param pulumi.Input[str] uri: Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        :param pulumi.Input[str] name: Name
        """
        pulumi.set(__self__, "network_scope", network_scope)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "uri", uri)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="networkScope")
    def network_scope(self) -> pulumi.Input[str]:
        """
        Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        """
        return pulumi.get(self, "network_scope")

    @network_scope.setter
    def network_scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_scope", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Provide a valid token created on the remote environment.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RemoteEnvironmentsState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 network_scope: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RemoteEnvironments resources.
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[str] network_scope: Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        :param pulumi.Input[str] token: Provide a valid token created on the remote environment.
        :param pulumi.Input[str] uri: Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_scope is not None:
            pulumi.set(__self__, "network_scope", network_scope)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkScope")
    def network_scope(self) -> Optional[pulumi.Input[str]]:
        """
        Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        """
        return pulumi.get(self, "network_scope")

    @network_scope.setter
    def network_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_scope", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Provide a valid token created on the remote environment.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


class RemoteEnvironments(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_scope: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a RemoteEnvironments resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[str] network_scope: Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        :param pulumi.Input[str] token: Provide a valid token created on the remote environment.
        :param pulumi.Input[str] uri: Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RemoteEnvironmentsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a RemoteEnvironments resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RemoteEnvironmentsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RemoteEnvironmentsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_scope: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RemoteEnvironmentsArgs.__new__(RemoteEnvironmentsArgs)

            __props__.__dict__["name"] = name
            if network_scope is None and not opts.urn:
                raise TypeError("Missing required property 'network_scope'")
            __props__.__dict__["network_scope"] = network_scope
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RemoteEnvironments, __self__).__init__(
            'dynatrace:index/remoteEnvironments:RemoteEnvironments',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_scope: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            uri: Optional[pulumi.Input[str]] = None) -> 'RemoteEnvironments':
        """
        Get an existing RemoteEnvironments resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[str] network_scope: Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        :param pulumi.Input[str] token: Provide a valid token created on the remote environment.
        :param pulumi.Input[str] uri: Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RemoteEnvironmentsState.__new__(_RemoteEnvironmentsState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_scope"] = network_scope
        __props__.__dict__["token"] = token
        __props__.__dict__["uri"] = uri
        return RemoteEnvironments(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkScope")
    def network_scope(self) -> pulumi.Output[str]:
        """
        Possible Values: `CLUSTER`, `EXTERNAL`, `INTERNAL`
        """
        return pulumi.get(self, "network_scope")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Provide a valid token created on the remote environment.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[str]:
        """
        Specify the full URI to the remote environment. Your local environment will have to be able to connect this URI on a network level.
        """
        return pulumi.get(self, "uri")

