# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 automation_client_id: Optional[pulumi.Input[str]] = None,
                 automation_client_secret: Optional[pulumi.Input[str]] = None,
                 automation_env_url: Optional[pulumi.Input[str]] = None,
                 automation_token_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 dt_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_url: Optional[pulumi.Input[str]] = None,
                 dt_env_url: Optional[pulumi.Input[str]] = None,
                 iam_account_id: Optional[pulumi.Input[str]] = None,
                 iam_client_id: Optional[pulumi.Input[str]] = None,
                 iam_client_secret: Optional[pulumi.Input[str]] = None,
                 iam_endpoint_url: Optional[pulumi.Input[str]] = None,
                 iam_token_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] automation_env_url: The URL of the Dynatrace Environment with Platform capabilities turned on (`https://#####.apps.dynatrace.com)`. This is
               optional configuration when `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
               `https://#####.apps.dynatrace.com`
        :param pulumi.Input[str] automation_token_url: The URL that provides the Bearer tokens when accessing the Automation REST API. This is optional configuration when
               `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
               `https://#####.apps.dynatrace.com`
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if automation_client_id is not None:
            pulumi.set(__self__, "automation_client_id", automation_client_id)
        if automation_client_secret is not None:
            pulumi.set(__self__, "automation_client_secret", automation_client_secret)
        if automation_env_url is not None:
            pulumi.set(__self__, "automation_env_url", automation_env_url)
        if automation_token_url is not None:
            pulumi.set(__self__, "automation_token_url", automation_token_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if dt_api_token is None:
            dt_api_token = _utilities.get_env('DYNATRACE_API_TOKEN', 'DT_API_TOKEN')
        if dt_api_token is not None:
            pulumi.set(__self__, "dt_api_token", dt_api_token)
        if dt_cluster_api_token is None:
            dt_cluster_api_token = _utilities.get_env('DYNATRACE_CLUSTER_API_TOKEN', 'DT_CLUSTER_API_TOKEN')
        if dt_cluster_api_token is not None:
            pulumi.set(__self__, "dt_cluster_api_token", dt_cluster_api_token)
        if dt_cluster_url is None:
            dt_cluster_url = _utilities.get_env('DYNATRACE_CLUSTER_URL', 'DT_CLUSTER_URL')
        if dt_cluster_url is not None:
            pulumi.set(__self__, "dt_cluster_url", dt_cluster_url)
        if dt_env_url is None:
            dt_env_url = _utilities.get_env('DYNATRACE_ENV_URL', 'DT_ENV_URL')
        if dt_env_url is not None:
            pulumi.set(__self__, "dt_env_url", dt_env_url)
        if iam_account_id is not None:
            pulumi.set(__self__, "iam_account_id", iam_account_id)
        if iam_client_id is not None:
            pulumi.set(__self__, "iam_client_id", iam_client_id)
        if iam_client_secret is not None:
            pulumi.set(__self__, "iam_client_secret", iam_client_secret)
        if iam_endpoint_url is not None:
            pulumi.set(__self__, "iam_endpoint_url", iam_endpoint_url)
        if iam_token_url is not None:
            pulumi.set(__self__, "iam_token_url", iam_token_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="automationClientId")
    def automation_client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "automation_client_id")

    @automation_client_id.setter
    def automation_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_client_id", value)

    @property
    @pulumi.getter(name="automationClientSecret")
    def automation_client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "automation_client_secret")

    @automation_client_secret.setter
    def automation_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_client_secret", value)

    @property
    @pulumi.getter(name="automationEnvUrl")
    def automation_env_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Dynatrace Environment with Platform capabilities turned on (`https://#####.apps.dynatrace.com)`. This is
        optional configuration when `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
        `https://#####.apps.dynatrace.com`
        """
        return pulumi.get(self, "automation_env_url")

    @automation_env_url.setter
    def automation_env_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_env_url", value)

    @property
    @pulumi.getter(name="automationTokenUrl")
    def automation_token_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that provides the Bearer tokens when accessing the Automation REST API. This is optional configuration when
        `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
        `https://#####.apps.dynatrace.com`
        """
        return pulumi.get(self, "automation_token_url")

    @automation_token_url.setter
    def automation_token_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_token_url", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="dtApiToken")
    def dt_api_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dt_api_token")

    @dt_api_token.setter
    def dt_api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dt_api_token", value)

    @property
    @pulumi.getter(name="dtClusterApiToken")
    def dt_cluster_api_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dt_cluster_api_token")

    @dt_cluster_api_token.setter
    def dt_cluster_api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dt_cluster_api_token", value)

    @property
    @pulumi.getter(name="dtClusterUrl")
    def dt_cluster_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dt_cluster_url")

    @dt_cluster_url.setter
    def dt_cluster_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dt_cluster_url", value)

    @property
    @pulumi.getter(name="dtEnvUrl")
    def dt_env_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dt_env_url")

    @dt_env_url.setter
    def dt_env_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dt_env_url", value)

    @property
    @pulumi.getter(name="iamAccountId")
    def iam_account_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iam_account_id")

    @iam_account_id.setter
    def iam_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_account_id", value)

    @property
    @pulumi.getter(name="iamClientId")
    def iam_client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iam_client_id")

    @iam_client_id.setter
    def iam_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_client_id", value)

    @property
    @pulumi.getter(name="iamClientSecret")
    def iam_client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iam_client_secret")

    @iam_client_secret.setter
    def iam_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_client_secret", value)

    @property
    @pulumi.getter(name="iamEndpointUrl")
    def iam_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iam_endpoint_url")

    @iam_endpoint_url.setter
    def iam_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_endpoint_url", value)

    @property
    @pulumi.getter(name="iamTokenUrl")
    def iam_token_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "iam_token_url")

    @iam_token_url.setter
    def iam_token_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_token_url", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 automation_client_id: Optional[pulumi.Input[str]] = None,
                 automation_client_secret: Optional[pulumi.Input[str]] = None,
                 automation_env_url: Optional[pulumi.Input[str]] = None,
                 automation_token_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 dt_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_url: Optional[pulumi.Input[str]] = None,
                 dt_env_url: Optional[pulumi.Input[str]] = None,
                 iam_account_id: Optional[pulumi.Input[str]] = None,
                 iam_client_id: Optional[pulumi.Input[str]] = None,
                 iam_client_secret: Optional[pulumi.Input[str]] = None,
                 iam_endpoint_url: Optional[pulumi.Input[str]] = None,
                 iam_token_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the dynatrace package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] automation_env_url: The URL of the Dynatrace Environment with Platform capabilities turned on (`https://#####.apps.dynatrace.com)`. This is
               optional configuration when `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
               `https://#####.apps.dynatrace.com`
        :param pulumi.Input[str] automation_token_url: The URL that provides the Bearer tokens when accessing the Automation REST API. This is optional configuration when
               `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
               `https://#####.apps.dynatrace.com`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the dynatrace package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 automation_client_id: Optional[pulumi.Input[str]] = None,
                 automation_client_secret: Optional[pulumi.Input[str]] = None,
                 automation_env_url: Optional[pulumi.Input[str]] = None,
                 automation_token_url: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 dt_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_api_token: Optional[pulumi.Input[str]] = None,
                 dt_cluster_url: Optional[pulumi.Input[str]] = None,
                 dt_env_url: Optional[pulumi.Input[str]] = None,
                 iam_account_id: Optional[pulumi.Input[str]] = None,
                 iam_client_id: Optional[pulumi.Input[str]] = None,
                 iam_client_secret: Optional[pulumi.Input[str]] = None,
                 iam_endpoint_url: Optional[pulumi.Input[str]] = None,
                 iam_token_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["account_id"] = None if account_id is None else pulumi.Output.secret(account_id)
            __props__.__dict__["automation_client_id"] = None if automation_client_id is None else pulumi.Output.secret(automation_client_id)
            __props__.__dict__["automation_client_secret"] = None if automation_client_secret is None else pulumi.Output.secret(automation_client_secret)
            __props__.__dict__["automation_env_url"] = automation_env_url
            __props__.__dict__["automation_token_url"] = automation_token_url
            __props__.__dict__["client_id"] = None if client_id is None else pulumi.Output.secret(client_id)
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            if dt_api_token is None:
                dt_api_token = _utilities.get_env('DYNATRACE_API_TOKEN', 'DT_API_TOKEN')
            __props__.__dict__["dt_api_token"] = None if dt_api_token is None else pulumi.Output.secret(dt_api_token)
            if dt_cluster_api_token is None:
                dt_cluster_api_token = _utilities.get_env('DYNATRACE_CLUSTER_API_TOKEN', 'DT_CLUSTER_API_TOKEN')
            __props__.__dict__["dt_cluster_api_token"] = None if dt_cluster_api_token is None else pulumi.Output.secret(dt_cluster_api_token)
            if dt_cluster_url is None:
                dt_cluster_url = _utilities.get_env('DYNATRACE_CLUSTER_URL', 'DT_CLUSTER_URL')
            __props__.__dict__["dt_cluster_url"] = None if dt_cluster_url is None else pulumi.Output.secret(dt_cluster_url)
            if dt_env_url is None:
                dt_env_url = _utilities.get_env('DYNATRACE_ENV_URL', 'DT_ENV_URL')
            __props__.__dict__["dt_env_url"] = dt_env_url
            __props__.__dict__["iam_account_id"] = None if iam_account_id is None else pulumi.Output.secret(iam_account_id)
            __props__.__dict__["iam_client_id"] = None if iam_client_id is None else pulumi.Output.secret(iam_client_id)
            __props__.__dict__["iam_client_secret"] = None if iam_client_secret is None else pulumi.Output.secret(iam_client_secret)
            __props__.__dict__["iam_endpoint_url"] = None if iam_endpoint_url is None else pulumi.Output.secret(iam_endpoint_url)
            __props__.__dict__["iam_token_url"] = None if iam_token_url is None else pulumi.Output.secret(iam_token_url)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountId", "automationClientId", "automationClientSecret", "clientId", "clientSecret", "dtApiToken", "dtClusterApiToken", "dtClusterUrl", "iamAccountId", "iamClientId", "iamClientSecret", "iamEndpointUrl", "iamTokenUrl"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'dynatrace',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="automationClientId")
    def automation_client_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "automation_client_id")

    @property
    @pulumi.getter(name="automationClientSecret")
    def automation_client_secret(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "automation_client_secret")

    @property
    @pulumi.getter(name="automationEnvUrl")
    def automation_env_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the Dynatrace Environment with Platform capabilities turned on (`https://#####.apps.dynatrace.com)`. This is
        optional configuration when `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
        `https://#####.apps.dynatrace.com`
        """
        return pulumi.get(self, "automation_env_url")

    @property
    @pulumi.getter(name="automationTokenUrl")
    def automation_token_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL that provides the Bearer tokens when accessing the Automation REST API. This is optional configuration when
        `dt_env_url` already specifies a SaaS Environment like `https://#####.live.dynatrace.com` or
        `https://#####.apps.dynatrace.com`
        """
        return pulumi.get(self, "automation_token_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="dtApiToken")
    def dt_api_token(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "dt_api_token")

    @property
    @pulumi.getter(name="dtClusterApiToken")
    def dt_cluster_api_token(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "dt_cluster_api_token")

    @property
    @pulumi.getter(name="dtClusterUrl")
    def dt_cluster_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "dt_cluster_url")

    @property
    @pulumi.getter(name="dtEnvUrl")
    def dt_env_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "dt_env_url")

    @property
    @pulumi.getter(name="iamAccountId")
    def iam_account_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "iam_account_id")

    @property
    @pulumi.getter(name="iamClientId")
    def iam_client_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "iam_client_id")

    @property
    @pulumi.getter(name="iamClientSecret")
    def iam_client_secret(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "iam_client_secret")

    @property
    @pulumi.getter(name="iamEndpointUrl")
    def iam_endpoint_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "iam_endpoint_url")

    @property
    @pulumi.getter(name="iamTokenUrl")
    def iam_token_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "iam_token_url")

