# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProcessGroupDetectionFlagsArgs', 'ProcessGroupDetectionFlags']

@pulumi.input_type
class ProcessGroupDetectionFlagsArgs:
    def __init__(__self__, *,
                 add_node_js_script_name: pulumi.Input[bool],
                 auto_detect_cassandra_clusters: pulumi.Input[bool],
                 auto_detect_spring_boot: pulumi.Input[bool],
                 auto_detect_tibco_container_edition_engines: pulumi.Input[bool],
                 auto_detect_tibco_engines: pulumi.Input[bool],
                 auto_detect_web_methods_integration_server: pulumi.Input[bool],
                 auto_detect_web_sphere_liberty_application: pulumi.Input[bool],
                 group_ibmmqby_instance_name: pulumi.Input[bool],
                 identify_jboss_server_by_system_property: pulumi.Input[bool],
                 ignore_unique_identifiers: pulumi.Input[bool],
                 short_lived_processes_monitoring: pulumi.Input[bool],
                 split_oracle_database_pg: pulumi.Input[bool],
                 split_oracle_listener_pg: pulumi.Input[bool],
                 use_catalina_base: pulumi.Input[bool],
                 use_docker_container_name: pulumi.Input[bool],
                 scope: Optional[pulumi.Input[str]] = None,
                 security_software_detection_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ProcessGroupDetectionFlags resource.
        :param pulumi.Input[bool] add_node_js_script_name: In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        :param pulumi.Input[bool] auto_detect_cassandra_clusters: Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        :param pulumi.Input[bool] auto_detect_spring_boot: Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        :param pulumi.Input[bool] auto_detect_tibco_container_edition_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_tibco_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_web_methods_integration_server: Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        :param pulumi.Input[bool] auto_detect_web_sphere_liberty_application: Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        :param pulumi.Input[bool] group_ibmmqby_instance_name: Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        :param pulumi.Input[bool] identify_jboss_server_by_system_property: Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        :param pulumi.Input[bool] ignore_unique_identifiers: To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        :param pulumi.Input[bool] short_lived_processes_monitoring: Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        :param pulumi.Input[bool] split_oracle_database_pg: Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        :param pulumi.Input[bool] split_oracle_listener_pg: Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        :param pulumi.Input[bool] use_catalina_base: By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        :param pulumi.Input[bool] use_docker_container_name: By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[bool] security_software_detection_enabled: This flag enables the detection of security software such as anti-malware protection.
        """
        pulumi.set(__self__, "add_node_js_script_name", add_node_js_script_name)
        pulumi.set(__self__, "auto_detect_cassandra_clusters", auto_detect_cassandra_clusters)
        pulumi.set(__self__, "auto_detect_spring_boot", auto_detect_spring_boot)
        pulumi.set(__self__, "auto_detect_tibco_container_edition_engines", auto_detect_tibco_container_edition_engines)
        pulumi.set(__self__, "auto_detect_tibco_engines", auto_detect_tibco_engines)
        pulumi.set(__self__, "auto_detect_web_methods_integration_server", auto_detect_web_methods_integration_server)
        pulumi.set(__self__, "auto_detect_web_sphere_liberty_application", auto_detect_web_sphere_liberty_application)
        pulumi.set(__self__, "group_ibmmqby_instance_name", group_ibmmqby_instance_name)
        pulumi.set(__self__, "identify_jboss_server_by_system_property", identify_jboss_server_by_system_property)
        pulumi.set(__self__, "ignore_unique_identifiers", ignore_unique_identifiers)
        pulumi.set(__self__, "short_lived_processes_monitoring", short_lived_processes_monitoring)
        pulumi.set(__self__, "split_oracle_database_pg", split_oracle_database_pg)
        pulumi.set(__self__, "split_oracle_listener_pg", split_oracle_listener_pg)
        pulumi.set(__self__, "use_catalina_base", use_catalina_base)
        pulumi.set(__self__, "use_docker_container_name", use_docker_container_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if security_software_detection_enabled is not None:
            pulumi.set(__self__, "security_software_detection_enabled", security_software_detection_enabled)

    @property
    @pulumi.getter(name="addNodeJsScriptName")
    def add_node_js_script_name(self) -> pulumi.Input[bool]:
        """
        In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        """
        return pulumi.get(self, "add_node_js_script_name")

    @add_node_js_script_name.setter
    def add_node_js_script_name(self, value: pulumi.Input[bool]):
        pulumi.set(self, "add_node_js_script_name", value)

    @property
    @pulumi.getter(name="autoDetectCassandraClusters")
    def auto_detect_cassandra_clusters(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        """
        return pulumi.get(self, "auto_detect_cassandra_clusters")

    @auto_detect_cassandra_clusters.setter
    def auto_detect_cassandra_clusters(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_cassandra_clusters", value)

    @property
    @pulumi.getter(name="autoDetectSpringBoot")
    def auto_detect_spring_boot(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        """
        return pulumi.get(self, "auto_detect_spring_boot")

    @auto_detect_spring_boot.setter
    def auto_detect_spring_boot(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_spring_boot", value)

    @property
    @pulumi.getter(name="autoDetectTibcoContainerEditionEngines")
    def auto_detect_tibco_container_edition_engines(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_container_edition_engines")

    @auto_detect_tibco_container_edition_engines.setter
    def auto_detect_tibco_container_edition_engines(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_tibco_container_edition_engines", value)

    @property
    @pulumi.getter(name="autoDetectTibcoEngines")
    def auto_detect_tibco_engines(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_engines")

    @auto_detect_tibco_engines.setter
    def auto_detect_tibco_engines(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_tibco_engines", value)

    @property
    @pulumi.getter(name="autoDetectWebMethodsIntegrationServer")
    def auto_detect_web_methods_integration_server(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        """
        return pulumi.get(self, "auto_detect_web_methods_integration_server")

    @auto_detect_web_methods_integration_server.setter
    def auto_detect_web_methods_integration_server(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_web_methods_integration_server", value)

    @property
    @pulumi.getter(name="autoDetectWebSphereLibertyApplication")
    def auto_detect_web_sphere_liberty_application(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        """
        return pulumi.get(self, "auto_detect_web_sphere_liberty_application")

    @auto_detect_web_sphere_liberty_application.setter
    def auto_detect_web_sphere_liberty_application(self, value: pulumi.Input[bool]):
        pulumi.set(self, "auto_detect_web_sphere_liberty_application", value)

    @property
    @pulumi.getter(name="groupIbmmqbyInstanceName")
    def group_ibmmqby_instance_name(self) -> pulumi.Input[bool]:
        """
        Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        """
        return pulumi.get(self, "group_ibmmqby_instance_name")

    @group_ibmmqby_instance_name.setter
    def group_ibmmqby_instance_name(self, value: pulumi.Input[bool]):
        pulumi.set(self, "group_ibmmqby_instance_name", value)

    @property
    @pulumi.getter(name="identifyJbossServerBySystemProperty")
    def identify_jboss_server_by_system_property(self) -> pulumi.Input[bool]:
        """
        Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        """
        return pulumi.get(self, "identify_jboss_server_by_system_property")

    @identify_jboss_server_by_system_property.setter
    def identify_jboss_server_by_system_property(self, value: pulumi.Input[bool]):
        pulumi.set(self, "identify_jboss_server_by_system_property", value)

    @property
    @pulumi.getter(name="ignoreUniqueIdentifiers")
    def ignore_unique_identifiers(self) -> pulumi.Input[bool]:
        """
        To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        """
        return pulumi.get(self, "ignore_unique_identifiers")

    @ignore_unique_identifiers.setter
    def ignore_unique_identifiers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ignore_unique_identifiers", value)

    @property
    @pulumi.getter(name="shortLivedProcessesMonitoring")
    def short_lived_processes_monitoring(self) -> pulumi.Input[bool]:
        """
        Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        """
        return pulumi.get(self, "short_lived_processes_monitoring")

    @short_lived_processes_monitoring.setter
    def short_lived_processes_monitoring(self, value: pulumi.Input[bool]):
        pulumi.set(self, "short_lived_processes_monitoring", value)

    @property
    @pulumi.getter(name="splitOracleDatabasePg")
    def split_oracle_database_pg(self) -> pulumi.Input[bool]:
        """
        Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        """
        return pulumi.get(self, "split_oracle_database_pg")

    @split_oracle_database_pg.setter
    def split_oracle_database_pg(self, value: pulumi.Input[bool]):
        pulumi.set(self, "split_oracle_database_pg", value)

    @property
    @pulumi.getter(name="splitOracleListenerPg")
    def split_oracle_listener_pg(self) -> pulumi.Input[bool]:
        """
        Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        """
        return pulumi.get(self, "split_oracle_listener_pg")

    @split_oracle_listener_pg.setter
    def split_oracle_listener_pg(self, value: pulumi.Input[bool]):
        pulumi.set(self, "split_oracle_listener_pg", value)

    @property
    @pulumi.getter(name="useCatalinaBase")
    def use_catalina_base(self) -> pulumi.Input[bool]:
        """
        By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        """
        return pulumi.get(self, "use_catalina_base")

    @use_catalina_base.setter
    def use_catalina_base(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_catalina_base", value)

    @property
    @pulumi.getter(name="useDockerContainerName")
    def use_docker_container_name(self) -> pulumi.Input[bool]:
        """
        By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        return pulumi.get(self, "use_docker_container_name")

    @use_docker_container_name.setter
    def use_docker_container_name(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_docker_container_name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="securitySoftwareDetectionEnabled")
    def security_software_detection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag enables the detection of security software such as anti-malware protection.
        """
        return pulumi.get(self, "security_software_detection_enabled")

    @security_software_detection_enabled.setter
    def security_software_detection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_software_detection_enabled", value)


@pulumi.input_type
class _ProcessGroupDetectionFlagsState:
    def __init__(__self__, *,
                 add_node_js_script_name: Optional[pulumi.Input[bool]] = None,
                 auto_detect_cassandra_clusters: Optional[pulumi.Input[bool]] = None,
                 auto_detect_spring_boot: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_container_edition_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_methods_integration_server: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_sphere_liberty_application: Optional[pulumi.Input[bool]] = None,
                 group_ibmmqby_instance_name: Optional[pulumi.Input[bool]] = None,
                 identify_jboss_server_by_system_property: Optional[pulumi.Input[bool]] = None,
                 ignore_unique_identifiers: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 security_software_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 short_lived_processes_monitoring: Optional[pulumi.Input[bool]] = None,
                 split_oracle_database_pg: Optional[pulumi.Input[bool]] = None,
                 split_oracle_listener_pg: Optional[pulumi.Input[bool]] = None,
                 use_catalina_base: Optional[pulumi.Input[bool]] = None,
                 use_docker_container_name: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ProcessGroupDetectionFlags resources.
        :param pulumi.Input[bool] add_node_js_script_name: In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        :param pulumi.Input[bool] auto_detect_cassandra_clusters: Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        :param pulumi.Input[bool] auto_detect_spring_boot: Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        :param pulumi.Input[bool] auto_detect_tibco_container_edition_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_tibco_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_web_methods_integration_server: Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        :param pulumi.Input[bool] auto_detect_web_sphere_liberty_application: Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        :param pulumi.Input[bool] group_ibmmqby_instance_name: Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        :param pulumi.Input[bool] identify_jboss_server_by_system_property: Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        :param pulumi.Input[bool] ignore_unique_identifiers: To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[bool] security_software_detection_enabled: This flag enables the detection of security software such as anti-malware protection.
        :param pulumi.Input[bool] short_lived_processes_monitoring: Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        :param pulumi.Input[bool] split_oracle_database_pg: Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        :param pulumi.Input[bool] split_oracle_listener_pg: Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        :param pulumi.Input[bool] use_catalina_base: By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        :param pulumi.Input[bool] use_docker_container_name: By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        if add_node_js_script_name is not None:
            pulumi.set(__self__, "add_node_js_script_name", add_node_js_script_name)
        if auto_detect_cassandra_clusters is not None:
            pulumi.set(__self__, "auto_detect_cassandra_clusters", auto_detect_cassandra_clusters)
        if auto_detect_spring_boot is not None:
            pulumi.set(__self__, "auto_detect_spring_boot", auto_detect_spring_boot)
        if auto_detect_tibco_container_edition_engines is not None:
            pulumi.set(__self__, "auto_detect_tibco_container_edition_engines", auto_detect_tibco_container_edition_engines)
        if auto_detect_tibco_engines is not None:
            pulumi.set(__self__, "auto_detect_tibco_engines", auto_detect_tibco_engines)
        if auto_detect_web_methods_integration_server is not None:
            pulumi.set(__self__, "auto_detect_web_methods_integration_server", auto_detect_web_methods_integration_server)
        if auto_detect_web_sphere_liberty_application is not None:
            pulumi.set(__self__, "auto_detect_web_sphere_liberty_application", auto_detect_web_sphere_liberty_application)
        if group_ibmmqby_instance_name is not None:
            pulumi.set(__self__, "group_ibmmqby_instance_name", group_ibmmqby_instance_name)
        if identify_jboss_server_by_system_property is not None:
            pulumi.set(__self__, "identify_jboss_server_by_system_property", identify_jboss_server_by_system_property)
        if ignore_unique_identifiers is not None:
            pulumi.set(__self__, "ignore_unique_identifiers", ignore_unique_identifiers)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if security_software_detection_enabled is not None:
            pulumi.set(__self__, "security_software_detection_enabled", security_software_detection_enabled)
        if short_lived_processes_monitoring is not None:
            pulumi.set(__self__, "short_lived_processes_monitoring", short_lived_processes_monitoring)
        if split_oracle_database_pg is not None:
            pulumi.set(__self__, "split_oracle_database_pg", split_oracle_database_pg)
        if split_oracle_listener_pg is not None:
            pulumi.set(__self__, "split_oracle_listener_pg", split_oracle_listener_pg)
        if use_catalina_base is not None:
            pulumi.set(__self__, "use_catalina_base", use_catalina_base)
        if use_docker_container_name is not None:
            pulumi.set(__self__, "use_docker_container_name", use_docker_container_name)

    @property
    @pulumi.getter(name="addNodeJsScriptName")
    def add_node_js_script_name(self) -> Optional[pulumi.Input[bool]]:
        """
        In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        """
        return pulumi.get(self, "add_node_js_script_name")

    @add_node_js_script_name.setter
    def add_node_js_script_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_node_js_script_name", value)

    @property
    @pulumi.getter(name="autoDetectCassandraClusters")
    def auto_detect_cassandra_clusters(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        """
        return pulumi.get(self, "auto_detect_cassandra_clusters")

    @auto_detect_cassandra_clusters.setter
    def auto_detect_cassandra_clusters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_cassandra_clusters", value)

    @property
    @pulumi.getter(name="autoDetectSpringBoot")
    def auto_detect_spring_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        """
        return pulumi.get(self, "auto_detect_spring_boot")

    @auto_detect_spring_boot.setter
    def auto_detect_spring_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_spring_boot", value)

    @property
    @pulumi.getter(name="autoDetectTibcoContainerEditionEngines")
    def auto_detect_tibco_container_edition_engines(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_container_edition_engines")

    @auto_detect_tibco_container_edition_engines.setter
    def auto_detect_tibco_container_edition_engines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_tibco_container_edition_engines", value)

    @property
    @pulumi.getter(name="autoDetectTibcoEngines")
    def auto_detect_tibco_engines(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_engines")

    @auto_detect_tibco_engines.setter
    def auto_detect_tibco_engines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_tibco_engines", value)

    @property
    @pulumi.getter(name="autoDetectWebMethodsIntegrationServer")
    def auto_detect_web_methods_integration_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        """
        return pulumi.get(self, "auto_detect_web_methods_integration_server")

    @auto_detect_web_methods_integration_server.setter
    def auto_detect_web_methods_integration_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_web_methods_integration_server", value)

    @property
    @pulumi.getter(name="autoDetectWebSphereLibertyApplication")
    def auto_detect_web_sphere_liberty_application(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        """
        return pulumi.get(self, "auto_detect_web_sphere_liberty_application")

    @auto_detect_web_sphere_liberty_application.setter
    def auto_detect_web_sphere_liberty_application(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_detect_web_sphere_liberty_application", value)

    @property
    @pulumi.getter(name="groupIbmmqbyInstanceName")
    def group_ibmmqby_instance_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        """
        return pulumi.get(self, "group_ibmmqby_instance_name")

    @group_ibmmqby_instance_name.setter
    def group_ibmmqby_instance_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_ibmmqby_instance_name", value)

    @property
    @pulumi.getter(name="identifyJbossServerBySystemProperty")
    def identify_jboss_server_by_system_property(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        """
        return pulumi.get(self, "identify_jboss_server_by_system_property")

    @identify_jboss_server_by_system_property.setter
    def identify_jboss_server_by_system_property(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "identify_jboss_server_by_system_property", value)

    @property
    @pulumi.getter(name="ignoreUniqueIdentifiers")
    def ignore_unique_identifiers(self) -> Optional[pulumi.Input[bool]]:
        """
        To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        """
        return pulumi.get(self, "ignore_unique_identifiers")

    @ignore_unique_identifiers.setter
    def ignore_unique_identifiers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unique_identifiers", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="securitySoftwareDetectionEnabled")
    def security_software_detection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag enables the detection of security software such as anti-malware protection.
        """
        return pulumi.get(self, "security_software_detection_enabled")

    @security_software_detection_enabled.setter
    def security_software_detection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_software_detection_enabled", value)

    @property
    @pulumi.getter(name="shortLivedProcessesMonitoring")
    def short_lived_processes_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        """
        return pulumi.get(self, "short_lived_processes_monitoring")

    @short_lived_processes_monitoring.setter
    def short_lived_processes_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "short_lived_processes_monitoring", value)

    @property
    @pulumi.getter(name="splitOracleDatabasePg")
    def split_oracle_database_pg(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        """
        return pulumi.get(self, "split_oracle_database_pg")

    @split_oracle_database_pg.setter
    def split_oracle_database_pg(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "split_oracle_database_pg", value)

    @property
    @pulumi.getter(name="splitOracleListenerPg")
    def split_oracle_listener_pg(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        """
        return pulumi.get(self, "split_oracle_listener_pg")

    @split_oracle_listener_pg.setter
    def split_oracle_listener_pg(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "split_oracle_listener_pg", value)

    @property
    @pulumi.getter(name="useCatalinaBase")
    def use_catalina_base(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        """
        return pulumi.get(self, "use_catalina_base")

    @use_catalina_base.setter
    def use_catalina_base(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_catalina_base", value)

    @property
    @pulumi.getter(name="useDockerContainerName")
    def use_docker_container_name(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        return pulumi.get(self, "use_docker_container_name")

    @use_docker_container_name.setter
    def use_docker_container_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_docker_container_name", value)


class ProcessGroupDetectionFlags(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_node_js_script_name: Optional[pulumi.Input[bool]] = None,
                 auto_detect_cassandra_clusters: Optional[pulumi.Input[bool]] = None,
                 auto_detect_spring_boot: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_container_edition_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_methods_integration_server: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_sphere_liberty_application: Optional[pulumi.Input[bool]] = None,
                 group_ibmmqby_instance_name: Optional[pulumi.Input[bool]] = None,
                 identify_jboss_server_by_system_property: Optional[pulumi.Input[bool]] = None,
                 ignore_unique_identifiers: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 security_software_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 short_lived_processes_monitoring: Optional[pulumi.Input[bool]] = None,
                 split_oracle_database_pg: Optional[pulumi.Input[bool]] = None,
                 split_oracle_listener_pg: Optional[pulumi.Input[bool]] = None,
                 use_catalina_base: Optional[pulumi.Input[bool]] = None,
                 use_docker_container_name: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a ProcessGroupDetectionFlags resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_node_js_script_name: In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        :param pulumi.Input[bool] auto_detect_cassandra_clusters: Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        :param pulumi.Input[bool] auto_detect_spring_boot: Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        :param pulumi.Input[bool] auto_detect_tibco_container_edition_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_tibco_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_web_methods_integration_server: Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        :param pulumi.Input[bool] auto_detect_web_sphere_liberty_application: Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        :param pulumi.Input[bool] group_ibmmqby_instance_name: Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        :param pulumi.Input[bool] identify_jboss_server_by_system_property: Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        :param pulumi.Input[bool] ignore_unique_identifiers: To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[bool] security_software_detection_enabled: This flag enables the detection of security software such as anti-malware protection.
        :param pulumi.Input[bool] short_lived_processes_monitoring: Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        :param pulumi.Input[bool] split_oracle_database_pg: Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        :param pulumi.Input[bool] split_oracle_listener_pg: Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        :param pulumi.Input[bool] use_catalina_base: By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        :param pulumi.Input[bool] use_docker_container_name: By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessGroupDetectionFlagsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProcessGroupDetectionFlags resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProcessGroupDetectionFlagsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessGroupDetectionFlagsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_node_js_script_name: Optional[pulumi.Input[bool]] = None,
                 auto_detect_cassandra_clusters: Optional[pulumi.Input[bool]] = None,
                 auto_detect_spring_boot: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_container_edition_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_tibco_engines: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_methods_integration_server: Optional[pulumi.Input[bool]] = None,
                 auto_detect_web_sphere_liberty_application: Optional[pulumi.Input[bool]] = None,
                 group_ibmmqby_instance_name: Optional[pulumi.Input[bool]] = None,
                 identify_jboss_server_by_system_property: Optional[pulumi.Input[bool]] = None,
                 ignore_unique_identifiers: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 security_software_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 short_lived_processes_monitoring: Optional[pulumi.Input[bool]] = None,
                 split_oracle_database_pg: Optional[pulumi.Input[bool]] = None,
                 split_oracle_listener_pg: Optional[pulumi.Input[bool]] = None,
                 use_catalina_base: Optional[pulumi.Input[bool]] = None,
                 use_docker_container_name: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessGroupDetectionFlagsArgs.__new__(ProcessGroupDetectionFlagsArgs)

            if add_node_js_script_name is None and not opts.urn:
                raise TypeError("Missing required property 'add_node_js_script_name'")
            __props__.__dict__["add_node_js_script_name"] = add_node_js_script_name
            if auto_detect_cassandra_clusters is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_cassandra_clusters'")
            __props__.__dict__["auto_detect_cassandra_clusters"] = auto_detect_cassandra_clusters
            if auto_detect_spring_boot is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_spring_boot'")
            __props__.__dict__["auto_detect_spring_boot"] = auto_detect_spring_boot
            if auto_detect_tibco_container_edition_engines is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_tibco_container_edition_engines'")
            __props__.__dict__["auto_detect_tibco_container_edition_engines"] = auto_detect_tibco_container_edition_engines
            if auto_detect_tibco_engines is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_tibco_engines'")
            __props__.__dict__["auto_detect_tibco_engines"] = auto_detect_tibco_engines
            if auto_detect_web_methods_integration_server is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_web_methods_integration_server'")
            __props__.__dict__["auto_detect_web_methods_integration_server"] = auto_detect_web_methods_integration_server
            if auto_detect_web_sphere_liberty_application is None and not opts.urn:
                raise TypeError("Missing required property 'auto_detect_web_sphere_liberty_application'")
            __props__.__dict__["auto_detect_web_sphere_liberty_application"] = auto_detect_web_sphere_liberty_application
            if group_ibmmqby_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_ibmmqby_instance_name'")
            __props__.__dict__["group_ibmmqby_instance_name"] = group_ibmmqby_instance_name
            if identify_jboss_server_by_system_property is None and not opts.urn:
                raise TypeError("Missing required property 'identify_jboss_server_by_system_property'")
            __props__.__dict__["identify_jboss_server_by_system_property"] = identify_jboss_server_by_system_property
            if ignore_unique_identifiers is None and not opts.urn:
                raise TypeError("Missing required property 'ignore_unique_identifiers'")
            __props__.__dict__["ignore_unique_identifiers"] = ignore_unique_identifiers
            __props__.__dict__["scope"] = scope
            __props__.__dict__["security_software_detection_enabled"] = security_software_detection_enabled
            if short_lived_processes_monitoring is None and not opts.urn:
                raise TypeError("Missing required property 'short_lived_processes_monitoring'")
            __props__.__dict__["short_lived_processes_monitoring"] = short_lived_processes_monitoring
            if split_oracle_database_pg is None and not opts.urn:
                raise TypeError("Missing required property 'split_oracle_database_pg'")
            __props__.__dict__["split_oracle_database_pg"] = split_oracle_database_pg
            if split_oracle_listener_pg is None and not opts.urn:
                raise TypeError("Missing required property 'split_oracle_listener_pg'")
            __props__.__dict__["split_oracle_listener_pg"] = split_oracle_listener_pg
            if use_catalina_base is None and not opts.urn:
                raise TypeError("Missing required property 'use_catalina_base'")
            __props__.__dict__["use_catalina_base"] = use_catalina_base
            if use_docker_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'use_docker_container_name'")
            __props__.__dict__["use_docker_container_name"] = use_docker_container_name
        super(ProcessGroupDetectionFlags, __self__).__init__(
            'dynatrace:index/processGroupDetectionFlags:ProcessGroupDetectionFlags',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_node_js_script_name: Optional[pulumi.Input[bool]] = None,
            auto_detect_cassandra_clusters: Optional[pulumi.Input[bool]] = None,
            auto_detect_spring_boot: Optional[pulumi.Input[bool]] = None,
            auto_detect_tibco_container_edition_engines: Optional[pulumi.Input[bool]] = None,
            auto_detect_tibco_engines: Optional[pulumi.Input[bool]] = None,
            auto_detect_web_methods_integration_server: Optional[pulumi.Input[bool]] = None,
            auto_detect_web_sphere_liberty_application: Optional[pulumi.Input[bool]] = None,
            group_ibmmqby_instance_name: Optional[pulumi.Input[bool]] = None,
            identify_jboss_server_by_system_property: Optional[pulumi.Input[bool]] = None,
            ignore_unique_identifiers: Optional[pulumi.Input[bool]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            security_software_detection_enabled: Optional[pulumi.Input[bool]] = None,
            short_lived_processes_monitoring: Optional[pulumi.Input[bool]] = None,
            split_oracle_database_pg: Optional[pulumi.Input[bool]] = None,
            split_oracle_listener_pg: Optional[pulumi.Input[bool]] = None,
            use_catalina_base: Optional[pulumi.Input[bool]] = None,
            use_docker_container_name: Optional[pulumi.Input[bool]] = None) -> 'ProcessGroupDetectionFlags':
        """
        Get an existing ProcessGroupDetectionFlags resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_node_js_script_name: In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        :param pulumi.Input[bool] auto_detect_cassandra_clusters: Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        :param pulumi.Input[bool] auto_detect_spring_boot: Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        :param pulumi.Input[bool] auto_detect_tibco_container_edition_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_tibco_engines: Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        :param pulumi.Input[bool] auto_detect_web_methods_integration_server: Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        :param pulumi.Input[bool] auto_detect_web_sphere_liberty_application: Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        :param pulumi.Input[bool] group_ibmmqby_instance_name: Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        :param pulumi.Input[bool] identify_jboss_server_by_system_property: Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        :param pulumi.Input[bool] ignore_unique_identifiers: To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        :param pulumi.Input[bool] security_software_detection_enabled: This flag enables the detection of security software such as anti-malware protection.
        :param pulumi.Input[bool] short_lived_processes_monitoring: Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        :param pulumi.Input[bool] split_oracle_database_pg: Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        :param pulumi.Input[bool] split_oracle_listener_pg: Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        :param pulumi.Input[bool] use_catalina_base: By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        :param pulumi.Input[bool] use_docker_container_name: By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessGroupDetectionFlagsState.__new__(_ProcessGroupDetectionFlagsState)

        __props__.__dict__["add_node_js_script_name"] = add_node_js_script_name
        __props__.__dict__["auto_detect_cassandra_clusters"] = auto_detect_cassandra_clusters
        __props__.__dict__["auto_detect_spring_boot"] = auto_detect_spring_boot
        __props__.__dict__["auto_detect_tibco_container_edition_engines"] = auto_detect_tibco_container_edition_engines
        __props__.__dict__["auto_detect_tibco_engines"] = auto_detect_tibco_engines
        __props__.__dict__["auto_detect_web_methods_integration_server"] = auto_detect_web_methods_integration_server
        __props__.__dict__["auto_detect_web_sphere_liberty_application"] = auto_detect_web_sphere_liberty_application
        __props__.__dict__["group_ibmmqby_instance_name"] = group_ibmmqby_instance_name
        __props__.__dict__["identify_jboss_server_by_system_property"] = identify_jboss_server_by_system_property
        __props__.__dict__["ignore_unique_identifiers"] = ignore_unique_identifiers
        __props__.__dict__["scope"] = scope
        __props__.__dict__["security_software_detection_enabled"] = security_software_detection_enabled
        __props__.__dict__["short_lived_processes_monitoring"] = short_lived_processes_monitoring
        __props__.__dict__["split_oracle_database_pg"] = split_oracle_database_pg
        __props__.__dict__["split_oracle_listener_pg"] = split_oracle_listener_pg
        __props__.__dict__["use_catalina_base"] = use_catalina_base
        __props__.__dict__["use_docker_container_name"] = use_docker_container_name
        return ProcessGroupDetectionFlags(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addNodeJsScriptName")
    def add_node_js_script_name(self) -> pulumi.Output[bool]:
        """
        In older versions, Node.js applications were distinguished based on their directory name, omitting the script name. Changing this setting may change the general handling of Node.js process groups. Leave unchanged if in doubt.
        """
        return pulumi.get(self, "add_node_js_script_name")

    @property
    @pulumi.getter(name="autoDetectCassandraClusters")
    def auto_detect_cassandra_clusters(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect separate Cassandra process groups based on the configured Cassandra cluster name.
        """
        return pulumi.get(self, "auto_detect_cassandra_clusters")

    @property
    @pulumi.getter(name="autoDetectSpringBoot")
    def auto_detect_spring_boot(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect Spring Boot process groups based on command line and applications' configuration files.
        """
        return pulumi.get(self, "auto_detect_spring_boot")

    @property
    @pulumi.getter(name="autoDetectTibcoContainerEditionEngines")
    def auto_detect_tibco_container_edition_engines(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_container_edition_engines")

    @property
    @pulumi.getter(name="autoDetectTibcoEngines")
    def auto_detect_tibco_engines(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect separate TIBCO BusinessWorks process groups per engine property file.
        """
        return pulumi.get(self, "auto_detect_tibco_engines")

    @property
    @pulumi.getter(name="autoDetectWebMethodsIntegrationServer")
    def auto_detect_web_methods_integration_server(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect webMethods Integration Server including specific properties like install root and product name.
        """
        return pulumi.get(self, "auto_detect_web_methods_integration_server")

    @property
    @pulumi.getter(name="autoDetectWebSphereLibertyApplication")
    def auto_detect_web_sphere_liberty_application(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect separate WebSphere Liberty process groups based on java command line.
        """
        return pulumi.get(self, "auto_detect_web_sphere_liberty_application")

    @property
    @pulumi.getter(name="groupIbmmqbyInstanceName")
    def group_ibmmqby_instance_name(self) -> pulumi.Output[bool]:
        """
        Enable to group and separately analyze the processes of each IBM MQ Queue manager instance. Each process group receives a unique name based on the queue manager instance name.
        """
        return pulumi.get(self, "group_ibmmqby_instance_name")

    @property
    @pulumi.getter(name="identifyJbossServerBySystemProperty")
    def identify_jboss_server_by_system_property(self) -> pulumi.Output[bool]:
        """
        Enabling this flag will detect the JBoss server name from the system property jboss.server.name=\\n\\n, only if -D[Server:\\n\\n] is not set.
        """
        return pulumi.get(self, "identify_jboss_server_by_system_property")

    @property
    @pulumi.getter(name="ignoreUniqueIdentifiers")
    def ignore_unique_identifiers(self) -> pulumi.Output[bool]:
        """
        To determine the unique identity of each detected process, and to generate a unique name for each detected process, Dynatrace evaluates the name of the directory that each process binary is contained within. For application containers like Tomcat and JBoss, Dynatrace evaluates important directories like CATALINA*HOME and JBOSS*HOME for this information. In some automated deployment scenarios such directory names are updated automatically with new version numbers, build numbers, dates, or GUIDs. Enable this setting to ensure that automated directory name changes don't result in Dynatrace registering pre-existing processes as new processes.
        """
        return pulumi.get(self, "ignore_unique_identifiers")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="securitySoftwareDetectionEnabled")
    def security_software_detection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        This flag enables the detection of security software such as anti-malware protection.
        """
        return pulumi.get(self, "security_software_detection_enabled")

    @property
    @pulumi.getter(name="shortLivedProcessesMonitoring")
    def short_lived_processes_monitoring(self) -> pulumi.Output[bool]:
        """
        Enable to monitor CPU and memory usage of short lived processes, otherwise being lost by traditional monitoring. Disabling this flag blocks passing data to cluster only, it does not stop data collection and has no effect on performance.
        """
        return pulumi.get(self, "short_lived_processes_monitoring")

    @property
    @pulumi.getter(name="splitOracleDatabasePg")
    def split_oracle_database_pg(self) -> pulumi.Output[bool]:
        """
        Enable to group and separately analyze the processes of each Oracle DB. Each process group receives a unique name based on the Oracle DB SID.
        """
        return pulumi.get(self, "split_oracle_database_pg")

    @property
    @pulumi.getter(name="splitOracleListenerPg")
    def split_oracle_listener_pg(self) -> pulumi.Output[bool]:
        """
        Enable to group and separately analyze the processes of each Oracle Listener. Each process group receives a unique name based on the Oracle Listener name.
        """
        return pulumi.get(self, "split_oracle_listener_pg")

    @property
    @pulumi.getter(name="useCatalinaBase")
    def use_catalina_base(self) -> pulumi.Output[bool]:
        """
        By default, Tomcat clusters are identified and named based on the CATALINA*HOME directory name. This setting results in the use of the CATALINA*BASE directory name to identify multiple Tomcat nodes within each Tomcat cluster. If this setting is not enabled, each CATALINA*HOME+CATALINA*BASE combination will be considered a separate Tomcat cluster. In other words, Tomcat clusters can't have multiple nodes on a single host.
        """
        return pulumi.get(self, "use_catalina_base")

    @property
    @pulumi.getter(name="useDockerContainerName")
    def use_docker_container_name(self) -> pulumi.Output[bool]:
        """
        By default, Dynatrace uses image names as identifiers for individual process groups, with one process-group instance per host. Normally Docker container names can't serve as stable identifiers of process group instances because they are variable and auto-generated. You can however manually assign proper container names to their Docker instances. Such manually-assigned container names can serve as reliable process-group instance identifiers. This flag instructs Dynatrace to use Docker-provided names to distinguish between multiple instances of the same image. If this flag is not applied and you run multiple containers of the same image on the same host, the resulting processes will be consolidated into a single process view. Use this flag with caution!
        """
        return pulumi.get(self, "use_docker_container_name")

