# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProcessAvailabilityArgs', 'ProcessAvailability']

@pulumi.input_type
class ProcessAvailabilityArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 insert_after: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']] = None,
                 minimum_processes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input['ProcessAvailabilityRulesArgs']] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProcessAvailability resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input['ProcessAvailabilityMetadataArgs'] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[int] minimum_processes: Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        :param pulumi.Input[str] name: Monitoring rule name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which the monitoring rule should be applied.
        :param pulumi.Input['ProcessAvailabilityRulesArgs'] rules: Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
               detection rules associated with it.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if minimum_processes is not None:
            pulumi.set(__self__, "minimum_processes", minimum_processes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_systems is not None:
            pulumi.set(__self__, "operating_systems", operating_systems)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minimumProcesses")
    def minimum_processes(self) -> Optional[pulumi.Input[int]]:
        """
        Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        """
        return pulumi.get(self, "minimum_processes")

    @minimum_processes.setter
    def minimum_processes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_processes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitoring rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Select the operating systems on which the monitoring rule should be applied.
        """
        return pulumi.get(self, "operating_systems")

    @operating_systems.setter
    def operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "operating_systems", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['ProcessAvailabilityRulesArgs']]:
        """
        Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
        detection rules associated with it.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['ProcessAvailabilityRulesArgs']]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ProcessAvailabilityState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']] = None,
                 minimum_processes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input['ProcessAvailabilityRulesArgs']] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProcessAvailability resources.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input['ProcessAvailabilityMetadataArgs'] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[int] minimum_processes: Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        :param pulumi.Input[str] name: Monitoring rule name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which the monitoring rule should be applied.
        :param pulumi.Input['ProcessAvailabilityRulesArgs'] rules: Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
               detection rules associated with it.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if minimum_processes is not None:
            pulumi.set(__self__, "minimum_processes", minimum_processes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_systems is not None:
            pulumi.set(__self__, "operating_systems", operating_systems)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ProcessAvailabilityMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="minimumProcesses")
    def minimum_processes(self) -> Optional[pulumi.Input[int]]:
        """
        Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        """
        return pulumi.get(self, "minimum_processes")

    @minimum_processes.setter
    def minimum_processes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_processes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitoring rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Select the operating systems on which the monitoring rule should be applied.
        """
        return pulumi.get(self, "operating_systems")

    @operating_systems.setter
    def operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "operating_systems", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['ProcessAvailabilityRulesArgs']]:
        """
        Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
        detection rules associated with it.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['ProcessAvailabilityRulesArgs']]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class ProcessAvailability(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Union['ProcessAvailabilityMetadataArgs', 'ProcessAvailabilityMetadataArgsDict']]] = None,
                 minimum_processes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Union['ProcessAvailabilityRulesArgs', 'ProcessAvailabilityRulesArgsDict']]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ProcessAvailability resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[Union['ProcessAvailabilityMetadataArgs', 'ProcessAvailabilityMetadataArgsDict']] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[int] minimum_processes: Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        :param pulumi.Input[str] name: Monitoring rule name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which the monitoring rule should be applied.
        :param pulumi.Input[Union['ProcessAvailabilityRulesArgs', 'ProcessAvailabilityRulesArgsDict']] rules: Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
               detection rules associated with it.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessAvailabilityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ProcessAvailability resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProcessAvailabilityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessAvailabilityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Union['ProcessAvailabilityMetadataArgs', 'ProcessAvailabilityMetadataArgsDict']]] = None,
                 minimum_processes: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Union['ProcessAvailabilityRulesArgs', 'ProcessAvailabilityRulesArgsDict']]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessAvailabilityArgs.__new__(ProcessAvailabilityArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["minimum_processes"] = minimum_processes
            __props__.__dict__["name"] = name
            __props__.__dict__["operating_systems"] = operating_systems
            __props__.__dict__["rules"] = rules
            __props__.__dict__["scope"] = scope
        super(ProcessAvailability, __self__).__init__(
            'dynatrace:index/processAvailability:ProcessAvailability',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            insert_after: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Union['ProcessAvailabilityMetadataArgs', 'ProcessAvailabilityMetadataArgsDict']]] = None,
            minimum_processes: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rules: Optional[pulumi.Input[Union['ProcessAvailabilityRulesArgs', 'ProcessAvailabilityRulesArgsDict']]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'ProcessAvailability':
        """
        Get an existing ProcessAvailability resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
               instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
               specified during update the order will remain untouched
        :param pulumi.Input[Union['ProcessAvailabilityMetadataArgs', 'ProcessAvailabilityMetadataArgsDict']] metadata: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[int] minimum_processes: Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        :param pulumi.Input[str] name: Monitoring rule name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which the monitoring rule should be applied.
        :param pulumi.Input[Union['ProcessAvailabilityRulesArgs', 'ProcessAvailabilityRulesArgsDict']] rules: Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
               detection rules associated with it.
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessAvailabilityState.__new__(_ProcessAvailabilityState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["minimum_processes"] = minimum_processes
        __props__.__dict__["name"] = name
        __props__.__dict__["operating_systems"] = operating_systems
        __props__.__dict__["rules"] = rules
        __props__.__dict__["scope"] = scope
        return ProcessAvailability(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this
        instance regarding order. If not specified when creating the setting will be added to the end of the list. If not
        specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.ProcessAvailabilityMetadata']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minimumProcesses")
    def minimum_processes(self) -> pulumi.Output[Optional[int]]:
        """
        Specify a minimum number of processes matching the monitoring rule. If it's not satisfied, an alert will open.
        """
        return pulumi.get(self, "minimum_processes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Monitoring rule name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Select the operating systems on which the monitoring rule should be applied.
        """
        return pulumi.get(self, "operating_systems")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional['outputs.ProcessAvailabilityRules']]:
        """
        Define process detection rules by selecting a process property and a condition. Each monitoring rule can have multiple
        detection rules associated with it.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

