# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OneagentSideMaskingArgs', 'OneagentSideMasking']

@pulumi.input_type
class OneagentSideMaskingArgs:
    def __init__(__self__, *,
                 is_email_masking_enabled: pulumi.Input[bool],
                 is_financial_masking_enabled: pulumi.Input[bool],
                 is_numbers_masking_enabled: pulumi.Input[bool],
                 is_query_masking_enabled: pulumi.Input[bool],
                 process_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OneagentSideMasking resource.
        :param pulumi.Input[bool] is_email_masking_enabled: Exclude email addresses from URLs
        :param pulumi.Input[bool] is_financial_masking_enabled: Exclude IBANs and payment card numbers from URLs
        :param pulumi.Input[bool] is_numbers_masking_enabled: Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        :param pulumi.Input[bool] is_query_masking_enabled: Exclude query parameters from URLs and web requests
        :param pulumi.Input[str] process_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        pulumi.set(__self__, "is_email_masking_enabled", is_email_masking_enabled)
        pulumi.set(__self__, "is_financial_masking_enabled", is_financial_masking_enabled)
        pulumi.set(__self__, "is_numbers_masking_enabled", is_numbers_masking_enabled)
        pulumi.set(__self__, "is_query_masking_enabled", is_query_masking_enabled)
        if process_group_id is not None:
            pulumi.set(__self__, "process_group_id", process_group_id)

    @property
    @pulumi.getter(name="isEmailMaskingEnabled")
    def is_email_masking_enabled(self) -> pulumi.Input[bool]:
        """
        Exclude email addresses from URLs
        """
        return pulumi.get(self, "is_email_masking_enabled")

    @is_email_masking_enabled.setter
    def is_email_masking_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_email_masking_enabled", value)

    @property
    @pulumi.getter(name="isFinancialMaskingEnabled")
    def is_financial_masking_enabled(self) -> pulumi.Input[bool]:
        """
        Exclude IBANs and payment card numbers from URLs
        """
        return pulumi.get(self, "is_financial_masking_enabled")

    @is_financial_masking_enabled.setter
    def is_financial_masking_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_financial_masking_enabled", value)

    @property
    @pulumi.getter(name="isNumbersMaskingEnabled")
    def is_numbers_masking_enabled(self) -> pulumi.Input[bool]:
        """
        Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        """
        return pulumi.get(self, "is_numbers_masking_enabled")

    @is_numbers_masking_enabled.setter
    def is_numbers_masking_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_numbers_masking_enabled", value)

    @property
    @pulumi.getter(name="isQueryMaskingEnabled")
    def is_query_masking_enabled(self) -> pulumi.Input[bool]:
        """
        Exclude query parameters from URLs and web requests
        """
        return pulumi.get(self, "is_query_masking_enabled")

    @is_query_masking_enabled.setter
    def is_query_masking_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_query_masking_enabled", value)

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "process_group_id")

    @process_group_id.setter
    def process_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "process_group_id", value)


@pulumi.input_type
class _OneagentSideMaskingState:
    def __init__(__self__, *,
                 is_email_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_financial_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_numbers_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_query_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 process_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OneagentSideMasking resources.
        :param pulumi.Input[bool] is_email_masking_enabled: Exclude email addresses from URLs
        :param pulumi.Input[bool] is_financial_masking_enabled: Exclude IBANs and payment card numbers from URLs
        :param pulumi.Input[bool] is_numbers_masking_enabled: Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        :param pulumi.Input[bool] is_query_masking_enabled: Exclude query parameters from URLs and web requests
        :param pulumi.Input[str] process_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        if is_email_masking_enabled is not None:
            pulumi.set(__self__, "is_email_masking_enabled", is_email_masking_enabled)
        if is_financial_masking_enabled is not None:
            pulumi.set(__self__, "is_financial_masking_enabled", is_financial_masking_enabled)
        if is_numbers_masking_enabled is not None:
            pulumi.set(__self__, "is_numbers_masking_enabled", is_numbers_masking_enabled)
        if is_query_masking_enabled is not None:
            pulumi.set(__self__, "is_query_masking_enabled", is_query_masking_enabled)
        if process_group_id is not None:
            pulumi.set(__self__, "process_group_id", process_group_id)

    @property
    @pulumi.getter(name="isEmailMaskingEnabled")
    def is_email_masking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Exclude email addresses from URLs
        """
        return pulumi.get(self, "is_email_masking_enabled")

    @is_email_masking_enabled.setter
    def is_email_masking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_email_masking_enabled", value)

    @property
    @pulumi.getter(name="isFinancialMaskingEnabled")
    def is_financial_masking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Exclude IBANs and payment card numbers from URLs
        """
        return pulumi.get(self, "is_financial_masking_enabled")

    @is_financial_masking_enabled.setter
    def is_financial_masking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_financial_masking_enabled", value)

    @property
    @pulumi.getter(name="isNumbersMaskingEnabled")
    def is_numbers_masking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        """
        return pulumi.get(self, "is_numbers_masking_enabled")

    @is_numbers_masking_enabled.setter
    def is_numbers_masking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_numbers_masking_enabled", value)

    @property
    @pulumi.getter(name="isQueryMaskingEnabled")
    def is_query_masking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Exclude query parameters from URLs and web requests
        """
        return pulumi.get(self, "is_query_masking_enabled")

    @is_query_masking_enabled.setter
    def is_query_masking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_query_masking_enabled", value)

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "process_group_id")

    @process_group_id.setter
    def process_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "process_group_id", value)


class OneagentSideMasking(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_email_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_financial_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_numbers_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_query_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 process_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a OneagentSideMasking resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_email_masking_enabled: Exclude email addresses from URLs
        :param pulumi.Input[bool] is_financial_masking_enabled: Exclude IBANs and payment card numbers from URLs
        :param pulumi.Input[bool] is_numbers_masking_enabled: Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        :param pulumi.Input[bool] is_query_masking_enabled: Exclude query parameters from URLs and web requests
        :param pulumi.Input[str] process_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OneagentSideMaskingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OneagentSideMasking resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OneagentSideMaskingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OneagentSideMaskingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_email_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_financial_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_numbers_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 is_query_masking_enabled: Optional[pulumi.Input[bool]] = None,
                 process_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OneagentSideMaskingArgs.__new__(OneagentSideMaskingArgs)

            if is_email_masking_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_email_masking_enabled'")
            __props__.__dict__["is_email_masking_enabled"] = is_email_masking_enabled
            if is_financial_masking_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_financial_masking_enabled'")
            __props__.__dict__["is_financial_masking_enabled"] = is_financial_masking_enabled
            if is_numbers_masking_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_numbers_masking_enabled'")
            __props__.__dict__["is_numbers_masking_enabled"] = is_numbers_masking_enabled
            if is_query_masking_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_query_masking_enabled'")
            __props__.__dict__["is_query_masking_enabled"] = is_query_masking_enabled
            __props__.__dict__["process_group_id"] = process_group_id
        super(OneagentSideMasking, __self__).__init__(
            'dynatrace:index/oneagentSideMasking:OneagentSideMasking',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_email_masking_enabled: Optional[pulumi.Input[bool]] = None,
            is_financial_masking_enabled: Optional[pulumi.Input[bool]] = None,
            is_numbers_masking_enabled: Optional[pulumi.Input[bool]] = None,
            is_query_masking_enabled: Optional[pulumi.Input[bool]] = None,
            process_group_id: Optional[pulumi.Input[str]] = None) -> 'OneagentSideMasking':
        """
        Get an existing OneagentSideMasking resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_email_masking_enabled: Exclude email addresses from URLs
        :param pulumi.Input[bool] is_financial_masking_enabled: Exclude IBANs and payment card numbers from URLs
        :param pulumi.Input[bool] is_numbers_masking_enabled: Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        :param pulumi.Input[bool] is_query_masking_enabled: Exclude query parameters from URLs and web requests
        :param pulumi.Input[str] process_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OneagentSideMaskingState.__new__(_OneagentSideMaskingState)

        __props__.__dict__["is_email_masking_enabled"] = is_email_masking_enabled
        __props__.__dict__["is_financial_masking_enabled"] = is_financial_masking_enabled
        __props__.__dict__["is_numbers_masking_enabled"] = is_numbers_masking_enabled
        __props__.__dict__["is_query_masking_enabled"] = is_query_masking_enabled
        __props__.__dict__["process_group_id"] = process_group_id
        return OneagentSideMasking(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isEmailMaskingEnabled")
    def is_email_masking_enabled(self) -> pulumi.Output[bool]:
        """
        Exclude email addresses from URLs
        """
        return pulumi.get(self, "is_email_masking_enabled")

    @property
    @pulumi.getter(name="isFinancialMaskingEnabled")
    def is_financial_masking_enabled(self) -> pulumi.Output[bool]:
        """
        Exclude IBANs and payment card numbers from URLs
        """
        return pulumi.get(self, "is_financial_masking_enabled")

    @property
    @pulumi.getter(name="isNumbersMaskingEnabled")
    def is_numbers_masking_enabled(self) -> pulumi.Output[bool]:
        """
        Exclude hexadecimal IDs and consecutive numbers above 5 digits from URLs
        """
        return pulumi.get(self, "is_numbers_masking_enabled")

    @property
    @pulumi.getter(name="isQueryMaskingEnabled")
    def is_query_masking_enabled(self) -> pulumi.Output[bool]:
        """
        Exclude query parameters from URLs and web requests
        """
        return pulumi.get(self, "is_query_masking_enabled")

    @property
    @pulumi.getter(name="processGroupId")
    def process_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "process_group_id")

