# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkMonitorArgs', 'NetworkMonitor']

@pulumi.input_type
class NetworkMonitorArgs:
    def __init__(__self__, *,
                 locations: pulumi.Input[Sequence[pulumi.Input[str]]],
                 steps: pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency_min: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outage_handling: Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']] = None,
                 performance_thresholds: Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkMonitor resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations to which the monitor is assigned
        :param pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]] steps: The steps of the monitor
        :param pulumi.Input[str] type: Type of the monitor, possible values: `MULTI_PROTOCOL`
        :param pulumi.Input[str] description: Description of the monitor
        :param pulumi.Input[bool] enabled: If true, the monitor is enabled
        :param pulumi.Input[int] frequency_min: Frequency of the monitor, in minutes
        :param pulumi.Input[str] name: Name of the monitor
        :param pulumi.Input['NetworkMonitorOutageHandlingArgs'] outage_handling: Outage handling configuration
        :param pulumi.Input['NetworkMonitorPerformanceThresholdsArgs'] performance_thresholds: Performance thresholds configuration
        :param pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]] tags: A set of tags assigned to the monitor.
        """
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency_min is not None:
            pulumi.set(__self__, "frequency_min", frequency_min)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outage_handling is not None:
            pulumi.set(__self__, "outage_handling", outage_handling)
        if performance_thresholds is not None:
            pulumi.set(__self__, "performance_thresholds", performance_thresholds)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The locations to which the monitor is assigned
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]]:
        """
        The steps of the monitor
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the monitor
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the monitor is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="frequencyMin")
    def frequency_min(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of the monitor, in minutes
        """
        return pulumi.get(self, "frequency_min")

    @frequency_min.setter
    def frequency_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency_min", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the monitor
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outageHandling")
    def outage_handling(self) -> Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']]:
        """
        Outage handling configuration
        """
        return pulumi.get(self, "outage_handling")

    @outage_handling.setter
    def outage_handling(self, value: Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']]):
        pulumi.set(self, "outage_handling", value)

    @property
    @pulumi.getter(name="performanceThresholds")
    def performance_thresholds(self) -> Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']]:
        """
        Performance thresholds configuration
        """
        return pulumi.get(self, "performance_thresholds")

    @performance_thresholds.setter
    def performance_thresholds(self, value: Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']]):
        pulumi.set(self, "performance_thresholds", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkMonitorState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency_min: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outage_handling: Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']] = None,
                 performance_thresholds: Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkMonitor resources.
        :param pulumi.Input[str] description: Description of the monitor
        :param pulumi.Input[bool] enabled: If true, the monitor is enabled
        :param pulumi.Input[int] frequency_min: Frequency of the monitor, in minutes
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations to which the monitor is assigned
        :param pulumi.Input[str] name: Name of the monitor
        :param pulumi.Input['NetworkMonitorOutageHandlingArgs'] outage_handling: Outage handling configuration
        :param pulumi.Input['NetworkMonitorPerformanceThresholdsArgs'] performance_thresholds: Performance thresholds configuration
        :param pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]] steps: The steps of the monitor
        :param pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]] tags: A set of tags assigned to the monitor.
        :param pulumi.Input[str] type: Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency_min is not None:
            pulumi.set(__self__, "frequency_min", frequency_min)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outage_handling is not None:
            pulumi.set(__self__, "outage_handling", outage_handling)
        if performance_thresholds is not None:
            pulumi.set(__self__, "performance_thresholds", performance_thresholds)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the monitor
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the monitor is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="frequencyMin")
    def frequency_min(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of the monitor, in minutes
        """
        return pulumi.get(self, "frequency_min")

    @frequency_min.setter
    def frequency_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency_min", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The locations to which the monitor is assigned
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the monitor
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outageHandling")
    def outage_handling(self) -> Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']]:
        """
        Outage handling configuration
        """
        return pulumi.get(self, "outage_handling")

    @outage_handling.setter
    def outage_handling(self, value: Optional[pulumi.Input['NetworkMonitorOutageHandlingArgs']]):
        pulumi.set(self, "outage_handling", value)

    @property
    @pulumi.getter(name="performanceThresholds")
    def performance_thresholds(self) -> Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']]:
        """
        Performance thresholds configuration
        """
        return pulumi.get(self, "performance_thresholds")

    @performance_thresholds.setter
    def performance_thresholds(self, value: Optional[pulumi.Input['NetworkMonitorPerformanceThresholdsArgs']]):
        pulumi.set(self, "performance_thresholds", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]]]:
        """
        The steps of the monitor
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class NetworkMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency_min: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outage_handling: Optional[pulumi.Input[Union['NetworkMonitorOutageHandlingArgs', 'NetworkMonitorOutageHandlingArgsDict']]] = None,
                 performance_thresholds: Optional[pulumi.Input[Union['NetworkMonitorPerformanceThresholdsArgs', 'NetworkMonitorPerformanceThresholdsArgsDict']]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorStepArgs', 'NetworkMonitorStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorTagArgs', 'NetworkMonitorTagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a NetworkMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the monitor
        :param pulumi.Input[bool] enabled: If true, the monitor is enabled
        :param pulumi.Input[int] frequency_min: Frequency of the monitor, in minutes
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations to which the monitor is assigned
        :param pulumi.Input[str] name: Name of the monitor
        :param pulumi.Input[Union['NetworkMonitorOutageHandlingArgs', 'NetworkMonitorOutageHandlingArgsDict']] outage_handling: Outage handling configuration
        :param pulumi.Input[Union['NetworkMonitorPerformanceThresholdsArgs', 'NetworkMonitorPerformanceThresholdsArgsDict']] performance_thresholds: Performance thresholds configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorStepArgs', 'NetworkMonitorStepArgsDict']]]] steps: The steps of the monitor
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorTagArgs', 'NetworkMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor.
        :param pulumi.Input[str] type: Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency_min: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outage_handling: Optional[pulumi.Input[Union['NetworkMonitorOutageHandlingArgs', 'NetworkMonitorOutageHandlingArgsDict']]] = None,
                 performance_thresholds: Optional[pulumi.Input[Union['NetworkMonitorPerformanceThresholdsArgs', 'NetworkMonitorPerformanceThresholdsArgsDict']]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorStepArgs', 'NetworkMonitorStepArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorTagArgs', 'NetworkMonitorTagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkMonitorArgs.__new__(NetworkMonitorArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["frequency_min"] = frequency_min
            if locations is None and not opts.urn:
                raise TypeError("Missing required property 'locations'")
            __props__.__dict__["locations"] = locations
            __props__.__dict__["name"] = name
            __props__.__dict__["outage_handling"] = outage_handling
            __props__.__dict__["performance_thresholds"] = performance_thresholds
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(NetworkMonitor, __self__).__init__(
            'dynatrace:index/networkMonitor:NetworkMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            frequency_min: Optional[pulumi.Input[int]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outage_handling: Optional[pulumi.Input[Union['NetworkMonitorOutageHandlingArgs', 'NetworkMonitorOutageHandlingArgsDict']]] = None,
            performance_thresholds: Optional[pulumi.Input[Union['NetworkMonitorPerformanceThresholdsArgs', 'NetworkMonitorPerformanceThresholdsArgsDict']]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorStepArgs', 'NetworkMonitorStepArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorTagArgs', 'NetworkMonitorTagArgsDict']]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'NetworkMonitor':
        """
        Get an existing NetworkMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the monitor
        :param pulumi.Input[bool] enabled: If true, the monitor is enabled
        :param pulumi.Input[int] frequency_min: Frequency of the monitor, in minutes
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The locations to which the monitor is assigned
        :param pulumi.Input[str] name: Name of the monitor
        :param pulumi.Input[Union['NetworkMonitorOutageHandlingArgs', 'NetworkMonitorOutageHandlingArgsDict']] outage_handling: Outage handling configuration
        :param pulumi.Input[Union['NetworkMonitorPerformanceThresholdsArgs', 'NetworkMonitorPerformanceThresholdsArgsDict']] performance_thresholds: Performance thresholds configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorStepArgs', 'NetworkMonitorStepArgsDict']]]] steps: The steps of the monitor
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkMonitorTagArgs', 'NetworkMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor.
        :param pulumi.Input[str] type: Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkMonitorState.__new__(_NetworkMonitorState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency_min"] = frequency_min
        __props__.__dict__["locations"] = locations
        __props__.__dict__["name"] = name
        __props__.__dict__["outage_handling"] = outage_handling
        __props__.__dict__["performance_thresholds"] = performance_thresholds
        __props__.__dict__["steps"] = steps
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return NetworkMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the monitor
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the monitor is enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="frequencyMin")
    def frequency_min(self) -> pulumi.Output[Optional[int]]:
        """
        Frequency of the monitor, in minutes
        """
        return pulumi.get(self, "frequency_min")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence[str]]:
        """
        The locations to which the monitor is assigned
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the monitor
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outageHandling")
    def outage_handling(self) -> pulumi.Output[Optional['outputs.NetworkMonitorOutageHandling']]:
        """
        Outage handling configuration
        """
        return pulumi.get(self, "outage_handling")

    @property
    @pulumi.getter(name="performanceThresholds")
    def performance_thresholds(self) -> pulumi.Output[Optional['outputs.NetworkMonitorPerformanceThresholds']]:
        """
        Performance thresholds configuration
        """
        return pulumi.get(self, "performance_thresholds")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.NetworkMonitorStep']]:
        """
        The steps of the monitor
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkMonitorTag']]]:
        """
        A set of tags assigned to the monitor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the monitor, possible values: `MULTI_PROTOCOL`
        """
        return pulumi.get(self, "type")

