# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MobileApplicationArgs', 'MobileApplication']

@pulumi.input_type
class MobileApplicationArgs:
    def __init__(__self__, *,
                 apdex: pulumi.Input['MobileApplicationApdexArgs'],
                 beacon_endpoint_type: pulumi.Input[str],
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_url: Optional[pulumi.Input[str]] = None,
                 icon_type: Optional[pulumi.Input[str]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['MobileApplicationPropertiesArgs']] = None,
                 session_replay: Optional[pulumi.Input[bool]] = None,
                 session_replay_on_crash: Optional[pulumi.Input[bool]] = None,
                 user_session_percentage: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a MobileApplication resource.
        :param pulumi.Input['MobileApplicationApdexArgs'] apdex: Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        :param pulumi.Input[str] beacon_endpoint_type: The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        :param pulumi.Input[str] application_id: The UUID of the application.
        :param pulumi.Input[str] application_type: The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        :param pulumi.Input[str] beacon_endpoint_url: The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
               `INSTRUMENTED_WEB_SERVER`
        :param pulumi.Input[str] icon_type: Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[bool] opt_in_mode: The opt-in mode is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['MobileApplicationPropertiesArgs'] properties: User Action and Session Properties
        :param pulumi.Input[bool] session_replay: (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[bool] session_replay_on_crash: The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
               and **optInModeEnabled** values set to `true`.
        :param pulumi.Input[int] user_session_percentage: (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
               user sessions to be analyzed
        """
        pulumi.set(__self__, "apdex", apdex)
        pulumi.set(__self__, "beacon_endpoint_type", beacon_endpoint_type)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if beacon_endpoint_url is not None:
            pulumi.set(__self__, "beacon_endpoint_url", beacon_endpoint_url)
        if icon_type is not None:
            pulumi.set(__self__, "icon_type", icon_type)
        if key_user_actions is not None:
            pulumi.set(__self__, "key_user_actions", key_user_actions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opt_in_mode is not None:
            pulumi.set(__self__, "opt_in_mode", opt_in_mode)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if session_replay is not None:
            pulumi.set(__self__, "session_replay", session_replay)
        if session_replay_on_crash is not None:
            pulumi.set(__self__, "session_replay_on_crash", session_replay_on_crash)
        if user_session_percentage is not None:
            pulumi.set(__self__, "user_session_percentage", user_session_percentage)

    @property
    @pulumi.getter
    def apdex(self) -> pulumi.Input['MobileApplicationApdexArgs']:
        """
        Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        """
        return pulumi.get(self, "apdex")

    @apdex.setter
    def apdex(self, value: pulumi.Input['MobileApplicationApdexArgs']):
        pulumi.set(self, "apdex", value)

    @property
    @pulumi.getter(name="beaconEndpointType")
    def beacon_endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        """
        return pulumi.get(self, "beacon_endpoint_type")

    @beacon_endpoint_type.setter
    def beacon_endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "beacon_endpoint_type", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="beaconEndpointUrl")
    def beacon_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
        `INSTRUMENTED_WEB_SERVER`
        """
        return pulumi.get(self, "beacon_endpoint_url")

    @beacon_endpoint_url.setter
    def beacon_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beacon_endpoint_url", value)

    @property
    @pulumi.getter(name="iconType")
    def icon_type(self) -> Optional[pulumi.Input[str]]:
        """
        Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        """
        return pulumi.get(self, "icon_type")

    @icon_type.setter
    def icon_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_type", value)

    @property
    @pulumi.getter(name="keyUserActions")
    def key_user_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @key_user_actions.setter
    def key_user_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_user_actions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optInMode")
    def opt_in_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        The opt-in mode is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "opt_in_mode")

    @opt_in_mode.setter
    def opt_in_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "opt_in_mode", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MobileApplicationPropertiesArgs']]:
        """
        User Action and Session Properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MobileApplicationPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> Optional[pulumi.Input[bool]]:
        """
        (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "session_replay")

    @session_replay.setter
    def session_replay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_replay", value)

    @property
    @pulumi.getter(name="sessionReplayOnCrash")
    def session_replay_on_crash(self) -> Optional[pulumi.Input[bool]]:
        """
        The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
        and **optInModeEnabled** values set to `true`.
        """
        return pulumi.get(self, "session_replay_on_crash")

    @session_replay_on_crash.setter
    def session_replay_on_crash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_replay_on_crash", value)

    @property
    @pulumi.getter(name="userSessionPercentage")
    def user_session_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
        user sessions to be analyzed
        """
        return pulumi.get(self, "user_session_percentage")

    @user_session_percentage.setter
    def user_session_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_session_percentage", value)


@pulumi.input_type
class _MobileApplicationState:
    def __init__(__self__, *,
                 apdex: Optional[pulumi.Input['MobileApplicationApdexArgs']] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_url: Optional[pulumi.Input[str]] = None,
                 icon_type: Optional[pulumi.Input[str]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['MobileApplicationPropertiesArgs']] = None,
                 session_replay: Optional[pulumi.Input[bool]] = None,
                 session_replay_on_crash: Optional[pulumi.Input[bool]] = None,
                 user_session_percentage: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering MobileApplication resources.
        :param pulumi.Input['MobileApplicationApdexArgs'] apdex: Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        :param pulumi.Input[str] application_id: The UUID of the application.
        :param pulumi.Input[str] application_type: The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        :param pulumi.Input[str] beacon_endpoint_type: The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        :param pulumi.Input[str] beacon_endpoint_url: The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
               `INSTRUMENTED_WEB_SERVER`
        :param pulumi.Input[str] icon_type: Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[bool] opt_in_mode: The opt-in mode is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['MobileApplicationPropertiesArgs'] properties: User Action and Session Properties
        :param pulumi.Input[bool] session_replay: (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[bool] session_replay_on_crash: The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
               and **optInModeEnabled** values set to `true`.
        :param pulumi.Input[int] user_session_percentage: (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
               user sessions to be analyzed
        """
        if apdex is not None:
            pulumi.set(__self__, "apdex", apdex)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if beacon_endpoint_type is not None:
            pulumi.set(__self__, "beacon_endpoint_type", beacon_endpoint_type)
        if beacon_endpoint_url is not None:
            pulumi.set(__self__, "beacon_endpoint_url", beacon_endpoint_url)
        if icon_type is not None:
            pulumi.set(__self__, "icon_type", icon_type)
        if key_user_actions is not None:
            pulumi.set(__self__, "key_user_actions", key_user_actions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opt_in_mode is not None:
            pulumi.set(__self__, "opt_in_mode", opt_in_mode)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if session_replay is not None:
            pulumi.set(__self__, "session_replay", session_replay)
        if session_replay_on_crash is not None:
            pulumi.set(__self__, "session_replay_on_crash", session_replay_on_crash)
        if user_session_percentage is not None:
            pulumi.set(__self__, "user_session_percentage", user_session_percentage)

    @property
    @pulumi.getter
    def apdex(self) -> Optional[pulumi.Input['MobileApplicationApdexArgs']]:
        """
        Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        """
        return pulumi.get(self, "apdex")

    @apdex.setter
    def apdex(self, value: Optional[pulumi.Input['MobileApplicationApdexArgs']]):
        pulumi.set(self, "apdex", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="beaconEndpointType")
    def beacon_endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        """
        return pulumi.get(self, "beacon_endpoint_type")

    @beacon_endpoint_type.setter
    def beacon_endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beacon_endpoint_type", value)

    @property
    @pulumi.getter(name="beaconEndpointUrl")
    def beacon_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
        `INSTRUMENTED_WEB_SERVER`
        """
        return pulumi.get(self, "beacon_endpoint_url")

    @beacon_endpoint_url.setter
    def beacon_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beacon_endpoint_url", value)

    @property
    @pulumi.getter(name="iconType")
    def icon_type(self) -> Optional[pulumi.Input[str]]:
        """
        Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        """
        return pulumi.get(self, "icon_type")

    @icon_type.setter
    def icon_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_type", value)

    @property
    @pulumi.getter(name="keyUserActions")
    def key_user_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @key_user_actions.setter
    def key_user_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_user_actions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optInMode")
    def opt_in_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        The opt-in mode is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "opt_in_mode")

    @opt_in_mode.setter
    def opt_in_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "opt_in_mode", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MobileApplicationPropertiesArgs']]:
        """
        User Action and Session Properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MobileApplicationPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> Optional[pulumi.Input[bool]]:
        """
        (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "session_replay")

    @session_replay.setter
    def session_replay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_replay", value)

    @property
    @pulumi.getter(name="sessionReplayOnCrash")
    def session_replay_on_crash(self) -> Optional[pulumi.Input[bool]]:
        """
        The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
        and **optInModeEnabled** values set to `true`.
        """
        return pulumi.get(self, "session_replay_on_crash")

    @session_replay_on_crash.setter
    def session_replay_on_crash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_replay_on_crash", value)

    @property
    @pulumi.getter(name="userSessionPercentage")
    def user_session_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
        user sessions to be analyzed
        """
        return pulumi.get(self, "user_session_percentage")

    @user_session_percentage.setter
    def user_session_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_session_percentage", value)


class MobileApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apdex: Optional[pulumi.Input[Union['MobileApplicationApdexArgs', 'MobileApplicationApdexArgsDict']]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_url: Optional[pulumi.Input[str]] = None,
                 icon_type: Optional[pulumi.Input[str]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Union['MobileApplicationPropertiesArgs', 'MobileApplicationPropertiesArgsDict']]] = None,
                 session_replay: Optional[pulumi.Input[bool]] = None,
                 session_replay_on_crash: Optional[pulumi.Input[bool]] = None,
                 user_session_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a MobileApplication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MobileApplicationApdexArgs', 'MobileApplicationApdexArgsDict']] apdex: Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        :param pulumi.Input[str] application_id: The UUID of the application.
        :param pulumi.Input[str] application_type: The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        :param pulumi.Input[str] beacon_endpoint_type: The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        :param pulumi.Input[str] beacon_endpoint_url: The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
               `INSTRUMENTED_WEB_SERVER`
        :param pulumi.Input[str] icon_type: Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[bool] opt_in_mode: The opt-in mode is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['MobileApplicationPropertiesArgs', 'MobileApplicationPropertiesArgsDict']] properties: User Action and Session Properties
        :param pulumi.Input[bool] session_replay: (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[bool] session_replay_on_crash: The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
               and **optInModeEnabled** values set to `true`.
        :param pulumi.Input[int] user_session_percentage: (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
               user sessions to be analyzed
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MobileApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MobileApplication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MobileApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MobileApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apdex: Optional[pulumi.Input[Union['MobileApplicationApdexArgs', 'MobileApplicationApdexArgsDict']]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_type: Optional[pulumi.Input[str]] = None,
                 beacon_endpoint_url: Optional[pulumi.Input[str]] = None,
                 icon_type: Optional[pulumi.Input[str]] = None,
                 key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opt_in_mode: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Union['MobileApplicationPropertiesArgs', 'MobileApplicationPropertiesArgsDict']]] = None,
                 session_replay: Optional[pulumi.Input[bool]] = None,
                 session_replay_on_crash: Optional[pulumi.Input[bool]] = None,
                 user_session_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MobileApplicationArgs.__new__(MobileApplicationArgs)

            if apdex is None and not opts.urn:
                raise TypeError("Missing required property 'apdex'")
            __props__.__dict__["apdex"] = apdex
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["application_type"] = application_type
            if beacon_endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'beacon_endpoint_type'")
            __props__.__dict__["beacon_endpoint_type"] = beacon_endpoint_type
            __props__.__dict__["beacon_endpoint_url"] = beacon_endpoint_url
            __props__.__dict__["icon_type"] = icon_type
            __props__.__dict__["key_user_actions"] = key_user_actions
            __props__.__dict__["name"] = name
            __props__.__dict__["opt_in_mode"] = opt_in_mode
            __props__.__dict__["properties"] = properties
            __props__.__dict__["session_replay"] = session_replay
            __props__.__dict__["session_replay_on_crash"] = session_replay_on_crash
            __props__.__dict__["user_session_percentage"] = user_session_percentage
        super(MobileApplication, __self__).__init__(
            'dynatrace:index/mobileApplication:MobileApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apdex: Optional[pulumi.Input[Union['MobileApplicationApdexArgs', 'MobileApplicationApdexArgsDict']]] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            application_type: Optional[pulumi.Input[str]] = None,
            beacon_endpoint_type: Optional[pulumi.Input[str]] = None,
            beacon_endpoint_url: Optional[pulumi.Input[str]] = None,
            icon_type: Optional[pulumi.Input[str]] = None,
            key_user_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            opt_in_mode: Optional[pulumi.Input[bool]] = None,
            properties: Optional[pulumi.Input[Union['MobileApplicationPropertiesArgs', 'MobileApplicationPropertiesArgsDict']]] = None,
            session_replay: Optional[pulumi.Input[bool]] = None,
            session_replay_on_crash: Optional[pulumi.Input[bool]] = None,
            user_session_percentage: Optional[pulumi.Input[int]] = None) -> 'MobileApplication':
        """
        Get an existing MobileApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MobileApplicationApdexArgs', 'MobileApplicationApdexArgsDict']] apdex: Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        :param pulumi.Input[str] application_id: The UUID of the application.
        :param pulumi.Input[str] application_type: The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        :param pulumi.Input[str] beacon_endpoint_type: The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        :param pulumi.Input[str] beacon_endpoint_url: The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
               `INSTRUMENTED_WEB_SERVER`
        :param pulumi.Input[str] icon_type: Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_user_actions: User Action names to be flagged as Key User Actions
        :param pulumi.Input[str] name: The name of the application
        :param pulumi.Input[bool] opt_in_mode: The opt-in mode is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['MobileApplicationPropertiesArgs', 'MobileApplicationPropertiesArgsDict']] properties: User Action and Session Properties
        :param pulumi.Input[bool] session_replay: (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[bool] session_replay_on_crash: The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
               and **optInModeEnabled** values set to `true`.
        :param pulumi.Input[int] user_session_percentage: (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
               user sessions to be analyzed
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MobileApplicationState.__new__(_MobileApplicationState)

        __props__.__dict__["apdex"] = apdex
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_type"] = application_type
        __props__.__dict__["beacon_endpoint_type"] = beacon_endpoint_type
        __props__.__dict__["beacon_endpoint_url"] = beacon_endpoint_url
        __props__.__dict__["icon_type"] = icon_type
        __props__.__dict__["key_user_actions"] = key_user_actions
        __props__.__dict__["name"] = name
        __props__.__dict__["opt_in_mode"] = opt_in_mode
        __props__.__dict__["properties"] = properties
        __props__.__dict__["session_replay"] = session_replay
        __props__.__dict__["session_replay_on_crash"] = session_replay_on_crash
        __props__.__dict__["user_session_percentage"] = user_session_percentage
        return MobileApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apdex(self) -> pulumi.Output['outputs.MobileApplicationApdex']:
        """
        Apdex configuration of a mobile application. A duration less than the **tolerable** threshold is considered satisfied
        """
        return pulumi.get(self, "apdex")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID of the application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the application. Either `CUSTOM_APPLICATION` or `MOBILE_APPLICATION`.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="beaconEndpointType")
    def beacon_endpoint_type(self) -> pulumi.Output[str]:
        """
        The type of the beacon endpoint. Possible values are `CLUSTER_ACTIVE_GATE`, `ENVIRONMENT_ACTIVE_GATE` and `INSTRUMENTED_WEB_SERVER`.
        """
        return pulumi.get(self, "beacon_endpoint_type")

    @property
    @pulumi.getter(name="beaconEndpointUrl")
    def beacon_endpoint_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the beacon endpoint. Only applicable when the **beacon_endpoint_type** is set to `ENVIRONMENT_ACTIVE_GATE` or
        `INSTRUMENTED_WEB_SERVER`
        """
        return pulumi.get(self, "beacon_endpoint_url")

    @property
    @pulumi.getter(name="iconType")
    def icon_type(self) -> pulumi.Output[Optional[str]]:
        """
        Custom application icon. Mobile apps always use the mobile device icon, so this icon can only be set for custom apps.
        """
        return pulumi.get(self, "icon_type")

    @property
    @pulumi.getter(name="keyUserActions")
    def key_user_actions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        User Action names to be flagged as Key User Actions
        """
        return pulumi.get(self, "key_user_actions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optInMode")
    def opt_in_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        The opt-in mode is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "opt_in_mode")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional['outputs.MobileApplicationProperties']]:
        """
        User Action and Session Properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="sessionReplay")
    def session_replay(self) -> pulumi.Output[Optional[bool]]:
        """
        (Field has overlap with `MobileAppEnablement`) The session replay is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "session_replay")

    @property
    @pulumi.getter(name="sessionReplayOnCrash")
    def session_replay_on_crash(self) -> pulumi.Output[Optional[bool]]:
        """
        The session replay on crash is enabled (`true`) or disabled (`false`). Enabling requires both **sessionReplayEnabled**
        and **optInModeEnabled** values set to `true`.
        """
        return pulumi.get(self, "session_replay_on_crash")

    @property
    @pulumi.getter(name="userSessionPercentage")
    def user_session_percentage(self) -> pulumi.Output[Optional[int]]:
        """
        (Field has overlap with `MobileAppEnablement` for mobile and `CustomAppEnablement` for custom apps) The percentage of
        user sessions to be analyzed
        """
        return pulumi.get(self, "user_session_percentage")

