# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedRemoteAccessArgs', 'ManagedRemoteAccess']

@pulumi.input_type
class ManagedRemoteAccessArgs:
    def __init__(__self__, *,
                 reason: pulumi.Input[str],
                 requested_days: pulumi.Input[int],
                 role: pulumi.Input[str],
                 user_id: pulumi.Input[str],
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedRemoteAccess resource.
        :param pulumi.Input[str] reason: Request reason description, cannot be changed once created
        :param pulumi.Input[int] requested_days: For how many days access is requested, cannot be changed once created
        :param pulumi.Input[str] role: Requested role, cannot be changed once created
        :param pulumi.Input[str] user_id: User id, cannot be changed once created
        :param pulumi.Input[str] state: Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        """
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "requested_days", requested_days)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "user_id", user_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[str]:
        """
        Request reason description, cannot be changed once created
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="requestedDays")
    def requested_days(self) -> pulumi.Input[int]:
        """
        For how many days access is requested, cannot be changed once created
        """
        return pulumi.get(self, "requested_days")

    @requested_days.setter
    def requested_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "requested_days", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        Requested role, cannot be changed once created
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        User id, cannot be changed once created
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ManagedRemoteAccessState:
    def __init__(__self__, *,
                 reason: Optional[pulumi.Input[str]] = None,
                 requested_days: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagedRemoteAccess resources.
        :param pulumi.Input[str] reason: Request reason description, cannot be changed once created
        :param pulumi.Input[int] requested_days: For how many days access is requested, cannot be changed once created
        :param pulumi.Input[str] role: Requested role, cannot be changed once created
        :param pulumi.Input[str] state: Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        :param pulumi.Input[str] user_id: User id, cannot be changed once created
        """
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if requested_days is not None:
            pulumi.set(__self__, "requested_days", requested_days)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Request reason description, cannot be changed once created
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="requestedDays")
    def requested_days(self) -> Optional[pulumi.Input[int]]:
        """
        For how many days access is requested, cannot be changed once created
        """
        return pulumi.get(self, "requested_days")

    @requested_days.setter
    def requested_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requested_days", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Requested role, cannot be changed once created
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User id, cannot be changed once created
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class ManagedRemoteAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 requested_days: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ManagedRemoteAccess resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] reason: Request reason description, cannot be changed once created
        :param pulumi.Input[int] requested_days: For how many days access is requested, cannot be changed once created
        :param pulumi.Input[str] role: Requested role, cannot be changed once created
        :param pulumi.Input[str] state: Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        :param pulumi.Input[str] user_id: User id, cannot be changed once created
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedRemoteAccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ManagedRemoteAccess resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ManagedRemoteAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedRemoteAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 requested_days: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedRemoteAccessArgs.__new__(ManagedRemoteAccessArgs)

            if reason is None and not opts.urn:
                raise TypeError("Missing required property 'reason'")
            __props__.__dict__["reason"] = reason
            if requested_days is None and not opts.urn:
                raise TypeError("Missing required property 'requested_days'")
            __props__.__dict__["requested_days"] = requested_days
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["state"] = state
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(ManagedRemoteAccess, __self__).__init__(
            'dynatrace:index/managedRemoteAccess:ManagedRemoteAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            reason: Optional[pulumi.Input[str]] = None,
            requested_days: Optional[pulumi.Input[int]] = None,
            role: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'ManagedRemoteAccess':
        """
        Get an existing ManagedRemoteAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] reason: Request reason description, cannot be changed once created
        :param pulumi.Input[int] requested_days: For how many days access is requested, cannot be changed once created
        :param pulumi.Input[str] role: Requested role, cannot be changed once created
        :param pulumi.Input[str] state: Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        :param pulumi.Input[str] user_id: User id, cannot be changed once created
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedRemoteAccessState.__new__(_ManagedRemoteAccessState)

        __props__.__dict__["reason"] = reason
        __props__.__dict__["requested_days"] = requested_days
        __props__.__dict__["role"] = role
        __props__.__dict__["state"] = state
        __props__.__dict__["user_id"] = user_id
        return ManagedRemoteAccess(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[str]:
        """
        Request reason description, cannot be changed once created
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="requestedDays")
    def requested_days(self) -> pulumi.Output[int]:
        """
        For how many days access is requested, cannot be changed once created
        """
        return pulumi.get(self, "requested_days")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Requested role, cannot be changed once created
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        Access request state. Automatically set as `ACCEPTED` on create, state can be changed in subsequent updates.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        User id, cannot be changed once created
        """
        return pulumi.get(self, "user_id")

