# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaintenanceWindowArgs', 'MaintenanceWindow']

@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 suppression: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['MaintenanceWindowScheduleArgs']] = None,
                 scope: Optional[pulumi.Input['MaintenanceWindowScopeArgs']] = None,
                 suppress_synth_mon_exec: Optional[pulumi.Input[bool]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MaintenanceWindow resource.
        :param pulumi.Input[str] suppression: The type of suppression of alerting and problem detection during the maintenance
        :param pulumi.Input[str] type: The type of the maintenance: planned or unplanned
        :param pulumi.Input[str] description: A short description of the maintenance purpose
        :param pulumi.Input[bool] enabled: The Maintenance Window is enabled or disabled
        :param pulumi.Input[str] name: The name of the maintenance window, displayed in the UI
        :param pulumi.Input['MaintenanceWindowScheduleArgs'] schedule: The schedule of the maintenance window
        :param pulumi.Input['MaintenanceWindowScopeArgs'] scope: the tiles this Dashboard consist of
        :param pulumi.Input[bool] suppress_synth_mon_exec: Suppress execution of synthetic monitors during the maintenance
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        pulumi.set(__self__, "suppression", suppression)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if suppress_synth_mon_exec is not None:
            pulumi.set(__self__, "suppress_synth_mon_exec", suppress_synth_mon_exec)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def suppression(self) -> pulumi.Input[str]:
        """
        The type of suppression of alerting and problem detection during the maintenance
        """
        return pulumi.get(self, "suppression")

    @suppression.setter
    def suppression(self, value: pulumi.Input[str]):
        pulumi.set(self, "suppression", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the maintenance: planned or unplanned
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of the maintenance purpose
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The Maintenance Window is enabled or disabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance window, displayed in the UI
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['MaintenanceWindowScheduleArgs']]:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['MaintenanceWindowScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['MaintenanceWindowScopeArgs']]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['MaintenanceWindowScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="suppressSynthMonExec")
    def suppress_synth_mon_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        Suppress execution of synthetic monitors during the maintenance
        """
        return pulumi.get(self, "suppress_synth_mon_exec")

    @suppress_synth_mon_exec.setter
    def suppress_synth_mon_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suppress_synth_mon_exec", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _MaintenanceWindowState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['MaintenanceWindowScheduleArgs']] = None,
                 scope: Optional[pulumi.Input['MaintenanceWindowScopeArgs']] = None,
                 suppress_synth_mon_exec: Optional[pulumi.Input[bool]] = None,
                 suppression: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindow resources.
        :param pulumi.Input[str] description: A short description of the maintenance purpose
        :param pulumi.Input[bool] enabled: The Maintenance Window is enabled or disabled
        :param pulumi.Input[str] name: The name of the maintenance window, displayed in the UI
        :param pulumi.Input['MaintenanceWindowScheduleArgs'] schedule: The schedule of the maintenance window
        :param pulumi.Input['MaintenanceWindowScopeArgs'] scope: the tiles this Dashboard consist of
        :param pulumi.Input[bool] suppress_synth_mon_exec: Suppress execution of synthetic monitors during the maintenance
        :param pulumi.Input[str] suppression: The type of suppression of alerting and problem detection during the maintenance
        :param pulumi.Input[str] type: The type of the maintenance: planned or unplanned
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if suppress_synth_mon_exec is not None:
            pulumi.set(__self__, "suppress_synth_mon_exec", suppress_synth_mon_exec)
        if suppression is not None:
            pulumi.set(__self__, "suppression", suppression)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of the maintenance purpose
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The Maintenance Window is enabled or disabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance window, displayed in the UI
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['MaintenanceWindowScheduleArgs']]:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['MaintenanceWindowScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['MaintenanceWindowScopeArgs']]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['MaintenanceWindowScopeArgs']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="suppressSynthMonExec")
    def suppress_synth_mon_exec(self) -> Optional[pulumi.Input[bool]]:
        """
        Suppress execution of synthetic monitors during the maintenance
        """
        return pulumi.get(self, "suppress_synth_mon_exec")

    @suppress_synth_mon_exec.setter
    def suppress_synth_mon_exec(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suppress_synth_mon_exec", value)

    @property
    @pulumi.getter
    def suppression(self) -> Optional[pulumi.Input[str]]:
        """
        The type of suppression of alerting and problem detection during the maintenance
        """
        return pulumi.get(self, "suppression")

    @suppression.setter
    def suppression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suppression", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the maintenance: planned or unplanned
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)


class MaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['MaintenanceWindowScheduleArgs', 'MaintenanceWindowScheduleArgsDict']]] = None,
                 scope: Optional[pulumi.Input[Union['MaintenanceWindowScopeArgs', 'MaintenanceWindowScopeArgsDict']]] = None,
                 suppress_synth_mon_exec: Optional[pulumi.Input[bool]] = None,
                 suppression: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        !> This resource API endpoint has been deprecated, please use Maintenance instead.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Maintenance windows - https://www.dynatrace.com/support/help/how-to-use-dynatrace/problem-detection-and-analysis/notifications-and-alerting/maintenance-windows

        - Maintenance windows API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/maintenance-windows-api

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.MaintenanceWindow("#name#",
            schedule={
                "end": "2021-05-11 14:41",
                "recurrence_type": "ONCE",
                "start": "2021-05-11 13:41",
                "zone_id": "Europe/Vienna",
            },
            scope={
                "matches": [{
                    "tag_combination": "AND",
                    "tags": [
                        {
                            "context": "CONTEXTLESS",
                            "key": "bggtedgxen",
                        },
                        {
                            "context": "CONTEXTLESS",
                            "key": "deldel1",
                        },
                    ],
                }],
            },
            suppress_synth_mon_exec=True,
            suppression="DONT_DETECT_PROBLEMS",
            type="PLANNED")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A short description of the maintenance purpose
        :param pulumi.Input[bool] enabled: The Maintenance Window is enabled or disabled
        :param pulumi.Input[str] name: The name of the maintenance window, displayed in the UI
        :param pulumi.Input[Union['MaintenanceWindowScheduleArgs', 'MaintenanceWindowScheduleArgsDict']] schedule: The schedule of the maintenance window
        :param pulumi.Input[Union['MaintenanceWindowScopeArgs', 'MaintenanceWindowScopeArgsDict']] scope: the tiles this Dashboard consist of
        :param pulumi.Input[bool] suppress_synth_mon_exec: Suppress execution of synthetic monitors during the maintenance
        :param pulumi.Input[str] suppression: The type of suppression of alerting and problem detection during the maintenance
        :param pulumi.Input[str] type: The type of the maintenance: planned or unplanned
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> This resource API endpoint has been deprecated, please use Maintenance instead.

        > This resource requires the API token scopes **Read configuration** (`ReadConfig`) and **Write configuration** (`WriteConfig`)

        ## Dynatrace Documentation

        - Maintenance windows - https://www.dynatrace.com/support/help/how-to-use-dynatrace/problem-detection-and-analysis/notifications-and-alerting/maintenance-windows

        - Maintenance windows API - https://www.dynatrace.com/support/help/dynatrace-api/configuration-api/maintenance-windows-api

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.MaintenanceWindow("#name#",
            schedule={
                "end": "2021-05-11 14:41",
                "recurrence_type": "ONCE",
                "start": "2021-05-11 13:41",
                "zone_id": "Europe/Vienna",
            },
            scope={
                "matches": [{
                    "tag_combination": "AND",
                    "tags": [
                        {
                            "context": "CONTEXTLESS",
                            "key": "bggtedgxen",
                        },
                        {
                            "context": "CONTEXTLESS",
                            "key": "deldel1",
                        },
                    ],
                }],
            },
            suppress_synth_mon_exec=True,
            suppression="DONT_DETECT_PROBLEMS",
            type="PLANNED")
        ```

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[Union['MaintenanceWindowScheduleArgs', 'MaintenanceWindowScheduleArgsDict']]] = None,
                 scope: Optional[pulumi.Input[Union['MaintenanceWindowScopeArgs', 'MaintenanceWindowScopeArgsDict']]] = None,
                 suppress_synth_mon_exec: Optional[pulumi.Input[bool]] = None,
                 suppression: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowArgs.__new__(MaintenanceWindowArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["scope"] = scope
            __props__.__dict__["suppress_synth_mon_exec"] = suppress_synth_mon_exec
            if suppression is None and not opts.urn:
                raise TypeError("Missing required property 'suppression'")
            __props__.__dict__["suppression"] = suppression
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["unknowns"] = unknowns
        super(MaintenanceWindow, __self__).__init__(
            'dynatrace:index/maintenanceWindow:MaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[Union['MaintenanceWindowScheduleArgs', 'MaintenanceWindowScheduleArgsDict']]] = None,
            scope: Optional[pulumi.Input[Union['MaintenanceWindowScopeArgs', 'MaintenanceWindowScopeArgsDict']]] = None,
            suppress_synth_mon_exec: Optional[pulumi.Input[bool]] = None,
            suppression: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unknowns: Optional[pulumi.Input[str]] = None) -> 'MaintenanceWindow':
        """
        Get an existing MaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A short description of the maintenance purpose
        :param pulumi.Input[bool] enabled: The Maintenance Window is enabled or disabled
        :param pulumi.Input[str] name: The name of the maintenance window, displayed in the UI
        :param pulumi.Input[Union['MaintenanceWindowScheduleArgs', 'MaintenanceWindowScheduleArgsDict']] schedule: The schedule of the maintenance window
        :param pulumi.Input[Union['MaintenanceWindowScopeArgs', 'MaintenanceWindowScopeArgsDict']] scope: the tiles this Dashboard consist of
        :param pulumi.Input[bool] suppress_synth_mon_exec: Suppress execution of synthetic monitors during the maintenance
        :param pulumi.Input[str] suppression: The type of suppression of alerting and problem detection during the maintenance
        :param pulumi.Input[str] type: The type of the maintenance: planned or unplanned
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowState.__new__(_MaintenanceWindowState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["scope"] = scope
        __props__.__dict__["suppress_synth_mon_exec"] = suppress_synth_mon_exec
        __props__.__dict__["suppression"] = suppression
        __props__.__dict__["type"] = type
        __props__.__dict__["unknowns"] = unknowns
        return MaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A short description of the maintenance purpose
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The Maintenance Window is enabled or disabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the maintenance window, displayed in the UI
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.MaintenanceWindowSchedule']]:
        """
        The schedule of the maintenance window
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['outputs.MaintenanceWindowScope']]:
        """
        the tiles this Dashboard consist of
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="suppressSynthMonExec")
    def suppress_synth_mon_exec(self) -> pulumi.Output[Optional[bool]]:
        """
        Suppress execution of synthetic monitors during the maintenance
        """
        return pulumi.get(self, "suppress_synth_mon_exec")

    @property
    @pulumi.getter
    def suppression(self) -> pulumi.Output[str]:
        """
        The type of suppression of alerting and problem detection during the maintenance
        """
        return pulumi.get(self, "suppression")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the maintenance: planned or unplanned
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

