# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LogGrailArgs', 'LogGrail']

@pulumi.input_type
class LogGrailArgs:
    def __init__(__self__, *,
                 activated: pulumi.Input[bool],
                 parallel_ingest_period: pulumi.Input[str]):
        """
        The set of arguments for constructing a LogGrail resource.
        :param pulumi.Input[bool] activated: Activate logs powered by Grail.
        :param pulumi.Input[str] parallel_ingest_period: Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "parallel_ingest_period", parallel_ingest_period)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Input[bool]:
        """
        Activate logs powered by Grail.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="parallelIngestPeriod")
    def parallel_ingest_period(self) -> pulumi.Input[str]:
        """
        Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        return pulumi.get(self, "parallel_ingest_period")

    @parallel_ingest_period.setter
    def parallel_ingest_period(self, value: pulumi.Input[str]):
        pulumi.set(self, "parallel_ingest_period", value)


@pulumi.input_type
class _LogGrailState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[bool]] = None,
                 parallel_ingest_period: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogGrail resources.
        :param pulumi.Input[bool] activated: Activate logs powered by Grail.
        :param pulumi.Input[str] parallel_ingest_period: Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if parallel_ingest_period is not None:
            pulumi.set(__self__, "parallel_ingest_period", parallel_ingest_period)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[bool]]:
        """
        Activate logs powered by Grail.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="parallelIngestPeriod")
    def parallel_ingest_period(self) -> Optional[pulumi.Input[str]]:
        """
        Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        return pulumi.get(self, "parallel_ingest_period")

    @parallel_ingest_period.setter
    def parallel_ingest_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parallel_ingest_period", value)


class LogGrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 parallel_ingest_period: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a LogGrail resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Activate logs powered by Grail.
        :param pulumi.Input[str] parallel_ingest_period: Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogGrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LogGrail resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LogGrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogGrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 parallel_ingest_period: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogGrailArgs.__new__(LogGrailArgs)

            if activated is None and not opts.urn:
                raise TypeError("Missing required property 'activated'")
            __props__.__dict__["activated"] = activated
            if parallel_ingest_period is None and not opts.urn:
                raise TypeError("Missing required property 'parallel_ingest_period'")
            __props__.__dict__["parallel_ingest_period"] = parallel_ingest_period
        super(LogGrail, __self__).__init__(
            'dynatrace:index/logGrail:LogGrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[bool]] = None,
            parallel_ingest_period: Optional[pulumi.Input[str]] = None) -> 'LogGrail':
        """
        Get an existing LogGrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Activate logs powered by Grail.
        :param pulumi.Input[str] parallel_ingest_period: Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogGrailState.__new__(_LogGrailState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["parallel_ingest_period"] = parallel_ingest_period
        return LogGrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[bool]:
        """
        Activate logs powered by Grail.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="parallelIngestPeriod")
    def parallel_ingest_period(self) -> pulumi.Output[str]:
        """
        Possible Values: `NONE`, `SEVEN_DAYS`, `THIRTY_FIVE_DAYS`
        """
        return pulumi.get(self, "parallel_ingest_period")

