# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogEventsArgs', 'LogEvents']

@pulumi.input_type
class LogEventsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 event_template: pulumi.Input['LogEventsEventTemplateArgs'],
                 query: pulumi.Input[str],
                 summary: pulumi.Input[str]):
        """
        The set of arguments for constructing a LogEvents resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['LogEventsEventTemplateArgs'] event_template: Event template
        :param pulumi.Input[str] query: Log query
        :param pulumi.Input[str] summary: The textual summary of the log event entry
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "event_template", event_template)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> pulumi.Input['LogEventsEventTemplateArgs']:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @event_template.setter
    def event_template(self, value: pulumi.Input['LogEventsEventTemplateArgs']):
        pulumi.set(self, "event_template", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Log query
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Input[str]:
        """
        The textual summary of the log event entry
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: pulumi.Input[str]):
        pulumi.set(self, "summary", value)


@pulumi.input_type
class _LogEventsState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_template: Optional[pulumi.Input['LogEventsEventTemplateArgs']] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogEvents resources.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['LogEventsEventTemplateArgs'] event_template: Event template
        :param pulumi.Input[str] query: Log query
        :param pulumi.Input[str] summary: The textual summary of the log event entry
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_template is not None:
            pulumi.set(__self__, "event_template", event_template)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> Optional[pulumi.Input['LogEventsEventTemplateArgs']]:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @event_template.setter
    def event_template(self, value: Optional[pulumi.Input['LogEventsEventTemplateArgs']]):
        pulumi.set(self, "event_template", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Log query
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[str]]:
        """
        The textual summary of the log event entry
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary", value)


class LogEvents(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_template: Optional[pulumi.Input[Union['LogEventsEventTemplateArgs', 'LogEventsEventTemplateArgsDict']]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a LogEvents resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['LogEventsEventTemplateArgs', 'LogEventsEventTemplateArgsDict']] event_template: Event template
        :param pulumi.Input[str] query: Log query
        :param pulumi.Input[str] summary: The textual summary of the log event entry
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogEventsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LogEvents resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LogEventsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogEventsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_template: Optional[pulumi.Input[Union['LogEventsEventTemplateArgs', 'LogEventsEventTemplateArgsDict']]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogEventsArgs.__new__(LogEventsArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if event_template is None and not opts.urn:
                raise TypeError("Missing required property 'event_template'")
            __props__.__dict__["event_template"] = event_template
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            if summary is None and not opts.urn:
                raise TypeError("Missing required property 'summary'")
            __props__.__dict__["summary"] = summary
        super(LogEvents, __self__).__init__(
            'dynatrace:index/logEvents:LogEvents',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            event_template: Optional[pulumi.Input[Union['LogEventsEventTemplateArgs', 'LogEventsEventTemplateArgsDict']]] = None,
            query: Optional[pulumi.Input[str]] = None,
            summary: Optional[pulumi.Input[str]] = None) -> 'LogEvents':
        """
        Get an existing LogEvents resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['LogEventsEventTemplateArgs', 'LogEventsEventTemplateArgsDict']] event_template: Event template
        :param pulumi.Input[str] query: Log query
        :param pulumi.Input[str] summary: The textual summary of the log event entry
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogEventsState.__new__(_LogEventsState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_template"] = event_template
        __props__.__dict__["query"] = query
        __props__.__dict__["summary"] = summary
        return LogEvents(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventTemplate")
    def event_template(self) -> pulumi.Output['outputs.LogEventsEventTemplate']:
        """
        Event template
        """
        return pulumi.get(self, "event_template")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[str]:
        """
        Log query
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Output[str]:
        """
        The textual summary of the log event entry
        """
        return pulumi.get(self, "summary")

