# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesArgs', 'Kubernetes']

@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 cluster_id_enabled: pulumi.Input[bool],
                 enabled: pulumi.Input[bool],
                 label: pulumi.Input[str],
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_patterns: Optional[pulumi.Input['KubernetesEventPatternsArgs']] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 hostname_verification_enabled: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Kubernetes resource.
        :param pulumi.Input[bool] cluster_id_enabled: For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] label: Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        :param pulumi.Input[str] active_gate_group: ActiveGate Group
        :param pulumi.Input[str] auth_token: Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        :param pulumi.Input[bool] certificate_check_enabled: Require valid certificates for communication with API server (recommended)
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[str] cluster_id: Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        :param pulumi.Input[str] endpoint_url: Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        :param pulumi.Input['KubernetesEventPatternsArgs'] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored by default unless event filters are specified.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] hostname_verification_enabled: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
               may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER)
        """
        pulumi.set(__self__, "cluster_id_enabled", cluster_id_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "label", label)
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if certificate_check_enabled is not None:
            pulumi.set(__self__, "certificate_check_enabled", certificate_check_enabled)
        if cloud_application_pipeline_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""cloud_application_pipeline_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if cloud_application_pipeline_enabled is not None:
            pulumi.set(__self__, "cloud_application_pipeline_enabled", cloud_application_pipeline_enabled)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_patterns is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""event_patterns is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if event_patterns is not None:
            pulumi.set(__self__, "event_patterns", event_patterns)
        if event_processing_active is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""event_processing_active is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if event_processing_active is not None:
            pulumi.set(__self__, "event_processing_active", event_processing_active)
        if filter_events is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""filter_events is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if filter_events is not None:
            pulumi.set(__self__, "filter_events", filter_events)
        if hostname_verification_enabled is not None:
            pulumi.set(__self__, "hostname_verification_enabled", hostname_verification_enabled)
        if include_all_fdi_events is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""include_all_fdi_events is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if include_all_fdi_events is not None:
            pulumi.set(__self__, "include_all_fdi_events", include_all_fdi_events)
        if open_metrics_builtin_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""open_metrics_builtin_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if open_metrics_builtin_enabled is not None:
            pulumi.set(__self__, "open_metrics_builtin_enabled", open_metrics_builtin_enabled)
        if open_metrics_pipeline_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""open_metrics_pipeline_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if open_metrics_pipeline_enabled is not None:
            pulumi.set(__self__, "open_metrics_pipeline_enabled", open_metrics_pipeline_enabled)
        if pvc_monitoring_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""pvc_monitoring_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if pvc_monitoring_enabled is not None:
            pulumi.set(__self__, "pvc_monitoring_enabled", pvc_monitoring_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="clusterIdEnabled")
    def cluster_id_enabled(self) -> pulumi.Input[bool]:
        """
        For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        """
        return pulumi.get(self, "cluster_id_enabled")

    @cluster_id_enabled.setter
    def cluster_id_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "cluster_id_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        ActiveGate Group
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Require valid certificates for communication with API server (recommended)
        """
        return pulumi.get(self, "certificate_check_enabled")

    @certificate_check_enabled.setter
    def certificate_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "certificate_check_enabled", value)

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def cloud_application_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @cloud_application_pipeline_enabled.setter
    def cloud_application_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_application_pipeline_enabled", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="eventPatterns")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_patterns(self) -> Optional[pulumi.Input['KubernetesEventPatternsArgs']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @event_patterns.setter
    def event_patterns(self, value: Optional[pulumi.Input['KubernetesEventPatternsArgs']]):
        pulumi.set(self, "event_patterns", value)

    @property
    @pulumi.getter(name="eventProcessingActive")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_processing_active(self) -> Optional[pulumi.Input[bool]]:
        """
        All events are monitored by default unless event filters are specified.
        """
        return pulumi.get(self, "event_processing_active")

    @event_processing_active.setter
    def event_processing_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_processing_active", value)

    @property
    @pulumi.getter(name="filterEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def filter_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @filter_events.setter
    def filter_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "filter_events", value)

    @property
    @pulumi.getter(name="hostnameVerificationEnabled")
    def hostname_verification_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification_enabled")

    @hostname_verification_enabled.setter
    def hostname_verification_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hostname_verification_enabled", value)

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def include_all_fdi_events(self) -> Optional[pulumi.Input[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @include_all_fdi_events.setter
    def include_all_fdi_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_all_fdi_events", value)

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_builtin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
        may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @open_metrics_builtin_enabled.setter
    def open_metrics_builtin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_builtin_enabled", value)

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @open_metrics_pipeline_enabled.setter
    def open_metrics_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_pipeline_enabled", value)

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def pvc_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @pvc_monitoring_enabled.setter
    def pvc_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pvc_monitoring_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _KubernetesState:
    def __init__(__self__, *,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_id_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_patterns: Optional[pulumi.Input['KubernetesEventPatternsArgs']] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 hostname_verification_enabled: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Kubernetes resources.
        :param pulumi.Input[str] active_gate_group: ActiveGate Group
        :param pulumi.Input[str] auth_token: Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        :param pulumi.Input[bool] certificate_check_enabled: Require valid certificates for communication with API server (recommended)
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[str] cluster_id: Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        :param pulumi.Input[bool] cluster_id_enabled: For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] endpoint_url: Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        :param pulumi.Input['KubernetesEventPatternsArgs'] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored by default unless event filters are specified.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] hostname_verification_enabled: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[str] label: Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
               may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER)
        """
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if certificate_check_enabled is not None:
            pulumi.set(__self__, "certificate_check_enabled", certificate_check_enabled)
        if cloud_application_pipeline_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""cloud_application_pipeline_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if cloud_application_pipeline_enabled is not None:
            pulumi.set(__self__, "cloud_application_pipeline_enabled", cloud_application_pipeline_enabled)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_id_enabled is not None:
            pulumi.set(__self__, "cluster_id_enabled", cluster_id_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_patterns is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""event_patterns is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if event_patterns is not None:
            pulumi.set(__self__, "event_patterns", event_patterns)
        if event_processing_active is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""event_processing_active is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if event_processing_active is not None:
            pulumi.set(__self__, "event_processing_active", event_processing_active)
        if filter_events is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""filter_events is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if filter_events is not None:
            pulumi.set(__self__, "filter_events", filter_events)
        if hostname_verification_enabled is not None:
            pulumi.set(__self__, "hostname_verification_enabled", hostname_verification_enabled)
        if include_all_fdi_events is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""include_all_fdi_events is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if include_all_fdi_events is not None:
            pulumi.set(__self__, "include_all_fdi_events", include_all_fdi_events)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if open_metrics_builtin_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""open_metrics_builtin_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if open_metrics_builtin_enabled is not None:
            pulumi.set(__self__, "open_metrics_builtin_enabled", open_metrics_builtin_enabled)
        if open_metrics_pipeline_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""open_metrics_pipeline_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if open_metrics_pipeline_enabled is not None:
            pulumi.set(__self__, "open_metrics_pipeline_enabled", open_metrics_pipeline_enabled)
        if pvc_monitoring_enabled is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""pvc_monitoring_enabled is deprecated: This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
        if pvc_monitoring_enabled is not None:
            pulumi.set(__self__, "pvc_monitoring_enabled", pvc_monitoring_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        ActiveGate Group
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Require valid certificates for communication with API server (recommended)
        """
        return pulumi.get(self, "certificate_check_enabled")

    @certificate_check_enabled.setter
    def certificate_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "certificate_check_enabled", value)

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def cloud_application_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @cloud_application_pipeline_enabled.setter
    def cloud_application_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_application_pipeline_enabled", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterIdEnabled")
    def cluster_id_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        """
        return pulumi.get(self, "cluster_id_enabled")

    @cluster_id_enabled.setter
    def cluster_id_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cluster_id_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="eventPatterns")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_patterns(self) -> Optional[pulumi.Input['KubernetesEventPatternsArgs']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @event_patterns.setter
    def event_patterns(self, value: Optional[pulumi.Input['KubernetesEventPatternsArgs']]):
        pulumi.set(self, "event_patterns", value)

    @property
    @pulumi.getter(name="eventProcessingActive")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_processing_active(self) -> Optional[pulumi.Input[bool]]:
        """
        All events are monitored by default unless event filters are specified.
        """
        return pulumi.get(self, "event_processing_active")

    @event_processing_active.setter
    def event_processing_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_processing_active", value)

    @property
    @pulumi.getter(name="filterEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def filter_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @filter_events.setter
    def filter_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "filter_events", value)

    @property
    @pulumi.getter(name="hostnameVerificationEnabled")
    def hostname_verification_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification_enabled")

    @hostname_verification_enabled.setter
    def hostname_verification_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hostname_verification_enabled", value)

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def include_all_fdi_events(self) -> Optional[pulumi.Input[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @include_all_fdi_events.setter
    def include_all_fdi_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_all_fdi_events", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_builtin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
        may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @open_metrics_builtin_enabled.setter
    def open_metrics_builtin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_builtin_enabled", value)

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @open_metrics_pipeline_enabled.setter
    def open_metrics_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_pipeline_enabled", value)

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def pvc_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @pvc_monitoring_enabled.setter
    def pvc_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pvc_monitoring_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER)
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class Kubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_id_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_patterns: Optional[pulumi.Input[Union['KubernetesEventPatternsArgs', 'KubernetesEventPatternsArgsDict']]] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 hostname_verification_enabled: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Kubernetes resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_gate_group: ActiveGate Group
        :param pulumi.Input[str] auth_token: Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        :param pulumi.Input[bool] certificate_check_enabled: Require valid certificates for communication with API server (recommended)
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[str] cluster_id: Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        :param pulumi.Input[bool] cluster_id_enabled: For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] endpoint_url: Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        :param pulumi.Input[Union['KubernetesEventPatternsArgs', 'KubernetesEventPatternsArgsDict']] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored by default unless event filters are specified.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] hostname_verification_enabled: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[str] label: Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
               may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Kubernetes resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param KubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_id_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_patterns: Optional[pulumi.Input[Union['KubernetesEventPatternsArgs', 'KubernetesEventPatternsArgsDict']]] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 hostname_verification_enabled: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesArgs.__new__(KubernetesArgs)

            __props__.__dict__["active_gate_group"] = active_gate_group
            __props__.__dict__["auth_token"] = None if auth_token is None else pulumi.Output.secret(auth_token)
            __props__.__dict__["certificate_check_enabled"] = certificate_check_enabled
            __props__.__dict__["cloud_application_pipeline_enabled"] = cloud_application_pipeline_enabled
            __props__.__dict__["cluster_id"] = cluster_id
            if cluster_id_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id_enabled'")
            __props__.__dict__["cluster_id_enabled"] = cluster_id_enabled
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["endpoint_url"] = endpoint_url
            __props__.__dict__["event_patterns"] = event_patterns
            __props__.__dict__["event_processing_active"] = event_processing_active
            __props__.__dict__["filter_events"] = filter_events
            __props__.__dict__["hostname_verification_enabled"] = hostname_verification_enabled
            __props__.__dict__["include_all_fdi_events"] = include_all_fdi_events
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["open_metrics_builtin_enabled"] = open_metrics_builtin_enabled
            __props__.__dict__["open_metrics_pipeline_enabled"] = open_metrics_pipeline_enabled
            __props__.__dict__["pvc_monitoring_enabled"] = pvc_monitoring_enabled
            __props__.__dict__["scope"] = scope
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Kubernetes, __self__).__init__(
            'dynatrace:index/kubernetes:Kubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_gate_group: Optional[pulumi.Input[str]] = None,
            auth_token: Optional[pulumi.Input[str]] = None,
            certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
            cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            cluster_id_enabled: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            endpoint_url: Optional[pulumi.Input[str]] = None,
            event_patterns: Optional[pulumi.Input[Union['KubernetesEventPatternsArgs', 'KubernetesEventPatternsArgsDict']]] = None,
            event_processing_active: Optional[pulumi.Input[bool]] = None,
            filter_events: Optional[pulumi.Input[bool]] = None,
            hostname_verification_enabled: Optional[pulumi.Input[bool]] = None,
            include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
            label: Optional[pulumi.Input[str]] = None,
            open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
            open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
            pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'Kubernetes':
        """
        Get an existing Kubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_gate_group: ActiveGate Group
        :param pulumi.Input[str] auth_token: Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        :param pulumi.Input[bool] certificate_check_enabled: Require valid certificates for communication with API server (recommended)
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[str] cluster_id: Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        :param pulumi.Input[bool] cluster_id_enabled: For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] endpoint_url: Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        :param pulumi.Input[Union['KubernetesEventPatternsArgs', 'KubernetesEventPatternsArgsDict']] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored by default unless event filters are specified.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] hostname_verification_enabled: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[str] label: Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
               may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesState.__new__(_KubernetesState)

        __props__.__dict__["active_gate_group"] = active_gate_group
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["certificate_check_enabled"] = certificate_check_enabled
        __props__.__dict__["cloud_application_pipeline_enabled"] = cloud_application_pipeline_enabled
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_id_enabled"] = cluster_id_enabled
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["endpoint_url"] = endpoint_url
        __props__.__dict__["event_patterns"] = event_patterns
        __props__.__dict__["event_processing_active"] = event_processing_active
        __props__.__dict__["filter_events"] = filter_events
        __props__.__dict__["hostname_verification_enabled"] = hostname_verification_enabled
        __props__.__dict__["include_all_fdi_events"] = include_all_fdi_events
        __props__.__dict__["label"] = label
        __props__.__dict__["open_metrics_builtin_enabled"] = open_metrics_builtin_enabled
        __props__.__dict__["open_metrics_pipeline_enabled"] = open_metrics_pipeline_enabled
        __props__.__dict__["pvc_monitoring_enabled"] = pvc_monitoring_enabled
        __props__.__dict__["scope"] = scope
        return Kubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> pulumi.Output[Optional[str]]:
        """
        ActiveGate Group
        """
        return pulumi.get(self, "active_gate_group")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[str]]:
        """
        Create a bearer token for [Kubernetes](https://dt-url.net/og43szq) or [OpenShift](https://dt-url.net/7l43xtp).
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Require valid certificates for communication with API server (recommended)
        """
        return pulumi.get(self, "certificate_check_enabled")

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def cloud_application_pipeline_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique ID of the cluster, the containerized ActiveGate is deployed to. Defaults to the UUID of the kube-system namespace. The cluster ID of containerized ActiveGates is shown on the Deployment status screen.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterIdEnabled")
    def cluster_id_enabled(self) -> pulumi.Output[bool]:
        """
        For more information on local Kubernetes API monitoring, see the [documentation](https://dt-url.net/6q62uep).
        """
        return pulumi.get(self, "cluster_id_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> pulumi.Output[Optional[str]]:
        """
        Get the API URL for [Kubernetes](https://dt-url.net/kz23snj) or [OpenShift](https://dt-url.net/d623xgw).
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="eventPatterns")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_patterns(self) -> pulumi.Output[Optional['outputs.KubernetesEventPatterns']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @property
    @pulumi.getter(name="eventProcessingActive")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def event_processing_active(self) -> pulumi.Output[Optional[bool]]:
        """
        All events are monitored by default unless event filters are specified.
        """
        return pulumi.get(self, "event_processing_active")

    @property
    @pulumi.getter(name="filterEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def filter_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @property
    @pulumi.getter(name="hostnameVerificationEnabled")
    def hostname_verification_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification_enabled")

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def include_all_fdi_events(self) -> pulumi.Output[Optional[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Renaming the cluster breaks configurations that are based on its name (e.g., management zones, and alerting).
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_builtin_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The workload resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size, this
        may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def open_metrics_pipeline_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `K8sMonitoring` to configure this field.""")
    def pvc_monitoring_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER)
        """
        return pulumi.get(self, "scope")

