# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['KeyRequestsArgs', 'KeyRequests']

@pulumi.input_type
class KeyRequestsArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[str],
                 key_request_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a KeyRequests resource.
        :param pulumi.Input[str] service: ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] key_request_ids: The ids of the key requests
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: The names of the key requests
        """
        pulumi.set(__self__, "service", service)
        if key_request_ids is not None:
            pulumi.set(__self__, "key_request_ids", key_request_ids)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="keyRequestIds")
    def key_request_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The ids of the key requests
        """
        return pulumi.get(self, "key_request_ids")

    @key_request_ids.setter
    def key_request_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "key_request_ids", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of the key requests
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class _KeyRequestsState:
    def __init__(__self__, *,
                 key_request_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KeyRequests resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] key_request_ids: The ids of the key requests
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: The names of the key requests
        :param pulumi.Input[str] service: ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        if key_request_ids is not None:
            pulumi.set(__self__, "key_request_ids", key_request_ids)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="keyRequestIds")
    def key_request_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The ids of the key requests
        """
        return pulumi.get(self, "key_request_ids")

    @key_request_ids.setter
    def key_request_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "key_request_ids", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of the key requests
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


class KeyRequests(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_request_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a KeyRequests resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] key_request_ids: The ids of the key requests
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: The names of the key requests
        :param pulumi.Input[str] service: ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyRequestsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a KeyRequests resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param KeyRequestsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyRequestsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_request_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyRequestsArgs.__new__(KeyRequestsArgs)

            __props__.__dict__["key_request_ids"] = key_request_ids
            __props__.__dict__["names"] = names
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
        super(KeyRequests, __self__).__init__(
            'dynatrace:index/keyRequests:KeyRequests',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key_request_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service: Optional[pulumi.Input[str]] = None) -> 'KeyRequests':
        """
        Get an existing KeyRequests resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] key_request_ids: The ids of the key requests
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: The names of the key requests
        :param pulumi.Input[str] service: ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyRequestsState.__new__(_KeyRequestsState)

        __props__.__dict__["key_request_ids"] = key_request_ids
        __props__.__dict__["names"] = names
        __props__.__dict__["service"] = service
        return KeyRequests(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="keyRequestIds")
    def key_request_ids(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The ids of the key requests
        """
        return pulumi.get(self, "key_request_ids")

    @property
    @pulumi.getter
    def names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The names of the key requests
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        ID of Dynatrace Service, eg. SERVICE-123ABC45678EFGH
        """
        return pulumi.get(self, "service")

