# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sMonitoringArgs', 'K8sMonitoring']

@pulumi.input_type
class K8sMonitoringArgs:
    def __init__(__self__, *,
                 cloud_application_pipeline_enabled: pulumi.Input[bool],
                 event_processing_active: pulumi.Input[bool],
                 open_metrics_builtin_enabled: pulumi.Input[bool],
                 open_metrics_pipeline_enabled: pulumi.Input[bool],
                 event_patterns: Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8sMonitoring resource.
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[bool] event_processing_active: All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        :param pulumi.Input[bool] open_metrics_builtin_enabled: Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
               this may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input['K8sMonitoringEventPatternsArgs'] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the
               [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "cloud_application_pipeline_enabled", cloud_application_pipeline_enabled)
        pulumi.set(__self__, "event_processing_active", event_processing_active)
        pulumi.set(__self__, "open_metrics_builtin_enabled", open_metrics_builtin_enabled)
        pulumi.set(__self__, "open_metrics_pipeline_enabled", open_metrics_pipeline_enabled)
        if event_patterns is not None:
            pulumi.set(__self__, "event_patterns", event_patterns)
        if filter_events is not None:
            pulumi.set(__self__, "filter_events", filter_events)
        if include_all_fdi_events is not None:
            pulumi.set(__self__, "include_all_fdi_events", include_all_fdi_events)
        if pvc_monitoring_enabled is not None:
            warnings.warn("""This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""", DeprecationWarning)
            pulumi.log.warn("""pvc_monitoring_enabled is deprecated: This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""")
        if pvc_monitoring_enabled is not None:
            pulumi.set(__self__, "pvc_monitoring_enabled", pvc_monitoring_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    def cloud_application_pipeline_enabled(self) -> pulumi.Input[bool]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @cloud_application_pipeline_enabled.setter
    def cloud_application_pipeline_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "cloud_application_pipeline_enabled", value)

    @property
    @pulumi.getter(name="eventProcessingActive")
    def event_processing_active(self) -> pulumi.Input[bool]:
        """
        All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        """
        return pulumi.get(self, "event_processing_active")

    @event_processing_active.setter
    def event_processing_active(self, value: pulumi.Input[bool]):
        pulumi.set(self, "event_processing_active", value)

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    def open_metrics_builtin_enabled(self) -> pulumi.Input[bool]:
        """
        Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
        this may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @open_metrics_builtin_enabled.setter
    def open_metrics_builtin_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "open_metrics_builtin_enabled", value)

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    def open_metrics_pipeline_enabled(self) -> pulumi.Input[bool]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @open_metrics_pipeline_enabled.setter
    def open_metrics_pipeline_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "open_metrics_pipeline_enabled", value)

    @property
    @pulumi.getter(name="eventPatterns")
    def event_patterns(self) -> Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the
        [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @event_patterns.setter
    def event_patterns(self, value: Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']]):
        pulumi.set(self, "event_patterns", value)

    @property
    @pulumi.getter(name="filterEvents")
    def filter_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @filter_events.setter
    def filter_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "filter_events", value)

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    def include_all_fdi_events(self) -> Optional[pulumi.Input[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @include_all_fdi_events.setter
    def include_all_fdi_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_all_fdi_events", value)

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""")
    def pvc_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @pvc_monitoring_enabled.setter
    def pvc_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pvc_monitoring_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _K8sMonitoringState:
    def __init__(__self__, *,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 event_patterns: Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8sMonitoring resources.
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input['K8sMonitoringEventPatternsArgs'] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the
               [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
               this may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        if cloud_application_pipeline_enabled is not None:
            pulumi.set(__self__, "cloud_application_pipeline_enabled", cloud_application_pipeline_enabled)
        if event_patterns is not None:
            pulumi.set(__self__, "event_patterns", event_patterns)
        if event_processing_active is not None:
            pulumi.set(__self__, "event_processing_active", event_processing_active)
        if filter_events is not None:
            pulumi.set(__self__, "filter_events", filter_events)
        if include_all_fdi_events is not None:
            pulumi.set(__self__, "include_all_fdi_events", include_all_fdi_events)
        if open_metrics_builtin_enabled is not None:
            pulumi.set(__self__, "open_metrics_builtin_enabled", open_metrics_builtin_enabled)
        if open_metrics_pipeline_enabled is not None:
            pulumi.set(__self__, "open_metrics_pipeline_enabled", open_metrics_pipeline_enabled)
        if pvc_monitoring_enabled is not None:
            warnings.warn("""This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""", DeprecationWarning)
            pulumi.log.warn("""pvc_monitoring_enabled is deprecated: This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""")
        if pvc_monitoring_enabled is not None:
            pulumi.set(__self__, "pvc_monitoring_enabled", pvc_monitoring_enabled)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    def cloud_application_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @cloud_application_pipeline_enabled.setter
    def cloud_application_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_application_pipeline_enabled", value)

    @property
    @pulumi.getter(name="eventPatterns")
    def event_patterns(self) -> Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the
        [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @event_patterns.setter
    def event_patterns(self, value: Optional[pulumi.Input['K8sMonitoringEventPatternsArgs']]):
        pulumi.set(self, "event_patterns", value)

    @property
    @pulumi.getter(name="eventProcessingActive")
    def event_processing_active(self) -> Optional[pulumi.Input[bool]]:
        """
        All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        """
        return pulumi.get(self, "event_processing_active")

    @event_processing_active.setter
    def event_processing_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_processing_active", value)

    @property
    @pulumi.getter(name="filterEvents")
    def filter_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @filter_events.setter
    def filter_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "filter_events", value)

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    def include_all_fdi_events(self) -> Optional[pulumi.Input[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @include_all_fdi_events.setter
    def include_all_fdi_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_all_fdi_events", value)

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    def open_metrics_builtin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
        this may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @open_metrics_builtin_enabled.setter
    def open_metrics_builtin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_builtin_enabled", value)

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    def open_metrics_pipeline_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @open_metrics_pipeline_enabled.setter
    def open_metrics_pipeline_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open_metrics_pipeline_enabled", value)

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""")
    def pvc_monitoring_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @pvc_monitoring_enabled.setter
    def pvc_monitoring_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pvc_monitoring_enabled", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class K8sMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 event_patterns: Optional[pulumi.Input[Union['K8sMonitoringEventPatternsArgs', 'K8sMonitoringEventPatternsArgsDict']]] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a K8sMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[Union['K8sMonitoringEventPatternsArgs', 'K8sMonitoringEventPatternsArgsDict']] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the
               [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
               this may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a K8sMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param K8sMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 event_patterns: Optional[pulumi.Input[Union['K8sMonitoringEventPatternsArgs', 'K8sMonitoringEventPatternsArgsDict']]] = None,
                 event_processing_active: Optional[pulumi.Input[bool]] = None,
                 filter_events: Optional[pulumi.Input[bool]] = None,
                 include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
                 open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
                 open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
                 pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sMonitoringArgs.__new__(K8sMonitoringArgs)

            if cloud_application_pipeline_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_application_pipeline_enabled'")
            __props__.__dict__["cloud_application_pipeline_enabled"] = cloud_application_pipeline_enabled
            __props__.__dict__["event_patterns"] = event_patterns
            if event_processing_active is None and not opts.urn:
                raise TypeError("Missing required property 'event_processing_active'")
            __props__.__dict__["event_processing_active"] = event_processing_active
            __props__.__dict__["filter_events"] = filter_events
            __props__.__dict__["include_all_fdi_events"] = include_all_fdi_events
            if open_metrics_builtin_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'open_metrics_builtin_enabled'")
            __props__.__dict__["open_metrics_builtin_enabled"] = open_metrics_builtin_enabled
            if open_metrics_pipeline_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'open_metrics_pipeline_enabled'")
            __props__.__dict__["open_metrics_pipeline_enabled"] = open_metrics_pipeline_enabled
            __props__.__dict__["pvc_monitoring_enabled"] = pvc_monitoring_enabled
            __props__.__dict__["scope"] = scope
        super(K8sMonitoring, __self__).__init__(
            'dynatrace:index/k8sMonitoring:K8sMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_application_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
            event_patterns: Optional[pulumi.Input[Union['K8sMonitoringEventPatternsArgs', 'K8sMonitoringEventPatternsArgsDict']]] = None,
            event_processing_active: Optional[pulumi.Input[bool]] = None,
            filter_events: Optional[pulumi.Input[bool]] = None,
            include_all_fdi_events: Optional[pulumi.Input[bool]] = None,
            open_metrics_builtin_enabled: Optional[pulumi.Input[bool]] = None,
            open_metrics_pipeline_enabled: Optional[pulumi.Input[bool]] = None,
            pvc_monitoring_enabled: Optional[pulumi.Input[bool]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'K8sMonitoring':
        """
        Get an existing K8sMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] cloud_application_pipeline_enabled: Monitor Kubernetes namespaces, services, workloads, and pods
        :param pulumi.Input[Union['K8sMonitoringEventPatternsArgs', 'K8sMonitoringEventPatternsArgsDict']] event_patterns: Define Kubernetes event filters to ingest events into your environment. For more details, see the
               [documentation](https://dt-url.net/2201p0u).
        :param pulumi.Input[bool] event_processing_active: All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        :param pulumi.Input[bool] filter_events: Include only events specified by Events Field Selectors
        :param pulumi.Input[bool] include_all_fdi_events: For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        :param pulumi.Input[bool] open_metrics_builtin_enabled: Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
               this may increase the CPU/memory resource consumption of your ActiveGate.
        :param pulumi.Input[bool] open_metrics_pipeline_enabled: For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        :param pulumi.Input[bool] pvc_monitoring_enabled: To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        :param pulumi.Input[str] scope: The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sMonitoringState.__new__(_K8sMonitoringState)

        __props__.__dict__["cloud_application_pipeline_enabled"] = cloud_application_pipeline_enabled
        __props__.__dict__["event_patterns"] = event_patterns
        __props__.__dict__["event_processing_active"] = event_processing_active
        __props__.__dict__["filter_events"] = filter_events
        __props__.__dict__["include_all_fdi_events"] = include_all_fdi_events
        __props__.__dict__["open_metrics_builtin_enabled"] = open_metrics_builtin_enabled
        __props__.__dict__["open_metrics_pipeline_enabled"] = open_metrics_pipeline_enabled
        __props__.__dict__["pvc_monitoring_enabled"] = pvc_monitoring_enabled
        __props__.__dict__["scope"] = scope
        return K8sMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudApplicationPipelineEnabled")
    def cloud_application_pipeline_enabled(self) -> pulumi.Output[bool]:
        """
        Monitor Kubernetes namespaces, services, workloads, and pods
        """
        return pulumi.get(self, "cloud_application_pipeline_enabled")

    @property
    @pulumi.getter(name="eventPatterns")
    def event_patterns(self) -> pulumi.Output[Optional['outputs.K8sMonitoringEventPatterns']]:
        """
        Define Kubernetes event filters to ingest events into your environment. For more details, see the
        [documentation](https://dt-url.net/2201p0u).
        """
        return pulumi.get(self, "event_patterns")

    @property
    @pulumi.getter(name="eventProcessingActive")
    def event_processing_active(self) -> pulumi.Output[bool]:
        """
        All events are monitored unless event filters are specified. All ingested events are subject to licensing by default.
        """
        return pulumi.get(self, "event_processing_active")

    @property
    @pulumi.getter(name="filterEvents")
    def filter_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Include only events specified by Events Field Selectors
        """
        return pulumi.get(self, "filter_events")

    @property
    @pulumi.getter(name="includeAllFdiEvents")
    def include_all_fdi_events(self) -> pulumi.Output[Optional[bool]]:
        """
        For a list of included events, see the [documentation](https://dt-url.net/l61d02no).
        """
        return pulumi.get(self, "include_all_fdi_events")

    @property
    @pulumi.getter(name="openMetricsBuiltinEnabled")
    def open_metrics_builtin_enabled(self) -> pulumi.Output[bool]:
        """
        Workload and node resource metrics are based on a subset of cAdvisor metrics. Depending on your Kubernetes cluster size,
        this may increase the CPU/memory resource consumption of your ActiveGate.
        """
        return pulumi.get(self, "open_metrics_builtin_enabled")

    @property
    @pulumi.getter(name="openMetricsPipelineEnabled")
    def open_metrics_pipeline_enabled(self) -> pulumi.Output[bool]:
        """
        For annotation guidance, see the [documentation](https://dt-url.net/g42i0ppw).
        """
        return pulumi.get(self, "open_metrics_pipeline_enabled")

    @property
    @pulumi.getter(name="pvcMonitoringEnabled")
    @_utilities.deprecated("""This attribute is deprecated, see [this community guide](https://dt-url.net/v2200u4m) for details.""")
    def pvc_monitoring_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        To enable dashboards and alerts, add the Kubernetes persistent volume claims extension to your environment.
        """
        return pulumi.get(self, "pvc_monitoring_enabled")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (KUBERNETES_CLUSTER). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

