# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sCredentialsArgs', 'K8sCredentials']

@pulumi.input_type
class K8sCredentialsArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 davis_events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_analysis_and_alerting_enabled: Optional[pulumi.Input[bool]] = None,
                 events_field_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]] = None,
                 events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 hostname_verification: Optional[pulumi.Input[bool]] = None,
                 prometheus_exporters: Optional[pulumi.Input[bool]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 workload_integration_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a K8sCredentials resource.
        :param pulumi.Input[str] label: The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[bool] active: Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[str] active_gate_group: Active Gate group to filter active gates for this credentials.
        :param pulumi.Input[str] auth_token: The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] certificate_check_enabled: The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] davis_events_integration_enabled: Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] endpoint_url: The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[bool] event_analysis_and_alerting_enabled: Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]] events_field_selectors: Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        :param pulumi.Input[bool] events_integration_enabled: Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] hostname_verification: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[bool] prometheus_exporters: Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[bool] workload_integration_enabled: Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        pulumi.set(__self__, "label", label)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if certificate_check_enabled is not None:
            pulumi.set(__self__, "certificate_check_enabled", certificate_check_enabled)
        if davis_events_integration_enabled is not None:
            pulumi.set(__self__, "davis_events_integration_enabled", davis_events_integration_enabled)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_analysis_and_alerting_enabled is not None:
            pulumi.set(__self__, "event_analysis_and_alerting_enabled", event_analysis_and_alerting_enabled)
        if events_field_selectors is not None:
            pulumi.set(__self__, "events_field_selectors", events_field_selectors)
        if events_integration_enabled is not None:
            pulumi.set(__self__, "events_integration_enabled", events_integration_enabled)
        if hostname_verification is not None:
            pulumi.set(__self__, "hostname_verification", hostname_verification)
        if prometheus_exporters is not None:
            pulumi.set(__self__, "prometheus_exporters", prometheus_exporters)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)
        if workload_integration_enabled is not None:
            pulumi.set(__self__, "workload_integration_enabled", workload_integration_enabled)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        Active Gate group to filter active gates for this credentials.
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "certificate_check_enabled")

    @certificate_check_enabled.setter
    def certificate_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "certificate_check_enabled", value)

    @property
    @pulumi.getter(name="davisEventsIntegrationEnabled")
    def davis_events_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "davis_events_integration_enabled")

    @davis_events_integration_enabled.setter
    def davis_events_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "davis_events_integration_enabled", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="eventAnalysisAndAlertingEnabled")
    def event_analysis_and_alerting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "event_analysis_and_alerting_enabled")

    @event_analysis_and_alerting_enabled.setter
    def event_analysis_and_alerting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_analysis_and_alerting_enabled", value)

    @property
    @pulumi.getter(name="eventsFieldSelectors")
    def events_field_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]]:
        """
        Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        """
        return pulumi.get(self, "events_field_selectors")

    @events_field_selectors.setter
    def events_field_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]]):
        pulumi.set(self, "events_field_selectors", value)

    @property
    @pulumi.getter(name="eventsIntegrationEnabled")
    def events_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "events_integration_enabled")

    @events_integration_enabled.setter
    def events_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "events_integration_enabled", value)

    @property
    @pulumi.getter(name="hostnameVerification")
    def hostname_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification")

    @hostname_verification.setter
    def hostname_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hostname_verification", value)

    @property
    @pulumi.getter(name="prometheusExporters")
    def prometheus_exporters(self) -> Optional[pulumi.Input[bool]]:
        """
        Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "prometheus_exporters")

    @prometheus_exporters.setter
    def prometheus_exporters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prometheus_exporters", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)

    @property
    @pulumi.getter(name="workloadIntegrationEnabled")
    def workload_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "workload_integration_enabled")

    @workload_integration_enabled.setter
    def workload_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "workload_integration_enabled", value)


@pulumi.input_type
class _K8sCredentialsState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 davis_events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_analysis_and_alerting_enabled: Optional[pulumi.Input[bool]] = None,
                 events_field_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]] = None,
                 events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 hostname_verification: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prometheus_exporters: Optional[pulumi.Input[bool]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 workload_integration_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering K8sCredentials resources.
        :param pulumi.Input[bool] active: Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[str] active_gate_group: Active Gate group to filter active gates for this credentials.
        :param pulumi.Input[str] auth_token: The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] certificate_check_enabled: The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] davis_events_integration_enabled: Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] endpoint_url: The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[bool] event_analysis_and_alerting_enabled: Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]] events_field_selectors: Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        :param pulumi.Input[bool] events_integration_enabled: Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] hostname_verification: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[str] label: The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[bool] prometheus_exporters: Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[bool] workload_integration_enabled: Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if certificate_check_enabled is not None:
            pulumi.set(__self__, "certificate_check_enabled", certificate_check_enabled)
        if davis_events_integration_enabled is not None:
            pulumi.set(__self__, "davis_events_integration_enabled", davis_events_integration_enabled)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_analysis_and_alerting_enabled is not None:
            pulumi.set(__self__, "event_analysis_and_alerting_enabled", event_analysis_and_alerting_enabled)
        if events_field_selectors is not None:
            pulumi.set(__self__, "events_field_selectors", events_field_selectors)
        if events_integration_enabled is not None:
            pulumi.set(__self__, "events_integration_enabled", events_integration_enabled)
        if hostname_verification is not None:
            pulumi.set(__self__, "hostname_verification", hostname_verification)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if prometheus_exporters is not None:
            pulumi.set(__self__, "prometheus_exporters", prometheus_exporters)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)
        if workload_integration_enabled is not None:
            pulumi.set(__self__, "workload_integration_enabled", workload_integration_enabled)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        Active Gate group to filter active gates for this credentials.
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "certificate_check_enabled")

    @certificate_check_enabled.setter
    def certificate_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "certificate_check_enabled", value)

    @property
    @pulumi.getter(name="davisEventsIntegrationEnabled")
    def davis_events_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "davis_events_integration_enabled")

    @davis_events_integration_enabled.setter
    def davis_events_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "davis_events_integration_enabled", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="eventAnalysisAndAlertingEnabled")
    def event_analysis_and_alerting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "event_analysis_and_alerting_enabled")

    @event_analysis_and_alerting_enabled.setter
    def event_analysis_and_alerting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_analysis_and_alerting_enabled", value)

    @property
    @pulumi.getter(name="eventsFieldSelectors")
    def events_field_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]]:
        """
        Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        """
        return pulumi.get(self, "events_field_selectors")

    @events_field_selectors.setter
    def events_field_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCredentialsEventsFieldSelectorArgs']]]]):
        pulumi.set(self, "events_field_selectors", value)

    @property
    @pulumi.getter(name="eventsIntegrationEnabled")
    def events_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "events_integration_enabled")

    @events_integration_enabled.setter
    def events_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "events_integration_enabled", value)

    @property
    @pulumi.getter(name="hostnameVerification")
    def hostname_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification")

    @hostname_verification.setter
    def hostname_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hostname_verification", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="prometheusExporters")
    def prometheus_exporters(self) -> Optional[pulumi.Input[bool]]:
        """
        Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "prometheus_exporters")

    @prometheus_exporters.setter
    def prometheus_exporters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prometheus_exporters", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)

    @property
    @pulumi.getter(name="workloadIntegrationEnabled")
    def workload_integration_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "workload_integration_enabled")

    @workload_integration_enabled.setter
    def workload_integration_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "workload_integration_enabled", value)


class K8sCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 davis_events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_analysis_and_alerting_enabled: Optional[pulumi.Input[bool]] = None,
                 events_field_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCredentialsEventsFieldSelectorArgs', 'K8sCredentialsEventsFieldSelectorArgsDict']]]]] = None,
                 events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 hostname_verification: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prometheus_exporters: Optional[pulumi.Input[bool]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 workload_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a K8sCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[str] active_gate_group: Active Gate group to filter active gates for this credentials.
        :param pulumi.Input[str] auth_token: The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] certificate_check_enabled: The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] davis_events_integration_enabled: Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] endpoint_url: The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[bool] event_analysis_and_alerting_enabled: Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sCredentialsEventsFieldSelectorArgs', 'K8sCredentialsEventsFieldSelectorArgsDict']]]] events_field_selectors: Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        :param pulumi.Input[bool] events_integration_enabled: Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] hostname_verification: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[str] label: The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[bool] prometheus_exporters: Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[bool] workload_integration_enabled: Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a K8sCredentials resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param K8sCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
                 davis_events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 event_analysis_and_alerting_enabled: Optional[pulumi.Input[bool]] = None,
                 events_field_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCredentialsEventsFieldSelectorArgs', 'K8sCredentialsEventsFieldSelectorArgsDict']]]]] = None,
                 events_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 hostname_verification: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 prometheus_exporters: Optional[pulumi.Input[bool]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 workload_integration_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sCredentialsArgs.__new__(K8sCredentialsArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["active_gate_group"] = active_gate_group
            __props__.__dict__["auth_token"] = None if auth_token is None else pulumi.Output.secret(auth_token)
            __props__.__dict__["certificate_check_enabled"] = certificate_check_enabled
            __props__.__dict__["davis_events_integration_enabled"] = davis_events_integration_enabled
            __props__.__dict__["endpoint_url"] = endpoint_url
            __props__.__dict__["event_analysis_and_alerting_enabled"] = event_analysis_and_alerting_enabled
            __props__.__dict__["events_field_selectors"] = events_field_selectors
            __props__.__dict__["events_integration_enabled"] = events_integration_enabled
            __props__.__dict__["hostname_verification"] = hostname_verification
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["prometheus_exporters"] = prometheus_exporters
            __props__.__dict__["unknowns"] = unknowns
            __props__.__dict__["workload_integration_enabled"] = workload_integration_enabled
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(K8sCredentials, __self__).__init__(
            'dynatrace:index/k8sCredentials:K8sCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            active_gate_group: Optional[pulumi.Input[str]] = None,
            auth_token: Optional[pulumi.Input[str]] = None,
            certificate_check_enabled: Optional[pulumi.Input[bool]] = None,
            davis_events_integration_enabled: Optional[pulumi.Input[bool]] = None,
            endpoint_url: Optional[pulumi.Input[str]] = None,
            event_analysis_and_alerting_enabled: Optional[pulumi.Input[bool]] = None,
            events_field_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCredentialsEventsFieldSelectorArgs', 'K8sCredentialsEventsFieldSelectorArgsDict']]]]] = None,
            events_integration_enabled: Optional[pulumi.Input[bool]] = None,
            hostname_verification: Optional[pulumi.Input[bool]] = None,
            label: Optional[pulumi.Input[str]] = None,
            prometheus_exporters: Optional[pulumi.Input[bool]] = None,
            unknowns: Optional[pulumi.Input[str]] = None,
            workload_integration_enabled: Optional[pulumi.Input[bool]] = None) -> 'K8sCredentials':
        """
        Get an existing K8sCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[str] active_gate_group: Active Gate group to filter active gates for this credentials.
        :param pulumi.Input[str] auth_token: The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] certificate_check_enabled: The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] davis_events_integration_enabled: Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] endpoint_url: The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        :param pulumi.Input[bool] event_analysis_and_alerting_enabled: Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sCredentialsEventsFieldSelectorArgs', 'K8sCredentialsEventsFieldSelectorArgsDict']]]] events_field_selectors: Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        :param pulumi.Input[bool] events_integration_enabled: Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        :param pulumi.Input[bool] hostname_verification: Verify hostname in certificate against Kubernetes API URL
        :param pulumi.Input[str] label: The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        :param pulumi.Input[bool] prometheus_exporters: Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        :param pulumi.Input[str] unknowns: Any attributes that aren't yet supported by this provider
        :param pulumi.Input[bool] workload_integration_enabled: Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sCredentialsState.__new__(_K8sCredentialsState)

        __props__.__dict__["active"] = active
        __props__.__dict__["active_gate_group"] = active_gate_group
        __props__.__dict__["auth_token"] = auth_token
        __props__.__dict__["certificate_check_enabled"] = certificate_check_enabled
        __props__.__dict__["davis_events_integration_enabled"] = davis_events_integration_enabled
        __props__.__dict__["endpoint_url"] = endpoint_url
        __props__.__dict__["event_analysis_and_alerting_enabled"] = event_analysis_and_alerting_enabled
        __props__.__dict__["events_field_selectors"] = events_field_selectors
        __props__.__dict__["events_integration_enabled"] = events_integration_enabled
        __props__.__dict__["hostname_verification"] = hostname_verification
        __props__.__dict__["label"] = label
        __props__.__dict__["prometheus_exporters"] = prometheus_exporters
        __props__.__dict__["unknowns"] = unknowns
        __props__.__dict__["workload_integration_enabled"] = workload_integration_enabled
        return K8sCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        Monitoring is enabled (`true`) or disabled (`false`) for given credentials configuration.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> pulumi.Output[Optional[str]]:
        """
        Active Gate group to filter active gates for this credentials.
        """
        return pulumi.get(self, "active_gate_group")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[str]]:
        """
        The service account bearer token for the Kubernetes API server.  Submit your token on creation or update of the configuration. For security reasons, GET requests return this field as `null`.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="certificateCheckEnabled")
    def certificate_check_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The check of SSL certificates is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.  If not set on creation, the `true` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "certificate_check_enabled")

    @property
    @pulumi.getter(name="davisEventsIntegrationEnabled")
    def davis_events_integration_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Inclusion of all Davis relevant events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "davis_events_integration_enabled")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the Kubernetes API server.  It must be unique within a Dynatrace environment.  The URL must valid according to RFC 2396. Leading or trailing whitespaces are not allowed.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="eventAnalysisAndAlertingEnabled")
    def event_analysis_and_alerting_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Event analysis and alerting is (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "event_analysis_and_alerting_enabled")

    @property
    @pulumi.getter(name="eventsFieldSelectors")
    def events_field_selectors(self) -> pulumi.Output[Optional[Sequence['outputs.K8sCredentialsEventsFieldSelector']]]:
        """
        Kubernetes event filters based on field-selectors. If set to `null` on creation, no events field selectors are subscribed. If set to `null` on update, no change of stored events field selectors is applied. Set an empty list to clear all events field selectors.
        """
        return pulumi.get(self, "events_field_selectors")

    @property
    @pulumi.getter(name="eventsIntegrationEnabled")
    def events_integration_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Monitoring of events is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. Event monitoring depends on the active state of this configuration to be true.  If not set on creation, the `false` value is used.  If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "events_integration_enabled")

    @property
    @pulumi.getter(name="hostnameVerification")
    def hostname_verification(self) -> pulumi.Output[Optional[bool]]:
        """
        Verify hostname in certificate against Kubernetes API URL
        """
        return pulumi.get(self, "hostname_verification")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        The name of the Kubernetes credentials configuration.  Allowed characters are letters, numbers, whitespaces, and the following characters: `.+-_`. Leading or trailing whitespace is not allowed.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="prometheusExporters")
    def prometheus_exporters(self) -> pulumi.Output[Optional[bool]]:
        """
        Prometheus exporters integration is enabled (`true`) or disabled (`false`) for the Kubernetes cluster.If the field is omitted during an update, the old value remains unaffected
        """
        return pulumi.get(self, "prometheus_exporters")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[str]]:
        """
        Any attributes that aren't yet supported by this provider
        """
        return pulumi.get(self, "unknowns")

    @property
    @pulumi.getter(name="workloadIntegrationEnabled")
    def workload_integration_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Workload and cloud application processing is enabled (`true`) or disabled (`false`) for the Kubernetes cluster. If the field is omitted during an update, the old value remains unaffected.
        """
        return pulumi.get(self, "workload_integration_enabled")

