# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['JsonDashboardArgs', 'JsonDashboard']

@pulumi.input_type
class JsonDashboardArgs:
    def __init__(__self__, *,
                 contents: pulumi.Input[str],
                 link_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a JsonDashboard resource.
        :param pulumi.Input[str] contents: Contains the JSON Code of the Dashboard
        :param pulumi.Input[str] link_id: ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        pulumi.set(__self__, "contents", contents)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)

    @property
    @pulumi.getter
    def contents(self) -> pulumi.Input[str]:
        """
        Contains the JSON Code of the Dashboard
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: pulumi.Input[str]):
        pulumi.set(self, "contents", value)

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_id", value)


@pulumi.input_type
class _JsonDashboardState:
    def __init__(__self__, *,
                 contents: Optional[pulumi.Input[str]] = None,
                 link_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering JsonDashboard resources.
        :param pulumi.Input[str] contents: Contains the JSON Code of the Dashboard
        :param pulumi.Input[str] link_id: ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        if contents is not None:
            pulumi.set(__self__, "contents", contents)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)

    @property
    @pulumi.getter
    def contents(self) -> Optional[pulumi.Input[str]]:
        """
        Contains the JSON Code of the Dashboard
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contents", value)

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_id", value)


class JsonDashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contents: Optional[pulumi.Input[str]] = None,
                 link_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a JsonDashboard resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contents: Contains the JSON Code of the Dashboard
        :param pulumi.Input[str] link_id: ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JsonDashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a JsonDashboard resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param JsonDashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JsonDashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contents: Optional[pulumi.Input[str]] = None,
                 link_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JsonDashboardArgs.__new__(JsonDashboardArgs)

            if contents is None and not opts.urn:
                raise TypeError("Missing required property 'contents'")
            __props__.__dict__["contents"] = contents
            __props__.__dict__["link_id"] = link_id
        super(JsonDashboard, __self__).__init__(
            'dynatrace:index/jsonDashboard:JsonDashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contents: Optional[pulumi.Input[str]] = None,
            link_id: Optional[pulumi.Input[str]] = None) -> 'JsonDashboard':
        """
        Get an existing JsonDashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contents: Contains the JSON Code of the Dashboard
        :param pulumi.Input[str] link_id: ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JsonDashboardState.__new__(_JsonDashboardState)

        __props__.__dict__["contents"] = contents
        __props__.__dict__["link_id"] = link_id
        return JsonDashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def contents(self) -> pulumi.Output[str]:
        """
        Contains the JSON Code of the Dashboard
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> pulumi.Output[str]:
        """
        ID of the dashboard, used with the json*dashboard*base resource and variables to create circular dependencies between dashboards for hyperlinks. See the documentation for `JsonDashboardBase` for a concrete example.
        """
        return pulumi.get(self, "link_id")

