# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IssueTrackingArgs', 'IssueTracking']

@pulumi.input_type
class IssueTrackingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 issuelabel: pulumi.Input[str],
                 issuequery: pulumi.Input[str],
                 issuetheme: pulumi.Input[str],
                 issuetrackersystem: pulumi.Input[str],
                 url: pulumi.Input[str],
                 username: pulumi.Input[str],
                 insert_after: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IssueTracking resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] issuelabel: Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        :param pulumi.Input[str] issuequery: You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        :param pulumi.Input[str] issuetheme: Possible Values: `ERROR`, `INFO`, `RESOLVED`
        :param pulumi.Input[str] issuetrackersystem: Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        :param pulumi.Input[str] url: For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        :param pulumi.Input[str] username: Username
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] password: Password
        :param pulumi.Input[str] token: Token
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "issuelabel", issuelabel)
        pulumi.set(__self__, "issuequery", issuequery)
        pulumi.set(__self__, "issuetheme", issuetheme)
        pulumi.set(__self__, "issuetrackersystem", issuetrackersystem)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def issuelabel(self) -> pulumi.Input[str]:
        """
        Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        """
        return pulumi.get(self, "issuelabel")

    @issuelabel.setter
    def issuelabel(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuelabel", value)

    @property
    @pulumi.getter
    def issuequery(self) -> pulumi.Input[str]:
        """
        You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        """
        return pulumi.get(self, "issuequery")

    @issuequery.setter
    def issuequery(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuequery", value)

    @property
    @pulumi.getter
    def issuetheme(self) -> pulumi.Input[str]:
        """
        Possible Values: `ERROR`, `INFO`, `RESOLVED`
        """
        return pulumi.get(self, "issuetheme")

    @issuetheme.setter
    def issuetheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuetheme", value)

    @property
    @pulumi.getter
    def issuetrackersystem(self) -> pulumi.Input[str]:
        """
        Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        """
        return pulumi.get(self, "issuetrackersystem")

    @issuetrackersystem.setter
    def issuetrackersystem(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuetrackersystem", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class _IssueTrackingState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 issuelabel: Optional[pulumi.Input[str]] = None,
                 issuequery: Optional[pulumi.Input[str]] = None,
                 issuetheme: Optional[pulumi.Input[str]] = None,
                 issuetrackersystem: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IssueTracking resources.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] issuelabel: Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        :param pulumi.Input[str] issuequery: You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        :param pulumi.Input[str] issuetheme: Possible Values: `ERROR`, `INFO`, `RESOLVED`
        :param pulumi.Input[str] issuetrackersystem: Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        :param pulumi.Input[str] password: Password
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] url: For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        :param pulumi.Input[str] username: Username
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if issuelabel is not None:
            pulumi.set(__self__, "issuelabel", issuelabel)
        if issuequery is not None:
            pulumi.set(__self__, "issuequery", issuequery)
        if issuetheme is not None:
            pulumi.set(__self__, "issuetheme", issuetheme)
        if issuetrackersystem is not None:
            pulumi.set(__self__, "issuetrackersystem", issuetrackersystem)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def issuelabel(self) -> Optional[pulumi.Input[str]]:
        """
        Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        """
        return pulumi.get(self, "issuelabel")

    @issuelabel.setter
    def issuelabel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuelabel", value)

    @property
    @pulumi.getter
    def issuequery(self) -> Optional[pulumi.Input[str]]:
        """
        You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        """
        return pulumi.get(self, "issuequery")

    @issuequery.setter
    def issuequery(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuequery", value)

    @property
    @pulumi.getter
    def issuetheme(self) -> Optional[pulumi.Input[str]]:
        """
        Possible Values: `ERROR`, `INFO`, `RESOLVED`
        """
        return pulumi.get(self, "issuetheme")

    @issuetheme.setter
    def issuetheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuetheme", value)

    @property
    @pulumi.getter
    def issuetrackersystem(self) -> Optional[pulumi.Input[str]]:
        """
        Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        """
        return pulumi.get(self, "issuetrackersystem")

    @issuetrackersystem.setter
    def issuetrackersystem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuetrackersystem", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class IssueTracking(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 issuelabel: Optional[pulumi.Input[str]] = None,
                 issuequery: Optional[pulumi.Input[str]] = None,
                 issuetheme: Optional[pulumi.Input[str]] = None,
                 issuetrackersystem: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IssueTracking resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] issuelabel: Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        :param pulumi.Input[str] issuequery: You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        :param pulumi.Input[str] issuetheme: Possible Values: `ERROR`, `INFO`, `RESOLVED`
        :param pulumi.Input[str] issuetrackersystem: Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        :param pulumi.Input[str] password: Password
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] url: For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        :param pulumi.Input[str] username: Username
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IssueTrackingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IssueTracking resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IssueTrackingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IssueTrackingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 issuelabel: Optional[pulumi.Input[str]] = None,
                 issuequery: Optional[pulumi.Input[str]] = None,
                 issuetheme: Optional[pulumi.Input[str]] = None,
                 issuetrackersystem: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IssueTrackingArgs.__new__(IssueTrackingArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["insert_after"] = insert_after
            if issuelabel is None and not opts.urn:
                raise TypeError("Missing required property 'issuelabel'")
            __props__.__dict__["issuelabel"] = issuelabel
            if issuequery is None and not opts.urn:
                raise TypeError("Missing required property 'issuequery'")
            __props__.__dict__["issuequery"] = issuequery
            if issuetheme is None and not opts.urn:
                raise TypeError("Missing required property 'issuetheme'")
            __props__.__dict__["issuetheme"] = issuetheme
            if issuetrackersystem is None and not opts.urn:
                raise TypeError("Missing required property 'issuetrackersystem'")
            __props__.__dict__["issuetrackersystem"] = issuetrackersystem
            __props__.__dict__["password"] = password
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IssueTracking, __self__).__init__(
            'dynatrace:index/issueTracking:IssueTracking',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            insert_after: Optional[pulumi.Input[str]] = None,
            issuelabel: Optional[pulumi.Input[str]] = None,
            issuequery: Optional[pulumi.Input[str]] = None,
            issuetheme: Optional[pulumi.Input[str]] = None,
            issuetrackersystem: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'IssueTracking':
        """
        Get an existing IssueTracking resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] issuelabel: Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        :param pulumi.Input[str] issuequery: You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        :param pulumi.Input[str] issuetheme: Possible Values: `ERROR`, `INFO`, `RESOLVED`
        :param pulumi.Input[str] issuetrackersystem: Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        :param pulumi.Input[str] password: Password
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] url: For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        :param pulumi.Input[str] username: Username
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IssueTrackingState.__new__(_IssueTrackingState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["issuelabel"] = issuelabel
        __props__.__dict__["issuequery"] = issuequery
        __props__.__dict__["issuetheme"] = issuetheme
        __props__.__dict__["issuetrackersystem"] = issuetrackersystem
        __props__.__dict__["password"] = password
        __props__.__dict__["token"] = token
        __props__.__dict__["url"] = url
        __props__.__dict__["username"] = username
        return IssueTracking(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def issuelabel(self) -> pulumi.Output[str]:
        """
        Set a label to identify these issues, for example, `release_blocker` or `non-critical`
        """
        return pulumi.get(self, "issuelabel")

    @property
    @pulumi.getter
    def issuequery(self) -> pulumi.Output[str]:
        """
        You can use the following placeholders to automatically insert values from the **Release monitoring** page in your query: `{NAME}`, `{VERSION}`, `{STAGE}`, `{PRODUCT}`.
        """
        return pulumi.get(self, "issuequery")

    @property
    @pulumi.getter
    def issuetheme(self) -> pulumi.Output[str]:
        """
        Possible Values: `ERROR`, `INFO`, `RESOLVED`
        """
        return pulumi.get(self, "issuetheme")

    @property
    @pulumi.getter
    def issuetrackersystem(self) -> pulumi.Output[str]:
        """
        Possible Values: `GITHUB`, `GITLAB`, `JIRA`, `JIRA_CLOUD`, `JIRA_ON_PREMISE`, `SERVICENOW`
        """
        return pulumi.get(self, "issuetrackersystem")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        For Jira, use the base URL (for example, https://jira.yourcompany.com); for GitHub, use the repository URL (for example, https://github.com/org/repo); for GitLab, use the specific project API for a single project (for example, https://gitlab.com/api/v4/projects/:projectId), and the specific group API for a multiple projects (for example, https://gitlab.com/api/v4/groups/:groupId); for ServiceNow, use your company instance URL (for example, https://yourinstance.service-now.com/)
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username
        """
        return pulumi.get(self, "username")

