# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IamPolicyArgs', 'IamPolicy']

@pulumi.input_type
class IamPolicyArgs:
    def __init__(__self__, *,
                 statement_query: pulumi.Input[str],
                 account: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IamPolicy resource.
        :param pulumi.Input[str] statement_query: The Statement Query of the policy
        :param pulumi.Input[str] account: The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        :param pulumi.Input[str] description: An optional description text for the policy
        :param pulumi.Input[str] environment: The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        :param pulumi.Input[str] name: The name of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for this policy
        """
        pulumi.set(__self__, "statement_query", statement_query)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            warnings.warn("""Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""", DeprecationWarning)
            pulumi.log.warn("""environment is deprecated: Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""")
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> pulumi.Input[str]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @statement_query.setter
    def statement_query(self, value: pulumi.Input[str]):
        pulumi.set(self, "statement_query", value)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""")
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IamPolicyState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 statement_query: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IamPolicy resources.
        :param pulumi.Input[str] account: The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        :param pulumi.Input[str] description: An optional description text for the policy
        :param pulumi.Input[str] environment: The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        :param pulumi.Input[str] name: The name of the policy
        :param pulumi.Input[str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for this policy
        :param pulumi.Input[str] uuid: The ID of this resource is a concatenation of multiple pieces of information (policy UUID, accountID, environmentID, ...). There are use cases where you JUST need the UUID of the Policy, though
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            warnings.warn("""Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""", DeprecationWarning)
            pulumi.log.warn("""environment is deprecated: Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""")
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statement_query is not None:
            pulumi.set(__self__, "statement_query", statement_query)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""")
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> Optional[pulumi.Input[str]]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @statement_query.setter
    def statement_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_query", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of this resource is a concatenation of multiple pieces of information (policy UUID, accountID, environmentID, ...). There are use cases where you JUST need the UUID of the Policy, though
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


class IamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 statement_query: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace IAM Policy Management - https://docs.dynatrace.com/docs/manage/identity-access-management/permission-management/manage-user-permissions-policies

        - Settings API - https://www.dynatrace.com/support/help/how-to-use-dynatrace/user-management-and-sso/manage-groups-and-permissions/iam/iam-getting-started

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        policy = dynatrace.IamPolicy("policy",
            environment="siz654##",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"string\\";")
        ```

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        policy = dynatrace.IamPolicy("policy",
            account="########-####-####-####-############",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"string\\";")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        :param pulumi.Input[str] description: An optional description text for the policy
        :param pulumi.Input[str] environment: The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        :param pulumi.Input[str] name: The name of the policy
        :param pulumi.Input[str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for this policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Allow IAM policy configuration for environments** (`iam-policies-management`) and **View environments** (`account-env-read`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace IAM Policy Management - https://docs.dynatrace.com/docs/manage/identity-access-management/permission-management/manage-user-permissions-policies

        - Settings API - https://www.dynatrace.com/support/help/how-to-use-dynatrace/user-management-and-sso/manage-groups-and-permissions/iam/iam-getting-started

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        policy = dynatrace.IamPolicy("policy",
            environment="siz654##",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"string\\";")
        ```

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        policy = dynatrace.IamPolicy("policy",
            account="########-####-####-####-############",
            statement_query="ALLOW settings:objects:read, settings:schemas:read WHERE settings:schemaId = \\"string\\";")
        ```

        :param str resource_name: The name of the resource.
        :param IamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 statement_query: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamPolicyArgs.__new__(IamPolicyArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["name"] = name
            if statement_query is None and not opts.urn:
                raise TypeError("Missing required property 'statement_query'")
            __props__.__dict__["statement_query"] = statement_query
            __props__.__dict__["tags"] = tags
            __props__.__dict__["uuid"] = None
        super(IamPolicy, __self__).__init__(
            'dynatrace:index/iamPolicy:IamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            statement_query: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            uuid: Optional[pulumi.Input[str]] = None) -> 'IamPolicy':
        """
        Get an existing IamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        :param pulumi.Input[str] description: An optional description text for the policy
        :param pulumi.Input[str] environment: The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        :param pulumi.Input[str] name: The name of the policy
        :param pulumi.Input[str] statement_query: The Statement Query of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for this policy
        :param pulumi.Input[str] uuid: The ID of this resource is a concatenation of multiple pieces of information (policy UUID, accountID, environmentID, ...). There are use cases where you JUST need the UUID of the Policy, though
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamPolicyState.__new__(_IamPolicyState)

        __props__.__dict__["account"] = account
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["name"] = name
        __props__.__dict__["statement_query"] = statement_query
        __props__.__dict__["tags"] = tags
        __props__.__dict__["uuid"] = uuid
        return IamPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID of the account (`urn:dtaccount:<account-uuid>`) in case the policy should be applied to all environments of this account. The prefix `urn:dtaccount:` MUST be omitted here.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description text for the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Configuring policies on environment level has been deprecated by Dynatrace. Please consider creating an account wide policy instead""")
    def environment(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the environment (https://\\n\\n.live.dynatrace.com) if the policy should be applied to a specific environment
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="statementQuery")
    def statement_query(self) -> pulumi.Output[str]:
        """
        The Statement Query of the policy
        """
        return pulumi.get(self, "statement_query")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags for this policy
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        The ID of this resource is a concatenation of multiple pieces of information (policy UUID, accountID, environmentID, ...). There are use cases where you JUST need the UUID of the Policy, though
        """
        return pulumi.get(self, "uuid")

