# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['HubExtensionConfigArgs', 'HubExtensionConfig']

@pulumi.input_type
class HubExtensionConfigArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_group: Optional[pulumi.Input[str]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HubExtensionConfig resource.
        :param pulumi.Input[str] value: The JSON encoded value for this monitoring configuration
        :param pulumi.Input[str] active_gate_group: The name of the Active Gate Group this monitoring configuration will be defined for
        :param pulumi.Input[str] host: The ID of the host this monitoring configuration will be defined for
        :param pulumi.Input[str] host_group: The ID of the host group this monitoring configuration will be defined for
        :param pulumi.Input[str] management_zone: The name of the Management Zone this monitoring configuration will be defined for
        :param pulumi.Input[str] name: The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        """
        pulumi.set(__self__, "value", value)
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_group is not None:
            pulumi.set(__self__, "host_group", host_group)
        if management_zone is not None:
            pulumi.set(__self__, "management_zone", management_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The JSON encoded value for this monitoring configuration
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Active Gate Group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="hostGroup")
    def host_group(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host_group")

    @host_group.setter
    def host_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_group", value)

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Management Zone this monitoring configuration will be defined for
        """
        return pulumi.get(self, "management_zone")

    @management_zone.setter
    def management_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HubExtensionConfigState:
    def __init__(__self__, *,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_group: Optional[pulumi.Input[str]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HubExtensionConfig resources.
        :param pulumi.Input[str] active_gate_group: The name of the Active Gate Group this monitoring configuration will be defined for
        :param pulumi.Input[str] host: The ID of the host this monitoring configuration will be defined for
        :param pulumi.Input[str] host_group: The ID of the host group this monitoring configuration will be defined for
        :param pulumi.Input[str] management_zone: The name of the Management Zone this monitoring configuration will be defined for
        :param pulumi.Input[str] name: The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        :param pulumi.Input[str] value: The JSON encoded value for this monitoring configuration
        """
        if active_gate_group is not None:
            pulumi.set(__self__, "active_gate_group", active_gate_group)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_group is not None:
            pulumi.set(__self__, "host_group", host_group)
        if management_zone is not None:
            pulumi.set(__self__, "management_zone", management_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Active Gate Group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "active_gate_group")

    @active_gate_group.setter
    def active_gate_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_gate_group", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="hostGroup")
    def host_group(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the host group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host_group")

    @host_group.setter
    def host_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_group", value)

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Management Zone this monitoring configuration will be defined for
        """
        return pulumi.get(self, "management_zone")

    @management_zone.setter
    def management_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON encoded value for this monitoring configuration
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class HubExtensionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_group: Optional[pulumi.Input[str]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a HubExtensionConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_gate_group: The name of the Active Gate Group this monitoring configuration will be defined for
        :param pulumi.Input[str] host: The ID of the host this monitoring configuration will be defined for
        :param pulumi.Input[str] host_group: The ID of the host group this monitoring configuration will be defined for
        :param pulumi.Input[str] management_zone: The name of the Management Zone this monitoring configuration will be defined for
        :param pulumi.Input[str] name: The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        :param pulumi.Input[str] value: The JSON encoded value for this monitoring configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubExtensionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a HubExtensionConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param HubExtensionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubExtensionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_gate_group: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_group: Optional[pulumi.Input[str]] = None,
                 management_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubExtensionConfigArgs.__new__(HubExtensionConfigArgs)

            __props__.__dict__["active_gate_group"] = active_gate_group
            __props__.__dict__["host"] = host
            __props__.__dict__["host_group"] = host_group
            __props__.__dict__["management_zone"] = management_zone
            __props__.__dict__["name"] = name
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(HubExtensionConfig, __self__).__init__(
            'dynatrace:index/hubExtensionConfig:HubExtensionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_gate_group: Optional[pulumi.Input[str]] = None,
            host: Optional[pulumi.Input[str]] = None,
            host_group: Optional[pulumi.Input[str]] = None,
            management_zone: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'HubExtensionConfig':
        """
        Get an existing HubExtensionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_gate_group: The name of the Active Gate Group this monitoring configuration will be defined for
        :param pulumi.Input[str] host: The ID of the host this monitoring configuration will be defined for
        :param pulumi.Input[str] host_group: The ID of the host group this monitoring configuration will be defined for
        :param pulumi.Input[str] management_zone: The name of the Management Zone this monitoring configuration will be defined for
        :param pulumi.Input[str] name: The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        :param pulumi.Input[str] value: The JSON encoded value for this monitoring configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubExtensionConfigState.__new__(_HubExtensionConfigState)

        __props__.__dict__["active_gate_group"] = active_gate_group
        __props__.__dict__["host"] = host
        __props__.__dict__["host_group"] = host_group
        __props__.__dict__["management_zone"] = management_zone
        __props__.__dict__["name"] = name
        __props__.__dict__["value"] = value
        return HubExtensionConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeGateGroup")
    def active_gate_group(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Active Gate Group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "active_gate_group")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the host this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostGroup")
    def host_group(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the host group this monitoring configuration will be defined for
        """
        return pulumi.get(self, "host_group")

    @property
    @pulumi.getter(name="managementZone")
    def management_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Management Zone this monitoring configuration will be defined for
        """
        return pulumi.get(self, "management_zone")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the extension, such as `com.dynatrace.extension.jmx-liberty-cp`. You can query for these names using the data source `get_hub_items`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The JSON encoded value for this monitoring configuration
        """
        return pulumi.get(self, "value")

