# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HttpMonitorArgs', 'HttpMonitor']

@pulumi.input_type
class HttpMonitorArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[int],
                 anomaly_detections: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_script: Optional[pulumi.Input[bool]] = None,
                 script: Optional[pulumi.Input['HttpMonitorScriptArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]] = None):
        """
        The set of arguments for constructing a HttpMonitor resource.
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]] anomaly_detections: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[bool] no_script: No script block - handle requests via `HttpMonitorScript` resource
        :param pulumi.Input['HttpMonitorScriptArgs'] script: The HTTP Script
        :param pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        pulumi.set(__self__, "frequency", frequency)
        if anomaly_detections is not None:
            pulumi.set(__self__, "anomaly_detections", anomaly_detections)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if manually_assigned_apps is not None:
            pulumi.set(__self__, "manually_assigned_apps", manually_assigned_apps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_script is not None:
            pulumi.set(__self__, "no_script", no_script)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[int]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="anomalyDetections")
    def anomaly_detections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detections")

    @anomaly_detections.setter
    def anomaly_detections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]]):
        pulumi.set(self, "anomaly_detections", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @manually_assigned_apps.setter
    def manually_assigned_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manually_assigned_apps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noScript")
    def no_script(self) -> Optional[pulumi.Input[bool]]:
        """
        No script block - handle requests via `HttpMonitorScript` resource
        """
        return pulumi.get(self, "no_script")

    @no_script.setter
    def no_script(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_script", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['HttpMonitorScriptArgs']]:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['HttpMonitorScriptArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HttpMonitorState:
    def __init__(__self__, *,
                 anomaly_detections: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_script: Optional[pulumi.Input[bool]] = None,
                 script: Optional[pulumi.Input['HttpMonitorScriptArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering HttpMonitor resources.
        :param pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]] anomaly_detections: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[bool] no_script: No script block - handle requests via `HttpMonitorScript` resource
        :param pulumi.Input['HttpMonitorScriptArgs'] script: The HTTP Script
        :param pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        if anomaly_detections is not None:
            pulumi.set(__self__, "anomaly_detections", anomaly_detections)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if manually_assigned_apps is not None:
            pulumi.set(__self__, "manually_assigned_apps", manually_assigned_apps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_script is not None:
            pulumi.set(__self__, "no_script", no_script)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="anomalyDetections")
    def anomaly_detections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detections")

    @anomaly_detections.setter
    def anomaly_detections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorAnomalyDetectionArgs']]]]):
        pulumi.set(self, "anomaly_detections", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @manually_assigned_apps.setter
    def manually_assigned_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manually_assigned_apps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noScript")
    def no_script(self) -> Optional[pulumi.Input[bool]]:
        """
        No script block - handle requests via `HttpMonitorScript` resource
        """
        return pulumi.get(self, "no_script")

    @no_script.setter
    def no_script(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_script", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['HttpMonitorScriptArgs']]:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['HttpMonitorScriptArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


class HttpMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_detections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorAnomalyDetectionArgs', 'HttpMonitorAnomalyDetectionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_script: Optional[pulumi.Input[bool]] = None,
                 script: Optional[pulumi.Input[Union['HttpMonitorScriptArgs', 'HttpMonitorScriptArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorTagArgs', 'HttpMonitorTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a HttpMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorAnomalyDetectionArgs', 'HttpMonitorAnomalyDetectionArgsDict']]]] anomaly_detections: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[bool] no_script: No script block - handle requests via `HttpMonitorScript` resource
        :param pulumi.Input[Union['HttpMonitorScriptArgs', 'HttpMonitorScriptArgsDict']] script: The HTTP Script
        :param pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorTagArgs', 'HttpMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a HttpMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param HttpMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_detections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorAnomalyDetectionArgs', 'HttpMonitorAnomalyDetectionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_script: Optional[pulumi.Input[bool]] = None,
                 script: Optional[pulumi.Input[Union['HttpMonitorScriptArgs', 'HttpMonitorScriptArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorTagArgs', 'HttpMonitorTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpMonitorArgs.__new__(HttpMonitorArgs)

            __props__.__dict__["anomaly_detections"] = anomaly_detections
            __props__.__dict__["enabled"] = enabled
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["locations"] = locations
            __props__.__dict__["manually_assigned_apps"] = manually_assigned_apps
            __props__.__dict__["name"] = name
            __props__.__dict__["no_script"] = no_script
            __props__.__dict__["script"] = script
            __props__.__dict__["tags"] = tags
        super(HttpMonitor, __self__).__init__(
            'dynatrace:index/httpMonitor:HttpMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anomaly_detections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorAnomalyDetectionArgs', 'HttpMonitorAnomalyDetectionArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            no_script: Optional[pulumi.Input[bool]] = None,
            script: Optional[pulumi.Input[Union['HttpMonitorScriptArgs', 'HttpMonitorScriptArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorTagArgs', 'HttpMonitorTagArgsDict']]]]] = None) -> 'HttpMonitor':
        """
        Get an existing HttpMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorAnomalyDetectionArgs', 'HttpMonitorAnomalyDetectionArgsDict']]]] anomaly_detections: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[bool] no_script: No script block - handle requests via `HttpMonitorScript` resource
        :param pulumi.Input[Union['HttpMonitorScriptArgs', 'HttpMonitorScriptArgsDict']] script: The HTTP Script
        :param pulumi.Input[Sequence[pulumi.Input[Union['HttpMonitorTagArgs', 'HttpMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpMonitorState.__new__(_HttpMonitorState)

        __props__.__dict__["anomaly_detections"] = anomaly_detections
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["locations"] = locations
        __props__.__dict__["manually_assigned_apps"] = manually_assigned_apps
        __props__.__dict__["name"] = name
        __props__.__dict__["no_script"] = no_script
        __props__.__dict__["script"] = script
        __props__.__dict__["tags"] = tags
        return HttpMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anomalyDetections")
    def anomaly_detections(self) -> pulumi.Output[Optional[Sequence['outputs.HttpMonitorAnomalyDetection']]]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detections")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noScript")
    def no_script(self) -> pulumi.Output[Optional[bool]]:
        """
        No script block - handle requests via `HttpMonitorScript` resource
        """
        return pulumi.get(self, "no_script")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[Optional['outputs.HttpMonitorScript']]:
        """
        The HTTP Script
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.HttpMonitorTag']]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

