# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['HostMonitoringArgs', 'HostMonitoring']

@pulumi.input_type
class HostMonitoringArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 host_id: pulumi.Input[str],
                 auto_injection: Optional[pulumi.Input[bool]] = None,
                 full_stack: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a HostMonitoring resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[bool] auto_injection: An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        :param pulumi.Input[bool] full_stack: Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "host_id", host_id)
        if auto_injection is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""auto_injection is deprecated: This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""")
        if auto_injection is not None:
            pulumi.set(__self__, "auto_injection", auto_injection)
        if full_stack is not None:
            warnings.warn("""This attribute is not supported anymore by the Dynatrace API""", DeprecationWarning)
            pulumi.log.warn("""full_stack is deprecated: This attribute is not supported anymore by the Dynatrace API""")
        if full_stack is not None:
            pulumi.set(__self__, "full_stack", full_stack)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Input[str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="autoInjection")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""")
    def auto_injection(self) -> Optional[pulumi.Input[bool]]:
        """
        An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        """
        return pulumi.get(self, "auto_injection")

    @auto_injection.setter
    def auto_injection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_injection", value)

    @property
    @pulumi.getter(name="fullStack")
    @_utilities.deprecated("""This attribute is not supported anymore by the Dynatrace API""")
    def full_stack(self) -> Optional[pulumi.Input[bool]]:
        """
        Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        """
        return pulumi.get(self, "full_stack")

    @full_stack.setter
    def full_stack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_stack", value)


@pulumi.input_type
class _HostMonitoringState:
    def __init__(__self__, *,
                 auto_injection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_stack: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostMonitoring resources.
        :param pulumi.Input[bool] auto_injection: An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[bool] full_stack: Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        :param pulumi.Input[str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        if auto_injection is not None:
            warnings.warn("""This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""", DeprecationWarning)
            pulumi.log.warn("""auto_injection is deprecated: This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""")
        if auto_injection is not None:
            pulumi.set(__self__, "auto_injection", auto_injection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if full_stack is not None:
            warnings.warn("""This attribute is not supported anymore by the Dynatrace API""", DeprecationWarning)
            pulumi.log.warn("""full_stack is deprecated: This attribute is not supported anymore by the Dynatrace API""")
        if full_stack is not None:
            pulumi.set(__self__, "full_stack", full_stack)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)

    @property
    @pulumi.getter(name="autoInjection")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""")
    def auto_injection(self) -> Optional[pulumi.Input[bool]]:
        """
        An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        """
        return pulumi.get(self, "auto_injection")

    @auto_injection.setter
    def auto_injection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_injection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fullStack")
    @_utilities.deprecated("""This attribute is not supported anymore by the Dynatrace API""")
    def full_stack(self) -> Optional[pulumi.Input[bool]]:
        """
        Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        """
        return pulumi.get(self, "full_stack")

    @full_stack.setter
    def full_stack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_stack", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)


class HostMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_injection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_stack: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a HostMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_injection: An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[bool] full_stack: Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        :param pulumi.Input[str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a HostMonitoring resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param HostMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_injection: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 full_stack: Optional[pulumi.Input[bool]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostMonitoringArgs.__new__(HostMonitoringArgs)

            __props__.__dict__["auto_injection"] = auto_injection
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["full_stack"] = full_stack
            if host_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_id'")
            __props__.__dict__["host_id"] = host_id
        super(HostMonitoring, __self__).__init__(
            'dynatrace:index/hostMonitoring:HostMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_injection: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            full_stack: Optional[pulumi.Input[bool]] = None,
            host_id: Optional[pulumi.Input[str]] = None) -> 'HostMonitoring':
        """
        Get an existing HostMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_injection: An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[bool] full_stack: Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        :param pulumi.Input[str] host_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostMonitoringState.__new__(_HostMonitoringState)

        __props__.__dict__["auto_injection"] = auto_injection
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["full_stack"] = full_stack
        __props__.__dict__["host_id"] = host_id
        return HostMonitoring(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoInjection")
    @_utilities.deprecated("""This field has been moved to a new schema, please utilize the resource `HostMonitoringAdvanced` to configure this field.""")
    def auto_injection(self) -> pulumi.Output[Optional[bool]]:
        """
        An auto-injection disabled with [oneagentctl](https://dt-url.net/oneagentctl) takes precedence over this setting and cannot be changed from the Dynatrace web UI.
        """
        return pulumi.get(self, "auto_injection")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fullStack")
    @_utilities.deprecated("""This attribute is not supported anymore by the Dynatrace API""")
    def full_stack(self) -> pulumi.Output[Optional[bool]]:
        """
        Dynatrace uses full-stack monitoring by default, to monitor every aspect of your environment, including all processes, services, and applications detected on your hosts.
        """
        return pulumi.get(self, "full_stack")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[str]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_id")

