# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSyntheticLocationsResult',
    'AwaitableGetSyntheticLocationsResult',
    'get_synthetic_locations',
    'get_synthetic_locations_output',
]

@pulumi.output_type
class GetSyntheticLocationsResult:
    """
    A collection of values returned by getSyntheticLocations.
    """
    def __init__(__self__, id=None, locations=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, dict):
            raise TypeError("Expected argument 'locations' to be a dict")
        pulumi.set(__self__, "locations", locations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def locations(self) -> 'outputs.GetSyntheticLocationsLocationsResult':
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


class AwaitableGetSyntheticLocationsResult(GetSyntheticLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyntheticLocationsResult(
            id=self.id,
            locations=self.locations,
            name=self.name)


def get_synthetic_locations(id: Optional[str] = None,
                            locations: Optional[Union['GetSyntheticLocationsLocationsArgs', 'GetSyntheticLocationsLocationsArgsDict']] = None,
                            name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyntheticLocationsResult:
    """
    The synthetic locations data source allows the location IDs to be retrieved based off of provided parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    test = dynatrace.get_synthetic_locations(name="Sydney")
    _name_ = dynatrace.HttpMonitor("#name#",
        enabled=True,
        frequency=60,
        locations=[test.locations.entity_id],
        anomaly_detections=[{
            "loading_time_thresholds": [{
                "enabled": True,
            }],
            "outage_handlings": [{
                "global_outage": True,
                "local_outage": False,
                "retry_on_error": False,
            }],
        }],
        script={
            "requests": [{
                "description": "google.com",
                "method": "GET",
                "url": "https://www.google.com",
                "configuration": {
                    "accept_any_certificate": True,
                    "follow_redirects": True,
                },
                "validation": {
                    "rules": [{
                        "type": "httpStatusesList",
                        "pass_if_found": False,
                        "value": ">=400",
                    }],
                },
            }],
        })
    ```


    :param str id: The ID of this resource.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['locations'] = locations
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getSyntheticLocations:getSyntheticLocations', __args__, opts=opts, typ=GetSyntheticLocationsResult).value

    return AwaitableGetSyntheticLocationsResult(
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'),
        name=pulumi.get(__ret__, 'name'))
def get_synthetic_locations_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                   locations: Optional[pulumi.Input[Optional[Union['GetSyntheticLocationsLocationsArgs', 'GetSyntheticLocationsLocationsArgsDict']]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSyntheticLocationsResult]:
    """
    The synthetic locations data source allows the location IDs to be retrieved based off of provided parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    test = dynatrace.get_synthetic_locations(name="Sydney")
    _name_ = dynatrace.HttpMonitor("#name#",
        enabled=True,
        frequency=60,
        locations=[test.locations.entity_id],
        anomaly_detections=[{
            "loading_time_thresholds": [{
                "enabled": True,
            }],
            "outage_handlings": [{
                "global_outage": True,
                "local_outage": False,
                "retry_on_error": False,
            }],
        }],
        script={
            "requests": [{
                "description": "google.com",
                "method": "GET",
                "url": "https://www.google.com",
                "configuration": {
                    "accept_any_certificate": True,
                    "follow_redirects": True,
                },
                "validation": {
                    "rules": [{
                        "type": "httpStatusesList",
                        "pass_if_found": False,
                        "value": ">=400",
                    }],
                },
            }],
        })
    ```


    :param str id: The ID of this resource.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['locations'] = locations
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getSyntheticLocations:getSyntheticLocations', __args__, opts=opts, typ=GetSyntheticLocationsResult)
    return __ret__.apply(lambda __response__: GetSyntheticLocationsResult(
        id=pulumi.get(__response__, 'id'),
        locations=pulumi.get(__response__, 'locations'),
        name=pulumi.get(__response__, 'name')))
