# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLambdaAgentVersionResult',
    'AwaitableGetLambdaAgentVersionResult',
    'get_lambda_agent_version',
    'get_lambda_agent_version_output',
]

@pulumi.output_type
class GetLambdaAgentVersionResult:
    """
    A collection of values returned by getLambdaAgentVersion.
    """
    def __init__(__self__, collector=None, id=None, java=None, java_with_collector=None, nodejs=None, nodejs_with_collector=None, python=None, python_with_collector=None):
        if collector and not isinstance(collector, str):
            raise TypeError("Expected argument 'collector' to be a str")
        pulumi.set(__self__, "collector", collector)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java and not isinstance(java, str):
            raise TypeError("Expected argument 'java' to be a str")
        pulumi.set(__self__, "java", java)
        if java_with_collector and not isinstance(java_with_collector, str):
            raise TypeError("Expected argument 'java_with_collector' to be a str")
        pulumi.set(__self__, "java_with_collector", java_with_collector)
        if nodejs and not isinstance(nodejs, str):
            raise TypeError("Expected argument 'nodejs' to be a str")
        pulumi.set(__self__, "nodejs", nodejs)
        if nodejs_with_collector and not isinstance(nodejs_with_collector, str):
            raise TypeError("Expected argument 'nodejs_with_collector' to be a str")
        pulumi.set(__self__, "nodejs_with_collector", nodejs_with_collector)
        if python and not isinstance(python, str):
            raise TypeError("Expected argument 'python' to be a str")
        pulumi.set(__self__, "python", python)
        if python_with_collector and not isinstance(python_with_collector, str):
            raise TypeError("Expected argument 'python_with_collector' to be a str")
        pulumi.set(__self__, "python_with_collector", python_with_collector)

    @property
    @pulumi.getter
    def collector(self) -> str:
        """
        Latest version name of standalone log collector
        """
        return pulumi.get(self, "collector")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def java(self) -> str:
        """
        Latest version name of Java code module
        """
        return pulumi.get(self, "java")

    @property
    @pulumi.getter(name="javaWithCollector")
    def java_with_collector(self) -> str:
        """
        Latest version name of Java code module with log collector
        """
        return pulumi.get(self, "java_with_collector")

    @property
    @pulumi.getter
    def nodejs(self) -> str:
        """
        Latest version name of NodeJS code module
        """
        return pulumi.get(self, "nodejs")

    @property
    @pulumi.getter(name="nodejsWithCollector")
    def nodejs_with_collector(self) -> str:
        """
        Latest version name of NodeJS code module with log collector
        """
        return pulumi.get(self, "nodejs_with_collector")

    @property
    @pulumi.getter
    def python(self) -> str:
        """
        Latest version name of Python code module
        """
        return pulumi.get(self, "python")

    @property
    @pulumi.getter(name="pythonWithCollector")
    def python_with_collector(self) -> str:
        """
        Latest version name of Python code module with log collector
        """
        return pulumi.get(self, "python_with_collector")


class AwaitableGetLambdaAgentVersionResult(GetLambdaAgentVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLambdaAgentVersionResult(
            collector=self.collector,
            id=self.id,
            java=self.java,
            java_with_collector=self.java_with_collector,
            nodejs=self.nodejs,
            nodejs_with_collector=self.nodejs_with_collector,
            python=self.python,
            python_with_collector=self.python_with_collector)


def get_lambda_agent_version(collector: Optional[str] = None,
                             java: Optional[str] = None,
                             java_with_collector: Optional[str] = None,
                             nodejs: Optional[str] = None,
                             nodejs_with_collector: Optional[str] = None,
                             python: Optional[str] = None,
                             python_with_collector: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLambdaAgentVersionResult:
    """
    The AWS Lambda agent version data source retrieves the latest version names of OneAgent code modules for the Java, Node.js, and Python runtimes, also including names for layers that are combined with the log collector, as well as for the standalone log collector layer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_lambda_agent_version()
    pulumi.export("latest", example)
    ```


    :param str collector: Latest version name of standalone log collector
    :param str java: Latest version name of Java code module
    :param str java_with_collector: Latest version name of Java code module with log collector
    :param str nodejs: Latest version name of NodeJS code module
    :param str nodejs_with_collector: Latest version name of NodeJS code module with log collector
    :param str python: Latest version name of Python code module
    :param str python_with_collector: Latest version name of Python code module with log collector
    """
    __args__ = dict()
    __args__['collector'] = collector
    __args__['java'] = java
    __args__['javaWithCollector'] = java_with_collector
    __args__['nodejs'] = nodejs
    __args__['nodejsWithCollector'] = nodejs_with_collector
    __args__['python'] = python
    __args__['pythonWithCollector'] = python_with_collector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getLambdaAgentVersion:getLambdaAgentVersion', __args__, opts=opts, typ=GetLambdaAgentVersionResult).value

    return AwaitableGetLambdaAgentVersionResult(
        collector=pulumi.get(__ret__, 'collector'),
        id=pulumi.get(__ret__, 'id'),
        java=pulumi.get(__ret__, 'java'),
        java_with_collector=pulumi.get(__ret__, 'java_with_collector'),
        nodejs=pulumi.get(__ret__, 'nodejs'),
        nodejs_with_collector=pulumi.get(__ret__, 'nodejs_with_collector'),
        python=pulumi.get(__ret__, 'python'),
        python_with_collector=pulumi.get(__ret__, 'python_with_collector'))
def get_lambda_agent_version_output(collector: Optional[pulumi.Input[Optional[str]]] = None,
                                    java: Optional[pulumi.Input[Optional[str]]] = None,
                                    java_with_collector: Optional[pulumi.Input[Optional[str]]] = None,
                                    nodejs: Optional[pulumi.Input[Optional[str]]] = None,
                                    nodejs_with_collector: Optional[pulumi.Input[Optional[str]]] = None,
                                    python: Optional[pulumi.Input[Optional[str]]] = None,
                                    python_with_collector: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLambdaAgentVersionResult]:
    """
    The AWS Lambda agent version data source retrieves the latest version names of OneAgent code modules for the Java, Node.js, and Python runtimes, also including names for layers that are combined with the log collector, as well as for the standalone log collector layer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_lambda_agent_version()
    pulumi.export("latest", example)
    ```


    :param str collector: Latest version name of standalone log collector
    :param str java: Latest version name of Java code module
    :param str java_with_collector: Latest version name of Java code module with log collector
    :param str nodejs: Latest version name of NodeJS code module
    :param str nodejs_with_collector: Latest version name of NodeJS code module with log collector
    :param str python: Latest version name of Python code module
    :param str python_with_collector: Latest version name of Python code module with log collector
    """
    __args__ = dict()
    __args__['collector'] = collector
    __args__['java'] = java
    __args__['javaWithCollector'] = java_with_collector
    __args__['nodejs'] = nodejs
    __args__['nodejsWithCollector'] = nodejs_with_collector
    __args__['python'] = python
    __args__['pythonWithCollector'] = python_with_collector
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getLambdaAgentVersion:getLambdaAgentVersion', __args__, opts=opts, typ=GetLambdaAgentVersionResult)
    return __ret__.apply(lambda __response__: GetLambdaAgentVersionResult(
        collector=pulumi.get(__response__, 'collector'),
        id=pulumi.get(__response__, 'id'),
        java=pulumi.get(__response__, 'java'),
        java_with_collector=pulumi.get(__response__, 'java_with_collector'),
        nodejs=pulumi.get(__response__, 'nodejs'),
        nodejs_with_collector=pulumi.get(__response__, 'nodejs_with_collector'),
        python=pulumi.get(__response__, 'python'),
        python_with_collector=pulumi.get(__response__, 'python_with_collector')))
