# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGeoCitiesResult',
    'AwaitableGetGeoCitiesResult',
    'get_geo_cities',
    'get_geo_cities_output',
]

@pulumi.output_type
class GetGeoCitiesResult:
    """
    A collection of values returned by getGeoCities.
    """
    def __init__(__self__, cities=None, country_code=None, id=None, region_code=None):
        if cities and not isinstance(cities, list):
            raise TypeError("Expected argument 'cities' to be a list")
        pulumi.set(__self__, "cities", cities)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region_code and not isinstance(region_code, str):
            raise TypeError("Expected argument 'region_code' to be a str")
        pulumi.set(__self__, "region_code", region_code)

    @property
    @pulumi.getter
    def cities(self) -> Sequence['outputs.GetGeoCitiesCityResult']:
        return pulumi.get(self, "cities")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The ISO code of the required country
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        The code of the required region
        """
        return pulumi.get(self, "region_code")


class AwaitableGetGeoCitiesResult(GetGeoCitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGeoCitiesResult(
            cities=self.cities,
            country_code=self.country_code,
            id=self.id,
            region_code=self.region_code)


def get_geo_cities(country_code: Optional[str] = None,
                   region_code: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGeoCitiesResult:
    """
    The `get_geo_cities` data source retrieves the list of cities and their codes based on country and region code.

    - `country_code` (String) - The ISO code of the required country
    - `region_code` (String) - The code of the required region

    Geographic regions API: GET regions of a country - https://docs.dynatrace.com/docs/shortlink/api-v2-rum-geographic-regions-get-regions-country

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_geo_cities(country_code="FR",
        region_code="BRE")
    pulumi.export("test", example)
    ```


    :param str country_code: The ISO code of the required country
    :param str region_code: The code of the required region
    """
    __args__ = dict()
    __args__['countryCode'] = country_code
    __args__['regionCode'] = region_code
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getGeoCities:getGeoCities', __args__, opts=opts, typ=GetGeoCitiesResult).value

    return AwaitableGetGeoCitiesResult(
        cities=pulumi.get(__ret__, 'cities'),
        country_code=pulumi.get(__ret__, 'country_code'),
        id=pulumi.get(__ret__, 'id'),
        region_code=pulumi.get(__ret__, 'region_code'))
def get_geo_cities_output(country_code: Optional[pulumi.Input[str]] = None,
                          region_code: Optional[pulumi.Input[str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGeoCitiesResult]:
    """
    The `get_geo_cities` data source retrieves the list of cities and their codes based on country and region code.

    - `country_code` (String) - The ISO code of the required country
    - `region_code` (String) - The code of the required region

    Geographic regions API: GET regions of a country - https://docs.dynatrace.com/docs/shortlink/api-v2-rum-geographic-regions-get-regions-country

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example = dynatrace.get_geo_cities(country_code="FR",
        region_code="BRE")
    pulumi.export("test", example)
    ```


    :param str country_code: The ISO code of the required country
    :param str region_code: The code of the required region
    """
    __args__ = dict()
    __args__['countryCode'] = country_code
    __args__['regionCode'] = region_code
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getGeoCities:getGeoCities', __args__, opts=opts, typ=GetGeoCitiesResult)
    return __ret__.apply(lambda __response__: GetGeoCitiesResult(
        cities=pulumi.get(__response__, 'cities'),
        country_code=pulumi.get(__response__, 'country_code'),
        id=pulumi.get(__response__, 'id'),
        region_code=pulumi.get(__response__, 'region_code')))
