# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAutotagResult',
    'AwaitableGetAutotagResult',
    'get_autotag',
    'get_autotag_output',
]

@pulumi.output_type
class GetAutotagResult:
    """
    A collection of values returned by getAutotag.
    """
    def __init__(__self__, id=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetAutotagResult(GetAutotagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutotagResult(
            id=self.id,
            name=self.name)


def get_autotag(name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutotagResult:
    """
    The automatically applied tag data source allows the tag ID to be retrieved by its name.

    > This data source requires the API token scopes **Read settings** (`settings.read`)

    - `name` queries the automatically applied tag with the specified name

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    example_autotag = dynatrace.get_autotag(name="Terraform Example")
    example_autotag_rules = dynatrace.AutotagRules("exampleAutotagRules",
        auto_tag_id=example_autotag.id,
        rules={
            "rules": [
                {
                    "type": "ME",
                    "enabled": True,
                    "value_format": "Java",
                    "value_normalization": "Leave text as-is",
                    "attribute_rule": {
                        "entity_type": "PROCESS_GROUP",
                        "pg_to_host_propagation": True,
                        "pg_to_service_propagation": False,
                        "conditions": {
                            "conditions": [{
                                "enum_value": "JAVA",
                                "key": "PROCESS_GROUP_TECHNOLOGY",
                                "operator": "EQUALS",
                            }],
                        },
                    },
                },
                {
                    "type": "ME",
                    "enabled": True,
                    "value_format": ".NET",
                    "value_normalization": "Leave text as-is",
                    "attribute_rule": {
                        "entity_type": "PROCESS_GROUP",
                        "pg_to_host_propagation": True,
                        "pg_to_service_propagation": False,
                        "conditions": {
                            "conditions": [{
                                "enum_value": "DOTNET",
                                "key": "PROCESS_GROUP_TECHNOLOGY",
                                "operator": "EQUALS",
                            }],
                        },
                    },
                },
            ],
        })
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getAutotag:getAutotag', __args__, opts=opts, typ=GetAutotagResult).value

    return AwaitableGetAutotagResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_autotag_output(name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutotagResult]:
    """
    The automatically applied tag data source allows the tag ID to be retrieved by its name.

    > This data source requires the API token scopes **Read settings** (`settings.read`)

    - `name` queries the automatically applied tag with the specified name

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace
    import pulumiverse_dynatrace as dynatrace

    example_autotag = dynatrace.get_autotag(name="Terraform Example")
    example_autotag_rules = dynatrace.AutotagRules("exampleAutotagRules",
        auto_tag_id=example_autotag.id,
        rules={
            "rules": [
                {
                    "type": "ME",
                    "enabled": True,
                    "value_format": "Java",
                    "value_normalization": "Leave text as-is",
                    "attribute_rule": {
                        "entity_type": "PROCESS_GROUP",
                        "pg_to_host_propagation": True,
                        "pg_to_service_propagation": False,
                        "conditions": {
                            "conditions": [{
                                "enum_value": "JAVA",
                                "key": "PROCESS_GROUP_TECHNOLOGY",
                                "operator": "EQUALS",
                            }],
                        },
                    },
                },
                {
                    "type": "ME",
                    "enabled": True,
                    "value_format": ".NET",
                    "value_normalization": "Leave text as-is",
                    "attribute_rule": {
                        "entity_type": "PROCESS_GROUP",
                        "pg_to_host_propagation": True,
                        "pg_to_service_propagation": False,
                        "conditions": {
                            "conditions": [{
                                "enum_value": "DOTNET",
                                "key": "PROCESS_GROUP_TECHNOLOGY",
                                "operator": "EQUALS",
                            }],
                        },
                    },
                },
            ],
        })
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getAutotag:getAutotag', __args__, opts=opts, typ=GetAutotagResult)
    return __ret__.apply(lambda __response__: GetAutotagResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
