# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetApiTokenResult',
    'AwaitableGetApiTokenResult',
    'get_api_token',
    'get_api_token_output',
]

@pulumi.output_type
class GetApiTokenResult:
    """
    A collection of values returned by getApiToken.
    """
    def __init__(__self__, creation_date=None, enabled=None, expiration_date=None, id=None, name=None, owner=None, personal_access_token=None, scopes=None):
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if personal_access_token and not isinstance(personal_access_token, bool):
            raise TypeError("Expected argument 'personal_access_token' to be a bool")
        pulumi.set(__self__, "personal_access_token", personal_access_token)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        Token creation date in ISO 8601 format (yyyy-MM-dd'T'HH:mm:ss.SSS'Z')
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The token is enabled (true) or disabled (false), default disabled (false).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        The expiration date of the token.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The owner of the token
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> bool:
        """
        The token is a personal access token (true) or an API token (false).
        """
        return pulumi.get(self, "personal_access_token")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        A list of the scopes to be assigned to the token.
        """
        return pulumi.get(self, "scopes")


class AwaitableGetApiTokenResult(GetApiTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiTokenResult(
            creation_date=self.creation_date,
            enabled=self.enabled,
            expiration_date=self.expiration_date,
            id=self.id,
            name=self.name,
            owner=self.owner,
            personal_access_token=self.personal_access_token,
            scopes=self.scopes)


def get_api_token(name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiTokenResult:
    """
    The API token data source allows a single access token to be retrieved by its name, note the token value is not included in the response.

    If multiple tokens match the given name, the first result will be retrieved. To retrieve multiple tokens of the same name, please utilize the `get_api_tokens` data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example_api_token = dynatrace.get_api_token(name="Terraform")
    pulumi.export("example", example_api_token)
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dynatrace:index/getApiToken:getApiToken', __args__, opts=opts, typ=GetApiTokenResult).value

    return AwaitableGetApiTokenResult(
        creation_date=pulumi.get(__ret__, 'creation_date'),
        enabled=pulumi.get(__ret__, 'enabled'),
        expiration_date=pulumi.get(__ret__, 'expiration_date'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        personal_access_token=pulumi.get(__ret__, 'personal_access_token'),
        scopes=pulumi.get(__ret__, 'scopes'))
def get_api_token_output(name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiTokenResult]:
    """
    The API token data source allows a single access token to be retrieved by its name, note the token value is not included in the response.

    If multiple tokens match the given name, the first result will be retrieved. To retrieve multiple tokens of the same name, please utilize the `get_api_tokens` data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dynatrace as dynatrace

    example_api_token = dynatrace.get_api_token(name="Terraform")
    pulumi.export("example", example_api_token)
    ```
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dynatrace:index/getApiToken:getApiToken', __args__, opts=opts, typ=GetApiTokenResult)
    return __ret__.apply(lambda __response__: GetApiTokenResult(
        creation_date=pulumi.get(__response__, 'creation_date'),
        enabled=pulumi.get(__response__, 'enabled'),
        expiration_date=pulumi.get(__response__, 'expiration_date'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        personal_access_token=pulumi.get(__response__, 'personal_access_token'),
        scopes=pulumi.get(__response__, 'scopes')))
