# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 state: pulumi.Input[str],
                 storage: pulumi.Input['EnvironmentStorageArgs'],
                 name: Optional[pulumi.Input[str]] = None,
                 quotas: Optional[pulumi.Input['EnvironmentQuotasArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trial: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[str] state: Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        :param pulumi.Input['EnvironmentStorageArgs'] storage: Environment level storage usage and limit information
        :param pulumi.Input[str] name: The display name of the environment
        :param pulumi.Input['EnvironmentQuotasArgs'] quotas: Environment level consumption and quotas information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        :param pulumi.Input[bool] trial: Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage", storage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quotas is not None:
            pulumi.set(__self__, "quotas", quotas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trial is not None:
            pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[str]:
        """
        Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[str]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Input['EnvironmentStorageArgs']:
        """
        Environment level storage usage and limit information
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input['EnvironmentStorageArgs']):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quotas(self) -> Optional[pulumi.Input['EnvironmentQuotasArgs']]:
        """
        Environment level consumption and quotas information
        """
        return pulumi.get(self, "quotas")

    @quotas.setter
    def quotas(self, value: Optional[pulumi.Input['EnvironmentQuotasArgs']]):
        pulumi.set(self, "quotas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def trial(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        return pulumi.get(self, "trial")

    @trial.setter
    def trial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trial", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 quotas: Optional[pulumi.Input['EnvironmentQuotasArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input['EnvironmentStorageArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trial: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[str] name: The display name of the environment
        :param pulumi.Input['EnvironmentQuotasArgs'] quotas: Environment level consumption and quotas information
        :param pulumi.Input[str] state: Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        :param pulumi.Input['EnvironmentStorageArgs'] storage: Environment level storage usage and limit information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        :param pulumi.Input[bool] trial: Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quotas is not None:
            pulumi.set(__self__, "quotas", quotas)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trial is not None:
            pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def quotas(self) -> Optional[pulumi.Input['EnvironmentQuotasArgs']]:
        """
        Environment level consumption and quotas information
        """
        return pulumi.get(self, "quotas")

    @quotas.setter
    def quotas(self, value: Optional[pulumi.Input['EnvironmentQuotasArgs']]):
        pulumi.set(self, "quotas", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['EnvironmentStorageArgs']]:
        """
        Environment level storage usage and limit information
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['EnvironmentStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def trial(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        return pulumi.get(self, "trial")

    @trial.setter
    def trial(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trial", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quotas: Optional[pulumi.Input[Union['EnvironmentQuotasArgs', 'EnvironmentQuotasArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[Union['EnvironmentStorageArgs', 'EnvironmentStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trial: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        > This resource requires the cluster API token scope **Service Provider API** (`ServiceProviderAPI`)

        ## Dynatrace Documentation

        - Manage your monitoring environments - https://docs.dynatrace.com/managed/managed-cluster/operation/manage-your-monitoring-environments

        - Cluster API v2 - Environments - https://www.dynatrace.com/support/help/shortlink/cluster-api#environments

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The display name of the environment
        :param pulumi.Input[Union['EnvironmentQuotasArgs', 'EnvironmentQuotasArgsDict']] quotas: Environment level consumption and quotas information
        :param pulumi.Input[str] state: Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        :param pulumi.Input[Union['EnvironmentStorageArgs', 'EnvironmentStorageArgsDict']] storage: Environment level storage usage and limit information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        :param pulumi.Input[bool] trial: Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource requires the cluster API token scope **Service Provider API** (`ServiceProviderAPI`)

        ## Dynatrace Documentation

        - Manage your monitoring environments - https://docs.dynatrace.com/managed/managed-cluster/operation/manage-your-monitoring-environments

        - Cluster API v2 - Environments - https://www.dynatrace.com/support/help/shortlink/cluster-api#environments

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quotas: Optional[pulumi.Input[Union['EnvironmentQuotasArgs', 'EnvironmentQuotasArgsDict']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[Union['EnvironmentStorageArgs', 'EnvironmentStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trial: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["quotas"] = quotas
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            if storage is None and not opts.urn:
                raise TypeError("Missing required property 'storage'")
            __props__.__dict__["storage"] = storage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trial"] = trial
        super(Environment, __self__).__init__(
            'dynatrace:index/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            quotas: Optional[pulumi.Input[Union['EnvironmentQuotasArgs', 'EnvironmentQuotasArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage: Optional[pulumi.Input[Union['EnvironmentStorageArgs', 'EnvironmentStorageArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            trial: Optional[pulumi.Input[bool]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The display name of the environment
        :param pulumi.Input[Union['EnvironmentQuotasArgs', 'EnvironmentQuotasArgsDict']] quotas: Environment level consumption and quotas information
        :param pulumi.Input[str] state: Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        :param pulumi.Input[Union['EnvironmentStorageArgs', 'EnvironmentStorageArgsDict']] storage: Environment level storage usage and limit information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        :param pulumi.Input[bool] trial: Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["name"] = name
        __props__.__dict__["quotas"] = quotas
        __props__.__dict__["state"] = state
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trial"] = trial
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The display name of the environment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def quotas(self) -> pulumi.Output[Optional['outputs.EnvironmentQuotas']]:
        """
        Environment level consumption and quotas information
        """
        return pulumi.get(self, "quotas")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Indicates whether the environment is enabled or disabled. Possible values are `ENABLED` and `DISABLED`. The default value is ENABLED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.EnvironmentStorage']:
        """
        Environment level storage usage and limit information
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of tags that are assigned to this environment. Every tag can have a maximum length of 100 characters
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def trial(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the environment is a trial environment or a non-trial environment. Creating a trial environment is only possible if your license allows that. The default value is false (non-trial)
        """
        return pulumi.get(self, "trial")

