# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmailNotificationArgs', 'EmailNotification']

@pulumi.input_type
class EmailNotificationArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[str],
                 profile: pulumi.Input[str],
                 subject: pulumi.Input[str],
                 tos: pulumi.Input[Sequence[pulumi.Input[str]]],
                 active: Optional[pulumi.Input[bool]] = None,
                 bccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notify_closed_problems: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EmailNotification resource.
        :param pulumi.Input[str] body: The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[str] profile: The ID of the associated alerting profile
        :param pulumi.Input[str] subject: The subject of the email notifications
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tos: The list of the email recipients
        :param pulumi.Input[bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bccs: The list of the email BCC-recipients
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ccs: The list of the email CC-recipients
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The name of the notification configuration
        :param pulumi.Input[bool] notify_closed_problems: Send email if problem is closed
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "tos", tos)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if bccs is not None:
            pulumi.set(__self__, "bccs", bccs)
        if ccs is not None:
            pulumi.set(__self__, "ccs", ccs)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_closed_problems is not None:
            pulumi.set(__self__, "notify_closed_problems", notify_closed_problems)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Input[str]:
        """
        The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Input[str]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[str]:
        """
        The subject of the email notifications
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of the email recipients
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tos", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def bccs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the email BCC-recipients
        """
        return pulumi.get(self, "bccs")

    @bccs.setter
    def bccs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bccs", value)

    @property
    @pulumi.getter
    def ccs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the email CC-recipients
        """
        return pulumi.get(self, "ccs")

    @ccs.setter
    def ccs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ccs", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notifyClosedProblems")
    def notify_closed_problems(self) -> Optional[pulumi.Input[bool]]:
        """
        Send email if problem is closed
        """
        return pulumi.get(self, "notify_closed_problems")

    @notify_closed_problems.setter
    def notify_closed_problems(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_closed_problems", value)


@pulumi.input_type
class _EmailNotificationState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 bccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 ccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notify_closed_problems: Optional[pulumi.Input[bool]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering EmailNotification resources.
        :param pulumi.Input[bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bccs: The list of the email BCC-recipients
        :param pulumi.Input[str] body: The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ccs: The list of the email CC-recipients
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The name of the notification configuration
        :param pulumi.Input[bool] notify_closed_problems: Send email if problem is closed
        :param pulumi.Input[str] profile: The ID of the associated alerting profile
        :param pulumi.Input[str] subject: The subject of the email notifications
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tos: The list of the email recipients
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if bccs is not None:
            pulumi.set(__self__, "bccs", bccs)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if ccs is not None:
            pulumi.set(__self__, "ccs", ccs)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_closed_problems is not None:
            pulumi.set(__self__, "notify_closed_problems", notify_closed_problems)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def bccs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the email BCC-recipients
        """
        return pulumi.get(self, "bccs")

    @bccs.setter
    def bccs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bccs", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def ccs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the email CC-recipients
        """
        return pulumi.get(self, "ccs")

    @ccs.setter
    def ccs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ccs", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notifyClosedProblems")
    def notify_closed_problems(self) -> Optional[pulumi.Input[bool]]:
        """
        Send email if problem is closed
        """
        return pulumi.get(self, "notify_closed_problems")

    @notify_closed_problems.setter
    def notify_closed_problems(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_closed_problems", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the email notifications
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the email recipients
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tos", value)


class EmailNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 bccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 ccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notify_closed_problems: Optional[pulumi.Input[bool]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a EmailNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bccs: The list of the email BCC-recipients
        :param pulumi.Input[str] body: The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ccs: The list of the email CC-recipients
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The name of the notification configuration
        :param pulumi.Input[bool] notify_closed_problems: Send email if problem is closed
        :param pulumi.Input[str] profile: The ID of the associated alerting profile
        :param pulumi.Input[str] subject: The subject of the email notifications
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tos: The list of the email recipients
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EmailNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EmailNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 bccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 ccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notify_closed_problems: Optional[pulumi.Input[bool]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailNotificationArgs.__new__(EmailNotificationArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["bccs"] = bccs
            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            __props__.__dict__["ccs"] = ccs
            __props__.__dict__["legacy_id"] = legacy_id
            __props__.__dict__["name"] = name
            __props__.__dict__["notify_closed_problems"] = notify_closed_problems
            if profile is None and not opts.urn:
                raise TypeError("Missing required property 'profile'")
            __props__.__dict__["profile"] = profile
            if subject is None and not opts.urn:
                raise TypeError("Missing required property 'subject'")
            __props__.__dict__["subject"] = subject
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
        super(EmailNotification, __self__).__init__(
            'dynatrace:index/emailNotification:EmailNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            bccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            body: Optional[pulumi.Input[str]] = None,
            ccs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            legacy_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notify_closed_problems: Optional[pulumi.Input[bool]] = None,
            profile: Optional[pulumi.Input[str]] = None,
            subject: Optional[pulumi.Input[str]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'EmailNotification':
        """
        Get an existing EmailNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The configuration is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bccs: The list of the email BCC-recipients
        :param pulumi.Input[str] body: The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ccs: The list of the email CC-recipients
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The name of the notification configuration
        :param pulumi.Input[bool] notify_closed_problems: Send email if problem is closed
        :param pulumi.Input[str] profile: The ID of the associated alerting profile
        :param pulumi.Input[str] subject: The subject of the email notifications
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tos: The list of the email recipients
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailNotificationState.__new__(_EmailNotificationState)

        __props__.__dict__["active"] = active
        __props__.__dict__["bccs"] = bccs
        __props__.__dict__["body"] = body
        __props__.__dict__["ccs"] = ccs
        __props__.__dict__["legacy_id"] = legacy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["notify_closed_problems"] = notify_closed_problems
        __props__.__dict__["profile"] = profile
        __props__.__dict__["subject"] = subject
        __props__.__dict__["tos"] = tos
        return EmailNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        The configuration is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def bccs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of the email BCC-recipients
        """
        return pulumi.get(self, "bccs")

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[str]:
        """
        The template of the email notification.  You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsHTML}`: All problem event details, including root cause, as an HTML-formatted string.  * `{ProblemDetailsJSON}`: All problem event details, including root cause, as a JSON object.  * `{ProblemDetailsMarkdown}`: All problem event details, including root cause, as a [Markdown-formatted](https://www.markdownguide.org/cheat-sheet/) string.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def ccs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of the email CC-recipients
        """
        return pulumi.get(self, "ccs")

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> pulumi.Output[str]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the notification configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notifyClosedProblems")
    def notify_closed_problems(self) -> pulumi.Output[Optional[bool]]:
        """
        Send email if problem is closed
        """
        return pulumi.get(self, "notify_closed_problems")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[str]:
        """
        The ID of the associated alerting profile
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output[str]:
        """
        The subject of the email notifications
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of the email recipients
        """
        return pulumi.get(self, "tos")

