# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiskOptionsArgs', 'DiskOptions']

@pulumi.input_type
class DiskOptionsArgs:
    def __init__(__self__, *,
                 disable_nfs_disk_monitoring: Optional[pulumi.Input[bool]] = None,
                 exclusions: Optional[pulumi.Input['DiskOptionsExclusionsArgs']] = None,
                 nfs_show_all: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DiskOptions resource.
        :param pulumi.Input[bool] disable_nfs_disk_monitoring: Deactivate NFS monitoring on all supported systems
        :param pulumi.Input['DiskOptionsExclusionsArgs'] exclusions: OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
               disks from the monitoring list.
        :param pulumi.Input[bool] nfs_show_all: When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
               Requires OneAgent 1.209 or later
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        if disable_nfs_disk_monitoring is not None:
            pulumi.set(__self__, "disable_nfs_disk_monitoring", disable_nfs_disk_monitoring)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if nfs_show_all is not None:
            pulumi.set(__self__, "nfs_show_all", nfs_show_all)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="disableNfsDiskMonitoring")
    def disable_nfs_disk_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Deactivate NFS monitoring on all supported systems
        """
        return pulumi.get(self, "disable_nfs_disk_monitoring")

    @disable_nfs_disk_monitoring.setter
    def disable_nfs_disk_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_nfs_disk_monitoring", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input['DiskOptionsExclusionsArgs']]:
        """
        OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
        disks from the monitoring list.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input['DiskOptionsExclusionsArgs']]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="nfsShowAll")
    def nfs_show_all(self) -> Optional[pulumi.Input[bool]]:
        """
        When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
        Requires OneAgent 1.209 or later
        """
        return pulumi.get(self, "nfs_show_all")

    @nfs_show_all.setter
    def nfs_show_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfs_show_all", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _DiskOptionsState:
    def __init__(__self__, *,
                 disable_nfs_disk_monitoring: Optional[pulumi.Input[bool]] = None,
                 exclusions: Optional[pulumi.Input['DiskOptionsExclusionsArgs']] = None,
                 nfs_show_all: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiskOptions resources.
        :param pulumi.Input[bool] disable_nfs_disk_monitoring: Deactivate NFS monitoring on all supported systems
        :param pulumi.Input['DiskOptionsExclusionsArgs'] exclusions: OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
               disks from the monitoring list.
        :param pulumi.Input[bool] nfs_show_all: When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
               Requires OneAgent 1.209 or later
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        if disable_nfs_disk_monitoring is not None:
            pulumi.set(__self__, "disable_nfs_disk_monitoring", disable_nfs_disk_monitoring)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if nfs_show_all is not None:
            pulumi.set(__self__, "nfs_show_all", nfs_show_all)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="disableNfsDiskMonitoring")
    def disable_nfs_disk_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Deactivate NFS monitoring on all supported systems
        """
        return pulumi.get(self, "disable_nfs_disk_monitoring")

    @disable_nfs_disk_monitoring.setter
    def disable_nfs_disk_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_nfs_disk_monitoring", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input['DiskOptionsExclusionsArgs']]:
        """
        OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
        disks from the monitoring list.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input['DiskOptionsExclusionsArgs']]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="nfsShowAll")
    def nfs_show_all(self) -> Optional[pulumi.Input[bool]]:
        """
        When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
        Requires OneAgent 1.209 or later
        """
        return pulumi.get(self, "nfs_show_all")

    @nfs_show_all.setter
    def nfs_show_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfs_show_all", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class DiskOptions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_nfs_disk_monitoring: Optional[pulumi.Input[bool]] = None,
                 exclusions: Optional[pulumi.Input[Union['DiskOptionsExclusionsArgs', 'DiskOptionsExclusionsArgsDict']]] = None,
                 nfs_show_all: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a DiskOptions resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disable_nfs_disk_monitoring: Deactivate NFS monitoring on all supported systems
        :param pulumi.Input[Union['DiskOptionsExclusionsArgs', 'DiskOptionsExclusionsArgsDict']] exclusions: OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
               disks from the monitoring list.
        :param pulumi.Input[bool] nfs_show_all: When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
               Requires OneAgent 1.209 or later
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DiskOptionsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DiskOptions resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DiskOptionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskOptionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disable_nfs_disk_monitoring: Optional[pulumi.Input[bool]] = None,
                 exclusions: Optional[pulumi.Input[Union['DiskOptionsExclusionsArgs', 'DiskOptionsExclusionsArgsDict']]] = None,
                 nfs_show_all: Optional[pulumi.Input[bool]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskOptionsArgs.__new__(DiskOptionsArgs)

            __props__.__dict__["disable_nfs_disk_monitoring"] = disable_nfs_disk_monitoring
            __props__.__dict__["exclusions"] = exclusions
            __props__.__dict__["nfs_show_all"] = nfs_show_all
            __props__.__dict__["scope"] = scope
        super(DiskOptions, __self__).__init__(
            'dynatrace:index/diskOptions:DiskOptions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disable_nfs_disk_monitoring: Optional[pulumi.Input[bool]] = None,
            exclusions: Optional[pulumi.Input[Union['DiskOptionsExclusionsArgs', 'DiskOptionsExclusionsArgsDict']]] = None,
            nfs_show_all: Optional[pulumi.Input[bool]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'DiskOptions':
        """
        Get an existing DiskOptions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disable_nfs_disk_monitoring: Deactivate NFS monitoring on all supported systems
        :param pulumi.Input[Union['DiskOptionsExclusionsArgs', 'DiskOptionsExclusionsArgsDict']] exclusions: OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
               disks from the monitoring list.
        :param pulumi.Input[bool] nfs_show_all: When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
               Requires OneAgent 1.209 or later
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskOptionsState.__new__(_DiskOptionsState)

        __props__.__dict__["disable_nfs_disk_monitoring"] = disable_nfs_disk_monitoring
        __props__.__dict__["exclusions"] = exclusions
        __props__.__dict__["nfs_show_all"] = nfs_show_all
        __props__.__dict__["scope"] = scope
        return DiskOptions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="disableNfsDiskMonitoring")
    def disable_nfs_disk_monitoring(self) -> pulumi.Output[Optional[bool]]:
        """
        Deactivate NFS monitoring on all supported systems
        """
        return pulumi.get(self, "disable_nfs_disk_monitoring")

    @property
    @pulumi.getter
    def exclusions(self) -> pulumi.Output[Optional['outputs.DiskOptionsExclusions']]:
        """
        OneAgent automatically detects and monitors all your mount points, however you can create exception rules to remove
        disks from the monitoring list.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="nfsShowAll")
    def nfs_show_all(self) -> pulumi.Output[Optional[bool]]:
        """
        When disabled OneAgent will try to deduplicate some of nfs disks. Disabled by default, applies only to Linux hosts.
        Requires OneAgent 1.209 or later
        """
        return pulumi.get(self, "nfs_show_all")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

