# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiskEdgeAnomalyDetectorsArgs', 'DiskEdgeAnomalyDetectors']

@pulumi.input_type
class DiskEdgeAnomalyDetectorsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 policy_name: pulumi.Input[str],
                 alerts: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']] = None,
                 disk_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 event_properties: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']] = None,
                 host_metadata_conditions: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DiskEdgeAnomalyDetectors resource.
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] policy_name: Policy name
        :param pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs'] alerts: Alerts
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_name_filters: Disk will be included in this policy if **any** of the filters match
        :param pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs'] event_properties: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs'] host_metadata_conditions: The policy will be enabled if **all** conditions are met
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which policy should be applied
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "policy_name", policy_name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if disk_name_filters is not None:
            pulumi.set(__self__, "disk_name_filters", disk_name_filters)
        if event_properties is not None:
            pulumi.set(__self__, "event_properties", event_properties)
        if host_metadata_conditions is not None:
            pulumi.set(__self__, "host_metadata_conditions", host_metadata_conditions)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if operating_systems is not None:
            pulumi.set(__self__, "operating_systems", operating_systems)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[str]:
        """
        Policy name
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']]:
        """
        Alerts
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="diskNameFilters")
    def disk_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Disk will be included in this policy if **any** of the filters match
        """
        return pulumi.get(self, "disk_name_filters")

    @disk_name_filters.setter
    def disk_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_name_filters", value)

    @property
    @pulumi.getter(name="eventProperties")
    def event_properties(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "event_properties")

    @event_properties.setter
    def event_properties(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']]):
        pulumi.set(self, "event_properties", value)

    @property
    @pulumi.getter(name="hostMetadataConditions")
    def host_metadata_conditions(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']]:
        """
        The policy will be enabled if **all** conditions are met
        """
        return pulumi.get(self, "host_metadata_conditions")

    @host_metadata_conditions.setter
    def host_metadata_conditions(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']]):
        pulumi.set(self, "host_metadata_conditions", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Select the operating systems on which policy should be applied
        """
        return pulumi.get(self, "operating_systems")

    @operating_systems.setter
    def operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "operating_systems", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _DiskEdgeAnomalyDetectorsState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']] = None,
                 disk_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_properties: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']] = None,
                 host_metadata_conditions: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiskEdgeAnomalyDetectors resources.
        :param pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs'] alerts: Alerts
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_name_filters: Disk will be included in this policy if **any** of the filters match
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs'] event_properties: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs'] host_metadata_conditions: The policy will be enabled if **all** conditions are met
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which policy should be applied
        :param pulumi.Input[str] policy_name: Policy name
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if disk_name_filters is not None:
            pulumi.set(__self__, "disk_name_filters", disk_name_filters)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_properties is not None:
            pulumi.set(__self__, "event_properties", event_properties)
        if host_metadata_conditions is not None:
            pulumi.set(__self__, "host_metadata_conditions", host_metadata_conditions)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if operating_systems is not None:
            pulumi.set(__self__, "operating_systems", operating_systems)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']]:
        """
        Alerts
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="diskNameFilters")
    def disk_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Disk will be included in this policy if **any** of the filters match
        """
        return pulumi.get(self, "disk_name_filters")

    @disk_name_filters.setter
    def disk_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_name_filters", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventProperties")
    def event_properties(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "event_properties")

    @event_properties.setter
    def event_properties(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsEventPropertiesArgs']]):
        pulumi.set(self, "event_properties", value)

    @property
    @pulumi.getter(name="hostMetadataConditions")
    def host_metadata_conditions(self) -> Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']]:
        """
        The policy will be enabled if **all** conditions are met
        """
        return pulumi.get(self, "host_metadata_conditions")

    @host_metadata_conditions.setter
    def host_metadata_conditions(self, value: Optional[pulumi.Input['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs']]):
        pulumi.set(self, "host_metadata_conditions", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Select the operating systems on which policy should be applied
        """
        return pulumi.get(self, "operating_systems")

    @operating_systems.setter
    def operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "operating_systems", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy name
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class DiskEdgeAnomalyDetectors(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsAlertsArgs', 'DiskEdgeAnomalyDetectorsAlertsArgsDict']]] = None,
                 disk_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_properties: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsEventPropertiesArgs', 'DiskEdgeAnomalyDetectorsEventPropertiesArgsDict']]] = None,
                 host_metadata_conditions: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs', 'DiskEdgeAnomalyDetectorsHostMetadataConditionsArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a DiskEdgeAnomalyDetectors resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsAlertsArgs', 'DiskEdgeAnomalyDetectorsAlertsArgsDict']] alerts: Alerts
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_name_filters: Disk will be included in this policy if **any** of the filters match
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsEventPropertiesArgs', 'DiskEdgeAnomalyDetectorsEventPropertiesArgsDict']] event_properties: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs', 'DiskEdgeAnomalyDetectorsHostMetadataConditionsArgsDict']] host_metadata_conditions: The policy will be enabled if **all** conditions are met
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which policy should be applied
        :param pulumi.Input[str] policy_name: Policy name
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskEdgeAnomalyDetectorsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DiskEdgeAnomalyDetectors resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DiskEdgeAnomalyDetectorsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskEdgeAnomalyDetectorsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsAlertsArgs', 'DiskEdgeAnomalyDetectorsAlertsArgsDict']]] = None,
                 disk_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 event_properties: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsEventPropertiesArgs', 'DiskEdgeAnomalyDetectorsEventPropertiesArgsDict']]] = None,
                 host_metadata_conditions: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs', 'DiskEdgeAnomalyDetectorsHostMetadataConditionsArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskEdgeAnomalyDetectorsArgs.__new__(DiskEdgeAnomalyDetectorsArgs)

            __props__.__dict__["alerts"] = alerts
            __props__.__dict__["disk_name_filters"] = disk_name_filters
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_properties"] = event_properties
            __props__.__dict__["host_metadata_conditions"] = host_metadata_conditions
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["operating_systems"] = operating_systems
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            __props__.__dict__["scope"] = scope
        super(DiskEdgeAnomalyDetectors, __self__).__init__(
            'dynatrace:index/diskEdgeAnomalyDetectors:DiskEdgeAnomalyDetectors',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsAlertsArgs', 'DiskEdgeAnomalyDetectorsAlertsArgsDict']]] = None,
            disk_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            event_properties: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsEventPropertiesArgs', 'DiskEdgeAnomalyDetectorsEventPropertiesArgsDict']]] = None,
            host_metadata_conditions: Optional[pulumi.Input[Union['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs', 'DiskEdgeAnomalyDetectorsHostMetadataConditionsArgsDict']]] = None,
            insert_after: Optional[pulumi.Input[str]] = None,
            operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            policy_name: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'DiskEdgeAnomalyDetectors':
        """
        Get an existing DiskEdgeAnomalyDetectors resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsAlertsArgs', 'DiskEdgeAnomalyDetectorsAlertsArgsDict']] alerts: Alerts
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_name_filters: Disk will be included in this policy if **any** of the filters match
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsEventPropertiesArgs', 'DiskEdgeAnomalyDetectorsEventPropertiesArgsDict']] event_properties: Set of additional key-value properties to be attached to the triggered event.
        :param pulumi.Input[Union['DiskEdgeAnomalyDetectorsHostMetadataConditionsArgs', 'DiskEdgeAnomalyDetectorsHostMetadataConditionsArgsDict']] host_metadata_conditions: The policy will be enabled if **all** conditions are met
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operating_systems: Select the operating systems on which policy should be applied
        :param pulumi.Input[str] policy_name: Policy name
        :param pulumi.Input[str] scope: The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskEdgeAnomalyDetectorsState.__new__(_DiskEdgeAnomalyDetectorsState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["disk_name_filters"] = disk_name_filters
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_properties"] = event_properties
        __props__.__dict__["host_metadata_conditions"] = host_metadata_conditions
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["operating_systems"] = operating_systems
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["scope"] = scope
        return DiskEdgeAnomalyDetectors(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Output[Optional['outputs.DiskEdgeAnomalyDetectorsAlerts']]:
        """
        Alerts
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="diskNameFilters")
    def disk_name_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Disk will be included in this policy if **any** of the filters match
        """
        return pulumi.get(self, "disk_name_filters")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventProperties")
    def event_properties(self) -> pulumi.Output[Optional['outputs.DiskEdgeAnomalyDetectorsEventProperties']]:
        """
        Set of additional key-value properties to be attached to the triggered event.
        """
        return pulumi.get(self, "event_properties")

    @property
    @pulumi.getter(name="hostMetadataConditions")
    def host_metadata_conditions(self) -> pulumi.Output[Optional['outputs.DiskEdgeAnomalyDetectorsHostMetadataConditions']]:
        """
        The policy will be enabled if **all** conditions are met
        """
        return pulumi.get(self, "host_metadata_conditions")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Select the operating systems on which policy should be applied
        """
        return pulumi.get(self, "operating_systems")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[str]:
        """
        Policy name
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this setting (HOST, HOST_GROUP). Omit this property if you want to cover the whole environment.
        """
        return pulumi.get(self, "scope")

