# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiskAnomalyRulesArgs', 'DiskAnomalyRules']

@pulumi.input_type
class DiskAnomalyRulesArgs:
    def __init__(__self__, *,
                 disk_name_filter: pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs'],
                 enabled: pulumi.Input[bool],
                 metric: pulumi.Input[str],
                 sample_limit: pulumi.Input['DiskAnomalyRulesSampleLimitArgs'],
                 host_group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold_milliseconds: Optional[pulumi.Input[float]] = None,
                 threshold_percent: Optional[pulumi.Input[float]] = None):
        """
        The set of arguments for constructing a DiskAnomalyRules resource.
        :param pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs'] disk_name_filter: Only apply to disks whose name matches
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric: Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        :param pulumi.Input['DiskAnomalyRulesSampleLimitArgs'] sample_limit: Only alert if the threshold was violated in at least *n* of the last *m* samples
        :param pulumi.Input[str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_filters: Only apply to hosts that have the following tags
        :param pulumi.Input[float] threshold_milliseconds: Alert if higher than
        :param pulumi.Input[float] threshold_percent: Alert if lower than
        """
        pulumi.set(__self__, "disk_name_filter", disk_name_filter)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "sample_limit", sample_limit)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)
        if threshold_milliseconds is not None:
            pulumi.set(__self__, "threshold_milliseconds", threshold_milliseconds)
        if threshold_percent is not None:
            pulumi.set(__self__, "threshold_percent", threshold_percent)

    @property
    @pulumi.getter(name="diskNameFilter")
    def disk_name_filter(self) -> pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs']:
        """
        Only apply to disks whose name matches
        """
        return pulumi.get(self, "disk_name_filter")

    @disk_name_filter.setter
    def disk_name_filter(self, value: pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs']):
        pulumi.set(self, "disk_name_filter", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[str]:
        """
        Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> pulumi.Input['DiskAnomalyRulesSampleLimitArgs']:
        """
        Only alert if the threshold was violated in at least *n* of the last *m* samples
        """
        return pulumi.get(self, "sample_limit")

    @sample_limit.setter
    def sample_limit(self, value: pulumi.Input['DiskAnomalyRulesSampleLimitArgs']):
        pulumi.set(self, "sample_limit", value)

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only apply to hosts that have the following tags
        """
        return pulumi.get(self, "tag_filters")

    @tag_filters.setter
    def tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_filters", value)

    @property
    @pulumi.getter(name="thresholdMilliseconds")
    def threshold_milliseconds(self) -> Optional[pulumi.Input[float]]:
        """
        Alert if higher than
        """
        return pulumi.get(self, "threshold_milliseconds")

    @threshold_milliseconds.setter
    def threshold_milliseconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_milliseconds", value)

    @property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> Optional[pulumi.Input[float]]:
        """
        Alert if lower than
        """
        return pulumi.get(self, "threshold_percent")

    @threshold_percent.setter
    def threshold_percent(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_percent", value)


@pulumi.input_type
class _DiskAnomalyRulesState:
    def __init__(__self__, *,
                 disk_name_filter: Optional[pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 host_group_id: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_limit: Optional[pulumi.Input['DiskAnomalyRulesSampleLimitArgs']] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold_milliseconds: Optional[pulumi.Input[float]] = None,
                 threshold_percent: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering DiskAnomalyRules resources.
        :param pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs'] disk_name_filter: Only apply to disks whose name matches
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[str] metric: Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        :param pulumi.Input[str] name: Name
        :param pulumi.Input['DiskAnomalyRulesSampleLimitArgs'] sample_limit: Only alert if the threshold was violated in at least *n* of the last *m* samples
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_filters: Only apply to hosts that have the following tags
        :param pulumi.Input[float] threshold_milliseconds: Alert if higher than
        :param pulumi.Input[float] threshold_percent: Alert if lower than
        """
        if disk_name_filter is not None:
            pulumi.set(__self__, "disk_name_filter", disk_name_filter)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_limit is not None:
            pulumi.set(__self__, "sample_limit", sample_limit)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)
        if threshold_milliseconds is not None:
            pulumi.set(__self__, "threshold_milliseconds", threshold_milliseconds)
        if threshold_percent is not None:
            pulumi.set(__self__, "threshold_percent", threshold_percent)

    @property
    @pulumi.getter(name="diskNameFilter")
    def disk_name_filter(self) -> Optional[pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs']]:
        """
        Only apply to disks whose name matches
        """
        return pulumi.get(self, "disk_name_filter")

    @disk_name_filter.setter
    def disk_name_filter(self, value: Optional[pulumi.Input['DiskAnomalyRulesDiskNameFilterArgs']]):
        pulumi.set(self, "disk_name_filter", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_group_id", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> Optional[pulumi.Input['DiskAnomalyRulesSampleLimitArgs']]:
        """
        Only alert if the threshold was violated in at least *n* of the last *m* samples
        """
        return pulumi.get(self, "sample_limit")

    @sample_limit.setter
    def sample_limit(self, value: Optional[pulumi.Input['DiskAnomalyRulesSampleLimitArgs']]):
        pulumi.set(self, "sample_limit", value)

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only apply to hosts that have the following tags
        """
        return pulumi.get(self, "tag_filters")

    @tag_filters.setter
    def tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_filters", value)

    @property
    @pulumi.getter(name="thresholdMilliseconds")
    def threshold_milliseconds(self) -> Optional[pulumi.Input[float]]:
        """
        Alert if higher than
        """
        return pulumi.get(self, "threshold_milliseconds")

    @threshold_milliseconds.setter
    def threshold_milliseconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_milliseconds", value)

    @property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> Optional[pulumi.Input[float]]:
        """
        Alert if lower than
        """
        return pulumi.get(self, "threshold_percent")

    @threshold_percent.setter
    def threshold_percent(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_percent", value)


class DiskAnomalyRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_name_filter: Optional[pulumi.Input[Union['DiskAnomalyRulesDiskNameFilterArgs', 'DiskAnomalyRulesDiskNameFilterArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 host_group_id: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_limit: Optional[pulumi.Input[Union['DiskAnomalyRulesSampleLimitArgs', 'DiskAnomalyRulesSampleLimitArgsDict']]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold_milliseconds: Optional[pulumi.Input[float]] = None,
                 threshold_percent: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        Create a DiskAnomalyRules resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DiskAnomalyRulesDiskNameFilterArgs', 'DiskAnomalyRulesDiskNameFilterArgsDict']] disk_name_filter: Only apply to disks whose name matches
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[str] metric: Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[Union['DiskAnomalyRulesSampleLimitArgs', 'DiskAnomalyRulesSampleLimitArgsDict']] sample_limit: Only alert if the threshold was violated in at least *n* of the last *m* samples
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_filters: Only apply to hosts that have the following tags
        :param pulumi.Input[float] threshold_milliseconds: Alert if higher than
        :param pulumi.Input[float] threshold_percent: Alert if lower than
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskAnomalyRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DiskAnomalyRules resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DiskAnomalyRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskAnomalyRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_name_filter: Optional[pulumi.Input[Union['DiskAnomalyRulesDiskNameFilterArgs', 'DiskAnomalyRulesDiskNameFilterArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 host_group_id: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_limit: Optional[pulumi.Input[Union['DiskAnomalyRulesSampleLimitArgs', 'DiskAnomalyRulesSampleLimitArgsDict']]] = None,
                 tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold_milliseconds: Optional[pulumi.Input[float]] = None,
                 threshold_percent: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskAnomalyRulesArgs.__new__(DiskAnomalyRulesArgs)

            if disk_name_filter is None and not opts.urn:
                raise TypeError("Missing required property 'disk_name_filter'")
            __props__.__dict__["disk_name_filter"] = disk_name_filter
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["host_group_id"] = host_group_id
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["name"] = name
            if sample_limit is None and not opts.urn:
                raise TypeError("Missing required property 'sample_limit'")
            __props__.__dict__["sample_limit"] = sample_limit
            __props__.__dict__["tag_filters"] = tag_filters
            __props__.__dict__["threshold_milliseconds"] = threshold_milliseconds
            __props__.__dict__["threshold_percent"] = threshold_percent
        super(DiskAnomalyRules, __self__).__init__(
            'dynatrace:index/diskAnomalyRules:DiskAnomalyRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disk_name_filter: Optional[pulumi.Input[Union['DiskAnomalyRulesDiskNameFilterArgs', 'DiskAnomalyRulesDiskNameFilterArgsDict']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            host_group_id: Optional[pulumi.Input[str]] = None,
            metric: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            sample_limit: Optional[pulumi.Input[Union['DiskAnomalyRulesSampleLimitArgs', 'DiskAnomalyRulesSampleLimitArgsDict']]] = None,
            tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            threshold_milliseconds: Optional[pulumi.Input[float]] = None,
            threshold_percent: Optional[pulumi.Input[float]] = None) -> 'DiskAnomalyRules':
        """
        Get an existing DiskAnomalyRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DiskAnomalyRulesDiskNameFilterArgs', 'DiskAnomalyRulesDiskNameFilterArgsDict']] disk_name_filter: Only apply to disks whose name matches
        :param pulumi.Input[bool] enabled: This setting is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] host_group_id: The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        :param pulumi.Input[str] metric: Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        :param pulumi.Input[str] name: Name
        :param pulumi.Input[Union['DiskAnomalyRulesSampleLimitArgs', 'DiskAnomalyRulesSampleLimitArgsDict']] sample_limit: Only alert if the threshold was violated in at least *n* of the last *m* samples
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_filters: Only apply to hosts that have the following tags
        :param pulumi.Input[float] threshold_milliseconds: Alert if higher than
        :param pulumi.Input[float] threshold_percent: Alert if lower than
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskAnomalyRulesState.__new__(_DiskAnomalyRulesState)

        __props__.__dict__["disk_name_filter"] = disk_name_filter
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host_group_id"] = host_group_id
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["sample_limit"] = sample_limit
        __props__.__dict__["tag_filters"] = tag_filters
        __props__.__dict__["threshold_milliseconds"] = threshold_milliseconds
        __props__.__dict__["threshold_percent"] = threshold_percent
        return DiskAnomalyRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="diskNameFilter")
    def disk_name_filter(self) -> pulumi.Output['outputs.DiskAnomalyRulesDiskNameFilter']:
        """
        Only apply to disks whose name matches
        """
        return pulumi.get(self, "disk_name_filter")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        This setting is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The scope of this settings. If the settings should cover the whole environment, just don't specify any scope.
        """
        return pulumi.get(self, "host_group_id")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output[str]:
        """
        Possible Values: `LOW_DISK_SPACE`, `LOW_INODES`, `READ_TIME_EXCEEDING`, `WRITE_TIME_EXCEEDING`
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> pulumi.Output['outputs.DiskAnomalyRulesSampleLimit']:
        """
        Only alert if the threshold was violated in at least *n* of the last *m* samples
        """
        return pulumi.get(self, "sample_limit")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Only apply to hosts that have the following tags
        """
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="thresholdMilliseconds")
    def threshold_milliseconds(self) -> pulumi.Output[Optional[float]]:
        """
        Alert if higher than
        """
        return pulumi.get(self, "threshold_milliseconds")

    @property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> pulumi.Output[Optional[float]]:
        """
        Alert if lower than
        """
        return pulumi.get(self, "threshold_percent")

