# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DirectSharesArgs', 'DirectShares']

@pulumi.input_type
class DirectSharesArgs:
    def __init__(__self__, *,
                 document_id: pulumi.Input[str],
                 recipients: pulumi.Input['DirectSharesRecipientsArgs'],
                 access: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DirectShares resource.
        :param pulumi.Input[str] document_id: Document ID
        :param pulumi.Input['DirectSharesRecipientsArgs'] recipients: Recipients of the direct share
        :param pulumi.Input[str] access: Access grants. Possible values are `read` and `read-write`
        """
        pulumi.set(__self__, "document_id", document_id)
        pulumi.set(__self__, "recipients", recipients)
        if access is not None:
            pulumi.set(__self__, "access", access)

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> pulumi.Input[str]:
        """
        Document ID
        """
        return pulumi.get(self, "document_id")

    @document_id.setter
    def document_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "document_id", value)

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Input['DirectSharesRecipientsArgs']:
        """
        Recipients of the direct share
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: pulumi.Input['DirectSharesRecipientsArgs']):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Access grants. Possible values are `read` and `read-write`
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)


@pulumi.input_type
class _DirectSharesState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input['DirectSharesRecipientsArgs']] = None):
        """
        Input properties used for looking up and filtering DirectShares resources.
        :param pulumi.Input[str] access: Access grants. Possible values are `read` and `read-write`
        :param pulumi.Input[str] document_id: Document ID
        :param pulumi.Input['DirectSharesRecipientsArgs'] recipients: Recipients of the direct share
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if document_id is not None:
            pulumi.set(__self__, "document_id", document_id)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Access grants. Possible values are `read` and `read-write`
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> Optional[pulumi.Input[str]]:
        """
        Document ID
        """
        return pulumi.get(self, "document_id")

    @document_id.setter
    def document_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_id", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input['DirectSharesRecipientsArgs']]:
        """
        Recipients of the direct share
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input['DirectSharesRecipientsArgs']]):
        pulumi.set(self, "recipients", value)


class DirectShares(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Union['DirectSharesRecipientsArgs', 'DirectSharesRecipientsArgsDict']]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Read direct-shares** (`document:direct-shares:read`), **Write direct-shares** (`document:direct-shares:write`), and **Delete direct-shares** (`document:direct-shares:delete`).

        > This resource is currently not covered by the export utility.

        ## Dynatrace Documentation

        - Dynatrace Documents - https://########.apps.dynatrace.com/platform/swagger-ui/index.html?urls.primaryName=Document%20Service

        ## Resource Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_dynatrace as dynatrace

        this_document = dynatrace.Document("thisDocument",
            type="dashboard",
            content=json.dumps({
                "version": 13,
                "variables": [],
                "tiles": {
                    "0": {
                        "type": "markdown",
                        "title": "",
                        "content": "![Image of a Dashboard](https://dt-cdn.net/wp-content/uploads/2022/09/pic1____Dashboard-Preset___PNG.png)",
                    },
                    "1": {
                        "type": "data",
                        "title": "",
                        "query": "timeseries avg(dt.host.cpu.user)",
                        "queryConfig": {
                            "additionalFilters": {},
                            "version": "4.3.1",
                            "datatype": "metrics",
                            "metricKey": "dt.host.cpu.user",
                            "aggregation": "avg",
                            "by": [],
                        },
                        "subType": "dql-builder-metrics",
                        "visualization": "lineChart",
                        "visualizationSettings": {
                            "thresholds": [],
                            "chartSettings": {
                                "gapPolicy": "connect",
                                "circleChartSettings": {
                                    "groupingThresholdType": "relative",
                                    "groupingThresholdValue": 0,
                                    "valueType": "relative",
                                },
                                "categoryOverrides": {},
                                "fieldMapping": {
                                    "timestamp": "timeframe",
                                    "leftAxisValues": ["avg(dt.host.cpu.user)"],
                                    "leftAxisDimensions": [],
                                    "fields": [],
                                    "values": [],
                                },
                            },
                            "singleValue": {
                                "showLabel": True,
                                "label": "",
                                "prefixIcon": "",
                                "autoscale": True,
                                "alignment": "center",
                                "colorThresholdTarget": "value",
                            },
                            "table": {
                                "rowDensity": "condensed",
                                "enableSparklines": False,
                                "hiddenColumns": [],
                                "lineWrapIds": [],
                                "columnWidths": {},
                            },
                        },
                    },
                    "2": {
                        "type": "data",
                        "title": "",
                        "query": "timeseries avg(dt.host.memory.used)",
                        "queryConfig": {
                            "additionalFilters": {},
                            "version": "4.3.1",
                            "datatype": "metrics",
                            "metricKey": "dt.host.memory.used",
                            "aggregation": "avg",
                            "by": [],
                        },
                        "subType": "dql-builder-metrics",
                        "visualization": "lineChart",
                        "visualizationSettings": {
                            "thresholds": [],
                            "chartSettings": {
                                "gapPolicy": "connect",
                                "circleChartSettings": {
                                    "groupingThresholdType": "relative",
                                    "groupingThresholdValue": 0,
                                    "valueType": "relative",
                                },
                                "categoryOverrides": {},
                                "fieldMapping": {
                                    "timestamp": "timeframe",
                                    "leftAxisValues": ["avg(dt.host.memory.used)"],
                                    "leftAxisDimensions": [],
                                    "fields": [],
                                    "values": [],
                                },
                                "categoricalBarChartSettings": {},
                            },
                            "singleValue": {
                                "showLabel": True,
                                "label": "",
                                "prefixIcon": "",
                                "autoscale": True,
                                "alignment": "center",
                                "colorThresholdTarget": "value",
                            },
                            "table": {
                                "rowDensity": "condensed",
                                "enableSparklines": False,
                                "hiddenColumns": [],
                                "lineWrapIds": [],
                                "columnWidths": {},
                            },
                        },
                    },
                },
                "layouts": {
                    "0": {
                        "x": 0,
                        "y": 0,
                        "w": 24,
                        "h": 14,
                    },
                    "1": {
                        "x": 0,
                        "y": 14,
                        "w": 9,
                        "h": 6,
                    },
                    "2": {
                        "x": 15,
                        "y": 14,
                        "w": 9,
                        "h": 6,
                    },
                },
            }))
        this_direct_shares = dynatrace.DirectShares("thisDirectShares",
            document_id=this_document.id,
            access="read-write",
            recipients={
                "recipients": [
                    {
                        "id": "441664f0-23c9-40ef-b344-18c02c23d787",
                        "type": "user",
                    },
                    {
                        "id": "441664f0-23c9-40ef-b344-18c02c23d788",
                        "type": "group",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Access grants. Possible values are `read` and `read-write`
        :param pulumi.Input[str] document_id: Document ID
        :param pulumi.Input[Union['DirectSharesRecipientsArgs', 'DirectSharesRecipientsArgsDict']] recipients: Recipients of the direct share
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectSharesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **Read direct-shares** (`document:direct-shares:read`), **Write direct-shares** (`document:direct-shares:write`), and **Delete direct-shares** (`document:direct-shares:delete`).

        > This resource is currently not covered by the export utility.

        ## Dynatrace Documentation

        - Dynatrace Documents - https://########.apps.dynatrace.com/platform/swagger-ui/index.html?urls.primaryName=Document%20Service

        ## Resource Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_dynatrace as dynatrace

        this_document = dynatrace.Document("thisDocument",
            type="dashboard",
            content=json.dumps({
                "version": 13,
                "variables": [],
                "tiles": {
                    "0": {
                        "type": "markdown",
                        "title": "",
                        "content": "![Image of a Dashboard](https://dt-cdn.net/wp-content/uploads/2022/09/pic1____Dashboard-Preset___PNG.png)",
                    },
                    "1": {
                        "type": "data",
                        "title": "",
                        "query": "timeseries avg(dt.host.cpu.user)",
                        "queryConfig": {
                            "additionalFilters": {},
                            "version": "4.3.1",
                            "datatype": "metrics",
                            "metricKey": "dt.host.cpu.user",
                            "aggregation": "avg",
                            "by": [],
                        },
                        "subType": "dql-builder-metrics",
                        "visualization": "lineChart",
                        "visualizationSettings": {
                            "thresholds": [],
                            "chartSettings": {
                                "gapPolicy": "connect",
                                "circleChartSettings": {
                                    "groupingThresholdType": "relative",
                                    "groupingThresholdValue": 0,
                                    "valueType": "relative",
                                },
                                "categoryOverrides": {},
                                "fieldMapping": {
                                    "timestamp": "timeframe",
                                    "leftAxisValues": ["avg(dt.host.cpu.user)"],
                                    "leftAxisDimensions": [],
                                    "fields": [],
                                    "values": [],
                                },
                            },
                            "singleValue": {
                                "showLabel": True,
                                "label": "",
                                "prefixIcon": "",
                                "autoscale": True,
                                "alignment": "center",
                                "colorThresholdTarget": "value",
                            },
                            "table": {
                                "rowDensity": "condensed",
                                "enableSparklines": False,
                                "hiddenColumns": [],
                                "lineWrapIds": [],
                                "columnWidths": {},
                            },
                        },
                    },
                    "2": {
                        "type": "data",
                        "title": "",
                        "query": "timeseries avg(dt.host.memory.used)",
                        "queryConfig": {
                            "additionalFilters": {},
                            "version": "4.3.1",
                            "datatype": "metrics",
                            "metricKey": "dt.host.memory.used",
                            "aggregation": "avg",
                            "by": [],
                        },
                        "subType": "dql-builder-metrics",
                        "visualization": "lineChart",
                        "visualizationSettings": {
                            "thresholds": [],
                            "chartSettings": {
                                "gapPolicy": "connect",
                                "circleChartSettings": {
                                    "groupingThresholdType": "relative",
                                    "groupingThresholdValue": 0,
                                    "valueType": "relative",
                                },
                                "categoryOverrides": {},
                                "fieldMapping": {
                                    "timestamp": "timeframe",
                                    "leftAxisValues": ["avg(dt.host.memory.used)"],
                                    "leftAxisDimensions": [],
                                    "fields": [],
                                    "values": [],
                                },
                                "categoricalBarChartSettings": {},
                            },
                            "singleValue": {
                                "showLabel": True,
                                "label": "",
                                "prefixIcon": "",
                                "autoscale": True,
                                "alignment": "center",
                                "colorThresholdTarget": "value",
                            },
                            "table": {
                                "rowDensity": "condensed",
                                "enableSparklines": False,
                                "hiddenColumns": [],
                                "lineWrapIds": [],
                                "columnWidths": {},
                            },
                        },
                    },
                },
                "layouts": {
                    "0": {
                        "x": 0,
                        "y": 0,
                        "w": 24,
                        "h": 14,
                    },
                    "1": {
                        "x": 0,
                        "y": 14,
                        "w": 9,
                        "h": 6,
                    },
                    "2": {
                        "x": 15,
                        "y": 14,
                        "w": 9,
                        "h": 6,
                    },
                },
            }))
        this_direct_shares = dynatrace.DirectShares("thisDirectShares",
            document_id=this_document.id,
            access="read-write",
            recipients={
                "recipients": [
                    {
                        "id": "441664f0-23c9-40ef-b344-18c02c23d787",
                        "type": "user",
                    },
                    {
                        "id": "441664f0-23c9-40ef-b344-18c02c23d788",
                        "type": "group",
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param DirectSharesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectSharesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Union['DirectSharesRecipientsArgs', 'DirectSharesRecipientsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectSharesArgs.__new__(DirectSharesArgs)

            __props__.__dict__["access"] = access
            if document_id is None and not opts.urn:
                raise TypeError("Missing required property 'document_id'")
            __props__.__dict__["document_id"] = document_id
            if recipients is None and not opts.urn:
                raise TypeError("Missing required property 'recipients'")
            __props__.__dict__["recipients"] = recipients
        super(DirectShares, __self__).__init__(
            'dynatrace:index/directShares:DirectShares',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            document_id: Optional[pulumi.Input[str]] = None,
            recipients: Optional[pulumi.Input[Union['DirectSharesRecipientsArgs', 'DirectSharesRecipientsArgsDict']]] = None) -> 'DirectShares':
        """
        Get an existing DirectShares resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Access grants. Possible values are `read` and `read-write`
        :param pulumi.Input[str] document_id: Document ID
        :param pulumi.Input[Union['DirectSharesRecipientsArgs', 'DirectSharesRecipientsArgsDict']] recipients: Recipients of the direct share
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectSharesState.__new__(_DirectSharesState)

        __props__.__dict__["access"] = access
        __props__.__dict__["document_id"] = document_id
        __props__.__dict__["recipients"] = recipients
        return DirectShares(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[Optional[str]]:
        """
        Access grants. Possible values are `read` and `read-write`
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> pulumi.Output[str]:
        """
        Document ID
        """
        return pulumi.get(self, "document_id")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output['outputs.DirectSharesRecipients']:
        """
        Recipients of the direct share
        """
        return pulumi.get(self, "recipients")

